function [J_prime] = J_storage(omega,params)
%J_storage  This function gives an array of storage compliance on omega.
%   This function calculates the storage compliance given an input
%   frequency vector, omega, and the model parameters contained within
%   params.

    J_prime = zeros(size(omega));
    Jg = params(1);
    J = params(2:2:end);
    tau = params(3:2:end);

    for jj = 1:length(omega)
        if length(J) > 1
            % J_prime(jj) = Jg + sum( (J.*(omega(jj).^2).*(tau.^2)) ./ (1.0 + ( (omega(jj).^2).*(tau.^2) ) ) );
            J_prime(jj) = Jg + sum( J ./ (1.0 + ( (omega(jj).^2).*(tau.^2) ) ) );
        else
            % J_prime(jj) = Jg + ( ((J.*(omega(jj).^2).*(tau.^2)) ./ (1.0 + (  (omega(jj).^2).*(tau.^2) ) ) );
            J_prime(jj) = Jg + ( J ./ (1.0 + (  (omega(jj).^2).*(tau.^2) ) ) );
        end
    end

end

