% morphology generation
clc
clear all
close all
domain_x=60;                                                                    
domain_y=60;                                                                  
domain_z=30; 
a=3;

volume=domain_x*domain_y*domain_z;
total_lattice=domain_x*domain_y*domain_z;
factor=[1 0 0
    0 1 0
    0 0 0];
% step=1;
MS_step=0;

x_axe=1:domain_x;
y_axe=1:domain_y;
z_axe=1:domain_z;
BHJ_morphology= randi([1,2],domain_x,domain_y,domain_z);                  %0-P3HT,1-PCBM

% BHJ_morphology=zeros(domain_x,domain_y,domain_z);
% BHJ_morphology(1,1,1)=1;
% for k=1:domain_z-1
%     BHJ_morphology(1,1,k+1)=~BHJ_morphology(1,1,k);
% end
% for j=1:domain_y-1
%     BHJ_morphology(1,j+1,:)=~BHJ_morphology(1,j,:);
% end
% for i=1:domain_x-1
%     BHJ_morphology(i+1,:,:)=~BHJ_morphology(i,:,:);
% end
% BHJ_morphology=BHJ_morphology+1;

BHJ_morphology_temp=zeros(domain_x,domain_y,domain_z+2);
BHJ_morphology_temp(:,:,2:domain_z+1)=BHJ_morphology;
BHJ_morphology_temp(:,:,1)=3;
BHJ_morphology_temp(:,:,domain_z+2)=3;

domain_size = 4;
size=0;
% 
figure
for j=1:domain_y
    h=BHJ_morphology(1,j,1:domain_z);
    ind1=h==1;
    ind2=h==2;
    sequence1=zeros(1,domain_z)+1;
    sequence2=zeros(1,domain_z)+j;
    scatter3(sequence1(ind1),sequence2(ind1),z_axe(ind1),'s','g','filled');
    hold on
    scatter3(sequence1(ind2),sequence2(ind2),z_axe(ind2),'s','r','filled');
end

for i=1:domain_x
    h=BHJ_morphology(i,1,1:domain_z);
    ind1=h==1;
    ind2=h==2;
    sequence1=zeros(1,domain_z)+i;
    sequence2=zeros(1,domain_z)+1;
    scatter3(sequence1(ind1),sequence2(ind1),z_axe(ind1),'s','g','filled');
    hold on
    scatter3(sequence1(ind2),sequence2(ind2),z_axe(ind2),'s','r','filled');
end

for i=1:domain_x
    h=BHJ_morphology(i,1:domain_y,domain_z);
    ind1=h==1;
    ind2=h==2;
    sequence1=zeros(1,domain_y)+i;
    sequence2=zeros(1,domain_y)+domain_z;
    scatter3(sequence1(ind1),y_axe(ind1),sequence2(ind1),'s','g','filled');
    hold on
    scatter3(sequence1(ind2),y_axe(ind2),sequence2(ind2),'o','r','filled');
end
axis([0 domain_x 0 domain_y 0 domain_z])
axis equal
axis off
% % % % % % box on
saveas(gcf,[num2str(domain_size),'.fig'])
saveas(gcf,[num2str(domain_size),'.tif'])
close all

count_nointerface=0;
 for i=1:domain_x
    for j=1:domain_y
        for k=1:domain_z-1
            if BHJ_morphology(i,j,k)~=BHJ_morphology(i,j,mod(k,domain_z)+1)
                count_nointerface=count_nointerface+1;
            end
        end
    end
 end

for j=1:domain_y
    for k=1:domain_z
        for i=1:domain_x
            if BHJ_morphology(i,j,k)~=BHJ_morphology(mod(i,domain_x)+1,j,k)
                count_nointerface=count_nointerface+1;
            end
        end
    end
end
 for i=1:domain_x
    for k=1:domain_z
        for j=1:domain_y
            if BHJ_morphology(i,j,k)~=BHJ_morphology(i,mod(j,domain_y)+1,k)
                count_nointerface=count_nointerface+1;
            end
        end
    end
 end     
% %      interface_area=2*count_nointerface;
 size=a*3*volume/count_nointerface;

fid = fopen('domain_size.txt','w+');
BHJ_morphology = BHJ_morphology - 1;
fprintf(fid,'%2.4f\t',size);
fprintf(fid,'%d\t\n',count_nointerface);
save([num2str(domain_size),'.mat'],'BHJ_morphology')
BHJ_morphology = BHJ_morphology + 1;

for domain_size = 6:2:22
    
    tic
    while size<=domain_size
    % for n=1:step
        MS_step=MS_step+1;
        chosen_bead_x=randi([1,domain_x],total_lattice,1);
        chosen_bead_y=randi([1,domain_y],total_lattice,1);
        chosen_bead_z=randi([2,domain_z+1],total_lattice,1);
        u_random=rand(total_lattice,1);
        swap_direction=randi([1,6],total_lattice,1);
        for i=1:total_lattice
            temp_x=chosen_bead_x(i);
            temp_y=chosen_bead_y(i);
            temp_z=chosen_bead_z(i);
            temp_x0=temp_x;
            temp_y0=temp_y;
            temp_z0=temp_z;
            switch swap_direction(i)
                case 1
                    temp_x0=mod(temp_x,domain_x)+1;
                case 2
                    temp_x0=mod((temp_x-2),domain_x)+1;
                case 3
                    temp_y0=mod(temp_y,domain_y)+1;
                case 4
                    temp_y0=mod((temp_y-2),domain_y)+1;
                case 5
                    if temp_z==domain_z+1
                        continue
                    else
                        temp_z0=temp_z+1;
                    end           
                case 6
                    if temp_z==2
                        continue
                    else
                        temp_z0=temp_z-1;
                    end
            end
            temp_morphology=BHJ_morphology_temp(temp_x,temp_y,temp_z);
            temp_morphology0=BHJ_morphology_temp(temp_x0,temp_y0,temp_z0);
            if temp_morphology~=temp_morphology0
                Ising_Hamiltonian0=-0.5*(factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,temp_y,temp_z)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,temp_y,temp_z)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x,mod(temp_y,domain_y)+1,temp_z)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x,mod((temp_y-2),domain_y)+1,temp_z)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x,temp_y,temp_z+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x,temp_y,temp_z-1)))...
                -6+(factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,mod(temp_y,domain_y)+1,temp_z)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,mod((temp_y-2),domain_y)+1,temp_z)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,mod(temp_y,domain_y)+1,temp_z)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,mod((temp_y-2),domain_y)+1,temp_z)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,temp_y,temp_z+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,temp_y,temp_z-1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,temp_y,temp_z+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,temp_y,temp_z-1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x,mod(temp_y,domain_y)+1,temp_z+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x,mod(temp_y,domain_y)+1,temp_z-1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x,mod((temp_y-2),domain_y)+1,temp_z+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x,mod((temp_y-2),domain_y)+1,temp_z-1)))...
                -12)/1.4142)...
                -0.5*(factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,temp_y0,temp_z0)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,temp_y0,temp_z0)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x0,mod(temp_y0,domain_y)+1,temp_z0)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x0,mod((temp_y0-2),domain_y)+1,temp_z0)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x0,temp_y0,temp_z0+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x0,temp_y0,temp_z0-1)))...
                -6+(factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,mod(temp_y0,domain_y)+1,temp_z0)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,mod((temp_y0-2),domain_y)+1,temp_z0)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,mod(temp_y0,domain_y)+1,temp_z0)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,mod((temp_y0-2),domain_y)+1,temp_z0)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,temp_y0,temp_z0+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,temp_y0,temp_z0-1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,temp_y0,temp_z0+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,temp_y0,temp_z0-1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x0,mod(temp_y0,domain_y)+1,temp_z0+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x0,mod(temp_y0,domain_y)+1,temp_z0-1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x0,mod((temp_y0-2),domain_y)+1,temp_z0+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x0,mod((temp_y0-2),domain_y)+1,temp_z0-1)))...
                -12)/1.4142);
                Ising_Hamiltonian1=-0.5*(factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,temp_y0,temp_z0)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,temp_y0,temp_z0)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x0,mod(temp_y0,domain_y)+1,temp_z0)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x0,mod((temp_y0-2),domain_y)+1,temp_z0)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x0,temp_y0,temp_z0+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x0,temp_y0,temp_z0-1)))...
                -6+(factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,mod(temp_y0,domain_y)+1,temp_z0)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,mod((temp_y0-2),domain_y)+1,temp_z0)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,mod(temp_y0,domain_y)+1,temp_z0)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,mod((temp_y0-2),domain_y)+1,temp_z0)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,temp_y0,temp_z0+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod(temp_x0,domain_x)+1,temp_y0,temp_z0-1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,temp_y0,temp_z0+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(mod((temp_x0-2),domain_x)+1,temp_y0,temp_z0-1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x0,mod(temp_y0,domain_y)+1,temp_z0+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x0,mod(temp_y0,domain_y)+1,temp_z0-1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x0,mod((temp_y0-2),domain_y)+1,temp_z0+1)))...
                +factor(temp_morphology,(BHJ_morphology_temp(temp_x0,mod((temp_y0-2),domain_y)+1,temp_z0-1)))...
                -12)/1.4142)...
                -0.5*(factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,temp_y,temp_z)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,temp_y,temp_z)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x,mod(temp_y,domain_y)+1,temp_z)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x,mod((temp_y-2),domain_y)+1,temp_z)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x,temp_y,temp_z+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x,temp_y,temp_z-1)))...
                -6+(factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,mod(temp_y,domain_y)+1,temp_z)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,mod((temp_y-2),domain_y)+1,temp_z)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,mod(temp_y,domain_y)+1,temp_z)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,mod((temp_y-2),domain_y)+1,temp_z)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,temp_y,temp_z+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod(temp_x,domain_x)+1,temp_y,temp_z-1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,temp_y,temp_z+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(mod((temp_x-2),domain_x)+1,temp_y,temp_z-1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x,mod(temp_y,domain_y)+1,temp_z+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x,mod(temp_y,domain_y)+1,temp_z-1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x,mod((temp_y-2),domain_y)+1,temp_z+1)))...
                +factor(temp_morphology0,(BHJ_morphology_temp(temp_x,mod((temp_y-2),domain_y)+1,temp_z-1)))...
                -12)/1.4142);
                delta_Ising_Hamiltonian=Ising_Hamiltonian1-Ising_Hamiltonian0;
                prob=exp(-delta_Ising_Hamiltonian);
                if u_random(i)<=(prob/(prob+1))
                    temp_morphology=BHJ_morphology_temp(temp_x,temp_y,temp_z);
                    BHJ_morphology_temp(temp_x,temp_y,temp_z)=BHJ_morphology_temp(temp_x0,temp_y0,temp_z0);
                    BHJ_morphology_temp(temp_x0,temp_y0,temp_z0)=temp_morphology;
                end
            end
        end


    BHJ_morphology=BHJ_morphology_temp(:,:,2:domain_z+1);
        count_nointerface=0;
         for i=1:domain_x
            for j=1:domain_y
                for k=1:domain_z-1
                    if BHJ_morphology(i,j,k)~=BHJ_morphology(i,j,mod(k,domain_z)+1)
                        count_nointerface=count_nointerface+1;
                    end
                end
            end
         end

        for j=1:domain_y
            for k=1:domain_z
                for i=1:domain_x
                    if BHJ_morphology(i,j,k)~=BHJ_morphology(mod(i,domain_x)+1,j,k)
                        count_nointerface=count_nointerface+1;
                    end
                end
            end
        end
         for i=1:domain_x
            for k=1:domain_z
                for j=1:domain_y
                    if BHJ_morphology(i,j,k)~=BHJ_morphology(i,mod(j,domain_y)+1,k)
                        count_nointerface=count_nointerface+1;
                    end
                end
            end
         end     
    % %      interface_area=2*count_nointerface;
         size=a*3*volume/count_nointerface;
         MS_step
    end
    
    figure
    for j=1:domain_y
        h=BHJ_morphology(1,j,1:domain_z);
        ind1=h==1;
        ind2=h==2;
        sequence1=zeros(1,domain_z)+1;
        sequence2=zeros(1,domain_z)+j;
        scatter3(sequence1(ind1),sequence2(ind1),z_axe(ind1),'s','g','filled');
        hold on
        scatter3(sequence1(ind2),sequence2(ind2),z_axe(ind2),'s','r','filled');
    end

    for i=1:domain_x
        h=BHJ_morphology(i,1,1:domain_z);
        ind1=h==1;
        ind2=h==2;
        sequence1=zeros(1,domain_z)+i;
        sequence2=zeros(1,domain_z)+1;
        scatter3(sequence1(ind1),sequence2(ind1),z_axe(ind1),'s','g','filled');
        hold on
        scatter3(sequence1(ind2),sequence2(ind2),z_axe(ind2),'s','r','filled');
    end

    for i=1:domain_x
        h=BHJ_morphology(i,1:domain_y,domain_z);
        ind1=h==1;
        ind2=h==2;
        sequence1=zeros(1,domain_y)+i;
        sequence2=zeros(1,domain_y)+domain_z;
        scatter3(sequence1(ind1),y_axe(ind1),sequence2(ind1),'s','g','filled');
        hold on
        scatter3(sequence1(ind2),y_axe(ind2),sequence2(ind2),'o','r','filled');
    end
    axis equal
    axis off
    
    saveas(gcf,[num2str(domain_size),'.fig'])
    saveas(gcf,[num2str(domain_size),'.tif'])
    close all
    toc

    
    % % BHJ_morphology=BHJ_morphology-1;
    BHJ_morphology = BHJ_morphology - 1;
    fprintf(fid,'%2.4f\t',size);
    fprintf(fid,'%d\t\n',count_nointerface);
    save([num2str(domain_size),'.mat'],'BHJ_morphology')
    BHJ_morphology = BHJ_morphology + 1;
    domain_size
end

fclose(fid);
exit
% % % % % % axis off
% % % box on
% % % save('result_0504_morphology.mat');
% % % !shutdown -s