/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Vector;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class SpartanSmolReader
extends AtomSetCollectionReader {
    final boolean logging = false;

    SpartanSmolReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("spartan .smol");
        try {
            this.discardLinesUntilStartsWith(reader, "BEGINARCHIVE");
            if (this.discardLinesUntilContains(reader, "GEOMETRY") != null) {
                this.readAtoms(reader);
            }
            if (this.discardLinesUntilContains(reader, "BEGINPROPARC") != null) {
                this.readProperties(reader);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.atomSetCollection.errorMessage = "Could not read file:" + ex;
            return this.atomSetCollection;
        }
        if (this.atomSetCollection.atomCount == 0) {
            this.atomSetCollection.errorMessage = "No atoms in file";
        }
        return this.atomSetCollection;
    }

    void readAtoms(BufferedReader reader) throws Exception {
        int atomNum;
        String line;
        this.logger.log("Reading BEGINARCHIVE GEOMETERY atom records...");
        while ((line = reader.readLine()) != null && (atomNum = this.parseInt(line, 0, 5)) > 0) {
            float x = this.parseFloat(line, 6, 19);
            float y = this.parseFloat(line, 20, 33);
            float z = this.parseFloat(line, 34, 47);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = AtomSetCollectionReader.getElementSymbol(atomNum);
            atom.x = x * 0.5291772f;
            atom.y = y * 0.5291772f;
            atom.z = z * 0.5291772f;
        }
        this.atomSetCollection.setAtomSetName("Geometry");
    }

    void readProperties(BufferedReader reader) throws Exception {
        String line;
        this.logger.log("Reading PROPARC properties records...");
        while (!((line = reader.readLine()) == null || line.length() >= 10 && line.substring(0, 10).equals("ENDPROPARC"))) {
            if (line.length() >= 4 && line.substring(0, 4).equals("PROP")) {
                this.readProperty(reader, line);
            }
            if (line.length() < 7 || !line.substring(0, 7).equals("VIBFREQ")) continue;
            this.readVibFreqs(reader);
        }
    }

    void readProperty(BufferedReader reader, String line) throws Exception {
        String[] tokens = this.getTokens(line);
        if (tokens.length == 0) {
            return;
        }
        boolean isString = tokens[1].equals("STRING");
        String keyName = tokens[2];
        Object value = new Object();
        Vector<Object> vector = new Vector<Object>();
        if (tokens[3].equals("=")) {
            value = isString ? this.getString(line, tokens[4].substring(0, 1)) : new Float(this.parseFloat(tokens[4]));
        } else if (tokens[tokens.length - 1].equals("BEGIN")) {
            int nValues = this.parseInt(tokens[tokens.length - 2]);
            if (nValues == 0) {
                nValues = 1;
            }
            boolean isArray = tokens.length == 6;
            Vector<Float> atomInfo = new Vector<Float>();
            while ((line = reader.readLine()) != null && !line.substring(0, 3).equals("END")) {
                if (isString) {
                    value = this.getString(line, "\"");
                    vector.add(value);
                    continue;
                }
                String[] tokens2 = this.getTokens(line);
                for (int i = 0; i < tokens2.length; ++i) {
                    if (isArray) {
                        atomInfo.add(new Float(this.parseFloat(tokens2[i])));
                        if ((i + 1) % nValues != 0) continue;
                        vector.add(atomInfo);
                        atomInfo = new Vector();
                        continue;
                    }
                    value = new Float(this.parseFloat(tokens2[i]));
                    vector.add(value);
                }
            }
            value = null;
        } else {
            this.logger.log(" Skipping property line " + line);
        }
        if (value != null) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(keyName, value);
        }
        if (vector.size() != 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo(keyName, vector);
        }
    }

    void readVibFreqs(BufferedReader reader) throws Exception {
        String line = reader.readLine();
        String label = "";
        int frequencyCount = this.parseInt(line);
        Vector vibrations = new Vector();
        Vector freqs = new Vector();
        this.logger.log("reading VIBFREQ vibration records: frequencyCount = " + frequencyCount);
        for (int i = 0; i < frequencyCount; ++i) {
            this.atomSetCollection.cloneLastAtomSet();
            line = reader.readLine();
            Hashtable<String, Object> info = new Hashtable<String, Object>();
            float freq = this.parseFloat(line);
            info.put("freq", new Float(freq));
            if (line.length() > 15 && !(label = line.substring(15, line.length())).equals("???")) {
                info.put("label", label);
            }
            freqs.add(info);
            this.atomSetCollection.setAtomSetName(label + " " + freq + " cm^-1");
            this.atomSetCollection.setAtomSetProperty(".PATH", "Frequencies");
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("VibFreqs", freqs);
        int atomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
        Atom[] atoms = this.atomSetCollection.atoms;
        Vector vib = new Vector();
        Vector<Float> vibatom = new Vector<Float>();
        int ifreq = 0;
        int iatom = atomCount;
        int nValues = 3;
        float[] atomInfo = new float[3];
        while ((line = reader.readLine()) != null) {
            String[] tokens2 = this.getTokens(line);
            for (int i = 0; i < tokens2.length; ++i) {
                float f;
                atomInfo[i % nValues] = f = this.parseFloat(tokens2[i]);
                vibatom.add(new Float(f));
                if ((i + 1) % nValues != 0) continue;
                atoms[iatom].addVibrationVector(atomInfo[0], atomInfo[1], atomInfo[2]);
                vib.add(vibatom);
                vibatom = new Vector();
                ++iatom;
            }
            if (iatom % atomCount != 0) continue;
            vibrations.add(vib);
            vib = new Vector();
            if (++ifreq != frequencyCount) continue;
            break;
        }
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("vibration", vibrations);
    }
}

