(* Content-type: application/vnd.wolfram.cdf.text *)

(*** Wolfram CDF File ***)
(* http://www.wolfram.com/cdf *)

(* CreatedBy='Mathematica 9.0' *)

(*************************************************************************)
(*                                                                       *)
(*  The Mathematica License under which this file was created prohibits  *)
(*  restricting third parties in receipt of this file from republishing  *)
(*  or redistributing it by any means, including but not limited to      *)
(*  rights management or terms of use, without the express consent of    *)
(*  Wolfram Research, Inc. For additional information concerning CDF     *)
(*  licensing and redistribution see:                                    *)
(*                                                                       *)
(*        www.wolfram.com/cdf/adopting-cdf/licensing-options.html        *)
(*                                                                       *)
(*************************************************************************)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[      1063,         20]
NotebookDataLength[    306662,       5413]
NotebookOptionsPosition[    307003,       5402]
NotebookOutlinePosition[    307383,       5419]
CellTagsIndexPosition[    307340,       5416]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "Supporting", " ", "information", " ", "for", " ", "the", " ", "article", 
    " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
    "\"\<Core level binding energies of functionalized and defective graphene\
\>\""}], ",", "\[IndentingNewLine]", "\n", "Susi", ",", " ", 
   RowBox[{
    RowBox[{"T", "."}], ";", " ", "Kaukonen"}], ",", " ", 
   RowBox[{
    RowBox[{"M", "."}], ";", " ", "Havu"}], ",", " ", 
   RowBox[{
    RowBox[{"P", "."}], ";", " ", "Ljungberg"}], ",", " ", 
   RowBox[{
    RowBox[{"M", ".", "P", "."}], ";", " ", "Ayala"}], ",", " ", 
   RowBox[{
    RowBox[{"P", "."}], ";", " ", "Kauppinen"}], ",", " ", 
   RowBox[{
    RowBox[{"E", ".", "I", ".", "\n", "Beilstein"}], " ", 
    RowBox[{"J", ".", " ", "Nanotechnol", ".", " ", "2013"}]}], ",", " ", "5",
    ",", " ", 
   RowBox[{
    RowBox[{"121", ".", " ", 
     RowBox[{"doi", ":", 
      RowBox[{
       RowBox[{"10.3762", "/", "bjnano"}], 
       RowBox[{".5", ".", "12", ".", " ", "\[Copyright]"}], " ", "Susi", " ", 
       "et", " ", "al"}]}]}], ";", " ", 
    RowBox[{
     RowBox[{"licensee", " ", "Beilstein"}], "-", 
     RowBox[{
      RowBox[{
      "Institut", ".", " ", "\[IndentingNewLine]", "\[IndentingNewLine]", 
       "This"}], " ", "file", " ", "is", " ", "Open", " ", "Access", " ", 
      "under", " ", "the", " ", "terms", " ", "of", " ", "the", " ", 
      "Creative", " ", "Commons", " ", "Attribution", " ", "License", " ", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"http", ":"}], "//", 
         RowBox[{
          RowBox[{
           RowBox[{
            RowBox[{"creativecommons", ".", "org"}], "/", "licenses"}], "/", 
           "by"}], "/", "2.0"}]}], ")"}], "."}]}]}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.599988558357667*^9, 3.599988603949729*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "This", " ", "cell", " ", "contains", " ", "the", " ", "calculated", " ", 
     "binding", " ", "energy", " ", "values"}], ",", " ", 
    RowBox[{
    "the", " ", "weights", " ", "and", " ", "the", " ", "bulk", " ", "energy",
      " ", "shifts", " ", "used", " ", "for", " ", "plotting", " ", "the", 
     " ", 
     RowBox[{"lineshapes", "."}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"S1", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"0.29", ",", "0.22", ",", "0.00"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S2", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
       "0.22", ",", "0.02", ",", "0.02", ",", "0.23", ",", "0.23", ",", 
        "0.08", ",", "0.04", ",", "0.27"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"S3", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
       "0.31", ",", "0.14", ",", "0.26", ",", "0.26", ",", " ", "0.41", ",", 
        "0.00", ",", "0.33"}], "}"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"S", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
       "0.29", ",", "0.22", ",", "0.00", ",", "0.22", ",", "0.02", ",", 
        "0.02", ",", "0.23", ",", "0.23", ",", "0.08", ",", "0.04", ",", 
        "0.27", ",", "0.31", ",", "0.14", ",", "0.26", ",", "0.26", ",", " ", 
        "0.41", ",", "0.00", ",", "0.33"}], "}"}]}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"SV", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
       "2.40", ",", "0.64", ",", "0.74", ",", "0.06", ",", "0.37", ",", 
        "0.70", ",", "1.10", ",", "0.64"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSV", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
       "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSV", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SV"}], ",", 
       RowBox[{"List", "/@", "wSV"}], ",", "2"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"DV", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
       "0.34", ",", "0.82", ",", "0.03", ",", "1.18", ",", "0.08", ",", 
        "0.40", ",", "0.49"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wDV", "=", 
     RowBox[{"{", 
      RowBox[{
      "4", ",", "4", ",", "4", ",", "2", ",", "4", ",", "4", ",", "2"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mDV", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "DV"}], ",", 
       RowBox[{"List", "/@", "wDV"}], ",", "2"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"SW", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"0.51", ",", "0.45", ",", 
        RowBox[{"-", "0.22"}], ",", "0.94", ",", 
        RowBox[{"-", "0.09"}], ",", "0.34"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSW", "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "4", ",", "4", ",", "2", ",", "4"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSW", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SW"}], ",", 
       RowBox[{"List", "/@", "wSW"}], ",", "2"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"H", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"0.49", ",", "0.83", ",", "0.26"}], "}"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wH", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "6"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mH", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "H"}], ",", 
       RowBox[{"List", "/@", "wH"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"HH", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.94"}], ",", "0.42", ",", "0.03", ",", "0.05", ",", 
        "0.30"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wHH", "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "4", ",", "4", ",", "2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mHH", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "HH"}], ",", 
       RowBox[{"List", "/@", "wHH"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"HHO", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.75"}], ",", "0.45", ",", "0.01", ",", "0.08", ",", 
        "0.30"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wHHO", "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "4", ",", "4", ",", "2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mHHO", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "HHO"}], ",", 
       RowBox[{"List", "/@", "wHHO"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OH", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.20"}], ",", "1.26", ",", "0.70", ",", "0.78", ",", 
        "0.02"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wOH", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "6", ",", "3", ",", "6"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mOH", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "OH"}], ",", 
       RowBox[{"List", "/@", "wOH"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OK", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.32"}], ",", "1.25", ",", "0.70", ",", "0.78", ",", 
        "0.47", ",", "0.45"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wOK", "=", 
     RowBox[{"{", 
      RowBox[{"1", ",", "3", ",", "6", ",", "3", ",", "6", ",", "3"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mOK", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "OK"}], ",", 
       RowBox[{"List", "/@", "wOK"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OOK", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.55"}], ",", "0.61", ",", "0.17", ",", "0.16", ",", 
        "0.78"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wOOK", "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "4", ",", "4", ",", "2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mOOK", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "OOK"}], ",", 
       RowBox[{"List", "/@", "wOOK"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OE", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "1.52"}], ",", "0.45", ",", "0.05", ",", "0.07", ",", 
        "0.31"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wOE", "=", 
     RowBox[{"{", 
      RowBox[{"2", ",", "4", ",", "4", ",", "4", ",", "2"}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mOE", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "OE"}], ",", 
       RowBox[{"List", "/@", "wOE"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"COOH", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.81"}], ",", "0.94", ",", "0.84", ",", "0.40", ",", 
        "0.72", ",", "0.35", ",", "0.25", ",", 
        RowBox[{"-", "2.46"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wCOOH", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "1", ",", "2", ",", "6", ",", "3", ",", "6", ",", "3", ",", 
       "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mCOOH", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "COOH"}], ",", 
       RowBox[{"List", "/@", "wCOOH"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SVH", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"1.50", ",", "0.61", ",", "0.65", ",", 
        RowBox[{"-", "0.04"}], ",", "0.37", ",", "0.83", ",", "0.24", ",", 
        "0.52"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSVH", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
       "2"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSVH", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SVH"}], ",", 
       RowBox[{"List", "/@", "wSVH"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SVOK", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.65"}], ",", "0.97", ",", "0.34", ",", 
        RowBox[{"-", "0.04"}], ",", "0.19", ",", "0.60", ",", "1.01", ",", 
        "0.35", ",", "0.56"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSVOK", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
       "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSVOK", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SVOK"}], ",", 
       RowBox[{"List", "/@", "wSVOK"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SVOH", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.42"}], ",", "0.63", ",", "0.58", ",", "0.06", ",", 
        "0.33", ",", "0.82", ",", "1.20", ",", "0.46", ",", "0.48"}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSVOH", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
       "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSVOH", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SVOH"}], ",", 
       RowBox[{"List", "/@", "wSVOH"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SVOA", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.79"}], ",", "0.28", ",", "0.81", ",", "0.62", ",", 
        "2.06", ",", "0.56", ",", "0.38", ",", "0.26", ",", "0.59"}], 
       "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSVOA", "=", 
     RowBox[{"{", 
      RowBox[{
      "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", "2", ",", "1", ",", 
       "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSVOA", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SVOA"}], ",", 
       RowBox[{"List", "/@", "wSVOA"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SVOKA", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"-", "0.98"}], ",", "0.63", ",", 
        RowBox[{"-", "0.01"}], ",", 
        RowBox[{"-", "0.14"}], ",", 
        RowBox[{"-", "1.19"}], ",", 
        RowBox[{"-", "0.19"}], ",", "0.07", ",", 
        RowBox[{"-", "0.12"}], ",", 
        RowBox[{"-", "0.36"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSVOKA", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
       "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSVOKA", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SVOKA"}], ",", 
       RowBox[{"List", "/@", "wSVOKA"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SVOO", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"2.88", ",", "1.06", ",", "0.71", ",", "1.22", ",", 
        RowBox[{"-", "0.65"}], ",", "1.17", ",", "0.29", ",", "0.69", ",", 
        "0.58"}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSVOO", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
       "2", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSVOO", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SVOO"}], ",", 
       RowBox[{"List", "/@", "wSVOO"}], ",", "2"}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"SVCOOH", "=", 
     RowBox[{"-", 
      RowBox[{"{", 
       RowBox[{"1.23", ",", "0.60", ",", "0.64", ",", 
        RowBox[{"-", "0.04"}], ",", "0.37", ",", "0.82", ",", "1.25", ",", 
        "0.53", ",", "0.42", ",", 
        RowBox[{"-", "2.11"}]}], "}"}]}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wSVCOOH", "=", 
     RowBox[{"{", 
      RowBox[{
      "1", ",", "2", ",", "2", ",", "2", ",", "2", ",", "2", ",", "1", ",", 
       "2", ",", "1", ",", "1"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mSVCOOH", "=", 
     RowBox[{"Join", "[", 
      RowBox[{
       RowBox[{"List", "/@", "SVCOOH"}], ",", 
       RowBox[{"List", "/@", "wSVCOOH"}], ",", "2"}], "]"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"all", "=", 
     RowBox[{"{", 
      RowBox[{
      "SV", ",", "DV", ",", "SW", ",", "H", ",", "HH", ",", "HHO", ",", "OH", 
       ",", "OK", ",", "OOK", ",", "OE", ",", "COOH", ",", "SVH", ",", "SVOK",
        ",", "SVCOOH", ",", "SVOH", ",", "SVOA", ",", "SVOKA", ",", "SVOO"}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"wall", "=", 
     RowBox[{"{", 
      RowBox[{
      "wSV", ",", "wDV", ",", "wSW", ",", "wH", ",", "wHH", ",", "wHHO", ",", 
       "wOH", ",", "wOK", ",", "wOOK", ",", "wOE", ",", "wCOOH", ",", "wSVH", 
       ",", "wSVOK", ",", "wSVCOOH", ",", "wSVOH", ",", "wSVOA", ",", 
       "wSVOKA", ",", "wSVOO"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"mall", "=", 
     RowBox[{"{", 
      RowBox[{
      "mSV", ",", "mDV", ",", "mSW", ",", "mH", ",", "mHH", ",", "mHHO", ",", 
       "mOH", ",", "mOK", ",", "mOOK", ",", "mOE", ",", "mCOOH", ",", "mSVH", 
       ",", "mSVOK", ",", "mSVCOOH", ",", "mSVOH", ",", "mSVOA", ",", 
       "mSVOKA", ",", "mSVOO"}], "}"}]}], ";"}], "\n", 
   RowBox[{
    RowBox[{"shifts", "=", "S"}], ";"}], "\n", 
   RowBox[{
    RowBox[{
     RowBox[{"shifts", "[", 
      RowBox[{"[", "3", "]"}], "]"}], "=", "\"\<0.00\>\""}], ";", " ", 
    RowBox[{
     RowBox[{"shifts", "[", 
      RowBox[{"[", 
       RowBox[{"-", "2"}], "]"}], "]"}], "=", "\"\<0.00\>\""}], ";"}], "\n", 
   RowBox[{
    RowBox[{"label", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<SV\>\"", ",", "\"\<DV\>\"", ",", "\"\<S-W\>\"", ",", "\"\<-H\>\"", 
       ",", "\"\<-2H\>\"", ",", 
       "\"\<-2\!\(\*SubscriptBox[\(H\), \(opp\)]\)\>\"", ",", "\"\<-OH\>\"", 
       ",", "\"\<=O\>\"", ",", "\"\<-2O\>\"", ",", "\"\<>O\>\"", ",", 
       "\"\<-COOH\>\"", ",", "\"\<SV-H\>\"", ",", "\"\<SV=O\>\"", ",", 
       "\"\<SV-COOH\>\"", ",", "\"\<SV-OH\>\"", ",", "\"\<SV-O-\>\"", ",", 
       "\"\<SV=O+-O-\>\"", ",", "\"\<SV=2O\>\""}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"designation", "=", 
     RowBox[{"{", 
      RowBox[{
      "\"\<1 a)\>\"", ",", "\"\<1 b)\>\"", ",", "\"\<1 c)\>\"", ",", 
       "\"\<2 a)\>\"", ",", "\"\<2 b)\>\"", ",", "\"\<2 c)\>\"", ",", 
       "\"\<2 d)\>\"", ",", "\"\<2 e)\>\"", ",", "\"\<2 f)\>\"", ",", 
       "\"\<2 g)\>\"", ",", "\"\<2 h)\>\"", ",", "\"\<3 a)\>\"", ",", 
       "\"\<3 b)\>\"", ",", "\"\<3 c)\>\"", ",", "\"\<3 d)\>\"", ",", 
       "\"\<3 e)\>\"", ",", "\"\<3 f)\>\"", ",", "\"\<3 g)\>\""}], "}"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.5974761293294888`*^9, 3.597476266542355*^9}, {
  3.5974763030859222`*^9, 3.597476318762156*^9}, {3.5974769470423*^9, 
  3.597476948978305*^9}, {3.598178170346138*^9, 3.5981782083813868`*^9}, {
  3.598182085428741*^9, 3.598182174901129*^9}, {3.599986886164627*^9, 
  3.599987058214676*^9}, {3.599987164513504*^9, 3.59998716815175*^9}, {
  3.599987269339012*^9, 3.599987290027895*^9}, {3.5999874007250023`*^9, 
  3.599987406012033*^9}, {3.599988554872274*^9, 3.59998856424613*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
   "Cut", " ", "defines", " ", "the", " ", "energy", " ", "cutoff", " ", 
    "for", " ", "omitting", " ", "peaks", " ", "with", " ", "small", " ", 
    RowBox[{"shifts", ".", " ", "\[Delta]"}], " ", "is", " ", "the", " ", 
    "Lorentzian", " ", "broadening", " ", "and", " ", "\[Sigma]", " ", "the", 
    " ", "Gaussian", " ", 
    RowBox[{"one", ".", " ", "\"\<sall\>\""}], " ", "selects", " ", "only", 
    " ", "those", " ", "energy", " ", "values", " ", "with", " ", "shifts", 
    " ", "larger", " ", "than", " ", "the", " ", "cutoff", " ", "from", " ", 
    "the", " ", "system", " ", "bulk", " ", "value", " ", "for", " ", 
    RowBox[{"plotting", "."}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"cut", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Delta]", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"\[Sigma]", "=", "0.3"}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"sall", "=", 
     RowBox[{"Evaluate", "@", 
      RowBox[{"Table", "[", 
       RowBox[{
        RowBox[{"Select", "[", 
         RowBox[{
          RowBox[{"mall", "[", 
           RowBox[{"[", "i", "]"}], "]"}], ",", 
          RowBox[{
           RowBox[{
            RowBox[{"Abs", "[", 
             RowBox[{
              RowBox[{"#", "[", 
               RowBox[{"[", "1", "]"}], "]"}], "-", 
              RowBox[{"S", "[", 
               RowBox[{"[", "i", "]"}], "]"}]}], "]"}], ">=", "cut"}], 
           "&"}]}], "]"}], ",", 
        RowBox[{"{", 
         RowBox[{"i", ",", 
          RowBox[{"Length", "[", "mall", "]"}]}], "}"}]}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{"graphs", "=", 
    RowBox[{"Evaluate", "@", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"ImageCrop", "@", 
        RowBox[{"Show", "[", 
         RowBox[{
          RowBox[{"Plot", "[", 
           RowBox[{
            RowBox[{"Evaluate", "@", 
             RowBox[{"Table", "[", 
              RowBox[{"Sum", "[", 
               RowBox[{
                RowBox[{
                 RowBox[{
                  RowBox[{"sall", "[", 
                   RowBox[{"[", "j", "]"}], "]"}], "[", 
                  RowBox[{"[", 
                   RowBox[{"i", ",", "2"}], "]"}], "]"}], "*", 
                 RowBox[{"PDF", "[", 
                  RowBox[{
                   RowBox[{"VoigtDistribution", "[", 
                    RowBox[{"\[Delta]", ",", "\[Sigma]"}], "]"}], ",", 
                   RowBox[{"x", "-", 
                    RowBox[{"(", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"sall", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"S", "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}], ")"}]}]}], "]"}]}], ",", 
                RowBox[{"{", 
                 RowBox[{"i", ",", 
                  RowBox[{"Length", "[", 
                   RowBox[{"sall", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "}"}], ",", 
                RowBox[{"{", 
                 RowBox[{"i", ",", 
                  RowBox[{"Length", "[", 
                   RowBox[{"sall", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "}"}]}], "]"}], 
              "]"}]}], ",", 
            RowBox[{"{", 
             RowBox[{"x", ",", 
              RowBox[{"-", "4"}], ",", "5"}], "}"}], ",", 
            RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
            RowBox[{"Axes", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"True", ",", "False"}], "}"}]}], ",", 
            RowBox[{"PlotStyle", "\[Rule]", "Thick"}], ",", 
            RowBox[{"Frame", "\[Rule]", "True"}], ",", 
            RowBox[{"FrameStyle", "\[Rule]", "Thick"}], ",", 
            RowBox[{"FrameTicks", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{"False", ",", "False"}], "}"}], ",", 
               RowBox[{"{", 
                RowBox[{"True", ",", "False"}], "}"}]}], "}"}]}], ",", 
            RowBox[{"FrameTicksStyle", "\[Rule]", "Large"}], ",", 
            RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{"Large", ",", 
               RowBox[{"FontFamily", "\[Rule]", "Arial"}]}], "}"}]}], ",", 
            RowBox[{"GridLines", "\[Rule]", 
             RowBox[{"{", 
              RowBox[{
               RowBox[{"{", "0", "}"}], ",", 
               RowBox[{"{", "}"}]}], "}"}]}], ",", 
            RowBox[{"ImageSize", "\[Rule]", "Automatic"}], ",", 
            RowBox[{"GridLinesStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
              RowBox[{"Dashed", ",", 
               RowBox[{"Thickness", "\[Rule]", "0.004"}], ",", "Black"}], 
              "]"}]}]}], "]"}], ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"Inset", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{
                RowBox[{"label", "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "~~", "\"\<\\n\>\"", "~~", 
                RowBox[{"ToString", "[", 
                 RowBox[{"shifts", "[", 
                  RowBox[{"[", "j", "]"}], "]"}], "]"}], "~~", 
                "\"\< eV\>\""}], ",", 
               RowBox[{"SingleLetterItalics", "\[Rule]", "False"}], ",", 
               "Large", ",", 
               RowBox[{"FontFamily", "\[Rule]", "Arial"}]}], "]"}], ",", 
             RowBox[{"Scaled", "[", 
              RowBox[{"{", 
               RowBox[{"0.80", ",", "0.82"}], "}"}], "]"}]}], "]"}], "]"}], 
          ",", 
          RowBox[{"Graphics", "[", 
           RowBox[{"Inset", "[", 
            RowBox[{
             RowBox[{"Style", "[", 
              RowBox[{
               RowBox[{"designation", "[", 
                RowBox[{"[", "j", "]"}], "]"}], ",", "Large", ",", 
               RowBox[{"FontFamily", "\[Rule]", "Arial"}]}], "]"}], ",", 
             RowBox[{"Scaled", "[", 
              RowBox[{"{", 
               RowBox[{"0.1", ",", "0.9"}], "}"}], "]"}]}], "]"}], "]"}], ",", 
          RowBox[{"Evaluate", "@", 
           RowBox[{"Table", "[", 
            RowBox[{
             RowBox[{"ListLinePlot", "[", 
              RowBox[{
               RowBox[{"{", 
                RowBox[{
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"sall", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"S", "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}], ",", "0"}], "}"}], ",", 
                 
                 RowBox[{"{", 
                  RowBox[{
                   RowBox[{
                    RowBox[{
                    RowBox[{"sall", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "1"}], "]"}], "]"}], "-", 
                    RowBox[{"S", "[", 
                    RowBox[{"[", "j", "]"}], "]"}]}], ",", 
                   RowBox[{
                    RowBox[{"If", "[", 
                    RowBox[{
                    RowBox[{
                    RowBox[{"Length", "[", 
                    RowBox[{"sall", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "]"}], ">", "1"}], ",", 
                    RowBox[{
                    RowBox[{"(", 
                    RowBox[{"Length", "[", 
                    RowBox[{"sall", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "]"}], ")"}], "*", 
                    "0.5"}], ",", "0.5"}], "]"}], "*", 
                    RowBox[{
                    RowBox[{"sall", "[", 
                    RowBox[{"[", "j", "]"}], "]"}], "[", 
                    RowBox[{"[", 
                    RowBox[{"i", ",", "2"}], "]"}], "]"}]}]}], "}"}]}], "}"}],
                ",", 
               RowBox[{"PlotStyle", "\[Rule]", "Thick"}]}], "]"}], ",", 
             RowBox[{"{", 
              RowBox[{"i", ",", "1", ",", 
               RowBox[{"Length", "[", 
                RowBox[{"sall", "[", 
                 RowBox[{"[", "j", "]"}], "]"}], "]"}]}], "}"}]}], "]"}]}]}], 
         "]"}]}], ",", 
       RowBox[{"{", 
        RowBox[{"j", ",", 
         RowBox[{"Length", "[", "sall", "]"}]}], "}"}]}], 
      "]"}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.597561753379578*^9, 3.597561799615933*^9}, {
   3.597561829766172*^9, 3.597561860918397*^9}, {3.5975618936306667`*^9, 
   3.5975619175541286`*^9}, {3.597642502121004*^9, 3.597642524339003*^9}, {
   3.5976425838593283`*^9, 3.597642597491172*^9}, {3.597642698591832*^9, 
   3.597642743850477*^9}, {3.597642839352727*^9, 3.597642844367671*^9}, {
   3.597643014064467*^9, 3.5976430165164747`*^9}, {3.597643159089048*^9, 
   3.597643226375844*^9}, {3.5976432806431437`*^9, 3.597643354267873*^9}, {
   3.5976434316280947`*^9, 3.5976434405617113`*^9}, {3.5976434815113*^9, 
   3.597643526045986*^9}, {3.5976435645047617`*^9, 3.597643598561624*^9}, {
   3.597643667533465*^9, 3.597643680224729*^9}, {3.597643715273039*^9, 
   3.5976437812738333`*^9}, {3.597643819832399*^9, 3.5976440264500027`*^9}, {
   3.597646377735785*^9, 3.597646423843693*^9}, {3.597646454284527*^9, 
   3.5976465063217497`*^9}, {3.5976468366914997`*^9, 3.597646843842155*^9}, {
   3.5976470109458447`*^9, 3.5976470167257547`*^9}, {3.597647052736434*^9, 
   3.5976470971381807`*^9}, {3.597647130220195*^9, 3.597647234370434*^9}, {
   3.597648622850082*^9, 3.597648684820733*^9}, {3.597649093386601*^9, 
   3.597649095033989*^9}, {3.597650709324225*^9, 3.597650750293351*^9}, {
   3.597650785678101*^9, 3.597650947037778*^9}, 3.59765207990974*^9, {
   3.5976521269011307`*^9, 3.597652168522011*^9}, {3.597652408236434*^9, 
   3.59765242254016*^9}, {3.597654879396714*^9, 3.5976549321229153`*^9}, {
   3.597655014429453*^9, 3.597655082536253*^9}, {3.5976551468808737`*^9, 
   3.597655178981535*^9}, {3.597655276886025*^9, 3.5976552808019943`*^9}, {
   3.597655317329445*^9, 3.597655332441708*^9}, {3.59765538098004*^9, 
   3.597655417471712*^9}, {3.597655469816246*^9, 3.597655509654023*^9}, {
   3.597655567550939*^9, 3.597655570135128*^9}, {3.597656089315445*^9, 
   3.597656200031989*^9}, {3.597656239125099*^9, 3.597656454400536*^9}, {
   3.597656513943009*^9, 3.59765653926231*^9}, {3.597656644363988*^9, 
   3.5976567085304193`*^9}, {3.597656755427373*^9, 3.597656768944202*^9}, {
   3.597656813141923*^9, 3.597656849374412*^9}, {3.597657325802601*^9, 
   3.5976573317235117`*^9}, {3.597657368716136*^9, 3.597657369226915*^9}, {
   3.5976574345097733`*^9, 3.59765759271139*^9}, {3.597657744118825*^9, 
   3.5976577826175947`*^9}, {3.5976578472809258`*^9, 3.597657847392208*^9}, {
   3.597657923813686*^9, 3.5976579776845007`*^9}, {3.597658039416749*^9, 
   3.597658126857451*^9}, {3.597658188304442*^9, 3.597658191799101*^9}, {
   3.5976582491439953`*^9, 3.597658258406513*^9}, {3.597658395476738*^9, 
   3.597658539271133*^9}, {3.597658663365449*^9, 3.597658714762671*^9}, {
   3.597658795724235*^9, 3.5976588742634583`*^9}, {3.5976589059925957`*^9, 
   3.597658916975464*^9}, {3.59765920634805*^9, 3.597659276365921*^9}, {
   3.597659307429254*^9, 3.597659349060755*^9}, {3.597659595336993*^9, 
   3.5976596456845627`*^9}, {3.597659738114628*^9, 3.597660026797495*^9}, 
   3.5976600581272*^9, {3.597660095509297*^9, 3.597660157497477*^9}, {
   3.597660189603321*^9, 3.5976602301436*^9}, {3.597660441664194*^9, 
   3.597660442453128*^9}, {3.59766389027878*^9, 3.597663898083735*^9}, 
   3.597664886348531*^9, {3.597665722849728*^9, 3.59766575356353*^9}, {
   3.597665786916369*^9, 3.5976658300848637`*^9}, {3.5976658792676363`*^9, 
   3.597665879947159*^9}, {3.597666123712319*^9, 3.597666155876718*^9}, {
   3.598177144232874*^9, 3.598177144876113*^9}, {3.598178399701195*^9, 
   3.5981784004969788`*^9}, {3.5981787476311083`*^9, 
   3.5981787602117243`*^9}, {3.5981788194572163`*^9, 3.598178825840826*^9}, {
   3.5981788713827133`*^9, 3.598178978314887*^9}, {3.598179008362055*^9, 
   3.598179010631489*^9}, {3.5981796266118317`*^9, 3.5981796612479553`*^9}, {
   3.598182256846731*^9, 3.598182337230505*^9}, {3.599987014828148*^9, 
   3.5999870245073433`*^9}, {3.599987068049067*^9, 3.599987120812973*^9}, {
   3.599987308930896*^9, 3.5999873168978148`*^9}, 3.599987354561657*^9, {
   3.5999874169198437`*^9, 3.599987444749773*^9}, {3.599987479263176*^9, 
   3.5999875021422358`*^9}, {3.5999875608502398`*^9, 3.599987601818241*^9}}],

Cell[BoxData[
 RowBox[{"{", 
  RowBox[{
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXtwE/eW533v3bo1UzO7s7UzO7NbM7t3Z/7YOzVbpardmd2qrZ0bEK9A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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnVt4E9eW533m9EPmm3mYS3fPU/d0z7x192ge5qG7v5lOEATCLQgCAZKI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      "], {{0, 
      244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnWlwE+ea733O3Erdmjkf8mHOrZpTt+bO1MyHU/eDPsxM3Q9TM8SCsCUh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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnWtwE9ee4D07t6a29sPU1t0Pux92tmqmbu3MVO3o7nzamTu7uTYQAoQg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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXtwE/eW532zU1O3avb+ubWztXerdnZ2a2r/WO3W7OzW1swdYplHCBBE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      "], {{0, 244}, {
      358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXt0E9e+333vabvac/7oH+067V3tP73tav/TalfbdVfbe4llnnmKV0Ig
ysnrRDkknOBAICiQQJTwUEhCREgi2xjxEsYRYGQwMgFhEBjEQxiEQUAECLB4
yCBsGSNs+dHfaEujsazHSDOjmZF+n6VkGc3Mnj3a+/ed/fjt/ftPb8+dqvnb
srKy+f8S/jf1rU+U8+a9pZ32z+AfFdqP3337d/DHY/hP8zdlZdTfw6MoQxAE
SQMqBoIg7MmgGKMPIQhSsqBiIAjCHlQMueP3dz969ITNmVimCHdQMeTLgwe9
c963PvNPVeVjqr5fc2xgYDDz+VimCHdQMWRKX9/AO2/vALl48fmNY5U18Mda
Q2vmS7BMEe6gYsiUTRtdoBKzXq3r6gq73XeJaJw/fzfDJVimCHdQMeRIKPT0
2YkbQCLOnvWTbzbUnoZ/fjB7d4arsEwR7qBiyJHtdedBHz6au4f+pre3/6UX
NmVtZiAIR1Ax5MhrM7eDOLS2+phfrq85BV/qvrCLlasiJRIM+L0et9sFuH2B
kNj5ERlUDNnhuXQflGHK5C1JkyP37vWUj6kaP3Z9T0+fWHkrKkI+i0GrLEtG
oda7ApGkc70WLRyBj8mdUlLClkplmUJRptC4wwXIuoCgYsiOn348kW5mBPop
cKip6XLKC7FMcyLkMoxSi4Rs2PwjRMNtVJEDBlcwZWLx4yqnzBspqBiyY+aM
unTjFXsaPXBowcf7Ul6IZZoTRDHUOpPT4w9H5SHodVQq4j+i2sw0fbdRnVkx
THHFcKFijAA7fcJy8+Yj0ISXXtg0ODg0+uijR2HlM9VjlTW9vSk6JqgYuREJ
+QOjuhBBR8z0R7YWUDFyrl25dPqQvLH84gbF+FKXdnhzzgeUF+jhlmujD6Fi
8EHYnMr2UTFyrV05dfryJWDRG0pcfxYttIEgNDdfSXeCeWsbnLBq5eHRh1Ax
+MCnU2AbgzfFYNnpy5egRUulaHT4eUhMhgwMDBLHrUDgcbpzfvvtAZzw8jRz
ITNWOkS8lnid1noZ7y5aMYyp50IiKVsmcoQvxcip08eBiC0qGlqLl5fk5IXH
E6A8w2fWZThnaGhI9SLlynXr1qOCZaxk8McbGPAO9DAP0IqhqtSbjMmYjPp4
hx0VIzOpO31ZCfrcVnP0hzeZzGaL3eH0+uPXR7yV0RRNHpn/9LlTv51y9dSv
StHjYKJbdhBO27WzvTC5KhlCFrrRrDIGRh6jFSMbqBiZSd3py0TIa9SMHkAt
K1MY6P5hwK6LfqMrtc7JksX7QQps+9IOYhD27qHmWD9b8mvS9zyVaWkSMGni
cqHQeke1pmnFUChV6lFo1PG2NipGRtJ1+tISco1QaqW6UqNRKhREMRi/tE9L
ErWXlmZMmbyFTXejo6ObzMAmfV/yihF0O7Lj9o0y6ZBHR7/EVAZfqpqcbRwj
jCOfLEjb6UtDbIyCYLAnRirCwYB/pGuHgxSh2iJzl9scuHs3RHbDYHPy1Ki2
+G6MGLcvdcUIOVO0XUejc468yq2h32A6azpzzzpXYkTFyEKmTl9qAnZayLU2
X7ZzdUSK5O6lz55Ddi+IwMIFqf05k1i29ACc3Nh4ifllqStGJOCwZsXi8DBN
PmCghyz19gzN5LxnV0M+p1GvraTQGq0jDgY9DrPJ7A5GQh6btlIDZ+gMFl+i
wgcdFrPZ5o4MB20GnSZ63OLMYjjcEUYxsnT6UsLw6NBmfeyQ21gcis2en3+i
lpOYNpxhc/LOHRfg5BXLW5hflrpi5I7LEB9/0GRxD8hPMTwWbXILR6H1xO3F
FVUrVWXCSYFkJbbWLeSMipmqcuSYq8bk5uXZ08G/YrDo9KW+LiYCVB8mq8aE
4yMkpTNjUhldZZa0wj0dVy53Zp2HRTLDGIXTeLJV4zwUI+Kzkq/0NmqQD1oS
MX2qtEVGpqmoNLp8Ab/HRv6t1Ef7TWF60E9ptLkCQb/NQL5QOVNmgSd4Vgx2
nb40l8YUI/aDZCbsjv46CquvJLolQ0NDzz9rAhF40NnL5vxIZHDi+Fo4n+U2
48gowmbGu1tvSnayMBitgVQeXOwVg1yi1DkSZwXsCmLyocQJKoODvk/QqScK
QR2PKYbannCoDhK3D4OQLW9eFYNtpy8liTYG+UEyEvaYyLlmT0koBpn+mDJ5
C/tL5n4YbZMcE7xjW6TQY5XpUI70Es91tXvEHl2GNdK6g9HTYqpCFMPI3HAj
5KKOK7RU050ohsrENAByidYqYKHzqBjsO30poUUAysKRrVkVlxe1qyQEIzbs
uWihjf0lVcaTcMn6mlP0N3m9BUqWsEUzcvwgmRF743jMsca1MfX7PRRvsajj
x2OtjhGCEPtyhGKMkCDStCaeSDHFGPF6dZuo73RCeh3wpRg5dfrSENDTw6XZ
NCfkKq2Rz+oqyvxr159mf4njyHW4ZP68JvobVAxJ4Yq2JyqZ7YGYP/OIXglT
UiK+qJUpjZSIpGhjRKxRlUvTzuEHnhQjt05fOgIOfSIVlc7h9YdCQZ/HZTVq
VZpUG5iQn64EWPDxPjD/I4evs78kEHgMlzz/rIn+BhVDUvjjrsu0ZHitZOok
9g2p5Gq9Pa4JEXt0UmHkyKfaTg/l+W3RUYHsTXQu8KQYuXX60hNxpvPPVxqY
jTMiUCqjsBNJ0oF4ZPn93TldRXxEb9/qIv9ExZAY/lijWqkxms1GXazm6x0x
96XEWhUFnGAxVBIbU8aOJ+ZKyjQ6o8UcGxRQ6h0ZbskdnhQjt05fZnwO02j5
UetsTNcVoqV2Vp5hsufRozAY/qQJG4aGUuy7lYFPtc1w4a/7r5J/omJIjojP
VMms7CqTMzEEQRRDozcwbEtt88ZfvUQxFBqDXpM4rLcJ3U3nSTF4JxzweX3+
gN/nCwRDSR0a0jbTWNh4nhcDZ11+MPzZf2nI9cItm8+yia6IiEt0EQR8gkn1
PD6OEabcVakTRm4nwRjHiAThsD8QKsQ0gFQVIy2xMU9NCa0o2RF14Fz99ZFc
Lzx9+nZ+UoNIgRRzJUzicyUFHsqTl2IEPVaqgaY0lNSa1dX6I2D4oBu5XtjT
0wcXjh+7PhLJEvYdkSDES1yfzoMz5KIOKwyoGGmJuFWUj5ylROZHaKCRwAyx
mhMketrVq53D0ixTJD2RUMDr9QbC6WYZI9Bz9/oKve+tnBSjVJk0YUPU3zuf
fpjuCztcu6eRGvPBMkW4g4ohce7d6wGTn/zS5vwuJxv9ffsNNeOGZYpwBxVD
4jhP3ASTn/vhnuynpqKtjZpn0by7axjLFOEDVAyJs72OaiR8v+ZYfpf39lKD
n+MqaiKRQSxThDuoGBJn1crDYPINDRfzToE5+IkgHEHFkDiz36MmSqBzkXcK
JBjB3j2l4vCGCAoqhsQhG+kEg/lvjFO37Ryk8N23R3nMFVKyoGJImYcPe5PW
n+YBcTL/i6YByxThDiqGlDnXdody836Pk5s37flZVva3WKYIR1AxpEyj9RIY
+8oVLRzTmfVqHaTzh9//ByxThCOoGFJm3drjYOnmrW0c01n6ORW+5N/98f9g
mSIcQcWQMmTrraOOGxzT2WZug3T+y9/PwDJFOIKKIWVmvLINLP3mzSyBVrNC
lr2/P3s3L7lCShlUDMny9GmkfExVRXk197Xq3d3ULl4Tx9cODua2i1cpQO0k
G8Xt8ee56Uo4GEvC5fYFM6cRCQb8Xo/bTU4OyG9ja1QMyXLN+xDMXD1rOy+p
zXjZDKnduFFqWwVkJOw1qEfuNqnQ2HOMmeW1G5I2rNQYHSmSCPksBq2yLBmF
Wu/ib8F6xGeFWygU8ByWDGLkt+ngrLIypYVliFMGqBiSpeXQNbDxT7XNvKT2
2ZJfIbU//vEfsExjhD2VDMNVJMw+h0B7HksiDYWSkYTWlpQEI6zwaBQ2P0+i
EfFoEmmmO4nexzufQOeoGJJlo8kFNm78mUVMSRaQPT//89+/gmUahQ45VKbU
WqMNr4g7ETe50svCgpkxuazRiPCRoEsbl41Ki3fE/aKKodaZnND3iSYe9DoS
MZjV+QQFS4lTH5eDdCGb/TZFTNbseaSPiiFZvtRRm+E0NV3mJbVTJ6nBz/+u
WIBlOsw09pH7ZNLmlmTvKdOgNcfA3Fgv6IhvDj5SdiIhf2DUGz1xsopdeI7s
MGKN6VK2MkjctLLkcGxsQcWQLJp3d4GNX3Df5SW1ri5q8PMf/+/asrK/4SVB
WePUx0YUkvfdjQW2YBE8K/2ZaRNPQdg8KoIzC8Jep81EQocZzU5v0l2CdPjj
VJrg18UaNtr8grOiYkiW5yaZ8t6sLyX/8L+XQ4K///3f8ZWgXIkFK0z5ZqfN
TZU5spg3PoKhMriSk3DGhixiwcsy4YvbL+s2BnR8Ro2fqo0OZnOGzptCmxyo
l25cjc42S1AxpAkva9CS+Dw6+Gnbd4XHNGUJiZBelhRoLwYdcDxzC8FFB3Mf
vdd3yBlPP0tDhdGD0LIZOYGcJ0IGqjQ6bSK2kYbZjaIzMCqUuUNH5EZh9eU5
1oqKIU3On7tDFpzymCbx/FzzXckveycR0suSA6MT6NiFmRWDHg1IcRod3zBV
+gzoDkKZ2sxq9xJ7fFy10hxrIYR9trg4MHsZEWtcS7Q25tfxmZRUUskSVAxp
snePB6x7+ZeHeEzTdaaDdxWSIxGfRRFvA+SrGGFrfJ4jk2KkSj9OyELPlKiM
rMKBJkZODCOjlsc0gzlqQfeMylSmUCIBfYoGSY6gYkiTn39ygnVv3pRnZzMl
v/vdvxrzj8Z/+n/rSjzgUZjuC3BQDDrQcF6KETDRsVQVWpZeVAmPDpXB4/N6
oni9Pqe5MlVO6LEahTXm7AF5jmWLS/B3VAxpsli7HxTjkD3/d8FooDT/1/9c
Bsl6Lt3nMVlpEHQ7suP2RS1Y3F5JyKOjhy5VBvbDCSG3sSwjSTmhB2RUxuh7
Jxgf3FCbuQymo2JIkzde/4X37XyhNP/bf30Dkt2Ze0BGqRNyZramGLro5EVi
5DPFyGTOI5+jT8sw8hly04OVSp01J3+IrIphHJmTiM8aP6L1Dw/7rbFGh87O
qg+UDlQMCTI4ODSuogZM+8mTfh6ThdL8u38/BpL9SpePs5+kiQQc1qxYHB7i
3Un7h4/2gqBnV7M03ROzq8YMs6uOkUcCtKeESm/Pda6CVgxF9knbWEaM8duZ
3N64v1k+nuFMUDEkyN27IbDrqZO38JsslOYf/vAfIeVZM+v4TVl2xCcZR/k4
MUYXs3lw2eOOG6Yk1Ul4cDlTdxPKNPn4hCf8VBWpnTlH47Myls6QS/PyDGeC
iiFBTp+iPLo/nNPIe8qRyOCEcbWQeFcXb45hciRhfSMXdDjjRq1hTHdGgl6b
1WqD/+zMJknIFBcAE1N2Eo7fGg+jGcFwvRjxfS4E9PHhUg272ViGY0ZZaoXM
HVQMCbJrZzsY9Wr9ESESn/OBFRJ3nrgpROLyIWHvakNscbrHqqONmtl0Zyw7
VTI9MxkDC2oH2VqDMaqpNjGNOrEIBdCboi7eDAxGK5sl7/T0KKDSmb2BUCQS
CQUDHpfdoNVaU0y6RGyVzLX4eXqGM0HFkCBrDa1g1NvM54RI/OefTkDiG2pP
C5G4nGD6T47E7BnxImYoQ7Ivt8vESIOxYL4seXsKeoF5OpQsvcRdJk26JPSj
vU+pp0yMl+btGc4EFUOCLFxAbe/p4Ly9ZxKkQP/tv/kfkPj8eU38Ji5LUqzR
UFs9yaYbctOr2jWjhw3dZm1yEnrbKOtP+G+kIUXK6Qi4rZpRS0sUSo0t9bYe
9NKV/D3DmaBiSJBZM+uE2C+LFOi/+Of/GhJ/duIG3MEvSsTndtqdLpfT4XCN
EguWSQR9TrvD5XY57A6Pv0Ab8QUDPq/HC/j9gVCYt128soKKITUikcGK8ury
MVVPn/JcDegyfTW64TDGbkbyABVDaty+3QXm/Mp0M5uTdzdcrK8/z1Jb6DJd
/tWh4vTjQoQHFUNqOE/cBHOeV7mXzckvvbApuocGqzjOdJmSZW6fL/mVW06R
UgQVQ2rssFygQrF/w2pNek6KQUOaMXBtXhlEShpUDKnx/ZpjYM7Q12Bzcn6K
AUybsgWDESB5gIohNT6e3wS23NrKytcmb8XQfUFtO9ywqz33DCIlDSqG1Hg1
l8iJ+Y1jwN97GqmhjCWL93PKK1J6oGJIiv7+AeUz1fBhuelN3opx506I7CM6
MFDSu+sguYKKISl8vkdgyNDMYHl+3ooxHPcTa2+/l2dekZIEFUNStB7zgRV/
PJ+tCzcXxSBDrLXrS36BCZILqBiSon77ebBiw5pjLM/nohhO5y249s/v7Mwz
r0hJgoohKb79xgFWvIO1N2becyXA06cRslfGg87ePC5HShNUDEnx0dw91OYV
zlssz+eiGIB2UTNcbt19Mb/LkRIEFUNSTJ+2FUy4o6Ob5fkcFWNf02XKI/0j
Vh7pCDKMiiEloJsA9ltRXsN+xpPLOAYQCj2F21WUV+etOUipgYohHa5dewjm
r561nf0lHBUD+GShDVLYtROdPxFWoGJIhyOHr4PxLlqYHI87A9wVw37QCylo
/owzJggrUDGkg3krFUl53Q/H2V/CXTGgK/T8sybcYAdhCSqGdFi18jBY7u6G
HGYuuCsG8MNaaiPiVSta2N8XKVlQMaTDnPepuACuMx3sL+E4V0Lo6OguH1M1
rqKms/Mxl3SQUgAVQzqoXqTM//79HvaX8KIYwNLPD1Db+HzLahsfpJRBxZAI
odBTsNmJ42uHhnLY4psvxbh+/aHymeqK8mr4I/OZV692fr/m2J/U9c9NMs14
2Qx9mayXIMUEKoZEuHjxPtj+O2/vyOkqXsYxCNDAgKTe0+xKt9De53u06BNq
KjbpAzpTt02QYEyIBEHFkAjE/fKLpQdzuopHxYBGzivTzZDayhUtSaFMurvD
aw2toAxwdNKEWvgb9A3Ov3bt4XffHCW6gWtgSwRUDIlg/NkJdmfacCanq3hU
DMBz6T5ZmzZ/XhP8/eRJv9f7oLrqJJl+hW7LN6sdwWDyvQ7ZvXAITjhw4Lec
Mo/IEVQMibBk8X4wuoMHczM6fhUDONd2h6SZ9Jn30d7ffnuQ7qqGhoskztr9
ezkM2yJyBBVDIryurqfcqK7k5kbFu2IADx/2rlt7/NVXtkF7Y8Yr21atPNx+
Ifs+XYu1lOLB/1nlG5EtqBhSYGBgcFxFDVgcdARyupCvuRLuPOjsnTRhA2Sm
rc0vdl4QAUHFkAIdHd1ga9Onbc31QukoBrBpowsyM+cDq9gZQQQEFUMKnDie
Q+REJpJSjN7evhee2wj5OXsWmxlFCyqGFKivp7b3XPNdzi6XQoxjcIE0MxYu
2CfcLRBxQcWQAqu/PpJfsHWpKUZXV3j82PWQpdu3u4S7CyIiqBhS4MM5jWBl
p0/dzvVCqSnGcHwF7k8/nhD0LohYoGJIgSmqzWBl93J3ZpCgYngu3SeB41mG
dUPkBSqG6PT09IGJTRiX2xo0ggQVA3jrDQvk6tjRG0LfCCk8qBiic4msQXsr
tzVoBEnNldBsM5+DXC397IDYGUH4BxVDdJqbr4B9LVuaj31JUzECgcflY6rG
j13/+HGf2HlBeAYVQ3Sqq06C1W+ozWftpzQVA6iMhmpq2usROyMIz6BiiM5n
S37Ne+GnNMcxANCK/HzSEImDiiE6b/7pFzCuK5fz2cpbsopBx07q6goX4HZI
wUDFEJfBwaH81qARJKsYwIL5TVTHpOlyYW6HFAZUDHHx+6Nr0KbmvAaNIGXF
aLReogI2fZJDwCZE+qBiiEtrq49LrGQpK8aDB72Qt/Fj14fDkcLcESkAqBji
QuKgrTW05ne5ZOdKCLPfa4DsHXXcEDsjCG+gYojL8q8OgU01Nl7K73KJK8aW
zWche1/rj4idEYQ3UDHE5d13doJNXXDfze9yiSvGb789gOxNm7JF7IwgvIGK
ISJDQ0Nk7+5Q6Gl+KUh5HIMAcgE5zLCrMCIvUDFE5E50omTq5PxfwdJXDOiS
QA6he1LImyLCgYohIhwnSobloBiOI9epzT/fx80/iwRUDBEhEyU/rM1zomRY
DorR29s3VlmjfKY6754XIilQMUSE40TJsBwUYzi+Kq3l0LUC3xcRAlQMEeE4
UTIs+bkSAmlKrcY51qIAFUMsBgeHyCa6PT35byIhC8W4crkTMjnjZbPYGUF4
ABVDLG7degR29PI0TnYkC8UYGhoi+cQNxosAVAyxONxyDYzok4WcFmrJYhwD
WLb0AOSzoeFi4W+N8AsqhlhsqD0NRlRlPMklEbkoxt491AY7iz/FOM6yBxVD
LMB88t56i0YuinHvXg/k87lJpoEBDEkgb1AxxGLmjDowouvXH3JJRC6KAbw2
cztktb39nih3R/gCFUMUenv7wXzGVdRwDAMkI8VY891RyOpG0xlR7o7wBSqG
KFxw36VilLydT4wSJrKYKyEcddxAd/EiABVDFBp2tYP5rFrRwjEdGSnG48d9
FeXVFeU1vb0YxETGoGKIgn4VFc54R+7B3JOQkWIA78/eDbltPeYTOyNI/qBi
iAL0R8B23Bz8wwkyGscYjk8oG9YcEysDCHdQMQpPf/8ANM7Lx+QZcYCJvBTD
HR29eV1dL1YGEO6gYhSey5cDfBmOvBQjEhmcNGEDZDgQeCxWHhCOoGIUnsZG
KpDHlzo796TkpRjAooU2yHCz7YqIeUC4gIpReL79xgFWU7/9PPekZKcYll/c
kOHlXx4SMQ8IF1AxCs97ml1gNWfP+rknJa+5EuD69YeQ4SkctjZFxAUVo8BA
X577thg0slMMAOSCu3s8IhaoGAXG66VCeMx6tY6X1OSoGNAlgTxD90TsjCD5
gIpRYPY0Uuu+v1h6kJfUZDeOATTbrnDfGAQRC1SMArM6Gr+jvp6HYc9heSrG
g04qgvOkCbUcV+EhooCKUWDeftPCcTdgJlJQjN7ePueJm+fP5/BEb/7pF8h2
WxsPY79IgUHFKCThcET5THVFefXTpxFeEpSCYpCRmTffsLC/ZN0Px+GSmupT
/OYEKQCoGIUE3qpgKX9+ZydfCcpUMZzOW3CJ5t1d/OYEKQCoGIWERO5Y891R
vhKUwlxJHooBba1xFdTKmu7usHAZQ4QAFaOQaBc1g3H9uv8qXwnKVDGGMVCa
bEHFKCTEwO/4u/lNUI6KQZpb+lWHBcoVIhCoGAXDdyMINjKVVwdpmY5jAFev
UoHSpk/dym9mEKFBxSgYuxsugo3olvHju0WQr2IMDQ1NUW1Gd3HZgYpRMEAr
wEB28xoXTL6KAaxc0QIX1m07x29+EEFBxSgY06ZQK7Cgb8JjmrJWjEN2L1xY
OXcPv/lBBAUVozB0dHSDdYCB85usrBUjFHoa9WfD3cXlBCpGYWjaSy1A+2zJ
r/wmK9+5EsKcD6xw7eEWnGOVDagYhWHFcqrPvsPCNdxAEnJXjG1mao4Vfhy+
M4UIBSpGYZg+dSuYBhgXv8nKXTHIjDM8xeDgEO8ZQ4QAFaMA3Lz5COxC9eKm
oSGe7ULW4xiEV1/ZRkVwvoARnOUBKkYB2LnjAuWJ8QUPm4cnUQSKsdbQCpdX
V53kN1eIQKBiFIBFn1Bb7u9rusx7ykWgGKdP3+ZyOVJgUDGEpr9/YNKEWjCK
zk7+w/oUgWJEIoPPTTJBCn7+ltsgwoGKITRnznSAObwlzDu0CBQDgP4apLC9
jp+dDBFBQcUQGtJPrzIK0k+X+1wJoaXlGqTw/uzdPOYKEQhUDKGZ8bKZmgto
F2QuoDgU48mTfhLDBeOxSh9UDEEha7qnTN7C+7wqoTgUA1iyeD/l4baDZw83
hHdQMQSldv1pMIRvv3EIlH5xjGMA9oPUqrTZf2ngK1eIQKBiCMpbb1CxBk6d
vC1Q+kWjGOFwZOJ4akbp7t0QXxlDhAAVQzj8fmq96nOTTMKF8ikaxRiO7x9i
3trGS64QgUDFEI6tW6hlVl/q+Hf1pCkmxWg95oN03n4TXbkkDSqGcJAuSWur
T7hbFJNi9PcPPP+sCffxkzioGAIB1R4q/wvPbRQ0umjRzJUQvlntgKR+/snJ
PSlEIFAxBAKqPVR+MAFB71JkitF+4R6ZjB4YwCDOEgUVQwigwkO1L8Ai7iJT
DOD11+ohtV0723lJDeEdVAwhOHb0BlR7qPxC36iYxjEIZMZksmozL6khvIOK
IQSfLKSWt9dvF3xpVfEpxo3orlzomCFZUDF4586dUPmYqnEVNV1dgochLj7F
GKaWslLNDOPPOP4pRVAxeOenH09AhV/+1aEC3KsoFePixftk88++vgG+0kT4
AhWDX3p7+8j+MJcvBwpwu6JUDODdd3ZCmrZ9V3hME+EFVAx+2V53Hqr63L82
FuZ2xTdXQmi2XcGt/KQJKgaPQCt6anRS1XniZmHuWKyK0d8/QIJOnjheoF8S
YQkqBo/s2tkOlfydt3YU7I7FqhhA/fbzuDGXBEHF4Ive3v7JL22GSu5w3CjY
TYt1HGM4ujEXebozZzr4TRnhAioGX5g2nCn8njBFrBjAls1ncZsdqYGKwQsP
H/aSEAPnz98t5H2LWzGgmaF6cVOBm21IZlAxeGH5V4egYn+qbS7wfYtbMYCG
XdTQkHrWdkGXACPsQcXgzrm2O1Crx49dX/gYPUWvGCAUr83cTrnc12M0E0mA
isGRp08js2bWQZXeaDpT+LsX8VwJzYnjNyH9ZyduECKoHJIrqBgc+X7NMWIv
/f0iuDSXgmIAi7VUbAL4v3C3QFiCisGF1lZqa8qK8pqrVztFyUCJKMb9+z3E
9765Gf3GRQYVI2/u+LvJvpR1286JlYeiH8egse2j/MbhBwf1EPRGSGZQMfKj
t7ePbPyrXdQsULwzNpSOYgCfapvhRn+dY8U9/UQEFSMPIpHBeZV7yS5bPT19
IuakpBQDHpMs21m39rjQ90LSgYqRK4ODQ2RnuSmqzXcKPp2aREkpBnDBfXes
sgZu17TXU4DbIaNBxcgJaA8TZ61nJ24Qa7STSakpBrCn0RMdba7GZa2igIrB
nr6+gc+W/ArVddKE2gJ7g6ejROZKkqiuOklc5ly4SK3goGKwJBh88sHs3WS4
HtrGYmcnRmkqxnA8FhKIBrY0CgwqBhsuXrw/fdpWqKLwf0nF+CtZxRgaGiKi
Ad0THNMoJKgYmRkYGNy8yVVRTo22QRvjwYNesXM0ghIcx2CyvuYUCVXw47oT
uFStMKBiZODatYd/0TSQOrnuh+MSrJMlrhhAY+Mloufvz94t+tRVKYCKkZJQ
6OkPa1uhxUt6IpLdBgoVYzg65Tp96tboiPQG6+6LIjrUlQKoGEmEw5Ft5nMv
PLcRamD5mKo13x19/FhMH63MoGIQQOGXfn6AtAahWdjeLmy421IGFYOmuzu8
aaOL2CB8Ppq7B2xB7ExlARWDSUvLNeIUCh8QkBs3gmLnqAhBxQA8l+5/rT8y
YVwtqWyz32s4dfK22JliRcnOlaSjt7e/pvrU+LHrSRNxsXa/WzJT4cVBKSvG
vXs9ddvOvRldUEY+Cz7ed/asX+x85QAqRkoCgcfQnSS6QcWDeHtHQ8NF6LmI
na9ioAQVAxqr5q1t9CQICfH5048nbt/qEjtrOYOKkYFg8Ent+tN0N3NcRc2S
xfvtB729vdIdmJI+JaIYDx70Hjz4G3Q9Xp5mpoVi4vjaZUsPHHXckOC0KUtw
HCMrfX0DUPTz5zVBJ4WU+1hlzcfzm3ZYLvhwoCN3ilUxQASuXu207r64ckUL
2YeT/kx+aTN86ThyPRyOiJ1NrqBisKez87HlF/df51iVz1TTlWHq5C26ZQcb
drVDbcFtN9hQNIrx6FG4rc2/c8eF1fojmnd30X1Y8pk0YQO8VraZ265e6Sym
+XpUjDyAqrJ//9UvdfYpqs3MSjJhXO2c962G71v3NV2GevL0qexfKEIgR8Xo
6emDN8LhlmvmrW36VYehlOm+KvMDTQuoFTt2XLh8OVCsrw9UDI7cuBGEhujy
Lw/NerUuqf5AUwSq0KfaZuPPzqa9nvPn7kArpZheN/khWcV4/Ljv5s1HZ11+
eB1s3dK25ruj2kXN77y1g2ytOfrz7MQNf9E0gIBA//Rc2x0pu13xCCoGj3R1
hU+dvA2voWVLD7yuricev0kfaLu+/lo9tFdXf31k8yZXs+2K60wHVNTSGU0t
vGLA6x6K5vatrvb2e8dbb8JvXl9/vrrq5Nf6I6AJs99rmPHKtqQ+RdJn4vja
N//0C5y87ofjuxsunjnTEQiUaCQLnCsRjv7+gWvXHrYcurZpowsaIVAzUzZl
mZ2aV1/Z9sHs3UsW7//2G0ft+tPQvj1w4LfTp25DH+fu3VBvb7/Yz8QDeSsG
NM/C4QjU1Tv+bvhh2y/cA32GnoJt35WdOy5s2XwWROC7b49Cv2DRQht0HKBG
vTzNDC2BDL95kixAQ/Gvc6y6ZQd//ukEtByOHL7u8QTEtQ6pgYpRYMDqobbD
m66h4SL0VqB6fzinETovUF3Z1OqK8hooMjj/Pc2u+fOaln52AF6UP647sdF0
5pd69949HhAo54mb0AMCkYG36oPOXmi9DA5KqCuUk2JEIoOvTDfDI7P8fVJ+
ysdUvfDcRlAD+NEWfLzvK539h7Wt0MBrtF5yOG5ccN/t6OguDjUuAKgY0gEq
Ldg4GHtLy7WGXe2mDWegKw0dnI/m7oHe9PRpW7lYDbS6wWogEfWs7e+8vQNa
MvM+2gvNbEh/5YoWaNKsW3sc3tEbTa5t5nPQtgFrgta7/aD3qOOG03kLevdu
91144V7zPoQ+1J07oc7Ox48ehaHz/vRpJCdFykkx6C/pp4AaO+NlM/QRoM0G
jwDtsRXLW75fc6zKeBKaGbt2tu/ff7X1mA9+RqhX0DDr6emT8tiR6KM3uYLj
GEykX3zQ0wkGn4DNXrx4/6Tz1iG7t7HxUt22c9CFgffmqpWHodWxYH4TtMlB
ZOCtOkW1edKEWuJJkmR9/H6Uz1SDOUMX4MXnN8JNoTswc0bd66/VQ7GCFTMf
IT/FePKkX8qGnzfSr3JJoGIwkV3xsQdaAvTTQYcFGgynT90+dvQGtCL2NV2G
LlJ9/Xl4R6+vOQVdeMOaY6v1R5Z/dWjp5wc+1TaDBM39cM/7s3dr/rwTium1
mdvhLT918haoPCARIBS0b1vKD6gZMyf5KUauz5vfhQW+Xd4Xini7wihG5gvT
KQYWH78XCnq7gYFBECXopHR1hR909t6719PR0Z3ywnRJlSEIgqQBFQNBEPag
YiAIwp4cO0YIgiAIgiAIgiAIgiAIgiAIgiAIgiAIwiQSDPi9HrfbBbh9gZDY
+eFAOOhxEdy+YFjs3PBLERVTKeGxaMvKFPAxueVfZCGfxaBVjnJcUaj1roD8
tn/02g2KkQ+iMTqKQTWKq5jYUDRWFvZa6PIyuGS/qXvIZUjv76aw+eVUGz2W
ykTWlQnlUGhtcheNYiomNhSPlUW8WlJIRfAsUUhVVOtMTo+fxCgIeh2VtLWp
zXLR97DHFM+00uqhyiUSdGnjD1Jp8YqdQU4UTTGxonisLGKrHNHmlfOzxImE
/IFRb+CgQxV7RJVTHnUxbFbHC8XJKJTEg1R6Zf0eLpJiYkPxWJnfpou9w9Rq
+atfZsLmWF1UuWRRFYOOWB9faUwqEqdeKfeKlx65FRMLisfKAvb4uJPOF3Rr
ZP0s2fHpFHJ6eXnjIxgqgyvpUNAZGwFQ6p2i5E1IZFZM2SkeK/PH31QKiw/a
TW6VjJ8lO5HEuJNWFo15l1GVoktCCDlVaZofckd2xZSN4rEyhz5W6WIDaCGX
WrbPwgJ//M1VpjZ7xM4MK9wmddquRzhWWGUqY3G8h+PIr5gyUzRWRjdryzSW
2NhTWK7PwoKQhR53UhkDYueGHWFrPM+ZFENZTIohx2LKRPFYGd2mVWgT83MR
N3kWo1vu8/xJBEyaeD2E55XNw4UtmpJSDJkWU3okbGUhn9uRHdrJLGiKT18p
DHaPx018j112IymwSpPd7Xa5vdLR+CCrx/OlMp2QR0f7FKoMPln1i0uoVyLn
YkqDpK3MqS9jg4PULVr6MqMwSKXZFHKyejzdqFmDUGxcGlDqrLKzrMTI52jF
KKaRT5kXU2qkbWVBj8NizYojSKQ77FZnfxKQepNUyi4ScGR/OovDk/TbBwzx
15ZKb5fjWysxu2rMMLvqECVv/CH7YkqN7KwsI5HwKCLDfkespaJ3+KkzZF54
LkNc4zWydTYOxufxR9WrhAfX6IlXWVEMxZSGoreykNsYq4Ty97RjzOlrPDIu
lBDdFx6x1DHhRy3rpyuaYsqBYrIyxrPI+7XFXI5BibnJZByJwWiVy1pqulDK
ytQOf3R0nTFIqDbJ2mOheIqJPUVkZcX0LCFjllEnpYzcj10mhl0pGKuZNBb5
PERKiqqYWFJEVkYt3ifV0Sj79lLCkyENGnm5nLjN2qQHUOttci+k4ismNkjE
yv4/cxWidQ==
      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXlwU3e73/22N72dO9O+bzv3n7532plO3952OlO307lzu0xLLLMEwiIC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      "], {{0, 244}, {358, 0}}, {0, 
      255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXlwU/eW552e/DFd/f6Y/qe7/3nd1TNTNd39h2pquqZqqvo1QexborAH
EAFCIsILCQ5bIkgg8cumJA+iPJIIGyPAyGBkFhmMMEYYBAYBFotYBFgGgRFg
2chGYGT7eplzdaUrWZuvpLv7fErvFbGvfr9zfe753t9+/vmd5dM0f1VQULDy
v8L/TVv0iXLFikXa6a/Cf4zSrnrvnf8C/3gB/9O8UlBA/nsgiQIEQZA0oGIg
CMKcDIqR/CsEQYYtqBgIgjAHFUNC9Pf3P3jQ3t4eyu3r6FMkf1AxpMLNGy1z
5+x+7T+3jByx5YfvT/X09GZbAvoUyR9UDEnQ2Ng2YVwpyMXUN8tGK0vgHxs+
r822EPQpkj+oGOIHmhPz1RWgEkVf2gii786d1kkTjPCfR6pvZVUO+hTJH1QM
8bNn91XQh/nzKrq6COonNTV3yPaGamcoRDAvB32K5A8qhsgBTXhjyg7QB4fj
QfzPl2j2ww/Ne11CGYYMT1AxRM7+fddBGZYuOZDw8zOn78HP35pV3t/fL4hh
yPAEFUPkLJi/F5Shrq4p4ed9ff2zZ5rgVxcvNgtiGDI8QcUQM+6bLaAJqtd3
EERf8m+3G53w26+KbAxLQ5+KgaDf63JGcXn82YxEiQFUDDGz8c+nQRM2/+Vs
yt/6fM/gtxPGbaNHRDODPhWWgNtaqFIUJKEuMnmCQhvHGHYVgwgFfB6Py+UK
y6c3KDH5FBe9vX3UmKfH05bumvcW74ML6s94mRSIiiEchMOgSdaKOJQmV0Bo
IxnBlmJ4HeZCtTLp76DQmZ0oG7nR0PCQmlTNcE3Zzktwje67k0wKRMUQCrsu
FhrKQoPLF4CgIIig12nRxDU6DE4JiAZLihHQp2htRVVDa2VLNPxOk37YSNBP
m86AGpQUX8hwTZPnKbUQlEmBqBiCEHIb6b98oSl5NtxnUNO/1zJqLAoKS4oR
JBVDoTZaHb5AuEtGBOzGQroQo4udflrAbSaVSWP0DgPVmDWDnAq5eaMl82Uz
pu2Cyxob0/ZcEEEJmaPdEXh1pr6EcNM9Fq1V7JrBkmIMBP2+ZFGw61SRlpje
mZ+ZMQivNdyc0bpz3MEpDZqanlKrOodcbvHdtyfhyj27r/JjGJIVhM8abX0r
LOnfc25jtJ2hNIh8EJQtxUgJ3R5TZaMYIb/HajIaAL3BZE3RtfOYw60XtUnk
f9t82F1+BXTg22/qhrzyWHjF+JrVR7g3CsmaoNMQFQydP8N1AXt0pEPtEver
kFPF8Fm12bYxnCZtQSIauy9BnH1FVDvD6svHPDGz4uPDoAPHjzcOeWVba2d4
jrU05ZqNeFjxKZIVAYee7pJk6kmHnJHmeIHKIe4XIZeKAT24SIus0MKod+aM
jQEpNFqtJjbAXOge/OeOalGRLCWjq4sYO3or6ADDw3PmzyN3tl6//iTzZagY
7EB49IWawsxoNHqrB6516iNKoDJkfGkS7uion8o5XBXDZyuiGwmMxhz80R6f
QusMUAIRskVHQhI1J2Cj5MTkEXcbLieoedXF71QyvP7HH+xwfbnpcubLUDHY
IehIPzEYQ6FzDKBiMCZETWqE0TsydeBo6DlrXXyzjG6tqRJGhHy6cAVqoww3
b24tuQAK8Mvmcwyvp4YyPv0kzVB8FFQMliACfp/P588A/DoQXr/ot+uir0Hs
laTF74hNQGstHmZfChiifRC9ze31eNwkHq/HEdFepWHwEGjQqGIg3dJk2QcW
ciVnPdOJtkePgnD9G1N2ZL4MFYN/gq6sRz6d4m41s64YbgvdGSnQ2ZhPLkcU
IC2Js07RQRK1Sdx/4Kzp6iJGK0tGjtgSDHYx/9bUN8tANJofdHBnGJIDhM8S
m11NHMCP4TZp0jznooNdxXDRN16gsrizuvWhFCOxVxKZwlYUWmS2mOvSJV9W
gxgU69bWwLdqau5wZBUSI+QuVCqUmVEoCk1u6moTvdQi7S5jDz1BWGhm2CYX
DBYVw2/X0+FtSy+naQgaoqu97IwW1wcjjtDIrY1B7WH/WV+f1bdMuy7Dt37a
dIYjq5AYsTGHjI3i6IqCWMckdSc9YCqkx/w0btG//1hTjKCD/jOasmtdRL5P
S3GRjcmUaURhVAa5jXyuXFGd8gidzFxyki0TzXv7M1yTw1sASQkRGhoiFvuE
VRubXVHrzN4A9ZYj/G6bNm77ps7OaI5AWFhSjJAlOjmkMbpzs8RvpwdAChks
ewtEFIO99edioK+vf+L4bRD7ba2dWX2xs7Nn5Igto5Ul3d1p85igYghHyKob
omFisEtjbRErihFym2J3rtEZw0u8Y+j1FicT8fTrY3qrNjk8QYIgQkG/120z
67U66yAVCTmpJoleChuEmePxtIFczJ5VnsN33w5nKHDfTLtzDRVDWLwOkzrV
Sg5y/3tA9L2RKKwoRmzxfBqU4dUsQxNwpj12RKGPl4bojhW1yJe7ZEuV5SaZ
l+SL4zl89+uvTsB3Dxy4ke4CVAwRQPg9LrvN5nC5HDar3eHyBSQ2Dsd+GyMV
WayzIvwWfWFSAQr14DaGI9zGUxbZmRYrEb77pg6ivrLyWg7frTRfg+9+rzuV
7gJUDCR/WFEM9gkFvJ4wXp8/kHT4n59aIp642UQGzB+qZ5EBl+txDtOyCJIV
IlWMTASolRsm2R2QEQx2QciPHb11yF2oKaEHP3P7OoIwQWqKEbCEJ6p0EhlY
zoqLF5rJZEbvJyYzYs68OXvwPC6EU6SlGG6yeaEyS+TU5WzZuSOXtVvxbFhf
myGDszh9ikgLaSmGvFmrPQrxXnts6FN00rGr7HIGzUGfIvmDiiEeplG7yZpz
303mcDyAEj5aVpXyt+hTJH9QMUQCdfje5InGfDIv04Wk/C36FMkfVAyRUF/v
hWAvXH4oz3Jen7wdymlpeZ78K/Qpkj+oGCLBuK0BIv23X5meu5WO5R8dgnIc
5+6zYhWCJICKIRI+/cQKkW47nu/xCPqf6pmc+YkguYGKIRLyH/akOHzIDeX8
Ke3hLQiSF6gYYoCVYU+KmzdaoKhFC8zJv0KfIvmDiiEG2Br2BF6+TLtWHH2K
5A8qhhhga9iTYu5bu6G0pqanCT9HnyL5g4ohBrSfHmWYM5EJ1CnBtbWJpaFP
kfxBxRADM6bvghh/8KCdldK2lV6E0rYYzif8HH2akoDX7Qzjcvty2A5NhAI+
j8flcpEleLxJRzMkXewlL3ZR9UntOJ0BVAwR0NERolIt9/XlO+xJUVfXxCRF
GjIQ8ugTztFTaGxeplHsdZgL1cqCRBQ6szOFbBCeouRr4WqV1uZh7SA5wmuB
ShQKuA9zhkJ91iK4qqBAac4+CSkqhuBQm9w/WHqQrQLv3QtAgXNm72arQHkS
csed9aZQxJRDYWEkGgF9+vSrKXImBgflLEjQKWvW2TrSQLg1sTLTXURn+lAz
OII7EVQMwSk3sZxqhCD6Ro0ks6p1dcnukDLWiGW7UGot4dMTCJc5lmjIM/Rf
LkgqhkJttDp8gfD7nAjYjTERMroGv+QJd5FKbbA4vP5IxyXgsdGJSpTsHYnv
iB5anvaoTF8kJbpCm8uiHVQMwSn64jgoRvXhHLM2pIQ6V/zO7db4H6JPaaIn
S5MJb+IPW6HDjUlusqDfl9zyt0dLYCIChMcclSgLWyMasTILilK2MlzGiFYa
XLn0hlAxBGf+PDK6b99qHfpSxqz/7BiUeWxwUkX0KY1DFxlTSMxeQWdMTswM
zhRaixhl0gm5qOjNMhloyOOwhlN86A0Gk8OTYGmAzuKRShN8RZGGjZZ5UuR4
UDGEJRQioPsAnYienrSZiXKgdCs5XVK8ZdB0Cfo0AuGJdh5UjsSQosNNxSyb
ZyI+q5Z5G4PO6qVmnhcs4NQmjaCqDfZ4wfGYI/en0CaOfmcnaKlAxRCWG+kX
defDCZsHil2rPRr/Q/RpBHoQUqlPVgWnXpW6+cGIkFkTeYUXWoZ4h/td5uhY
KOO0O0GnmvaiSlOkjaX30cR3o2IpTdXOwb0de2TCRmHx5jjGhYohLJaDNyC0
v/7qBLvFNjU9hWLnzhk0XYI+jRDtCxSoDMmR6jKoc1YMn43OBKpJedS9z2Ex
GI0GfVFsVlZZaGe8DMQWzd9aaIq0EEJea1Qc4nsZhCWqJVpr/I+jMymppJIh
qBjCsvHH0xDaFXuuslss9HFGjSxWvlacIQ3rsIXwmiOBp2RTMUJuMz1nqnek
Thvq1CXOyKoMdqZ6ERtj0ceb7YrOlcaPWgQc+mgFxmCsAF2KBkmWoGIIyx+X
HgTFcDY8ZL1kakAVMxEkE6JnE9hTDL/DSIeM1pI2Hn1OaGOYjAZdoSpeOgod
fgazuU5aBPRur8cdxuPxOkyFqQymx2oUlshiD+gxRW47tyEaClQMAenv758w
rhTiuqOD/dXCn61LvbtEpgRc9qFxecMKwXavxG2hOyMFOhvTKYiQ3xXL985g
aiboGiK7cYLB9ICMyhDuwgSigxtqUz5PGyqGgDQ3d0BQT59axkXh1HRJSfEF
+idy9mnQkTmaIhSFM4bHRj5TxGm2I58uEz38qLK4s1zhEHLFLdEcopkxpGIY
BhtMeC3R32h90LyxRBodRbbUPSaGoGIIyMnwBpBP1nCyAeT48UYofN3aGvon
cvYp4bdbhsRsd1OrO+n14aqkSQp6dpVR091vj/YUClS2XFZ6h+ilp0MKFK0Y
Cp2DWeEBQ3R81ejyRCvKZWV4PKgYArK15ELyqgm28HjaoPB5c/bQP0Gf0kQn
GZPWOMWNLg4tGLFJzAJTtq2LCFkoRmydqiL1Ys5kvJa4rTPUV3NaGR4PKoaA
UKcBn7DlexpwSrq7e5WvDZouQZ/SxKJPbYoPdUe0S6IxxZZUEQGP1WKxwv9s
8U2SEB2OGubrrxLwWaOtACZNGj890xJvXibiNC21QmYPKoaAzJxuYvFYjGSo
xM1NnshhXOjTOIJGepGTPjK/GTeAqYlvuscmKQqU9BrRkNsUi0ONzhhetB1D
r7c4Bw0XhLxWjabI6nD7g5GifS5LbDmWUs9kcIGeHgVURSaPP0gQRDDgdztt
eq3WkmLrOmEtjJ+UyXFleDyoGEIRDHZBOI8bw9qxGMlQh3GxdbSX3IhfPzmY
hC5G3JBjbFV50DnEOKRy8GhDnOxA30CpHLQug+H+ehKnUZNYUxSdI0UzJd7O
nFeGx4OKIRSXL/sgnJdo9nNXRUkxOU5SuvUid1VImxR7NNTJ8x1BF73WItb2
GNTGSEXCZvPYIpAEYdHoXQwWY8Tjd1k0SVtLFEqNNbXseKNbz3JfGR4PKoZQ
VJqvQTj/oDvFXRW1x8jpks8/O8ZdFdKH8LocNofT6bDbnTkOXzKuKuT3ed0u
siqbzWZ3OL15nNoX8Hs9bg/g80FHh7+DUFAxhOK7b09COO/fd527KhobyemS
+fMqqP9EnyL5g4ohFJp390E4X736mLsqurqorfTF1FZ69CmSP6gYgtDb2zd2
9FZQjBcvujmtiMpdcvcuOV2CPkXyBxVDELzhw3tnzzRxXRGVCaXuRNMA+hRh
A1QMQbAdT3HiDRdsMZyHiozbGgbQpwgboGIIguE3Bz/znkeP3oaKNqyv5boi
ZJiAiiEIq1ZWQyDb7fe4rujWLT9UtJDtUwGRYQsqhiBMVe2EQH7ke8Z1RS9f
9kBFo5Ulvb2Jqd4RJAdQMfgnEHgJUTxx/Lb+fq7Wh8czeya5e+X+/Xb0KZI/
qBj8c97xAEL4w2UWfqpbs/oI2QM6dRd9iuQPKgb/UGkT9T/V81Pdr7+cg+p2
7nCiT5H8QcXgHy7SJmaguvoWVFf0pQ19iuQPKgb/zFeznzYxAzfDSZTeWWhG
nyL5g4rBM11dhPK14lEj+csk0tlJTpeMGYXTJQgLoGLwjPsm+cZf+PZePiud
NYPbw76Q4QMqBs9UVd2E4P2qKN8DWrOCni7hs1JElqBi8MymjWTaxD27WU6b
mJnffiWnS/7x95PQp0ieoGLwzAfhtIkXLzbzWan1CLm75F//17voUyRPUDH4
JJw2cRsEb3v7Sz7rdbvJ3SX//n/Wo0+RPEHF4BNO0yZmgNpd8p//8UtBwV+h
T5F8QMXgEypt4prVR/ivevascqj6r//6H9CnSD6gYvAJp2kTM/PJGjL/GkgW
/1UjcgIVg08+DYctdYYez1Bn+FCHcSFIzqBi8MmM6buEWklVU3MHql6PuUuQ
/EDF4I1nz0IQs+PHcpg2MQN37rRC7f/3379EnyL5gIrBG86GhxCzS98/IEjt
3d29I/7wG3xeeeVVQQxA5AEqBm9UVFwFxdj442mhDIAGBhjwu7/5vVAGIDIA
FYM3vv7qBASs5eANoQz41395Dwz4+7/7f0IZgMgAVAzeWLTADAF740aLUAb8
4+8ngQH//Z+nC2UAIgNQMfihp6d31MiSkSO2hHhMw53AmdP3QDFWrqgWygBE
BqBi8AM1VaGeu0dAGx75noENU9/ke406IidQMfjhSPiwzS82CJmbrL+/f+J4
AfbBIXICFYMf/vJzPYTqrrLLAtoA3vzfitXkXvsLvO61R+QEKgY/LP+wCkLV
ce6+gDaAN//n/3gLzCg3XRHQDETSoGLww+SJRgjVttZOAW0Ab/7D3/8BzPgT
v2cGInICFYMHHj8OQpyqXt8hrBngzd/97p/AkgXzeT2XGJETqBg8QE1rrvj4
sLBmgDdfeeXVEX/4jc/cB4jMQMXgge3GBlCM3349J7QhJG+H8yvduuUX2hBE
kqBi8MC6tTUQpLXHGoU2hKToSxufORwRmYGKwQNvhU/Mu3v3qdCGkETyRG86
I7QhiCRBxeCaFy+6IULHjt4qeBJDyqF/+9/+DexZ9keLsMYgEgUVg2uuXnkE
Eap5d5/QhkR8+uqrvwN7JowT5mAfROqgYnBNZeU1iNDvdaeENiTm05nTyTSs
Xi+mYUWyBhWDa6hjMQ4cEOxYDBrap9RI7LGaO0JbhEgPVAyumR+ezXS7hZ/N
pH26c4cTTNr881mhLUKkByoGp3R29owcsWW0sqSnR0Qrps47HuDgJ5IbqBic
cvmyTyTDnvF0dERONRd8+gaRHKgYnLK7/IqwpwGng1oi0tQkiiUiiIRAxeCU
LzbUkgssq28JbQhJvE83rK/FlZ9IDqBicErkVe4Rxas83qdUKoQfRDDni0gL
VAzuoJKgjRsjluGCeJ9ev/YEbFv4Nm57R7IDFYM7LpxvFtWURLxPu7t7RyvJ
s81fvOgW2i5ESqBicAe17OEvP9cLbUiEBJ8uXXKAPPPzIp75iWQBKgZ3rNUe
Fc8m92Q2/3wWzNtudAptCCIlUDG4Y/rUMgjJ5gcdQhuSmroTTWDe6lVHhDYE
kRKoGBzR1toJ8Th5orG/X6RbRFuePBe5hYgIQcXgCOpsz4+XHxLakBjJPqVa
QbiJFWEOKgZHbC25AMG4xXBeaENiJPuUWsd1qArXcSFMQcXgiNUrqyEYT9Y1
CW1IjGSf7guf3fH1n04IaBUiLVAxOOKNKTsgGJ88eS60ITGSferxtIGRs2aY
BLQKkRaoGFzw8CGZRf3NN3YKbcggkn3a398/ZdJ2MPXRo6CAhiESAhWDC2pq
7kAYrtPWCG3I0FDncYlkrxwiflAxuGDjj6fDCZE5zOReVXVztLJk08Z899FX
4lAGkg2oGFyweFElhOHVK4+4q8Jy8AZU8eMP9jzLaWp6CuVMn1rGilWI7EHF
YJ3Ozh7la8WjRpZ0dRHc1ZKDYqTz6VTVTvEkYEJEDioG6zgbHpIn9b23n9Na
WFSMb76ug6Iq9lxl1UBEnqBisA61ZVX/E7dbVllUjNraRjGknkckASoG66xZ
fQQC0Hbcw2ktLCpGR0do5IgtY0aVhEIcdqMQeYCKwS79/f2TJxohlls4XrvF
omIASzT7obRzZ++zZyAiT1Ax2IWaepg5nfNVlGzNlVCUbr3IQ08KkQGoGOxy
8AAZyEVf2riuiF3FoI79nDN7NyulITIGFYNdQCv4ybLKrmL09fVTG2Hu3Quw
UiAiV1Ax2GXG9F38ZA5idxwD+O7bk1Bg2c5LLBmIyBNUDBZ59CgIQff65O08
nGrFumLU13uhwHcXiyvhIyI2UDFYxHrkNm8b0FhXjO7u3onjt5H7WH3PWLIR
kSGoGCzy7Tfk4sm9FS4e6mJdMQaigzCmXRxuoEOkDioGi8ycboKIa2xs46Eu
LhSD6phgojQkA6gYbEGdovPGlB38HM3N7lwJBUH0UTMm/IgeIkVQMdiiquom
xNqGz2v5qY4LxQA2bSRP9vj1l3PsFovIBlQMtvhiA3ku90HuV2JQcKQY1FKu
6VPL+vowiQmSAlQMVoCeiOp1sj3/4AFPuT+4GMegmPvWbij5vONBfgYi8gQV
gxWo7SQzpu3irUbuFKNs5yUo+fPPjuVnICJPUDFYoaLiKnla5lf8nZbJnWK0
tXaOGlkMH/hHfjYiMgQVgxVWhfMZHau5w1uN3CkGsOFzckzGuK0hDwMReYKK
kT9dXcTY0VshxAKBl7xVyqliXL7so/KtdHf35mEjIkNQMfLnwvlm/ndkcDRX
QgO3A+UfPoQpWZFBoGLkz+afz0JwFW/hNSkz14pRe4w8/HO+uoKfBWmIVEDF
yJ95c/aQ2UmuPuazUq4VgyD6qJ379fVejqpApAgqRp48eNAOYTVl0vbe3j4+
6+V0HIOCmgBauuRATgYi8gQVI092l18RJAshD4rx8mUPtc0EV3MhNKgYebLs
AwvEVF1dE8/18qAYA1E95DpbEyIhUDHyob09pHyteLSypLOzm+eq+VGMri6C
yrHIvyQi4gQVIx+oQ7dWrazmv2p+FIOuaO6c3QTB60ANIk5QMfJhrfYoPyeH
J8P1XAlNb2/f/HkVUNe+ymtc14WIH1SMnOns7Bk7euvIEVsE2X/Bm2IAZ07f
g7omTzS2t/O3qBURJ6gYOWM77oE4WvZHiyC186kYwOrwxpnvvqnjpzpEtKBi
5My6tTUQRJVmYdrqvI1jUDQ3d4wZVQI1XnPxulANERuoGLnx4kW3gF2SAd4V
YyCam3Xxokqe16ohogIVIzcOH3JD+Cz/6JBQBvCvGF1dxOyZ5GHplTgEOoxB
xcgNauGW9chtoQzgXzGA+jNkeoKJ47e1tr7IuRBE0qBi5IDPRyYaGD+2tLOz
RygbBFGMgeiEsvbTo/kUgkgXVIwc2FZ6kecz+pLhea6EBloXkyYYoera2kae
q0bEACpGtvT398+eVQ4h42x4KKAZQinGQHQM5/XJ258+xYNAhx2oGNly8QJ5
4tasGab8j5o5W3//ZF1TVifjPXoUhK/cvtUqoGIMRM815ScnNSIqUDGy5fPP
jkGw7NzhzL+oN98gN3ll9aam3u+6704KNY5B0dLynOqbHD0q2NgvIgioGFnh
978In8xf0tbGQoNcuooBHKm+BQaAbjx58pyVAhFJgIqRFSXFFyBMvtjATnJV
SSvGQHTV6/IPqzDl4vABFYM5L1/2TJm0HWLk+rUnrBQodcVobw9Rp2fsLr/C
VpmIyEHFYA517iWLW8+krhiA49x9MGO0ssTjaWOxWES0oGIwhDxbexrLZ2vz
rBgcsfHH02DJwgVmTIc0HEDFYEh1eKBv4dt7WczfIQ/FCIUI9Vwy/4J+0xmh
bUE4BxWDCdDAeCu8aovdzKryUAzg9q1W6JiQDbAzmNxE5qBiMKHKcpNMEDav
gt1JARmMY9BU7LlKLQRtacHJVjmDijEk0Oqe9mYZeZ72CZbP05aTYkBn7ZM1
VjDpg6UH8QxhGYOKMSTUGowlmv2sZyCVk2IAHR0hanD411/OcVQFIjioGJmh
T6u7fp2dNRjxyEwxAJfr8aiRJZjfRMagYmRmzeoj3J2IKz/FACorr4FhE8aV
eu8FOK0IEQRUjAzU1jZSp+4HApycui+buZIEir60UQPF/KeKQ7gGFSMdbW2d
r08m14RXH3ZzVIVcFSMUIhYuMFPb4Vkf/EGEBRUjJfCcr/j4MDzzq7nMkChX
xRgIj/9A2wwsLN5yXmhbEDZBxUhJ2c5L8LS/MWUHK7va0yHLcQyahoaHo0YW
g5FgMz81IjyAipGMw/Fg5Igt8KjDPzitSN6KAVRVkSvfQDfO1t/nrVKEU1Ax
Erh79yl1utR2YwPXdcleMQaieZHGjSll64gARFhQMeJ55Hs2fSq5vHPD+loe
huyGg2IAYC015XT7VivPVSOsg4pB4/e/oLabfbSsqquL4KHGYaIYvb1968OH
o06ZtN3t9vNcO8IuqBgU0Lqg5GKJZj9vqwhkPFeSAEH0rdPWUOeCYq5nSYOK
Ady80UKdPgdyEQx28Vbv8FGMgbBofLGhlhrTwIFQ6YKKUXuscezorfAkryg8
zPMaxWGlGAPh7gk1pqF8rdi81yW0OUguDGfF6Ooi/vyjHR5g+MA/+N+jPUzG
MRIwbmug/ubffF3Hz3gRwiLDVjGuXn08d85ueG7HjCqB6BPEhuGpGEDdiabx
Y0vB/kULzPdww5qkGIaK0d4e+kF3inrNLVxgbmwU7BDsYasYQJPn6bw55Omg
0CUsN12GDovQFiGMGFaK8fJlz84dzonjt1EH5pduvSjsaVHSUoybN1o2/3z2
+HHWUrp3dvZ8H5Xu9xbvg/LZKhnhjmGiGMFgV9nOS29M2UE9n6tXHbl/v11o
oySmGNRp6qwfFXLhfPPM6SbKL0VfHPf5nrFbPsIuslcM6HT8+Uf7uDGl1DO5
9P0Dly75hDYqgrTmSjhSjIFw2694y3lqxmrUyJLvvj0pBj1HUiJXxWhr7dxb
4Xp38T5KKOCzamV1Q8NDoe0aBCpGPC1Pnn/7TZ3ytWLKX2tWHzlbfx/HN8SG
zBQD3k27y68s+6OF2nxKbWfQ/1Tv9YrxnYWKkczDh8/gpqj2BnymvVn2y+Zz
t27h2nKxIAPFgObE8eONP+hOzQ4v86Y+8MitW1tzsq5JzKn9cBwjHR0doXLT
FWoyhfrMnmn6adMZh+MBLuEQFikqBjwzN2607Ku89lWR7a04laDOwIEf1tU1
dXb2CG3m0KBiDAk4Wr/pzNRwvhjqM2ZUyUfLqkq3Xrxwvvn5czxHlG/ErxjQ
k21u7jhz+l7ZzktFX9oWzN9Ld3Wpz4Rx21avrC43XYa2K7s5y7gGFYMh/f39
IB2gEpp399H9TeoD7RB4KqArCgLS2vqCf9uGG6JSjJcve7z3AufO3t+/7/rm
v5zVfnp0vrqCSugZ/xk1snjhAjM8ugcP3GhsbJPu4BgqRg4Eg13w+vhl87ml
7x+gUsnEfyZPNC5dcuCbr+vg/XLC5nG7/dDBEdZgmcGzYkCH4smT5+6bLfVn
vFWWm9tKL/7w/alP1ljfWWieMml7gvfpz8zpplUrqzf/fLb6sBueAdn0ZFEx
8oQg+u7cbj1U5f5p05kPl1nSPUITxpVC0xQaoj/oThm3NcD1Z+vvQ4vU73+B
CR+zhRXFCIWIttZOr7f9+vUnDseD2mON0EjYsd0JMf71VydAEN7XHHhrVjl0
H9JpAj1cCY3MFR8fhkAw7bp8sq7J42mDwtm+abGAcyWsA3/MK5cfVVXd/PWX
c5+tq1m8qJJa4pvhAzozf17Fsg8s69bWfK87tcVwHvo48G6yn7p76ZLvzp3W
R4+C0LCRVoeXO7JSDBDk9Z8dA63+YOnBRQvMs2ea4K9NnRfN8ANdjBnTdr23
eN+a1UfgsYee6YEDN6CReftWK0dZhMQMKgY/QLzDq6e+3gvd2K0lF7779uTq
VUcWv1M5VbUzYUws8wdeefD0Qk8Z3oArCg+Dwnz9pxMbfzz926/noOmyZ/dV
KL+m5s6pk3fhvQnCBe3he/cCj3zPwMUvXnT39Ih32o452bYxEsad6LYB/PHV
c/fAXxK6D19uOL7xz6dLii9U7Ll6pPoWeAraHg8fPsOR7QRQMQQHWg7t7SGI
68uXfRDp0FMu23npl83n4DbXaWs+WlYFb8ZZM0zUYdH5fyB8xo0phffs9Kll
c2bvhr7Su4v3LX3/wPIPqyBw1mqPblhf+1WRDfwLQvSzvh60CCRuu9G5q+wy
RFNl5TXwO7R/QJdsxz1gMPTuQZ0aGh6CQF1zPYb+PnTTmpqeQoO/ubnj8eMg
9LzgAevoCIFsdnb2QI8+z45YVopB//Dq1ccg2iCeYImceoI8j/fiOAa7cOq+
/v5+aCe0PHl+9+7TGzdaLl5ohoA9ar19YP/1ctMVaC2DzoA7IN6h7QHh/+Ey
i+bdfW+rK6ApDo6GzlHyGH5WH/ruWNEuaFyBPfCuh4bT5InGN6bsACOnvVk2
c7pp9qzyuW/thgYAGL9wgXn/vuvJf2SGf3xBJlD4BBUjA8NcMVgBmjShEAHv
WXj1Q6sbxAf649evPbl0yQdNhdP2eydsnqNHb4OXobdu3usqN13esd0JcmT4
zUHfHbgAdOmLDbWfrav59BPr6pXVHy8/BAIFbRXNe/uht7Xw7b3z51VA1EPr
CBoz8Ji9Pnk7NJPGjy0FichqGAE+UHv8LfCjGLl9kefqcv4in9XBsxT/ruFH
MeJrZK4Y6D52v8hudb29fT09vdBJ6ezshg4LdM3gzdXa+uLJk+fQd4Aezf37
7Sm/mM6GAgRBkDSgYiAIwhxUDARBmJNtzwhBEARBEARBEARBEARBEARBEARB
EARB4iACfp/H7XI5AZfXHxTanjwIBdxOCpc3ILNjqWTkpuGE26wtKFDAx+iS
vsuCXrNeq0xauKJQ65x+6Z3w47HpFYNvRGOwy0E15OUmJsgmykIeM+0vvVPy
2bqDTn369W4Kq09KT6PbXBgzXRlTDoXWKnXRkJObmCCfKCM8WspJMriXMNSj
qC4yOtw+6tTAgMdeSEeb2iQVfQ+5jVGjlRY36Rci4NRGb6TQ7BHawLyQjZsY
IZ8oI6yFg9q8Ur6XKETQ5096AwfsqsgtqhzSeBZDJnXUKY44p8RupNAj6few
TNzEBPlEmc9aFHmHqdXSV7/MhEyRZ1HllMSjGLBH+vhKQ4JLHDql1B+89EjN
TQyQT5T5bdFxpyJvwKWR9L0MjbdIIaWXlyc6gqHSOxN+FXBERgCUOocgtnGJ
xNw0NPKJMl/0TaUwe6Hd5FJJ+F6GhoiNO2kl0Zh3GlQpuiQUQYcqTfND6kjO
TUMhnyiz6yIPXWQALehUS/ZeGOCLvrkK1Ca30MYwwmVUp+16hCLOKlAZ5PEe
jiI9N2VGNlFGN2sLNObI2FNIqvfCgKCZHndSGfxCW8OMkCVqcybFUMpJMaTo
pkzIJ8roNq1CG5ufI1zUvRhcUp/nT8Bv1ESfQ7hfydxcyKwZVoohUTelR8RR
FvS67ENDLzILGKPTVwq9ze12UWuPnTYD5bBCo83lcro84tH4AKPb86YKnaC7
iF5TqNJ7JdUvHka9Eim7KQ2ijjKHroAJdurZoqUvMwq9WJpNQcfQ1gJFSbMG
wci4NKAsskgusmIjn8mKIaeRT4m7KTXijrKA2262DIk9QEl3yKUe+k5A6o1i
8R3htw99d2a7O+Fv79dHX1sqnU2Kb63Y7Kohw+wqf3kYuUHybkqN5KIsI0Qo
CWLAZ4+0VHR2H3mFxJ3n1Ec1XiPZxcaB6Dx+0nMVW8GVPPEqKeTgpjTIPsqC
LkPkIZT+Sru4OX2NW8JOCdJ94UFbHWPrqCV9d7JxUxbIKcri7kXar6347Rik
mBuNhsHoDRap7KWmnVJQoLb7wqPrcYOEaqOkVyzIx03MkVGUyelegoYhRp2U
Elp+7DTGxZUibjeTxiydm0iJrNzEEBlFGbl5n3ocDZJvL8VWMqRBI60lJy6T
NuEG1Dqr1J0kPzcxQSRR9v8Bx5httA==
      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXlwU9eX552Z/NG/rv6jq/o33VVTNUvPP7P8ulxTs9ZU9w9sQgiEBCdA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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXtwU1ee593bUzO7Xbs1s9tbUztVMzX7qK2Z/sfVW1u7W7U1myDehIBC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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXtwU8ee5z2z9497q6Z2q2Z2p3ardrZqH7VTu1urmt2pqdrdqZsgAgQI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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnVl4U1e25327+6G+e5/7+7rqPvVD33u7H/TWfbsfbrDMkBAIZkrIICoE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      "], {{0, 244}, {358, 
      0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXtwE/eW5z13d7a2pmrnv9nd2f1np6Zm9o+tUdXu1tTUrdkhlkkIhBAB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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnfl7E1fW5z3T8/bT88M8Mz/0+wfMvPOznmd65rf37cRy2JIQHAKBQJSF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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXl0E/eW593vzZzTf/TM6Zk/Zjk9M+fM1uf1zDk63TPdf/R0v8QyWwgk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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXlwU9eX5/3r6T9+U9V/zNR0Tf8xUz01a011T2nqV10zXdXTDRjCTuIQ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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnVl0U8fW59399UN3v35fr9Wv/d6tXr26+7GDZeZAEAEyQJQJEiUk5OJA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      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}], ",", 
   GraphicsBox[
    TagBox[RasterBox[CompressedData["
1:eJztnXlwE/e25/3uTM1786reP1N3btX8MW/mzvw1m2pqpmam3ps3wWILJASx
hVUEAomS3EtAgZCgkIRcJSQoZBNJiLwhNhmMWCKWKMYWi8AgMGIRJmIRIMAC
I0DGMqZtt23mtFtqtaWW1JJavcjnUw7lWN2/Pq3Tv2//lvP7nT8uWDJF97uy
srJlfwP/THn1ffXSpa8apv5z+J+RhndfX/DP4Jcn8J/ur8rKqN+fpVCGIAiS
BlQMBEH4k0ExUj9CEGTYgoqBIAh/UDHkz8DAwJ3bjx8+7CqwHPQpUjioGDKn
5WLbnFnbR/y/CvgxrPi1vZ3Iuyj0KVI4qBhyBuRizKhq0IrJk7Y8P6YGfpk3
d0dnZ09+paFPkcJBxZAtXV0906ZuBZVY88URkux/8ODJ/Fd2wP9+sqohvwLR
p0jhoGLIlp/WnwR9eEO3G+SC/kso1DFuLNXSOOW5nUeB6FOkcFAx5MnDB110
f+TK5Qfsv2+rPQ9/XPjqzoGBAalsQ4YzqBjypMJyCpThow8PJv29p6dv6uQt
8NHJE7ckMQwZ5qBiyBCQhZde3AiycOnS/dRPt2+7AB8tfWe/+IYhCCqGDHE1
BkATXl+4i/PTaLR77GhqNKO1tSOnYtGnQyFCAb/X6/X5fP5AMByJSmEDGQmD
FT6flzIkGOZlQzQcHDx+EF8gTJDFtpINKoYMWfG+EwRh186L6Q74fPVhOKCm
ujmnYtGnDAGXRV2Witrup+osGXTApypVmUpnz1CHQ04jHEWdFcg9SCYatJsN
qTaotCZvOK0CRPxOvUaVarfWaAuIJXjCKUZcLQf10h8Iiat8pUNHBzGyvEo9
ojISeZrumLPeECjGrBnbcioZFYPGZ9VxqMUgZm+EOoL0x49QOUPpiolaNLH6
6stDMLzmdDYMXjS18pAeS1qzB1HbfJGc7cgdQRQj4DBy3rjB4pKkqadoDhy4
DGqwbOmBDMf09w9MnkSNf16+HOZfMioGQIaczEtab3WFowQRjQR8HrvFqKIU
I/bAekxxObD6uAuKl6MyuPIwg1YMrdHq8cferZGAW89YprUlVRy3KdEeUest
vlAETiLJaNDr0LEaHRZv0UVDEMXwmjUsnRjSalIZnMK2NcJem9nuLeH2i2HF
ryAFex2/ZT7M/O1xOOyn9R7+JaNiPGO93DVmb8qHiceKDNjj35aRs5Xhs2pj
ldSX11uRjIbCKU2TiDtekTQeVqmE38r4Tm9LVbCQRct8bgjmY00OCKIYAbtR
a7B4/MEoLZdExG3RxwvQeAVtZ0T8dkqSdNZgKapGdzdJh2FkXXd2/txdOGzO
rO3iGFYy+OJ9Cb09c92KmONvdS5NCBlVxaihhE2TWmsIO9NHMji5z0t0o8oM
zuJqhiCKwQVpj7WWVPmMC2UuOkg3CA1+gQuWHo/ndoZZEjZ9ff30DOzt2+0i
GFYyRDzMAILOnX6M8Rn1HtSnq6fMS5+roVIIwbgQJdoYrG6UypH+NemPt3nK
1JaiDgUUTTGYW8h0m6kQYb/TZrVQWJ0eP0n9JegHAkMGg2LeTOnuKZ3v1zWB
CFRXneZz8GdGFxxcV3eh2FaVFBE3a4ZCZXEF0h4Z9cT7CFrv0HeT26jO49nO
CqsrZAjEC456LXFjTZkGrRL3lc9ILH+KphhhkypX+0mPlenLxL8kDTNCovYM
UYdYs9CQfixbibyirQMRuHD+Lp+DGw5eg4PfXZZpjJRN4W+B0iDgMAx5yDQG
V4BzwJB0xNv6Q5r6TBdAbRZ0nJHp6cCb0M/8lWkUZRkSJLycYyCCUxTFIMIO
Y7w/ZuHbbPOwhk9VWr1Brx068Zw8HhJy0n7nHphSIg8fdoECjBtbwyw9y0x7
+1M4fsyo6u5uXm86VAyGoCt5clNjsKe+wRNdGI2VefoibhP9N52d1T4hA2a9
Tp8Znc7sTNekidqZmRKNhW0JM62QpSqR/vjrVuCRwyQEUwwy5LACFqM+MW6r
t7r5ti9CDuYsI/OtkmG7kZGRlO8h4qKbYTahx0mkorGRajMs591mABYu2Amn
NDff4XMwKgYbMuw1Jb2UVKkjY4F4NVQ5Yt1iZhxS7Wa3MKIejsiqFFQmzrmt
sJWZIlUZkh7nklWMId8Y/avWHeRbl+MdwzK1yZ1Ubjw4L/V7CNEdn7Qz5krj
q7VuqP61tnP8T7H85IFT4F8+B6NipBLy2tnxDGVqS1JHI7nCRuKDG1rb0Ieb
imAMhcIZgI8j0ZTWYNRvZAZWNObUcZFwvElTar2SwTaGzWY1GWOtK/pfnZVP
ryQSl4XUoaSolWO+achH/Ds+Mmfu4CAG5+qzdJw+dYfeQ4PPwagYaYjYWfHa
Vv+Q54wMMq1fQ4hqC8fe5EZXDrFzaYn6mFlRtdHBWdGjvpxHPr3KG/kkfA4T
U4I5exwaIwvadLLApRhE7PWQrPaKJBrtpgcleA5i0Dx92kuHlHd15bmVHzII
E/KdGs/AvM7KrL6ALdbnFmQ+IsyEfGhMrnTtB3gVJ2ZXOaLHY/htce1R8Oxq
7BZ4hH1mb0hw9s7oCVyV3lECwVyek7dAMRb92ZHriW+9uQdO9OS1KxfCwMQz
6FjzFDRBR8oUXmpkOOHXq1XqzKhUelbhiUhpXeYgAcLGhFoY00WkB5jpH709
/XyxEBRPMQi/LX6fWSehGIXXuJMPJTKISeyb1JVCG6Omunkw6vtkrifSQxmV
FaeKYVXpQUbD4dTBBHgxxWulOfXNlAjMiMERBZoYRsiEOh7xxQq90PmzvlCZ
jgk0gRypghCxJVakZC+tQIqpGPFg+JTRpBSYhkSZ3jGkTUj4mS+WQzEssXGM
Uhj5XKrfDxXfffRGric2NQXhxLcXZW+cFO7TEsA72BPQGS0ubyA8uKqBiARs
iXGM1H4xQDr17OFR7shwksgOGavOiWYDYLLSIYsJzBbH0HBU0mlIGKA12YMR
+iVJhv0u9pp5k1uI0ZWMFE8xXInpj+wj+cFEUI3a7qdXHEe9rMEQLsWIxBRD
4EhdCejvHxj//AY+y0lSYQZAenv7Mh+JivGMta6EE5ObO7onEXgpzPMWzWhF
WUq8IkA4TVnOsaQxXliEUAy4F53R6vSH4rsBESGHKaGhvHSPDLD7itAhHLoC
toxDMQgvfQ0eI6ty5/r1R1DrZ7xsy+/0eXOprAQtLW2ZD8vFpyVLwGHkDJxQ
UZGfGYYTmBUfgkSGE0PndFPRcY6sBj02Ldd51Pr3iEiDeUIoRoS9n5FaPWRj
If6r3cmwO3XHEK3JGg+zSVaMeK+HsxmpMPbu/Q2qvPGTxvxO/9J0FE7fUZel
d4aKEYeMRqjdnzwer8/rdrmp/onUJvGHDAd8bpfL4/N5XE63xxeKiDqMJ4Ri
EA49p2CqzQ5fbsJHRtx2i9FAYTRZ3X5onJCx9b8pgyH0nidqo5u7KEVhWnME
qvxOe9pt+jKzb68fTv/LqiyCg4qBFI4QikFBRMLBgN/r8bhB/kC1/bzDPTMT
jXU9khUjTIeI64s9MiwOC+bbqW7FxSzdinTEOjXTa4W1CkFSEUoxCicaCoSS
p72ijvhA8NDAzgg9t2IriQ0yurvJkeWV6hGVPBeUpdLfPzBuLDVwmmFrUAQR
BNkoRmz3Ia3eaLVD78zjdlhZg0MqVkxuxDE405RuWFtxtLS0QWWfP89eSCFL
Fu+DQpqOF3vPNmS4IxvFiHJuB093SKyehF74qeaFxi7KtsnisHtXC5WO+fPD
hRRC51Crqsy0FQ+OYyCFIxvFeBb2u21mk16n1cQialVqjdZkc4VKoeeRiTVf
HMmcnYQPx9w3qURp+kyJ0lAxkMKRj2IMWxa+Su1xcdF3r5BC6N14xj+/IUMG
Z/QpUjioGNLS29s3sryq/LmKp097Cyxq2tStIBrBYNqNgtGnSOGgYkjL1asP
oJprZwuQRGDlB/VQVH391XQHoE+RwkHFkBbnL1egmn+yqqHworZsPgtFfb+u
qfCiECQdqBjS8sO6E1DNobIXXtSpwVwneeywgSD8QcWQlneWUHEUJ5puFV5U
eztBb0Xe35928BNBCgQVQ1omTtgE1fx+W6cgpdGDn7ducQ9+ok+RwkHFkJCH
D6gp0RfHW4Uq8AMDleW5oeEa56foU6RwUDEkhM6yunjRXqEK3Gg9AwWu/5F7
6z/0KVI4qBgSUms7BxXc/J1gsxv0Dn7vLNnH+Sn6FCkcVAwJMf6FSrW8f1/y
5tV5Ew4/gQJfenEj56foU04iQb93EJ8/jxUJVGKjgN8HQAn+QIjIuP6YJCKh
YCB2NFxP3M1wBAEVQ0Lmv0Lttuf3C7mbq7BDqSUOETAnJ1LUuXjv7BJwGMs4
UBksLq7dhQNGrrWW2XYLzA0y6ICLqFRwH/YMhYacxsGtMNX23DOQomJIBUn2
0/HhRObXUo7Qe5LjsvfsEH7W1rIqFWtrBQc/0fCycouXqYZuTJu6WWV0SHqC
JJ1ypk9dlBtM3nmqzHQHMfsS55OnCRVDKuiNs2bP3CZsset/PAnFbuSVvHI4
E02kDTI46M3rffZEmqAAjxocsBu1BovHH4zSmk9E3BZGhFI2sib9Ro3W4vAE
4+lSIgEXs9ulWrj98D3xLcfT5iMOOWN5TlPzNPEAFUMq6EzuKw31whZ7sP4q
FPvhSo5i0acMiWQ6miG7QTLVLd/MYmR8k3AVnwZ/Is+R3iHUiAYrd5KRs5Xh
iydz4sjTxANUDKmorKD2wKmpbha22Bs3qKbLTK49P9GnDB5TbEwhOXUFk+84
e1oubuLZGPklKSB8saNzywRKBDxOK50KyWLzBJIsjTDpXLk0IRRPo8Cdpykr
qBhSYVhBRVsdcgmcJZMk+8eMqoaSnzxJzt2MPo2RSI6jSUkkxFS31ISefAib
YvWR1xBB2G2M9yB4z5dFvIaUEVStxc0WnIA9dn8qgzPpbKZxlXeeJlQMqZg1
YxvU65s3hd9+UPfaLij5wvm7SX9Hn8ZgBiG5MgIz45k5Z84iwg5jPEmwJXt9
DPvs8bFQ3jl3mK31qWvojIZEhh8duxuVSBSr9Q4VLndswib/PE2oGJJAEGT5
cxUjy6ugSSB44XTCo50p2wCiT2PE+wJQsVNrqs+izUExyJDDCliM+kRV1lvd
6doXIY/DAkebjVqmnaDWu3mHgbji2Vf1tpgiEUFnXBzYvQzSEdcSg5P95/hM
Svbk6WlBxZCEy5fD1P7hr+woRuGxrYa/OFKMwksAMmiPVTx1wYoR9bDmSelf
te70k7NeU3IuMI0lrbwkkxhjMbPNZjLJskctIh5z/ALWaKIAE0eDJEdQMSTh
V6dgG+mkAv0RKBz6JsUovAQgmNmEwhVjsI1hs1lNxthMKf2vLs3sdsgLbQyb
1WLSa9jSofeEs/cRol5GBMz+YMA/SCAQ9Nj0XAYzYzUqRyzYg7DHWxh5DdHE
QMWQhJ/We4oXNdHZ2UNnex9OG2VEfO7s+IKDCiFgr2QIhM9hYipO1tOJsC+R
rZ3H1EzUl8gvz0nSFZkBmdigSiQ+uKG1FTKTi4ohCSvec0KlPnL4epHKnz7N
lrpRRin7NOrJXJtiGD2DBzMjnxz1NP+Rz0H81tiLnFeOcsLHCtHMcnhWxbAM
NZgMOuKfGELQvHHEGh1GV0GrElAxJGHm9Fpq3+8iTJTQrHifUqTDh4YoUin7
lAy7HVmxu/10dCcTH54SmZmYXc2z6U74bbGyeY0uEkzoaVaBYhRDZfLwsyXC
ZA2z+gLxC+UTGc4GFUN8uruLOFFCU1V5GhSjumpIijT0KUN8kjElxok1upif
mieiSXnFgOWgGImSVdzBnKkEHaylM/SpeUWGs0HFEJ8rl6mMA/PmFmWihOaQ
KwCXgJYG+4/oU4ZE7dPa2JLhiXdJdLZESBUZCTgdDif858oeN+GKa5GaT0sg
5Iy3Avg0aZjwsCHmZSIRmFHGrZC5g4ohPvWDSz9WfVSUiRKaYLAdLjF9mo39
R/Qpi6iVCXIyx+Y3/YnV6zp20z0xSVGmZsWIEk6Tzmh1+kPh2OJjIuQwJaIy
TO4hwwVE0KnTGZ0efzgaKzrkcySOVpv5DC4w06OAxmgLhKMkSUYjYb/XZTYY
HBwrWUinnj0pk2dkOBtUDPGhV5RsqBF4RQmbvr60seJIDHb85FBs/iEvYtaQ
IzuqPMLOLa5WDwndTh32ZMkOfKxWD10cz3N9PeC16srSYPJwNFOi3sR4ad6R
4WxQMcSH3r9X8BUlScRixS8UlM61xOFYo6F1+JPb7VFfvAszpO1BOPTJ4Vi0
eJgdvtRpj0QQSNLROrOPRzAGm7DPoUtZWqJS65zcshOMLz3LPzKcDSqG+Mye
Ra0ouX79UVGvQqeM37O7pahXUT5k0Odxebxej9vtTRGLbBCRcDDg93rgZJfL
BQVkbCuQRDgU9Pu8saM93mABu/YNXjkAhELhqKCbMmUGFUNkenr61CMqR5ZX
9vb2FfVC9h0+UIyv1rqZv6BPkcJBxRCZQOChUKmZM3PWG4ILvfXmHuYv6FOk
cFAxRIbeeotzjyxhefw4llRxYCAWK44+RQoHFUNkqqs4YquKxJRJW+Bara0d
9P+iT5HCQcUQGWhdZEh0KCzLlx2Aa7mP3qD/F32KFA4qhsjMnVMHtfjatYci
XIteIWvdcEaEayHDBFQMMRnMUVJZ/lxFd7cY02ENB0UaM0GGD6gYYkJv9C14
jpJ0FCklCjKcQcUQk8OHrkMVNqz4VZzLQZNmlLoKrvj0ae8z9CkiBKgYYmLd
cAbqb4XllGhXXDDfDle8dOn+M/QpIgSoGGKy6qMGqL/19VdFu+LqTw/BFffu
/e0Z+hQRAlQMMZk3l0rmfuXyA9GuuK32PFzxu2+PP0OfIkKAiiEazKiCsMnc
M3P61B244tuLHM/Qp4gQoGKIBr3LzQyujKjF4+HDLrjoi+OtYl4UKWFQMUTj
6JEbUHnffy85FWax0by0Ca7b1tYp8nWRkgQVQzQ2bfRCzf1p/UmRr7tUvx+u
23S88A3bEAQVQzyMnzRCzf3lwGWRr/vjDyfhups3edGnSOGgYogGHRrx22Bo
hJjQGRtXfdSAPkUKBxVDHJiteru6ekW+9LVr1B4+c2ZtR58ihYOKIQ53bj+G
avvyVFv2Q4VmcPlbVflzFb/73b9AnyIFgoohDsfcN0Exli87IMnV6Q7R3/3d
H9GnSIGgYojDls1noc7+8P0JSa6++jMqVtzx8yVJro6UEqgY4vCZ0QV1dv8+
fsnvhKau7gJc/ZuvjklydaSUQMUQh9cWUvmGWi62SXJ175nWpH3FESQ/UDFE
YGBgYOzoGqiznZ3S5DSk9xX/p380o0+RAkHFEIG7oQ6osFMmbZHQhmlTtoIN
//Jv/oA+RQoBFUMEmpqCUFuXvrNfQhvef88JNvz+9/8DfYoUAiqGCNTazkFt
XWduktCGqkoqT8q//3ca9ClSCKgYIvD56sPURliO3yS04chhaovR//pfFqFP
kUJAxRAB3eu7obZeuHBPQhtCg2MpkyUdS0FKAFSMYjMwMDBuLDVR0tFBSGvG
C+OsYMajR10SmoEoHVSMYtPW1gn1dNLEzVIb8mzxor1giefkLakNQRQMKkax
8XhuQz1dsnif1IY8+49/fBks+ft/O15qQxAFg4pRbLZvoyK0v/1G+gjtP/zh
/4Al//k/vSG1IYiCQcUoNvREiRxWgf3t3/4bsOR//6/VUhuCKBhUjGKzcMFO
CVeUsCkr+6t/+sd1YMzjx1KOwSKKBhWjqJBk/+iRVYNbb0mzooQNePO/q5aD
MadP3ZHaFkSpoGIUlZs3I1BDZ4qboyQD369rAnu2bD4rtSGIUkHFKCqNjdeg
hq401EttSIyD9VdlZQ+iOFAxikplxSmooTXVzVIbEuPWLSov27QpW6U2BFEq
qBhFhV4xeuTwdakNoaAd+n//4TuM/ETyBhWjqEybSu1Kcef2Y6kNoaAdqvpv
S8GkE00Y+YnkAypG8YhGu6Fujh1d098/ILUtFLRD/8Mfp4BV1g1npDYHUSSo
GMXj/Lm7UDff0O2W2pAYtEP/9e//J1j13vJfpDYHUSSoGMVj186LUDe/NB2V
2pAYtEP/+q//FVg1ccImqc1BFAkqRvFYazoKdXPnzotSG5LMpImbwbDW1g6p
DUGUBypG8XhTtwcq5rlzIakNScaw4lcwrOHgNakNQZQHKkaRGBgYeH4MtZFO
NNottS3J0Anavvv2uNSGIMoDFaNI3LnzWG6xUoxPodkDtr22cJfUFiHKAxWj
SBw9ckNuUxKMTwmCHFleCT/wi9RGIQoDFaNIbKhpBsWosJyS2pAEbJ++PpjV
8exZ2Y2xIDIHFaNIrPygnhpdbJDR6CLbp+Zvj+MiViQPUDGKxKwZ26BK3rjx
SGpDErB96moMgHnL35VRpwlRBKgYxaCrqwfq4+iRVSTZL7Ut3Dx48AQsHP/8
BplEsCNKARWjGFw4T8WHvy7vyYiZ02vByKtXHkhtCKIkUDGKQV0dtX/42i/l
Eh/OyZrPqS2Ld9T5pDYEURKoGMXgU6OLSrS6V8pEq6kk+fRX5xUw8gPDr9Ja
hSgLVIxiMHdOHVTGK5fl1eBP8imdrO3F8VYcykD4g4ohOF1dveXPVYxSV/X2
9kltyxBSfToDhzKQHEHFEBzZDnum+tS05giYuq32vIRWIcoCFUNwdtT55Dns
merThgZqq/NlSw9IaBWiLFAxBOczetjTIa9hT07a25+CqWNGVXd34wIThBeo
GIJDD3tevhyW2hBevDa4wASzpCE8QcUQls7OHvqtLdtozySqKk+Dwd+va5La
EEQZoGIIS3PzHaiAb725R2pDOOD0qc93DwzWzt4ulVWIskDFEJbNm7xQAdeZ
5fjK5vRpX1//hBc2gs3BYLtUhiEKAhVDWGJbaMppkTtDOp9+MRgujivfET6g
YgiL5qVNUPtCITlu053Op03Hg2Cz7jXZBZAgMgQVQ0BAKKDqgWhIbQg36Xza
3U2OG0ttYtzW1imJYYiCQMUQkPr6qwpd27XqowYqtYpddqlVELmBiiEgX3/l
hnpXazsntSE5Qwd/LvqzQ2pDELmDiiEgr2ip2K2Wi21SG5IzXV29Y0ZVY8cE
yQoqhlA8fkzIPHYrs0+NnzSC/Zs2ekW2ClEWqBhC4XbfhBq3ZPE+qQ1JS2af
Np+mYs9mTK8dGMDtMpC0oGIIxQ/rTkCN21DTLLUhacnsUxCKGS/bcI0JkhlU
DKGgcwZ5z7RKbUhasvqUzsdqWKG8uR5ENFAxBKGrq0c9onJkeZWc8xJm9Wl7
+9Mxo6rLn6u4fRsjxhFuUDEEwXPylmwXoOXE2i+Pwo2s+fyw1IYgMgUVQxDW
/3gSKlplhYyyrOZHKNRBJ3GWZ6A7IjmoGIKwcMFOmQ9i8IfOY7Lq4wapDUHk
CCpG4bS3E4rY+46nT+/f7xw7mlpmcqYkBBARFlSMwqGzHi/V75fakCzw9yk9
aTJjeu2TJz0iGIYoCFSMwqGb8fLfw5+/T0myn54sXmmox4AuhA0qRoFAhZo8
aQtUruuBR1LbkoWcfNra2vHieCvc1zdfHcsqGtFo9zH3zZrq5tWfHvr4w4Nf
mo7uqPPduoVTtCUIKkaB+H+7D9Xq5ak2qQ3JTq4+PesN0cvTVrzvfPSoK/WA
+/c7d+68uHjR3pHllXBY6s+St/e2tChvXR6SAVSMAqmuovbi/vabY1IbUhS8
Z1rplsbzY2pWf3bo67XuLZvP/nLg8g/rTtDTQ/TPyPIq0I3KilPw0eFD1/fs
uQQHj39+A/3pT+tP9vXJdHUekiuoGAWyYL69tNditLV1fmD4lbMJATLy4cr6
hoZrnAOkXV09oCF082P5sgNPn/aKbzwiOKgYhXDvXhSqw7ixG+SWlFlwgsH2
H384+fI028zptZ8ZXRut3ubmOz092e/6ou/exAnU3qdvL3LIfPYZ4QMqRiHs
3tUCdeHjDw9KbQgvpPJpa2vHtClb6f0M+/tx5kXZoGIUwpLF+6Ai1NdfldoQ
XkjoU2ii0FlRSiCQfpiDipE3kchT9YjK0SOrOjuVEeYkrU/Png3RYxonT9yS
xABEEFAx8mbP7hZ65lFqQ/giuU9rbefgG5s4YRPnXC2iCFAx8ubPb/1MpT87
KMf0Z5xI7tOBgYFlSw8oNEEDQoOKkR+trR309CJOGuZEOPzkhXFUgIerMSC1
LUg+oGLkR4XlFDz2X+DOM7mzb68fvrrJms24zE2JoGLkAUn2T5q4WaGpSSQH
+iZ0h878XZPUtiA5g4qRB4cPXYcHfv48u9SG5IZ8fHo98GhkeaV6ROW1aw+l
tgXJDVSMPFiq3w+KsXtXi9SG5IasfEona9AvkW96F4QTVIxcuXkzAo/62NE1
SgnDYJCVT6PR7pdepGK6mo4HpbYFyQFUjFxZ88URhS5WlZtPd9ovwjc5d06d
bPNOIqmgYuTE/bbOUeoq6IArcattufkUhGLOrO1K7N8NZ1AxcuKrtW54wo1/
cUltSIlwbDBZ7cQJmxTXxRu2oGLw5/btdnqEH/ejE5Alb++ld92R2hCEF6gY
/FlpqIdne63pqNSGlBRXLj+Ab3X0yKq2tk6pbUGyg4rBEzpP4rixGx4+VOoq
Ktn69FOjC77b1Z8ektoQJDuoGHx48qRn2lRqT5i67RektiV/ZOvTu3ejo9RV
5c9VYECX/EHF4MNngy/BN3V7FL3DrZx9Sgd0LVt6QGpDkCygYmSF3prv+TE1
t28re8BTzj7t6CDoTcubT5fsHsulASpGZpqOB+mdoxobFbMPRjpk7tNa23n4
nhe+uhP3ApUzqBgZcB+9MXpkFTzGNdXNUttS+nR3ky9PtcG37fzlitS2IGlB
xeCkr6/fuuFM+XNUVo7v1+GibJE4WH8VvvCpk7cQBOYpkCklqRhtbZ3QidhQ
07z2y6OrPz205osjP3x/om77hWPum7dvt2du9A4MDHhO3oK2MTy6oBhbNp8V
zWwEvnzd67uxUSdnSkkxHj8mbFvPzX9lB2cCL+ZnzKhq3Wu7vvj8MBzsagyc
9YZaLrZ5z7T+6rxi/q5p5vRa+rDp02zwkWjGd3b2PD+mZuKETfDvoj854C+P
HnXB77NmbMt8YldXL911WvVxQ+YjRfbp4UPXwf41OW5TdtF3j/bRvXvR4tiF
FERpKMaTJz0VllPwfNKV/YVx1hXvOasqT/+85xLowP59/lrbeVCD5csO0D3l
zD/Tpm7dVnte5ARe0Wg3PSMD/762cBf85eGDLmp3u0lbMp8IikGbnXVXc5F9
2tBwjVqD80ljrifSAV0frqwvhlVIgZSAYhw+fH2yZjNda5a/+8uJpluZV0/D
2/zChXuOny9BV+WjDw8uXrT3rTf2LHl7719WNW7a6IWPJBmrR8VgePDgybix
1PfQ3IwzrbJD0YpBEOTqzw7R9eVPb/3826X7UluUP6gYbKDDCOdqZ28v+YS2
ikO5itHa2jF/np3eDmvP7paBAWVP4qNisIFW4ivaOjh9Qw0OgcoLhSrGWW+I
DhGcO6cueDMitTkCIIJiiEwhigFA9xBOH6WuunHjkbCGIYWgRMU4WH91ZDk1
O7DSUN/VVSI7saBipPL1V9T+Ra8v3IXb+skHxSmGfYePriDrfzyp9J4IG1SM
VODWZrxMzW1ttHoFNAwpBGUpRk11M1076uoUvOqcExzH4AS6n1AINCn9/rBQ
hiGFoCDF+H5d0+DDU/mrswTXHaBipIP2+6wZ2zDrohxQhGL09w+s/fIoPQ7m
dt+U2pyigIqRjp6ePvhCqGGrD+pLqR+qUOSvGCTZTwcBjhlVfcpzW2pzigUq
RgZaWzvoqTHrhjOFl4YUgswVo7e3D94sIwY32Dx/7q60xhQVVIzMwMtCPYLa
qOTokRuCFIjkh5wV4+nT3qXvUBlOJ7yw0f+bguM5+YBzJVnZVnuebmpeuHBP
qDKRXJGtYrS3E2/oqIXPkyZuDgRKf8NYVAw+0BEaL4yzlvwbRLbIUzFCoQ46
v97M6bXQh5XEBpFBxeBDf//AJ6saaNFQ9DIi5SJDxfCeaZ04YRM8FQsX7Mwj
OcidO4+zbpsjQ3Acgyck2b/qowZ6aOvMmVZhC0eyIjfF2L7tAj3A9f57TqgL
eZQADxKcrrjocVQM/jDTZyPLqxw/XxK8fCQD8lEMgiDh6aIf/uqq03k3ElAx
0lEyivFscH+/n9Z76Btf88URkbc/Gs7IRDH8/rB29na6qVlgjBYqRjpKSTFi
lzh4bexo6hubq63DsVBxkFwxenr6qipP0zlB5s+zB4OFZhFCxUhH6SkGEAg8
pHfSKH+uwvxdE0aSFxtpFeP4sZuzZ26j3f3D9ydAPQovExVDJoijGM8GE51A
D4V+6Whe2rRr50VBHiSEE6kUo+Vi25LF++hHff4rOy76BIvJQcWQCaIpBs21
aw8X/dlBfxVTJ2/ZUedT3DOgCERWDDobyJK399KenfDCRngjCLtfCiqGTBBZ
MWiOuW/SuWboMbGvv3JfvozL5IVENMUIh59s3XJu9qxtI+IJAmqqmzs7ha/X
qBjpKMlxjFTgrdR0PMi8lUYMbu0ID9vVqw9EtqQkKbZi3A117LRfXLxoL52R
cMRg5qBa2/nijVChYqRjmCgGw82bkR/WndC8tImRjmlTt35pOtrYeC2PyECE
phiKAc0JV2Pgm6+P0ROmI+KZyFZ91HDyxK1iR2OiYqRjuCkGDfR5m0/fge4J
fJPM0wg/s2du+8zogk5xy8U2TPPKn8IVAxSgtbUD+o8brWdWGuqnTdnK9suL
462frGpoOHhNtGkvVIx0DE/FYIDeytUrD2pt55YvO0BnUGJ+oAEM/eUPV9ZX
V50+WH/V7w8Xo79cGuSkGCAOwWD7Kc9tx8+XflrvgW94/jw7NB7YXz6tEuCU
LZvPgnr39Ym9CzQqRjqGuWKwgccS1OPnPZfWfH54wXw7vTV90s/ECZt0r+9e
9XHDT+tPQlME3omXL4ehO6O4JUvCkpNiPH3am/rFUt3DKVvfXXYAvlhoS9y6
1S7t1mqoGDJBzoqRBPRcAoGHYDC0MaDv/Oo8Ox1KyvmjHlEJTlm4YCe8Fj9f
fRge+1rb+QMHLh8/dtPnuwev1EjkaQmnS8i1VwKq+86SfaY1R6AJ0dh4DVRX
bnUTFUMmKEgxOIHmxEXfPXgJwqP+9Vfu999zLnx1J3scNfMPuHLq5C3z5u74
01s/v7f8l7+savxqrXv9jyc3Wr11dRf27fW7GgMnmm6dOxeCTlDwZqStrfPx
Y0L+C2REjscQAVQMmaB0xUgHtB/C4SfwroT6Dk0L29ZzoANffH4Yvn8QB+3s
7dCdoQNQ8/6BFs5LL26cNnXrnFnbQabeenPPksX7lr/7y8oP6uH7hJ7UN18f
+2HdicqKU9YNZ7ZuOQcStGd3y/59/vr6q4dcAbf75skTt5qb75w/d7elpe3K
5QfXrz+Cxn8o1HH/fuejR10dHQRUEFCnPAYNclIMRchIIYoh4Q3iOEbhyOr5
BL9A9YSqCl0V0Bb4Nhw/X4L+S0118/frmqCVvurjBmh7LF609/WFu+bOqQN9
AJVIHRVkfpi7K0SLOH9GlleBRr0wzgoGTNZsnjZl64yXbbNnbpurrZs/z757
Vwv7vlAx2KBiCMgwV4y8GRgYIAiyvZ2439YJDYOrVx+0XGw76w0xd3dgvx9a
FHXbL0B3aUNNc4XlFLQ3oNUBKvSZ0QVCtNJQD1q0VL//7UWON3V74HGa/8oO
aPzMnF4LajBp4uYXx1vHja0BdaL3osn8AxLHNk8cxcjvxPzOAsVQhJ1JJ/JX
jKTLiaAYEn4tIpw4zO0Egert7QON6uzsAZl6+LALmkZ370bv3H7MeWK6osoQ
BEHSgIqBIAh/UDEQBOFPrj0jBEEQBEEQBEEQBEEQBEEQBEEQBEEQBGFBRsKh
gN/n8wK+YDgqtT0FQET8XhpfMEJIbY2wlJCbhhN+u6GsTAU/Vp/yXRYN2s0G
dUrgikpr8oblvoNBKgGXWTX0RnQWdymoRmm5iQ8lU8uIgJ3xl9kbkdqcQol6
zenj3VTOkJKeRr9dnzBdnVAOlcGpdNEoJTfxoXRqGRkw0E4qgXsZhH4UtUar
xx+i95mOBNx6prZpbUrRd8JvjRutdvgpv5ARryF+I3p7QGoDC6Jk3MSL0qll
pFM/pM2r5HuJQ0ZD4ZQ3cMStid2ixqOMZ5GwaeNO8bCckrgRfUDR7+EScRMf
SqeWhZzG2DtMq1W++mWGsMWeRY1XEY9ixB3r46stSS7xmNRKf/DSozQ38aB0
alnYFR93MgYjPp2i7yU7QaNKSS+vQHwEQ2P2Jn0U8cRGANQmjyS2FROFuSk7
pVPLQvE3lcoehHaTT6Pge8kOmRh3MiiiMe+1aDi6JDRRjyZN80PpKM5N2Sid
WuY2xR662ABa1KtV7L3wIBR/c5VpbX6pjeGFz6pN2/UgYs4q01hK4z0cR3lu
ykzJ1DKmWVums8fGngil3gsPonZm3EljCUttDT8IR9zmTIqhLiXFUKKbMlE6
tYxp06oMifk50kffi8Wn9Hn+JMJWXfw5hPtVzM0Rdt2wUgyFuik9Mq5l0aDP
nR0myCxijU9fqcwuv99Hxx57XRbaYXqry+fz+gLy0fgIr9sLclWdqN/IxBRq
zEFF9YuHUa9EyW5Kg6xrmcdUxgc3/Wwx0pcZlVkuzaaoh9ftGVNmDaKxcWlA
bXQormYlRj5TFaOURj4V7iZu5F3LIn633ZEVd4SWbsKnzX4nIPVWufiODLuz
353d7U/67sPm+GtLY3Ip8a2VmF21ZJhddUtim3Ao3k3cKK6WZYQkUiCfhdyx
lorJHaKOULjzvOa4xusUG2wcic/jpzxXiQiu1IlXRVEKbkpDydeyqM8SewiV
H2nHmtPX+RXslCjTFx6y1DERR63ouysZN+VAKdUy1r0o+7XFXo5BibnVahmK
2eJQylpqxillZVp3aHB0nTVIqLUqOmKhdNzEnxKqZaV0L1FLllEntYLCj71W
Vr1SsVYz6ezKuQlOSspNPCmhWkYt3qcfR4vi20uJSIY06JQVcuKzGZJuQGty
Kt1JpecmPsiklv1/9xOd6Q==
      "], {{0, 244}, {358, 0}}, {0, 255},
      ColorFunction->RGBColor],
     BoxForm`ImageTag["Byte", ColorSpace -> "RGB", Interleaving -> True],
     Selectable->False],
    BaseStyle->"ImageGraphics",
    ImageSizeRaw->{358, 244},
    PlotRange->{{0, 358}, {0, 244}}]}], "}"}]], "Output",
 CellChangeTimes->{{3.599987569350464*^9, 3.5999875867542477`*^9}, 
   3.599987676681772*^9, 3.5999886945155354`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\<Fig4.svg\>\"", ",", 
   RowBox[{"GraphicsGrid", "[", 
    RowBox[{
     RowBox[{"Partition", "[", 
      RowBox[{"graphs", ",", "3"}], "]"}], ",", 
     RowBox[{"Spacings", "\[Rule]", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"Scaled", "[", "0.1", "]"}], ",", 
        RowBox[{"Scaled", "[", 
         RowBox[{"-", "0.3"}], "]"}]}], "}"}]}]}], "]"}], ",", 
   RowBox[{"ImageSize", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Automatic", ",", 
      RowBox[{"72", " ", "11"}]}], "}"}]}]}], "]"}]], "Input",
 CellChangeTimes->{{3.597644031478951*^9, 3.5976440519426613`*^9}, {
   3.597644102017014*^9, 3.597644266110684*^9}, {3.597644509811914*^9, 
   3.597644510184436*^9}, {3.597644939022586*^9, 3.597644940166038*^9}, {
   3.597645043878985*^9, 3.597645096059368*^9}, {3.597645135117737*^9, 
   3.5976451467122927`*^9}, {3.5976452426199512`*^9, 
   3.5976452480155783`*^9}, {3.597645288602895*^9, 3.597645399836382*^9}, {
   3.597645446620059*^9, 3.597645452283408*^9}, {3.597645508302685*^9, 
   3.5976455162721777`*^9}, {3.597645570944027*^9, 3.597645580951641*^9}, 
   3.597647305293497*^9, {3.597658738677245*^9, 3.597658739818028*^9}, {
   3.59766047997239*^9, 3.597660517520393*^9}, {3.597660552195672*^9, 
   3.597660570469989*^9}, {3.5976606046443157`*^9, 3.597660605272563*^9}, 
   3.597661060497035*^9, {3.597663572371015*^9, 3.59766359959971*^9}, {
   3.5976636379004183`*^9, 3.597663643172853*^9}, {3.597663682751371*^9, 
   3.597663747248827*^9}, {3.597663820982357*^9, 3.597663821613307*^9}, 
   3.597663852585244*^9, {3.597664453885969*^9, 3.597664457446207*^9}, {
   3.597664519836974*^9, 3.59766452826528*^9}, {3.5976645863437243`*^9, 
   3.59766458826705*^9}, {3.597664796191077*^9, 3.597664854549485*^9}, {
   3.597664982827351*^9, 3.5976649838871603`*^9}, {3.597665185155635*^9, 
   3.597665243553008*^9}, {3.5976652854680033`*^9, 3.5976653013682823`*^9}, {
   3.597666645765688*^9, 3.597666646904531*^9}, {3.5976666998738937`*^9, 
   3.597666702598529*^9}, {3.597667024458673*^9, 3.597667024647849*^9}, {
   3.598179797452523*^9, 3.5981798053416348`*^9}, {3.5981801837355947`*^9, 
   3.598180187559166*^9}}],

Cell[BoxData["\<\"Fig4.svg\"\>"], "Output",
 CellChangeTimes->{3.598180188595503*^9, 3.599987713087962*^9}]
}, Open  ]]
},
WindowSize->{790, 1004},
WindowMargins->{{57, Automatic}, {983, Automatic}},
ShowSelection->True,
FrontEndVersion->"9.0 for Mac OS X x86 (32-bit, 64-bit Kernel) (November 20, \
2012)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[1463, 33, 1861, 46, 182, "Input"],
Cell[3327, 81, 16540, 465, 1261, "Input"],
Cell[CellGroupData[{
Cell[19892, 550, 12759, 263, 573, "Input"],
Cell[32654, 815, 271992, 4537, 879, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[304683, 5357, 2194, 39, 46, "Input"],
Cell[306880, 5398, 107, 1, 28, "Output"]
}, Open  ]]
}
]
*)

(* End of internal cache information *)

(* NotebookSignature Ju0IMhoVlVJChB1miUhmpBrO *)
