(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 9.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       157,          7]
NotebookDataLength[    118369,       2755]
NotebookOptionsPosition[    115158,       2658]
NotebookOutlinePosition[    115506,       2673]
CellTagsIndexPosition[    115463,       2670]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
    "The", " ", "variables", " ", "that", " ", "appear", " ", "throughout", 
     " ", "this", " ", "notebook", " ", 
     RowBox[{"are", ":", " ", "\[IndentingNewLine]", 
      RowBox[{"a", " ", "-", " ", 
       RowBox[{"oscillation", " ", "amplitude"}]}]}]}], ",", " ", 
    RowBox[{"l", " ", "-", " ", 
     RowBox[{"interaction", " ", "length", " ", "scale"}]}], ",", " ", 
    RowBox[{"z", " ", "-", " ", 
     RowBox[{
     "distance", " ", "of", " ", "closest", " ", "approach", " ", "in", " ", 
      "an", " ", "oscillation", " ", "cycle"}]}]}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{
   "The", " ", "explicit", " ", "form", " ", "of", " ", "the", " ", 
    "formulae", " ", "in", " ", "Table", " ", "1", " ", "is", " ", 
    "described", " ", 
    RowBox[{"below", ".", " ", "\[IndentingNewLine]", "These"}], " ", 
    "equations", " ", "only", " ", "describe", " ", "the", " ", "general", 
    " ", "form", " ", "of", " ", "the", " ", "formulae", " ", "and", " ", 
    "have", " ", "no", " ", "functionality"}], " ", "*)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{"(*", " ", 
   RowBox[{"Sader", " ", "Jarvis", " ", "Formula"}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"2", "k", " ", "*", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", "z"], "\[Infinity]"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{"1", "+", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"1", "/", "2"}]], 
            RowBox[{"8", 
             RowBox[{"Sqrt", "[", 
              RowBox[{"Pi", "*", 
               RowBox[{"(", 
                RowBox[{"t", "-", "z"}], ")"}]}], "]"}]}]]}], ")"}], 
         RowBox[{"\[CapitalOmega]", "[", "t", "]"}]}], "-", 
        RowBox[{
         FractionBox[
          SuperscriptBox["a", 
           RowBox[{"3", "/", "2"}]], 
          RowBox[{"Sqrt", "[", 
           RowBox[{"2", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}]}], "]"}]], 
         RowBox[{
          FractionBox["d\[CapitalOmega]", "dt"], "[", "t", "]"}]}]}], ")"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Second", " ", "Harmonic"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     FractionBox["0.8", "\[Pi]"], " ", 
     RowBox[{
      SubscriptBox["\[CapitalPi]", "2"], "[", "z", "]"}]}], "+", " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", "z"], "\[Infinity]"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox[
             RowBox[{"8", " ", 
              SuperscriptBox["a", 
               RowBox[{"-", "2"}]]}], "\[Pi]"], "*", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}]}], "+", 
           RowBox[{
            FractionBox["8.8", "\[Pi]"], 
            SuperscriptBox["a", 
             RowBox[{"-", "1"}]]}]}], ")"}], 
         RowBox[{
          SubscriptBox["\[CapitalPi]", "2"], "[", "t", "]"}]}], "-", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"Sqrt", "[", "2", "]"}], " ", 
           SuperscriptBox["a", 
            RowBox[{"1", "/", "2"}]]}], 
          RowBox[{"\[Pi]", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
         RowBox[{
          FractionBox[
           SubscriptBox["d\[CapitalPi]", "2"], "dt"], "[", "t", "]"}]}]}], 
       ")"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Third", " ", "Harmonic"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["48", "\[Pi]"]}], "0.024", 
     RowBox[{
      SubscriptBox["\[CapitalPi]", "3"], "[", "z", "]"}]}], "+", " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", "z"], "\[Infinity]"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["48", "\[Pi]"]}], 
         RowBox[{"(", " ", 
          RowBox[{
           RowBox[{
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "3"}]], 
             RowBox[{"Gamma", "[", "3", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "2"]}], "+", 
           RowBox[{"0.89", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "2"}]], 
             RowBox[{"Gamma", "[", "2", "]"}]], "*", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}]}], "+", 
           RowBox[{"0.58", 
            SuperscriptBox["a", 
             RowBox[{"-", "1"}]]}]}], ")"}], 
         RowBox[{
          SubscriptBox["\[CapitalPi]", "3"], "[", "t", "]"}]}], "+", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"Sqrt", "[", "2", "]"}], " ", 
           SuperscriptBox["a", 
            RowBox[{"1", "/", "2"}]]}], 
          RowBox[{"\[Pi]", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
         RowBox[{
          FractionBox[
           SubscriptBox["d\[CapitalPi]", "3"], "dt"], "[", "t", "]"}]}]}], 
       ")"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Fourth", " ", "Harmonic"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     FractionBox["384", "\[Pi]"], "0.004", 
     RowBox[{
      SubscriptBox["\[CapitalPi]", "4"], "[", "z", "]"}]}], "+", " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", "z"], "\[Infinity]"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["384", "\[Pi]"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "4"}]], 
             RowBox[{"Gamma", "[", "4", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "3"]}], "+", " ", 
           RowBox[{"1.05", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "3"}]], 
             RowBox[{"Gamma", "[", "3", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "2"]}], "+", 
           RowBox[{"0.31", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "2"}]], 
             RowBox[{"Gamma", "[", "2", "]"}]], "*", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}]}], "+", 
           RowBox[{"0.18", 
            SuperscriptBox["a", 
             RowBox[{"-", "1"}]]}]}], ")"}], 
         RowBox[{
          SubscriptBox["\[CapitalPi]", "4"], "[", "t", "]"}]}], "-", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"Sqrt", "[", "2", "]"}], " ", 
           SuperscriptBox["a", 
            RowBox[{"1", "/", "2"}]]}], 
          RowBox[{"\[Pi]", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
         RowBox[{
          FractionBox[
           SubscriptBox["d\[CapitalPi]", "4"], "dt"], "[", "t", "]"}]}]}], 
       ")"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{"Fifth", " ", "Harmonic"}], " ", "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"-", 
     RowBox[{
      FractionBox["3840", "\[Pi]"], "0.0005", 
      RowBox[{
       SubscriptBox["\[CapitalPi]", "5"], "[", "z", "]"}]}]}], "+", " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", "z"], "\[Infinity]"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         RowBox[{"-", 
          FractionBox["3840", "\[Pi]"]}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "5"}]], 
             RowBox[{"Gamma", "[", "5", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "4"]}], "+", 
           RowBox[{"0.98", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "4"}]], 
             RowBox[{"Gamma", "[", "4", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "3"]}], "+", " ", 
           RowBox[{"0.56", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "3"}]], 
             RowBox[{"Gamma", "[", "3", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "2"]}], "+", 
           RowBox[{"0.049", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "2"}]], 
             RowBox[{"Gamma", "[", "2", "]"}]], "*", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}]}], "+", 
           RowBox[{"0.0375", 
            SuperscriptBox["a", 
             RowBox[{"-", "1"}]]}]}], ")"}], 
         RowBox[{
          SubscriptBox["\[CapitalPi]", "5"], "[", "t", "]"}]}], "+", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"Sqrt", "[", "2", "]"}], " ", 
           SuperscriptBox["a", 
            RowBox[{"1", "/", "2"}]]}], 
          RowBox[{"\[Pi]", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
         RowBox[{
          FractionBox[
           SubscriptBox["d\[CapitalPi]", "5"], "dt"], "[", "t", "]"}]}]}], 
       ")"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}]}]}]], "Input",
 CellChangeTimes->{{3.6235568276883173`*^9, 3.623556835748325*^9}, {
   3.6235569476084375`*^9, 3.6235570957685876`*^9}, {3.6235571417142105`*^9, 
   3.6235571440903454`*^9}, {3.6235853362098503`*^9, 3.623585561482664*^9}, {
   3.623585603843073*^9, 3.623585643080305*^9}, {3.6235856792223606`*^9, 
   3.623585774560783*^9}, {3.623585805399537*^9, 3.623585933915846*^9}, {
   3.6235859659266677`*^9, 3.6235863636412883`*^9}, 3.623586419466463*^9, {
   3.6235865149648957`*^9, 3.623586536238106*^9}, 3.623586751998378*^9, {
   3.6235870988201036`*^9, 3.62358720441011*^9}, {3.6235872383430395`*^9, 
   3.623587272780999*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", " ", 
   RowBox[{"Sixth", " ", "Harmonic"}], " ", "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
     FractionBox["46080", "\[Pi]"], 
     RowBox[{
      SubscriptBox["\[CapitalPi]", "6"], "[", "z", "]"}]}], "+", " ", 
    RowBox[{
     SuperscriptBox[
      SubscriptBox["\[Integral]", "z"], "\[Infinity]"], " ", 
     RowBox[{
      RowBox[{"(", 
       RowBox[{
        RowBox[{
         FractionBox["46080", "\[Pi]"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "6"}]], 
             RowBox[{"Gamma", "[", "6", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "5"]}], "+", 
           RowBox[{"0.96", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "5"}]], 
             RowBox[{"Gamma", "[", "5", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "4"]}], "+", 
           RowBox[{"0.469", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "4"}]], 
             RowBox[{"Gamma", "[", "4", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "3"]}], "+", 
           RowBox[{"0.185", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "3"}]], 
             RowBox[{"Gamma", "[", "3", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "2"]}], "+", 
           RowBox[{"0.0022", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "2"}]], 
             RowBox[{"Gamma", "[", "2", "]"}]], "*", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}]}], "+", 
           RowBox[{"0.0058", 
            SuperscriptBox["a", 
             RowBox[{"-", "1"}]]}]}], ")"}], 
         RowBox[{
          SubscriptBox["\[CapitalPi]", "6"], "[", "t", "]"}]}], "-", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"Sqrt", "[", "2", "]"}], " ", 
           SuperscriptBox["a", 
            RowBox[{"1", "/", "2"}]]}], 
          RowBox[{"\[Pi]", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
         RowBox[{
          FractionBox[
           SubscriptBox["d\[CapitalPi]", "6"], "dt"], "[", "t", "]"}]}]}], 
       ")"}], 
      RowBox[{"\[DifferentialD]", "t"}]}]}]}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{"(*", " ", 
    RowBox[{
    "The", " ", "code", " ", "below", " ", "reconstructs", " ", "a", " ", 
     "given", " ", "simulated", " ", "force", " ", "using", " ", "the", " ", 
     "various", " ", "formulae"}], " ", "*)"}]}]}]], "Input",
 CellChangeTimes->{{3.623586368693576*^9, 3.623586408485839*^9}, {
  3.623586443173812*^9, 3.623586512350746*^9}, {3.623586542793478*^9, 
  3.6235865646177206`*^9}, {3.623586606506102*^9, 3.6235866604661713`*^9}, {
  3.623586707913871*^9, 3.6235867179534416`*^9}, {3.623586932926668*^9, 
  3.623586993442111*^9}, {3.6235870928207626`*^9, 3.623587094137838*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"k", "=", "1"}], ";", " ", 
  RowBox[{"(*", " ", 
   RowBox[{
    RowBox[{
     RowBox[{
     "The", " ", "spring", " ", "constant", " ", "is", " ", "irrelevant", " ",
       "for", " ", "the", " ", "reconstruction", " ", "of", " ", "a", " ", 
      "simulated", " ", "force", " ", "because", " ", "it", " ", "cancels", 
      " ", "out", " ", "in", " ", "the", " ", "Sader"}], "-", 
     RowBox[{"Jarvis", " ", "formula"}]}], ",", " ", 
    RowBox[{
    "but", " ", "we", " ", "write", " ", "it", " ", "for", " ", "clarity"}]}],
    " ", "*)"}]}]], "Input",
 CellChangeTimes->{{3.623586905330099*^9, 3.6235869059621353`*^9}, {
  3.62358731079416*^9, 3.623587311898224*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"z_", ",", "l_"}], "]"}], ":=", " ", 
    RowBox[{"Exp", "[", 
     RowBox[{"-", 
      FractionBox["z", "l"]}], "]"}]}], ";"}], " ", 
  RowBox[{"(*", " ", 
   RowBox[{"This", " ", "is", " ", "the", " ", "simulated", " ", "force"}], 
   " ", "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{"Forceplot", " ", "=", " ", 
  RowBox[{"Plot", "[", 
   RowBox[{
    RowBox[{"F", "[", 
     RowBox[{"z", ",", "1"}], "]"}], ",", 
    RowBox[{"{", 
     RowBox[{"z", ",", "0", ",", "2"}], "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{"Red", ",", 
       RowBox[{"Thickness", "[", "0.007", "]"}]}], "}"}]}], ",", 
    RowBox[{"PlotRange", "\[Rule]", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "1.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}]}], "Input",
 CellChangeTimes->{
  3.623556601248088*^9, {3.623556794818284*^9, 3.6235568032282915`*^9}, {
   3.623557159195205*^9, 3.623557307818658*^9}, {3.6235575321554193`*^9, 
   3.623557601697374*^9}, {3.62355767968981*^9, 3.6235577654416866`*^9}, 
   3.6235577997856407`*^9, {3.6235578615141516`*^9, 3.623557891354848*^9}, {
   3.6235580788375125`*^9, 3.6235580927013006`*^9}, {3.6235584178287926`*^9, 
   3.6235584238551364`*^9}, 3.623558494722167*^9, {3.623560189748576*^9, 
   3.6235601900675945`*^9}, {3.6235606158928146`*^9, 
   3.6235606208910975`*^9}, {3.6235610373517857`*^9, 
   3.6235610707716875`*^9}, {3.623561196460835*^9, 3.6235611972278795`*^9}, {
   3.6235613442772427`*^9, 3.623561348394477*^9}, {3.6235624009063416`*^9, 
   3.6235624472189755`*^9}, {3.6235738917109127`*^9, 3.623573913624159*^9}, {
   3.6235739553275313`*^9, 3.6235739625899444`*^9}, 3.623585350505664*^9}],

Cell[BoxData[
 GraphicsBox[{{}, {}, 
   {RGBColor[1, 0, 0], Thickness[0.007], LineBox[CompressedData["
1:eJwV0f8303sAx3GkfKshxZnuiEskxSlXV6pX3dxI1DWUTmJXqHT7otxbnLpx
r3UlZaecUr5U1hUpypeusspnJBLGVpPr63wJG7PuZqx433t/eJ7HH/C0iTjG
jNLR0tLy/6//9Y0abq0eidroDvNRQuTQ3WJ5vIfuhaemtmPTGjnW3MrMLqMH
QWFMe6ZUybG9SVyaQ4/Epla9xzKpHLsj1c+v0ONg6TvfZEgsR5fLH1su0ZPR
eKLyl9kSOW4v3nk+lZ6BVYuzDV+x5EjSL3O4QL8LmUPOmbzacYTsuVMyoShH
4pqhhNgzYzAiSaHeVi9xjC1K2LtLBvuA8eGai7XITX16yGmzFKeaPZCpbIC+
56/HY5eOwqLctFtbuwUen5K76hgjeCLZ8rZlfRvOyR0f8kyGwY/JWbJHJoJf
V6XgstlHqJZtMH54RAxX5lX/etch6EwXmSyx74A0L5RR7jUId8J6EljcCYHo
Z45z7ADeJrs11zn1wL9xXF1f2A9rjnS6cLwXkfTzTXodEkjVPd3vXCUw2HlV
T2otwd3Rqje0y/14kLpHsDWsDzTGPfnAwAD82KXzDAt6kXaoIvq23RC0tfrm
tun2YnJT0cDBcx9RJ8s3Lq3oRtzq2nLzmmEsd2PXWbO70FNce7HVZhSS6CVH
D/h04nOMKGt5ghQvNEyDMKu/sWKz3mx0lQxtKcucos064J1nc+CxxTi+15fH
XJhpxylGuG1fqBxrr2bdvKzbDmdZsJHYfwJKbt2iXroYZsYT+rWaCYRbZK6M
tn8P3ZdZJV9nK9AtULj96PsOh92qPhhs/4SEFUzHtGgRirZF3H4x+Qk9nuMu
dhwhVFJLk6Fr/4DWz1LQBW2oCPSek+GlRG+w1ipH/f8++LBvlQ8pceQKLV4n
uBU2Xb7tXLYKN9T5OnYPBFi3NjmDvnoSTcvSqwOnWhBq1TKtLZzECHNTh9Hz
ZqjeXJIcT1KDt8hZpY5rQqZuWBzTbgqiwFulmh1vYdZdkadTO4WiK6cH+zwa
MfdsUpBH7DSCWSaOPvQ30CoMK5Es1MDrr6BdleYNOHGz5NJCvgaD07axLQb1
eL4iRd/06GdIGf6D1PzXMPU94fwb7QvMWbnuFk516FwpEMbzvoBb3fjebuMr
PMqF3UDYDDjzxDefxdRiX4m7KWN2BmnVVQEnuTVIZN9J6rw/i20Xw5VCIR8P
hxlZND+C9RcUHBGdj5QcNqt7B8Fr/yhOvjkfkcwx++IAAh/Ve6t4Mz6+4vEe
+e8msDy9c9h6AR+p6Xvr0iII/EzETnFafBx0v6EwjCcwXLwvZO1HCrbJi3z0
8gniamj3HCoozH57ZoG4gGCWMRJsVErhw1h/W34RwdIF+Rx5MQXO7rJ9Wx8T
NEREFT4toECcmCfZPILGCd+ooGwKna3puXOEBPd6vBXc3ylUnlfvF74j+MFF
wOQkUsjwDF/ObSdwHyvbePYshe1/rir/rpvAIdG5IuQUhWenmxqSRghyUtZZ
mh+mcG3lN+kBMoINpZON8w5SiJVkB9nICYQBfnpTkRQc/X7qqVYSXPfeb9kZ
RkFXW3SXoybgMZWK5r0Ueis8Y1gaglcbXjD5IRR4MVwX1xmC+rGC9U+CKVy3
NlIRQmDhl11yn0nhX2lqdHw=
     "]]}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  Method->{},
  PlotRange->{{0, 1.6}, {0, 1}},
  PlotRangeClipping->True,
  PlotRangePadding->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.623557872441773*^9, {3.6235580811936464`*^9, 3.623558092984317*^9}, 
   3.6235584246421814`*^9, 3.6235584956032176`*^9, 3.623560190541621*^9, {
   3.623560617293895*^9, 3.6235606215101337`*^9}, {3.6235610905408106`*^9, 
   3.623561092126902*^9}, 3.6235611993570004`*^9, {3.6235612420694304`*^9, 
   3.6235612428154726`*^9}, {3.6235613490505147`*^9, 
   3.6235613502875853`*^9}, {3.6235624164902277`*^9, 3.623562448074025*^9}, 
   3.623573914916233*^9, 3.6235739633989897`*^9, {3.623574435407837*^9, 
   3.6235744361018763`*^9}, {3.623574585792391*^9, 3.623574586668441*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"(*", " ", 
  RowBox[{
   RowBox[{
   "Below", " ", "are", " ", "the", " ", "results", " ", "of", " ", "force", 
    " ", "reconstruction", " ", "with", " ", "the", " ", "different", " ", 
    RowBox[{"harmonics", ".", " ", "\[IndentingNewLine]", "Note"}], " ", 
    "that", " ", "numerical", " ", "integration", " ", "in", " ", 
    "Mathematica", " ", "needs", " ", "to", " ", "be", " ", "performed", " ", 
    "very", " ", 
    RowBox[{"carefully", ".", " ", "Tweaking"}], " ", "the", " ", "various", 
    " ", "parameters", " ", "of", " ", "NIntegrate", " ", "such", " ", "as", 
    " ", "WorkingPrecision", " ", "AccuracyGoal", " ", "Method", " ", "etc", 
    " ", "is", " ", "often", " ", "essential", " ", "to", " ", "achieve", " ",
     "correct", " ", "results", " ", "in", " ", "a", " ", "reasonable", " ", 
    "amount", " ", "of", " ", "computation", " ", 
    RowBox[{
    "time", ".", "\[IndentingNewLine]", "\[IndentingNewLine]", "One"}], " ", 
    "known", " ", "issue", " ", "with", " ", "this", " ", "simulation", " ", 
    "is", " ", "that", " ", "it", " ", "produces", " ", "erroneous", " ", 
    "results", " ", "when", " ", "the", " ", "amplitude", " ", "is", " ", 
    "too", " ", 
    RowBox[{"small", ".", " ", "For"}], " ", "an", " ", "exponential", " ", 
    "force", " ", "for", " ", "example"}], ",", " ", 
   RowBox[{
    RowBox[{
    "it", " ", "can", " ", "be", " ", "verified", " ", "analytically", " ", 
     "using", " ", 
     RowBox[{"eq", ".", " ", "6"}], " ", "from", " ", "the", " ", 
     "manuscript", " ", "that", " ", 
     SubscriptBox["\[CapitalPi]", "n"]}], "\[Proportional]", 
    SuperscriptBox["a", "n"]}], " ", ",", " ", 
   RowBox[{
   "while", " ", "the", " ", "dominant", " ", "term", " ", "in", " ", "the", 
    " ", "reconstruction", " ", "formula", " ", "is", " ", "proportional", 
    " ", "to", " ", 
    RowBox[{
     SuperscriptBox["a", 
      RowBox[{"-", "n"}]], ".", " ", "It"}], " ", "is", " ", "evident", " ", 
    "that", " ", "these", " ", "powers", " ", "of", " ", "amplitude", " ", 
    "should", " ", "cancel", " ", "out"}], ",", " ", 
   RowBox[{
   "but", " ", "when", " ", "the", " ", "amplitude", " ", "is", " ", "too", 
    " ", "small", " ", "the", " ", "numerical", " ", "integration", " ", 
    "algorithm", " ", "fails", " ", "to", " ", "do", " ", "so", " ", 
    RowBox[{"properly", ".", " ", "This"}], " ", "problem", " ", "gets", " ", 
    "worse", " ", "for", " ", "higher", " ", 
    RowBox[{"harmonics", ".", " ", "If"}], " ", "we", " ", "take", " ", "the",
     " ", "force", " ", "to", " ", "be", " ", "exponential", " ", "for", " ", 
    "example"}], ",", "  ", 
   RowBox[{
    RowBox[{
    "the", " ", "second", " ", "harmonic", " ", "formula", " ", "exhibits", 
     " ", "this", " ", "error", " ", "only", " ", "for", " ", 
     RowBox[{"a", "/", "l"}]}], " ", "<", " ", 
    RowBox[{
    "0.00001", " ", "while", " ", "the", " ", "sixth", " ", "harmonic", " ", 
     "exhibits", " ", "this", " ", "error", " ", "for", " ", 
     RowBox[{"a", "/", "l"}]}], " ", "<", " ", "1"}]}], " ", "*)"}]], "Input",
 CellChangeTimes->{{3.6235846949223757`*^9, 3.6235847402739553`*^9}, {
   3.6235848174663453`*^9, 3.6235850079061775`*^9}, {3.6235850458343353`*^9, 
   3.6235850705867424`*^9}, {3.6235851184504647`*^9, 
   3.6235851716424904`*^9}, {3.623647295896964*^9, 3.623647834484598*^9}, {
   3.6236479736875153`*^9, 3.6236481355597224`*^9}, {3.6236481794482193`*^9, 
   3.6236482250788145`*^9}, {3.6236483284716945`*^9, 3.623648394568454*^9}, {
   3.6236484257352266`*^9, 3.6236484857996426`*^9}, 3.6236485590308075`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SaderJarvis", "[", 
    RowBox[{
     RowBox[{"z_", "?", "NumericQ"}], ",", 
     RowBox[{"a_", "?", "NumericQ"}], ",", 
     RowBox[{"l_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{"2", "k", " ", "*", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{"1", "+", 
          FractionBox[
           SuperscriptBox["a", 
            RowBox[{"1", "/", "2"}]], 
           RowBox[{"8", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"Pi", "*", 
              RowBox[{"(", 
               RowBox[{"t", "-", "z"}], ")"}]}], "]"}]}]]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"-", 
           FractionBox["1", 
            RowBox[{"\[Pi]", " ", "a", " ", "k"}]]}], 
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"t", "+", 
             RowBox[{"a", 
              RowBox[{"(", 
               RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
          FractionBox["x", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}], "]"}]]}], ")"}]}], "-", 
       RowBox[{
        FractionBox[
         SuperscriptBox["a", 
          RowBox[{"3", "/", "2"}]], 
         RowBox[{"Sqrt", "[", 
          RowBox[{"2", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}]}], "]"}]], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"-", 
            FractionBox["1", 
             RowBox[{"\[Pi]", " ", "a", " ", "k"}]]}], 
           RowBox[{"F", "[", 
            RowBox[{
             RowBox[{"t", "+", 
              RowBox[{"a", 
               RowBox[{"(", 
                RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
           FractionBox["x", 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}], "]"}]]}], ",", "t"}], "]"}]}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "z", ",", "Infinity"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", " ", "4"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "8"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<OscillatorySelection\>\"", ",", 
         RowBox[{"Method", "\[Rule]", "\"\<DoubleExponential\>\""}], ",", 
         RowBox[{"\"\<FourierFiniteRangeMethod\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<LocalAdaptive\>\"", ",", 
            RowBox[{"\"\<Partitioning\>\"", "\[Rule]", "Automatic"}]}], 
           "}"}]}]}], "}"}]}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6235568868083773`*^9, 3.623556887468378*^9}, {
   3.623557994034689*^9, 3.623558016246952*^9}, {3.6235582716434784`*^9, 
   3.6235583097066436`*^9}, {3.62355846488347*^9, 3.623558468298664*^9}, {
   3.6235586447787013`*^9, 3.6235586727272916`*^9}, 3.6235587217150774`*^9, {
   3.623558822050784*^9, 3.6235588696024885`*^9}, {3.623558992946504*^9, 
   3.623559006093252*^9}, {3.623559054090983*^9, 3.6235590874498796`*^9}, {
   3.623559195964052*^9, 3.6235592007253227`*^9}, {3.623559292755557*^9, 
   3.62355929508169*^9}, {3.623559361141447*^9, 3.623559400073661*^9}, {
   3.6235595287299795`*^9, 3.623559546778005*^9}, {3.623559634722007*^9, 
   3.6235596409693623`*^9}, {3.6235597495075364`*^9, 3.62355975818603*^9}, {
   3.623559820281561*^9, 3.62355982570687*^9}, {3.623559901991209*^9, 
   3.623559907442519*^9}, {3.6235611667961483`*^9, 3.6235611743405776`*^9}, 
   3.623561364331383*^9, 3.623562518834049*^9, 3.623574771862974*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"SaderJarvisPlot", " ", "=", " ", 
   RowBox[{"DiscretePlot", "[", 
    RowBox[{
     RowBox[{"SaderJarvis", "[", 
      RowBox[{"x", ",", "1", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1.5", ",", "0.2"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", " ", "None"}], ",", "  ", 
     RowBox[{"PlotMarkers", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledDiamond]\>\"", ",", "10"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "  ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6235580092985563`*^9, 3.6235580119937105`*^9}, {
   3.623558042026418*^9, 3.623558066218794*^9}, {3.6235581010597754`*^9, 
   3.6235581277942967`*^9}, {3.6235581763000555`*^9, 
   3.6235581842025046`*^9}, {3.623558216428338*^9, 3.62355826376303*^9}, 
   3.623558333820015*^9, {3.6235583727642307`*^9, 3.6235583964995804`*^9}, 
   3.6235584431312323`*^9, {3.623558482492471*^9, 3.6235585409467955`*^9}, {
   3.623558583540219*^9, 3.6235586131889043`*^9}, {3.6235588779549637`*^9, 
   3.6235588856584024`*^9}, {3.623559949835931*^9, 3.623559963219692*^9}, {
   3.6235600050830727`*^9, 3.6235600377309294`*^9}, {3.62356017679484*^9, 
   3.623560177385873*^9}, {3.6235624646019645`*^9, 3.623562504762249*^9}, {
   3.6235629181947637`*^9, 3.62356300902593*^9}, {3.6235747400621653`*^9, 
   3.6235747430223336`*^9}, {3.6235747874548607`*^9, 3.62357482592505*^9}, {
   3.6235757513096824`*^9, 3.6235757525017505`*^9}, {3.623576585213114*^9, 
   3.623576587597248*^9}, {3.62357849468472*^9, 3.6235785897981296`*^9}, 
   3.6235786304934444`*^9, 3.623584540676602*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"SaderJarvisPlot", ",", "Forceplot"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{
  3.6235581337706366`*^9, 3.6235584530337954`*^9, {3.6235615432925625`*^9, 
   3.623561556657323*^9}, 3.6235616108564053`*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.24720000000000014`, 0.24, 0.6]}, 
    {RGBColor[0.24720000000000014`, 0.24, 0.6], {}, 
     GeometricTransformationBox[InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FrontFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        BackFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        GraphicsColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FontSize->10,
        FontColor->RGBColor[0.24720000000000014`, 0.24, 0.6]], {0, 0}], {{{0.,
       0.9889484572142891}}, {{0.2, 0.8096825137708897}}, {{0.4, 
      0.662911973811162}}, {{0.6000000000000001, 0.542746419557517}}, {{0.8, 
      0.44436318481470427`}}, {{1., 0.36381380591395956`}}, {{
      1.2000000000000002`, 0.29786555129607617`}}, {{1.4000000000000001`, 
      0.2438716871286247}}}], {}}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.007], LineBox[CompressedData["
1:eJwV0f8303sAx3GkfKshxZnuiEskxSlXV6pX3dxI1DWUTmJXqHT7otxbnLpx
r3UlZaecUr5U1hUpypeusspnJBLGVpPr63wJG7PuZqx433t/eJ7HH/C0iTjG
jNLR0tLy/6//9Y0abq0eidroDvNRQuTQ3WJ5vIfuhaemtmPTGjnW3MrMLqMH
QWFMe6ZUybG9SVyaQ4/Epla9xzKpHLsj1c+v0ONg6TvfZEgsR5fLH1su0ZPR
eKLyl9kSOW4v3nk+lZ6BVYuzDV+x5EjSL3O4QL8LmUPOmbzacYTsuVMyoShH
4pqhhNgzYzAiSaHeVi9xjC1K2LtLBvuA8eGai7XITX16yGmzFKeaPZCpbIC+
56/HY5eOwqLctFtbuwUen5K76hgjeCLZ8rZlfRvOyR0f8kyGwY/JWbJHJoJf
V6XgstlHqJZtMH54RAxX5lX/etch6EwXmSyx74A0L5RR7jUId8J6EljcCYHo
Z45z7ADeJrs11zn1wL9xXF1f2A9rjnS6cLwXkfTzTXodEkjVPd3vXCUw2HlV
T2otwd3Rqje0y/14kLpHsDWsDzTGPfnAwAD82KXzDAt6kXaoIvq23RC0tfrm
tun2YnJT0cDBcx9RJ8s3Lq3oRtzq2nLzmmEsd2PXWbO70FNce7HVZhSS6CVH
D/h04nOMKGt5ghQvNEyDMKu/sWKz3mx0lQxtKcucos064J1nc+CxxTi+15fH
XJhpxylGuG1fqBxrr2bdvKzbDmdZsJHYfwJKbt2iXroYZsYT+rWaCYRbZK6M
tn8P3ZdZJV9nK9AtULj96PsOh92qPhhs/4SEFUzHtGgRirZF3H4x+Qk9nuMu
dhwhVFJLk6Fr/4DWz1LQBW2oCPSek+GlRG+w1ipH/f8++LBvlQ8pceQKLV4n
uBU2Xb7tXLYKN9T5OnYPBFi3NjmDvnoSTcvSqwOnWhBq1TKtLZzECHNTh9Hz
ZqjeXJIcT1KDt8hZpY5rQqZuWBzTbgqiwFulmh1vYdZdkadTO4WiK6cH+zwa
MfdsUpBH7DSCWSaOPvQ30CoMK5Es1MDrr6BdleYNOHGz5NJCvgaD07axLQb1
eL4iRd/06GdIGf6D1PzXMPU94fwb7QvMWbnuFk516FwpEMbzvoBb3fjebuMr
PMqF3UDYDDjzxDefxdRiX4m7KWN2BmnVVQEnuTVIZN9J6rw/i20Xw5VCIR8P
hxlZND+C9RcUHBGdj5QcNqt7B8Fr/yhOvjkfkcwx++IAAh/Ve6t4Mz6+4vEe
+e8msDy9c9h6AR+p6Xvr0iII/EzETnFafBx0v6EwjCcwXLwvZO1HCrbJi3z0
8gniamj3HCoozH57ZoG4gGCWMRJsVErhw1h/W34RwdIF+Rx5MQXO7rJ9Wx8T
NEREFT4toECcmCfZPILGCd+ooGwKna3puXOEBPd6vBXc3ylUnlfvF74j+MFF
wOQkUsjwDF/ObSdwHyvbePYshe1/rir/rpvAIdG5IuQUhWenmxqSRghyUtZZ
mh+mcG3lN+kBMoINpZON8w5SiJVkB9nICYQBfnpTkRQc/X7qqVYSXPfeb9kZ
RkFXW3SXoybgMZWK5r0Ueis8Y1gaglcbXjD5IRR4MVwX1xmC+rGC9U+CKVy3
NlIRQmDhl11yn0nhX2lqdHw=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"MessagesHead" -> DiscretePlot},
  PlotRange->{{0, 1.6}, {0, 1}},
  PlotRangePadding->{{Automatic, Automatic}, {
    Automatic, Automatic}}]], "Output",
 CellChangeTimes->{
  3.623558195097124*^9, 3.623558231220253*^9, {3.6235583193091908`*^9, 
   3.6235583383732743`*^9}, {3.6235583778525195`*^9, 
   3.6235583999607763`*^9}, {3.6235584476284876`*^9, 3.6235584748720384`*^9}, 
   3.6235585093720007`*^9, 3.6235585533064985`*^9, {3.623558590547617*^9, 
   3.623558619396258*^9}, 3.6235588649252234`*^9, 3.6235590941142583`*^9, {
   3.6235593735371523`*^9, 3.6235593858778534`*^9}, 3.6235595183663893`*^9, {
   3.6235596705420446`*^9, 3.623559670612048*^9}, {3.6235599171310697`*^9, 
   3.62355996725292*^9}, {3.623560020626957*^9, 3.62356004635242*^9}, 
   3.6235601930687647`*^9, 3.623560626081394*^9, {3.6235612938843775`*^9, 
   3.6235612964625235`*^9}, 3.6235613776331396`*^9, 3.623561558594433*^9, 
   3.623561611753457*^9, {3.623562496352771*^9, 3.6235625257374415`*^9}, {
   3.6235629220039806`*^9, 3.623563013241171*^9}, {3.6235747854827485`*^9, 
   3.623574829933277*^9}, {3.62357850065906*^9, 3.623578585093862*^9}, 
   3.6235786346506815`*^9, 3.6235845601037073`*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SecondHarmonic", "[", 
    RowBox[{
     RowBox[{"z_", "?", "NumericQ"}], ",", 
     RowBox[{"a_", "?", "NumericQ"}], ",", 
     RowBox[{"l_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["0.8", "\[Pi]"], "*", "  ", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"F", "[", 
         RowBox[{
          RowBox[{"z", "+", 
           RowBox[{"a", 
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}]}]}], ",", "l"}], "]"}], 
        FractionBox[
         RowBox[{
          RowBox[{"2", 
           SuperscriptBox["u", "2"]}], "-", "1"}], 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox["u", "2"]}], "]"}]]}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "+", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox[
            RowBox[{"8", " ", 
             SuperscriptBox["a", 
              RowBox[{"-", "2"}]]}], "\[Pi]"], "*", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}]}], "+", 
          RowBox[{
           FractionBox["8.8", "\[Pi]"], 
           SuperscriptBox["a", 
            RowBox[{"-", "1"}]]}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"t", "+", 
             RowBox[{"a", 
              RowBox[{"(", 
               RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
          FractionBox[
           RowBox[{
            RowBox[{"2", 
             SuperscriptBox["x", "2"]}], "-", "1"}], 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}], "]"}]]}], ")"}]}], "-", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], " ", 
          SuperscriptBox["a", 
           RowBox[{"1", "/", "2"}]]}], 
         RowBox[{"\[Pi]", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"F", "[", 
            RowBox[{
             RowBox[{"t", "+", 
              RowBox[{"a", 
               RowBox[{"(", 
                RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
           FractionBox[
            RowBox[{
             RowBox[{"2", 
              SuperscriptBox["x", "2"]}], "-", "1"}], 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}], "]"}]]}], ",", "t"}], "]"}]}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "z", ",", "Infinity"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "6"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", " ", "8"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<OscillatorySelection\>\"", ",", 
         RowBox[{"Method", "\[Rule]", "\"\<DoubleExponential\>\""}], ",", 
         RowBox[{"\"\<FourierFiniteRangeMethod\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<LocalAdaptive\>\"", ",", 
            RowBox[{"\"\<Partitioning\>\"", "\[Rule]", "Automatic"}]}], 
           "}"}]}]}], "}"}]}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6235550259825773`*^9, 3.6235550494599123`*^9}, {
   3.6235587125005536`*^9, 3.6235587165197816`*^9}, {3.6235602218444023`*^9, 
   3.6235602539142256`*^9}, 3.6235625567152042`*^9, 3.62357281127346*^9, 
   3.6235759801537*^9, 3.6235766561771493`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SecondHarmonicPlot", " ", "=", " ", 
   RowBox[{"DiscretePlot", "[", 
    RowBox[{
     RowBox[{"SecondHarmonic", "[", 
      RowBox[{"x", ",", "0.00001", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1.5", ",", "0.2"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", " ", "None"}], ",", "  ", 
     RowBox[{"PlotMarkers", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledDiamond]\>\"", ",", "10"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "  ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6235602778875895`*^9, 3.623560298267749*^9}, {
   3.6235614191625023`*^9, 3.6235614220096636`*^9}, {3.6235625720910783`*^9, 
   3.623562574233201*^9}, {3.623563055345565*^9, 3.6235630765217695`*^9}, {
   3.6235728225831027`*^9, 3.6235728429032593`*^9}, {3.6235746804377737`*^9, 
   3.623574708358362*^9}, 3.623575079783488*^9, {3.6235757638623962`*^9, 
   3.6235757706707835`*^9}, {3.623577828437825*^9, 3.623577828565832*^9}, 
   3.6235845511091957`*^9, {3.623647860381071*^9, 3.623647863806266*^9}, {
   3.623647912281022*^9, 3.6236479657850657`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({\\(-0.\
99999999999999667104594803109799410885580269090806374709815354529`65.\
954589770191\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(9.81694538160216`*^-10\\)\[NoBreak] and \
\[NoBreak]\\!\\(4.2771569365607656`*^-10\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6236478828723497`*^9, {3.623647913387085*^9, 3.6236479596327157`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \[NoBreak]\\!\\({\\(\\({0, \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.9901419946869689653869628326906608300700681726677807545324`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(231813.0488076306179834675694156024901391338334620179423009`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6236478828723497`*^9, {3.623647913387085*^9, 3.6236479599327335`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({0.\
99999999999999667104594803109799410885580269090806374709815354529`65.\
954589770191}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(8.037436619034999`*^-10\\)\[NoBreak] and \
\[NoBreak]\\!\\(3.5014903851813937`*^-10\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6236478828723497`*^9, {3.623647913387085*^9, 3.623647960019739*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
200000000000000011102230246251565404236316680908203125`8., \
\[Infinity]}\\)\\), \\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. \
NIntegrate obtained \
\[NoBreak]\\!\\(0.810659693702994026115641443395208208318717893215143182314`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(189792.4720236031587988882067911702848616238797109022213028`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6236478828723497`*^9, {3.623647913387085*^9, 3.62364796021175*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvb"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] recursive bisections in \[NoBreak]\\!\\(u\\)\
\[NoBreak] near \[NoBreak]\\!\\({u}\\)\[NoBreak] = \
\[NoBreak]\\!\\({\\(-0.\
99999999999999667104594803109799410885580269090806374709815354529`65.\
954589770191\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(6.580496928615398`*^-10\\)\[NoBreak] and \
\[NoBreak]\\!\\(2.8670639400124673`*^-10\\)\[NoBreak] for the integral and \
error estimates. \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\
\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvb\\\", ButtonNote -> \
\\\"NIntegrate::ncvb\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6236478828723497`*^9, {3.623647913387085*^9, 3.6236479602977543`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvb\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6236478828723497`*^9, {3.623647913387085*^9, 3.6236479603527565`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
40000000000000002220446049250313080847263336181640625`8., \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.663712079008018933604372585180104526088357367278931566942`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(155388.9335484103894563523293126940328637890126545146909654`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6236478828723497`*^9, {3.623647913387085*^9, 3.6236479605307674`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvi\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6236478828723497`*^9, {3.623647913387085*^9, 3.6236479605717688`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"SecondHarmonicPlot", ",", "Forceplot"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{{3.623560342009236*^9, 3.6235603445273795`*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.24720000000000014`, 0.24, 0.6]}, 
    {RGBColor[0.24720000000000014`, 0.24, 0.6], {}, 
     GeometricTransformationBox[InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FrontFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        BackFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        GraphicsColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FontSize->10,
        FontColor->RGBColor[0.24720000000000014`, 0.24, 0.6]], {0, 0}], {{{0.,
       0.9901419949369554}}, {{0.2, 0.8106596939076657}}, {{0.4, 
      0.6637120791755899}}, {{0.6000000000000001, 0.543401454566803}}, {{0.8, 
      0.44489949356077696`}}, {{1., 0.3642528724224025}}, {{
      1.2000000000000002`, 0.2982250358937328}}, {{1.4000000000000001`, 
      0.24416601073187932`}}}], {}}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.007], LineBox[CompressedData["
1:eJwV0f8303sAx3GkfKshxZnuiEskxSlXV6pX3dxI1DWUTmJXqHT7otxbnLpx
r3UlZaecUr5U1hUpypeusspnJBLGVpPr63wJG7PuZqx433t/eJ7HH/C0iTjG
jNLR0tLy/6//9Y0abq0eidroDvNRQuTQ3WJ5vIfuhaemtmPTGjnW3MrMLqMH
QWFMe6ZUybG9SVyaQ4/Epla9xzKpHLsj1c+v0ONg6TvfZEgsR5fLH1su0ZPR
eKLyl9kSOW4v3nk+lZ6BVYuzDV+x5EjSL3O4QL8LmUPOmbzacYTsuVMyoShH
4pqhhNgzYzAiSaHeVi9xjC1K2LtLBvuA8eGai7XITX16yGmzFKeaPZCpbIC+
56/HY5eOwqLctFtbuwUen5K76hgjeCLZ8rZlfRvOyR0f8kyGwY/JWbJHJoJf
V6XgstlHqJZtMH54RAxX5lX/etch6EwXmSyx74A0L5RR7jUId8J6EljcCYHo
Z45z7ADeJrs11zn1wL9xXF1f2A9rjnS6cLwXkfTzTXodEkjVPd3vXCUw2HlV
T2otwd3Rqje0y/14kLpHsDWsDzTGPfnAwAD82KXzDAt6kXaoIvq23RC0tfrm
tun2YnJT0cDBcx9RJ8s3Lq3oRtzq2nLzmmEsd2PXWbO70FNce7HVZhSS6CVH
D/h04nOMKGt5ghQvNEyDMKu/sWKz3mx0lQxtKcucos064J1nc+CxxTi+15fH
XJhpxylGuG1fqBxrr2bdvKzbDmdZsJHYfwJKbt2iXroYZsYT+rWaCYRbZK6M
tn8P3ZdZJV9nK9AtULj96PsOh92qPhhs/4SEFUzHtGgRirZF3H4x+Qk9nuMu
dhwhVFJLk6Fr/4DWz1LQBW2oCPSek+GlRG+w1ipH/f8++LBvlQ8pceQKLV4n
uBU2Xb7tXLYKN9T5OnYPBFi3NjmDvnoSTcvSqwOnWhBq1TKtLZzECHNTh9Hz
ZqjeXJIcT1KDt8hZpY5rQqZuWBzTbgqiwFulmh1vYdZdkadTO4WiK6cH+zwa
MfdsUpBH7DSCWSaOPvQ30CoMK5Es1MDrr6BdleYNOHGz5NJCvgaD07axLQb1
eL4iRd/06GdIGf6D1PzXMPU94fwb7QvMWbnuFk516FwpEMbzvoBb3fjebuMr
PMqF3UDYDDjzxDefxdRiX4m7KWN2BmnVVQEnuTVIZN9J6rw/i20Xw5VCIR8P
hxlZND+C9RcUHBGdj5QcNqt7B8Fr/yhOvjkfkcwx++IAAh/Ve6t4Mz6+4vEe
+e8msDy9c9h6AR+p6Xvr0iII/EzETnFafBx0v6EwjCcwXLwvZO1HCrbJi3z0
8gniamj3HCoozH57ZoG4gGCWMRJsVErhw1h/W34RwdIF+Rx5MQXO7rJ9Wx8T
NEREFT4toECcmCfZPILGCd+ooGwKna3puXOEBPd6vBXc3ylUnlfvF74j+MFF
wOQkUsjwDF/ObSdwHyvbePYshe1/rir/rpvAIdG5IuQUhWenmxqSRghyUtZZ
mh+mcG3lN+kBMoINpZON8w5SiJVkB9nICYQBfnpTkRQc/X7qqVYSXPfeb9kZ
RkFXW3SXoybgMZWK5r0Ueis8Y1gaglcbXjD5IRR4MVwX1xmC+rGC9U+CKVy3
NlIRQmDhl11yn0nhX2lqdHw=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"MessagesHead" -> DiscretePlot},
  PlotRange->{{0, 1.6}, {0, 1}},
  PlotRangePadding->{{Automatic, Automatic}, {
    Automatic, Automatic}}]], "Output",
 CellChangeTimes->{{3.6235603268993764`*^9, 3.6235603466435003`*^9}, 
   3.6235606290675645`*^9, 3.6235613374108534`*^9, 3.6235613972982583`*^9, 
   3.6235614288040514`*^9, 3.6235625818556337`*^9, {3.62356306036185*^9, 
   3.6235630792969275`*^9}, {3.623572819989956*^9, 3.6235728469914923`*^9}, {
   3.623574677250592*^9, 3.6235747109615097`*^9}, 3.623575083181682*^9, {
   3.623575759904172*^9, 3.6235757739279685`*^9}, 3.62357784219867*^9, 
   3.623584560166712*^9, {3.6236478890297*^9, 3.623647962208863*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"ThirdHarmonic", "[", 
    RowBox[{
     RowBox[{"z_", "?", "NumericQ"}], ",", 
     RowBox[{"a_", "?", "NumericQ"}], ",", 
     RowBox[{"l_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["48", "\[Pi]"]}], "0.024", "*", "  ", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"F", "[", 
         RowBox[{
          RowBox[{"z", "+", 
           RowBox[{"a", 
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}]}]}], ",", "l"}], "]"}], 
        FractionBox[
         RowBox[{
          RowBox[{
           RowBox[{"-", "3"}], " ", "u"}], "+", 
          RowBox[{"4", " ", 
           SuperscriptBox["u", "3"]}]}], 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox["u", "2"]}], "]"}]]}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "+", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["48", "\[Pi]"]}], 
        RowBox[{"(", " ", 
         RowBox[{
          RowBox[{
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "3"}]], 
            RowBox[{"Gamma", "[", "3", "]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "2"]}], "+", 
          RowBox[{"0.89", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "2"}]], 
            RowBox[{"Gamma", "[", "2", "]"}]], "*", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}]}], "+", 
          RowBox[{"0.58", 
           SuperscriptBox["a", 
            RowBox[{"-", "1"}]]}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"t", "+", 
             RowBox[{"a", 
              RowBox[{"(", 
               RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
          FractionBox[
           RowBox[{
            RowBox[{
             RowBox[{"-", "3"}], " ", "x"}], "+", 
            RowBox[{"4", " ", 
             SuperscriptBox["x", "3"]}]}], 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}], "]"}]]}], ")"}]}], "+", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], " ", 
          SuperscriptBox["a", 
           RowBox[{"1", "/", "2"}]]}], 
         RowBox[{"\[Pi]", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"F", "[", 
            RowBox[{
             RowBox[{"t", "+", 
              RowBox[{"a", 
               RowBox[{"(", 
                RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
           FractionBox[
            RowBox[{
             RowBox[{
              RowBox[{"-", "3"}], " ", "x"}], "+", 
             RowBox[{"4", " ", 
              SuperscriptBox["x", "3"]}]}], 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}], "]"}]]}], ",", "t"}], "]"}]}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "z", ",", "Infinity"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "6"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "15"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<OscillatorySelection\>\"", ",", 
         RowBox[{"Method", "\[Rule]", "\"\<DoubleExponential\>\""}], ",", 
         RowBox[{"\"\<FourierFiniteRangeMethod\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<LocalAdaptive\>\"", ",", 
            RowBox[{"\"\<Partitioning\>\"", "\[Rule]", "Automatic"}]}], 
           "}"}]}]}], "}"}]}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.609750850820449*^9, 3.6097508968851013`*^9}, {
   3.6097509451338778`*^9, 3.609751052280046*^9}, {3.609988635444041*^9, 
   3.60998863578306*^9}, {3.609988694984468*^9, 3.609988722496051*^9}, {
   3.613704736465395*^9, 3.6137047483380785`*^9}, {3.613704870066085*^9, 
   3.6137048705231113`*^9}, {3.6137049182588587`*^9, 
   3.6137049184248686`*^9}, {3.6137082605002394`*^9, 
   3.6137082606832504`*^9}, {3.6137082944771953`*^9, 
   3.6137083525845404`*^9}, {3.6137084186793447`*^9, 3.613708433991226*^9}, 
   3.613708531808856*^9, {3.6137092148181705`*^9, 3.613709215153189*^9}, {
   3.613710756178892*^9, 3.6137107719537997`*^9}, {3.613710814531251*^9, 
   3.6137108475391507`*^9}, 3.613710911530834*^9, 3.6137109623387585`*^9, 
   3.6137112084769263`*^9, {3.613711543595216*^9, 3.6137115438102283`*^9}, {
   3.6137116401547737`*^9, 3.61371164633913*^9}, {3.613711716587173*^9, 
   3.613711717074201*^9}, {3.6137119417551346`*^9, 3.6137119576030464`*^9}, 
   3.6137128340434947`*^9, {3.6137287538388443`*^9, 3.613728761149266*^9}, 
   3.6137294696000443`*^9, {3.6137959668386526`*^9, 3.6137959754091473`*^9}, {
   3.613796008575055*^9, 3.6137960168545322`*^9}, {3.6137960900467453`*^9, 
   3.6137960983672237`*^9}, 3.6137961970239024`*^9, {3.613796306559207*^9, 
   3.6137963068952274`*^9}, 3.6137963425522795`*^9, {3.6137964257520685`*^9, 
   3.613796428847246*^9}, {3.6137964868315845`*^9, 3.613796503010515*^9}, 
   3.6137968610721254`*^9, 3.6137976871766768`*^9, 3.613797803352363*^9, {
   3.6141586401072073`*^9, 3.614158642309333*^9}, {3.6141594526426816`*^9, 
   3.614159454759803*^9}, {3.6141598875775585`*^9, 3.6141598912597694`*^9}, {
   3.6148321534597607`*^9, 3.6148321882557635`*^9}, {3.6148329261602383`*^9, 
   3.6148329448273134`*^9}, {3.614832993057089*^9, 3.614833000316507*^9}, {
   3.614834231750389*^9, 3.614834238952803*^9}, {3.614834269368554*^9, 
   3.614834278592085*^9}, {3.61483438119199*^9, 3.6148344053683825`*^9}, {
   3.614834439312336*^9, 3.614834454288198*^9}, {3.614834485460993*^9, 
   3.614834570945913*^9}, {3.6148350671794767`*^9, 3.614835068650561*^9}, {
   3.614839412429591*^9, 3.6148394243732777`*^9}, {3.6235551272766037`*^9, 
   3.6235551294866056`*^9}, {3.6235555300070095`*^9, 
   3.6235555315170107`*^9}, {3.6235562344177203`*^9, 3.6235562402777257`*^9}, 
   3.6235603686307507`*^9, {3.623560565425943*^9, 3.623560570197215*^9}, {
   3.623561705596794*^9, 3.623561752397456*^9}, {3.6235626403809624`*^9, 
   3.623562640484969*^9}, 3.623562706118702*^9, 3.623562829061694*^9, 
   3.623573776418356*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"ThirdHarmonicPlot", " ", "=", " ", 
   RowBox[{"DiscretePlot", "[", 
    RowBox[{
     RowBox[{"ThirdHarmonic", "[", 
      RowBox[{"x", ",", "1", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1.5", ",", "0.2"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", " ", "None"}], ",", "  ", 
     RowBox[{"PlotMarkers", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledDiamond]\>\"", ",", "10"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "  ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6235603834825954`*^9, 3.623560390178976*^9}, {
  3.6235614472420993`*^9, 3.6235614474101086`*^9}, {3.623562597162504*^9, 
  3.6235625985935855`*^9}, {3.6235628449055953`*^9, 3.6235629064740973`*^9}, {
  3.623572858239131*^9, 3.6235728685187163`*^9}, {3.6235737675828524`*^9, 
  3.6235737948954067`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \[NoBreak]\\!\\({\\(\\({0, \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.9875261393486021914674067431409248355454480408900116749785`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.08783701142575538476360188086671684988072643572774475597044`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.62356040537584*^9, 3.6235605731663847`*^9, 3.6235614552225533`*^9, {
   3.623561714573305*^9, 3.623561756010662*^9}, 3.623562606238022*^9, 
   3.6235626430541153`*^9, 3.6235627097079067`*^9, {3.6235628317518473`*^9, 
   3.6235629074811554`*^9}, {3.6235728631034093`*^9, 
   3.6235728694957724`*^9}, {3.6235737698769836`*^9, 3.6235737888080606`*^9}, 
   3.6235845663270617`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
200000000000000011102230246251565404236316680908203125`8., \
\[Infinity]}\\)\\), \\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. \
NIntegrate obtained \
\[NoBreak]\\!\\(0.8085180197045835866855678585833947002486037125680112729609`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.07191486256022053790164741776040031108416168849222103239577`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.62356040537584*^9, 3.6235605731663847`*^9, 3.6235614552225533`*^9, {
   3.623561714573305*^9, 3.623561756010662*^9}, 3.623562606238022*^9, 
   3.6235626430541153`*^9, 3.6235627097079067`*^9, {3.6235628317518473`*^9, 
   3.6235629074811554`*^9}, {3.6235728631034093`*^9, 
   3.6235728694957724`*^9}, {3.6235737698769836`*^9, 3.6235737888080606`*^9}, 
   3.6235845666170783`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
40000000000000002220446049250313080847263336181640625`8., \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.6619585671340677874827155413365902989993506773060772570318`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(0.05887890956445975411918860348408982798605402250353673221554`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.62356040537584*^9, 3.6235605731663847`*^9, 3.6235614552225533`*^9, {
   3.623561714573305*^9, 3.623561756010662*^9}, 3.623562606238022*^9, 
   3.6235626430541153`*^9, 3.6235627097079067`*^9, {3.6235628317518473`*^9, 
   3.6235629074811554`*^9}, {3.6235728631034093`*^9, 
   3.6235728694957724`*^9}, {3.6235737698769836`*^9, 3.6235737888080606`*^9}, 
   3.6235845669230957`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvi\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.62356040537584*^9, 3.6235605731663847`*^9, 3.6235614552225533`*^9, {
   3.623561714573305*^9, 3.623561756010662*^9}, 3.623562606238022*^9, 
   3.6235626430541153`*^9, 3.6235627097079067`*^9, {3.6235628317518473`*^9, 
   3.6235629074811554`*^9}, {3.6235728631034093`*^9, 
   3.6235728694957724`*^9}, {3.6235737698769836`*^9, 3.6235737888080606`*^9}, 
   3.6235845669560976`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"ThirdHarmonicPlot", ",", "Forceplot"}], "}"}], "]"}]], "Input",
 CellChangeTimes->{3.623560402713689*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.24720000000000014`, 0.24, 0.6]}, 
    {RGBColor[0.24720000000000014`, 0.24, 0.6], {}, 
     GeometricTransformationBox[InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FrontFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        BackFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        GraphicsColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FontSize->10,
        FontColor->RGBColor[0.24720000000000014`, 0.24, 0.6]], {0, 0}], {{{0.,
       0.9969210539028869}}, {{0.2, 0.8162099251727164}}, {{0.4, 
      0.6682561666905967}}, {{0.6000000000000001, 0.5471218746041218}}, {{0.8,
       0.4479455044200694}}, {{1., 0.36674676020723196`}}, {{
      1.2000000000000002`, 0.3002668511726582}}, {{1.4000000000000001`, 
      0.24583770518494477`}}}], {}}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.007], LineBox[CompressedData["
1:eJwV0f8303sAx3GkfKshxZnuiEskxSlXV6pX3dxI1DWUTmJXqHT7otxbnLpx
r3UlZaecUr5U1hUpypeusspnJBLGVpPr63wJG7PuZqx433t/eJ7HH/C0iTjG
jNLR0tLy/6//9Y0abq0eidroDvNRQuTQ3WJ5vIfuhaemtmPTGjnW3MrMLqMH
QWFMe6ZUybG9SVyaQ4/Epla9xzKpHLsj1c+v0ONg6TvfZEgsR5fLH1su0ZPR
eKLyl9kSOW4v3nk+lZ6BVYuzDV+x5EjSL3O4QL8LmUPOmbzacYTsuVMyoShH
4pqhhNgzYzAiSaHeVi9xjC1K2LtLBvuA8eGai7XITX16yGmzFKeaPZCpbIC+
56/HY5eOwqLctFtbuwUen5K76hgjeCLZ8rZlfRvOyR0f8kyGwY/JWbJHJoJf
V6XgstlHqJZtMH54RAxX5lX/etch6EwXmSyx74A0L5RR7jUId8J6EljcCYHo
Z45z7ADeJrs11zn1wL9xXF1f2A9rjnS6cLwXkfTzTXodEkjVPd3vXCUw2HlV
T2otwd3Rqje0y/14kLpHsDWsDzTGPfnAwAD82KXzDAt6kXaoIvq23RC0tfrm
tun2YnJT0cDBcx9RJ8s3Lq3oRtzq2nLzmmEsd2PXWbO70FNce7HVZhSS6CVH
D/h04nOMKGt5ghQvNEyDMKu/sWKz3mx0lQxtKcucos064J1nc+CxxTi+15fH
XJhpxylGuG1fqBxrr2bdvKzbDmdZsJHYfwJKbt2iXroYZsYT+rWaCYRbZK6M
tn8P3ZdZJV9nK9AtULj96PsOh92qPhhs/4SEFUzHtGgRirZF3H4x+Qk9nuMu
dhwhVFJLk6Fr/4DWz1LQBW2oCPSek+GlRG+w1ipH/f8++LBvlQ8pceQKLV4n
uBU2Xb7tXLYKN9T5OnYPBFi3NjmDvnoSTcvSqwOnWhBq1TKtLZzECHNTh9Hz
ZqjeXJIcT1KDt8hZpY5rQqZuWBzTbgqiwFulmh1vYdZdkadTO4WiK6cH+zwa
MfdsUpBH7DSCWSaOPvQ30CoMK5Es1MDrr6BdleYNOHGz5NJCvgaD07axLQb1
eL4iRd/06GdIGf6D1PzXMPU94fwb7QvMWbnuFk516FwpEMbzvoBb3fjebuMr
PMqF3UDYDDjzxDefxdRiX4m7KWN2BmnVVQEnuTVIZN9J6rw/i20Xw5VCIR8P
hxlZND+C9RcUHBGdj5QcNqt7B8Fr/yhOvjkfkcwx++IAAh/Ve6t4Mz6+4vEe
+e8msDy9c9h6AR+p6Xvr0iII/EzETnFafBx0v6EwjCcwXLwvZO1HCrbJi3z0
8gniamj3HCoozH57ZoG4gGCWMRJsVErhw1h/W34RwdIF+Rx5MQXO7rJ9Wx8T
NEREFT4toECcmCfZPILGCd+ooGwKna3puXOEBPd6vBXc3ylUnlfvF74j+MFF
wOQkUsjwDF/ObSdwHyvbePYshe1/rir/rpvAIdG5IuQUhWenmxqSRghyUtZZ
mh+mcG3lN+kBMoINpZON8w5SiJVkB9nICYQBfnpTkRQc/X7qqVYSXPfeb9kZ
RkFXW3SXoybgMZWK5r0Ueis8Y1gaglcbXjD5IRR4MVwX1xmC+rGC9U+CKVy3
NlIRQmDhl11yn0nhX2lqdHw=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"MessagesHead" -> DiscretePlot},
  PlotRange->{{0, 1.6}, {0, 1}},
  PlotRangePadding->{{Automatic, Automatic}, {
    Automatic, Automatic}}]], "Output",
 CellChangeTimes->{
  3.6235617882544966`*^9, 3.623562612944403*^9, {3.6235627593547297`*^9, 
   3.6235627609978237`*^9}, {3.62356283497103*^9, 3.6235629095162697`*^9}, {
   3.623572866038575*^9, 3.6235728724799414`*^9}, {3.6235737731271677`*^9, 
   3.6235737912712*^9}, 3.623584568448182*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.623561779238982*^9, 3.6235617793179874`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{
    RowBox[{"FourthHarmonic", "[", 
     RowBox[{
      RowBox[{"z_", "?", "NumericQ"}], ",", 
      RowBox[{"a_", "?", "NumericQ"}], ",", 
      RowBox[{"l_", "?", "NumericQ"}]}], "]"}], ":=", 
    RowBox[{
     RowBox[{
      FractionBox["384", "\[Pi]"], "0.004", "*", "  ", 
      RowBox[{"NIntegrate", "[", 
       RowBox[{
        RowBox[{
         RowBox[{"F", "[", 
          RowBox[{
           RowBox[{"z", "+", 
            RowBox[{"a", 
             RowBox[{"(", 
              RowBox[{"1", "+", "u"}], ")"}]}]}], ",", "l"}], "]"}], 
         FractionBox[
          RowBox[{"1", "-", 
           RowBox[{"8", " ", 
            SuperscriptBox["u", "2"]}], "+", 
           RowBox[{"8", " ", 
            SuperscriptBox["u", "4"]}]}], 
          RowBox[{"Sqrt", "[", 
           RowBox[{"1", "-", 
            SuperscriptBox["u", "2"]}], "]"}]]}], ",", 
        RowBox[{"{", 
         RowBox[{"u", ",", 
          RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "+", " ", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{
         FractionBox["384", "\[Pi]"], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "4"}]], 
             RowBox[{"Gamma", "[", "4", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "3"]}], "+", " ", 
           RowBox[{"1.05", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "3"}]], 
             RowBox[{"Gamma", "[", "3", "]"}]], 
            SuperscriptBox[
             RowBox[{"(", 
              RowBox[{"t", "-", "z"}], ")"}], "2"]}], "+", 
           RowBox[{"0.31", 
            FractionBox[
             SuperscriptBox["a", 
              RowBox[{"-", "2"}]], 
             RowBox[{"Gamma", "[", "2", "]"}]], "*", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}]}], "+", 
           RowBox[{"0.18", 
            SuperscriptBox["a", 
             RowBox[{"-", "1"}]]}]}], ")"}], 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"F", "[", 
            RowBox[{
             RowBox[{"t", "+", 
              RowBox[{"a", 
               RowBox[{"(", 
                RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
           FractionBox[
            RowBox[{"1", "-", 
             RowBox[{"8", " ", 
              SuperscriptBox["x", "2"]}], "+", 
             RowBox[{"8", " ", 
              SuperscriptBox["x", "4"]}]}], 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}], "]"}]]}], ")"}]}], "-", 
        RowBox[{
         FractionBox[
          RowBox[{
           RowBox[{"Sqrt", "[", "2", "]"}], " ", 
           SuperscriptBox["a", 
            RowBox[{"1", "/", "2"}]]}], 
          RowBox[{"\[Pi]", "*", 
           RowBox[{"Sqrt", "[", 
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
         RowBox[{"D", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"F", "[", 
             RowBox[{
              RowBox[{"t", "+", 
               RowBox[{"a", 
                RowBox[{"(", 
                 RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
            FractionBox[
             RowBox[{"1", "-", 
              RowBox[{"8", " ", 
               SuperscriptBox["x", "2"]}], "+", 
              RowBox[{"8", " ", 
               SuperscriptBox["x", "4"]}]}], 
             RowBox[{"Sqrt", "[", 
              RowBox[{"1", "-", 
               SuperscriptBox["x", "2"]}], "]"}]]}], ",", "t"}], "]"}]}]}], 
       ",", 
       RowBox[{"{", 
        RowBox[{"t", ",", "z", ",", "Infinity"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"x", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
       RowBox[{"AccuracyGoal", "\[Rule]", "4"}], ",", 
       RowBox[{"WorkingPrecision", "\[Rule]", " ", "8"}], ",", 
       RowBox[{"Method", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\"\<OscillatorySelection\>\"", ",", 
          RowBox[{"Method", "\[Rule]", "\"\<DoubleExponential\>\""}], ",", 
          RowBox[{"\"\<FourierFiniteRangeMethod\>\"", "\[Rule]", 
           RowBox[{"{", 
            RowBox[{"\"\<LocalAdaptive\>\"", ",", 
             RowBox[{"\"\<Partitioning\>\"", "\[Rule]", "Automatic"}]}], 
            "}"}]}]}], "}"}]}]}], "]"}]}]}], ";"}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.623555161766639*^9, 3.6235551694766455`*^9}, {
   3.6235552125966897`*^9, 3.6235552133766904`*^9}, 3.62355554041702*^9, {
   3.6235556263871064`*^9, 3.623555647857128*^9}, {3.62355569981718*^9, 
   3.623555784607266*^9}, {3.6235562218277073`*^9, 3.623556229957715*^9}, {
   3.623560452079497*^9, 3.6235604735767193`*^9}, {3.623560698198496*^9, 
   3.6235607025227413`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FourthHarmonicPlot", " ", "=", " ", 
   RowBox[{"DiscretePlot", "[", 
    RowBox[{
     RowBox[{"FourthHarmonic", "[", 
      RowBox[{"x", ",", "1", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1.5", ",", "0.2"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", " ", "None"}], ",", "  ", 
     RowBox[{"PlotMarkers", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledDiamond]\>\"", ",", "10"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "  ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{
  3.623560483027257*^9, {3.6235618301618795`*^9, 3.6235618306099043`*^9}, {
   3.6235618808747635`*^9, 3.6235618816588078`*^9}, {3.6235628101706195`*^9, 
   3.6235628126817627`*^9}, {3.6235735369757357`*^9, 
   3.6235735605270753`*^9}, {3.6235746022863283`*^9, 3.6235746373753242`*^9}, 
   3.623578666661501*^9, 3.6235846208761644`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \[NoBreak]\\!\\({\\(\\({0, \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.9852745869466913912545241274373179487179754726300131549476`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.989795652984990952294127235476802469298631390258859829256`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.623560485190381*^9, 3.6235607094961386`*^9, 3.623561836616246*^9, 
   3.6235619007058926`*^9, 3.6235627820900235`*^9, 3.62356281456087*^9, {
   3.623573539246866*^9, 3.623573561277119*^9}, {3.623574593007801*^9, 
   3.6235746383773823`*^9}, {3.623578660019125*^9, 3.6235786672915382`*^9}, {
   3.623584613213728*^9, 3.623584623457311*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
200000000000000011102230246251565404236316680908203125`8., \
\[Infinity]}\\)\\), \\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. \
NIntegrate obtained \
\[NoBreak]\\!\\(0.8066746045534755019426835728102069123786778946584593620326`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.62910689342130255943556450246069660928891551046246171708`58.\
\\)\[NoBreak] for the integral and error estimates. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", ButtonNote -> \
\\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.623560485190381*^9, 3.6235607094961386`*^9, 3.623561836616246*^9, 
   3.6235619007058926`*^9, 3.6235627820900235`*^9, 3.62356281456087*^9, {
   3.623573539246866*^9, 3.623573561277119*^9}, {3.623574593007801*^9, 
   3.6235746383773823`*^9}, {3.623578660019125*^9, 3.6235786672915382`*^9}, {
   3.623584613213728*^9, 3.623584623765328*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
40000000000000002220446049250313080847263336181640625`8., \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.6604493064730040855257196691045326183900234640407064213686`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(1.333799913693374004536385733383707808273766747530729549288`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.623560485190381*^9, 3.6235607094961386`*^9, 3.623561836616246*^9, 
   3.6235619007058926`*^9, 3.6235627820900235`*^9, 3.62356281456087*^9, {
   3.623573539246866*^9, 3.623573561277119*^9}, {3.623574593007801*^9, 
   3.6235746383773823`*^9}, {3.623578660019125*^9, 3.6235786672915382`*^9}, {
   3.623584613213728*^9, 3.623584624063346*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvi\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.623560485190381*^9, 3.6235607094961386`*^9, 3.623561836616246*^9, 
   3.6235619007058926`*^9, 3.6235627820900235`*^9, 3.62356281456087*^9, {
   3.623573539246866*^9, 3.623573561277119*^9}, {3.623574593007801*^9, 
   3.6235746383773823`*^9}, {3.623578660019125*^9, 3.6235786672915382`*^9}, {
   3.623584613213728*^9, 3.6235846240973473`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"FourthHarmonicPlot", " ", ",", "Forceplot"}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{3.623560501153288*^9}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.24720000000000014`, 0.24, 0.6]}, 
    {RGBColor[0.24720000000000014`, 0.24, 0.6], {}, 
     GeometricTransformationBox[InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FrontFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        BackFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        GraphicsColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FontSize->10,
        FontColor->RGBColor[0.24720000000000014`, 0.24, 0.6]], {0, 0}], {{{0.,
       0.9868212318219667}}, {{0.2, 0.8079408902769539}}, {{0.4, 
      0.6614860535369994}}, {{0.6000000000000001, 0.5415789747629975}}, {{0.8,
       0.44340736185890595`}}, {{1., 0.36303124329517555`}}, {{
      1.2000000000000002`, 0.2972248432173041}}, {{1.4000000000000001`, 
      0.24334711972078665`}}}], {}}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.007], LineBox[CompressedData["
1:eJwV0f8303sAx3GkfKshxZnuiEskxSlXV6pX3dxI1DWUTmJXqHT7otxbnLpx
r3UlZaecUr5U1hUpypeusspnJBLGVpPr63wJG7PuZqx433t/eJ7HH/C0iTjG
jNLR0tLy/6//9Y0abq0eidroDvNRQuTQ3WJ5vIfuhaemtmPTGjnW3MrMLqMH
QWFMe6ZUybG9SVyaQ4/Epla9xzKpHLsj1c+v0ONg6TvfZEgsR5fLH1su0ZPR
eKLyl9kSOW4v3nk+lZ6BVYuzDV+x5EjSL3O4QL8LmUPOmbzacYTsuVMyoShH
4pqhhNgzYzAiSaHeVi9xjC1K2LtLBvuA8eGai7XITX16yGmzFKeaPZCpbIC+
56/HY5eOwqLctFtbuwUen5K76hgjeCLZ8rZlfRvOyR0f8kyGwY/JWbJHJoJf
V6XgstlHqJZtMH54RAxX5lX/etch6EwXmSyx74A0L5RR7jUId8J6EljcCYHo
Z45z7ADeJrs11zn1wL9xXF1f2A9rjnS6cLwXkfTzTXodEkjVPd3vXCUw2HlV
T2otwd3Rqje0y/14kLpHsDWsDzTGPfnAwAD82KXzDAt6kXaoIvq23RC0tfrm
tun2YnJT0cDBcx9RJ8s3Lq3oRtzq2nLzmmEsd2PXWbO70FNce7HVZhSS6CVH
D/h04nOMKGt5ghQvNEyDMKu/sWKz3mx0lQxtKcucos064J1nc+CxxTi+15fH
XJhpxylGuG1fqBxrr2bdvKzbDmdZsJHYfwJKbt2iXroYZsYT+rWaCYRbZK6M
tn8P3ZdZJV9nK9AtULj96PsOh92qPhhs/4SEFUzHtGgRirZF3H4x+Qk9nuMu
dhwhVFJLk6Fr/4DWz1LQBW2oCPSek+GlRG+w1ipH/f8++LBvlQ8pceQKLV4n
uBU2Xb7tXLYKN9T5OnYPBFi3NjmDvnoSTcvSqwOnWhBq1TKtLZzECHNTh9Hz
ZqjeXJIcT1KDt8hZpY5rQqZuWBzTbgqiwFulmh1vYdZdkadTO4WiK6cH+zwa
MfdsUpBH7DSCWSaOPvQ30CoMK5Es1MDrr6BdleYNOHGz5NJCvgaD07axLQb1
eL4iRd/06GdIGf6D1PzXMPU94fwb7QvMWbnuFk516FwpEMbzvoBb3fjebuMr
PMqF3UDYDDjzxDefxdRiX4m7KWN2BmnVVQEnuTVIZN9J6rw/i20Xw5VCIR8P
hxlZND+C9RcUHBGdj5QcNqt7B8Fr/yhOvjkfkcwx++IAAh/Ve6t4Mz6+4vEe
+e8msDy9c9h6AR+p6Xvr0iII/EzETnFafBx0v6EwjCcwXLwvZO1HCrbJi3z0
8gniamj3HCoozH57ZoG4gGCWMRJsVErhw1h/W34RwdIF+Rx5MQXO7rJ9Wx8T
NEREFT4toECcmCfZPILGCd+ooGwKna3puXOEBPd6vBXc3ylUnlfvF74j+MFF
wOQkUsjwDF/ObSdwHyvbePYshe1/rir/rpvAIdG5IuQUhWenmxqSRghyUtZZ
mh+mcG3lN+kBMoINpZON8w5SiJVkB9nICYQBfnpTkRQc/X7qqVYSXPfeb9kZ
RkFXW3SXoybgMZWK5r0Ueis8Y1gaglcbXjD5IRR4MVwX1xmC+rGC9U+CKVy3
NlIRQmDhl11yn0nhX2lqdHw=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"MessagesHead" -> DiscretePlot},
  PlotRange->{{0, 1.6}, {0, 1}},
  PlotRangePadding->{{Automatic, Automatic}, {
    Automatic, Automatic}}]], "Output",
 CellChangeTimes->{
  3.623560502723378*^9, 3.6235606428763485`*^9, 3.6235607165715404`*^9, 
   3.6235618420765567`*^9, 3.623561907404272*^9, {3.623562789091421*^9, 
   3.6235628188251123`*^9}, {3.6235735426100564`*^9, 
   3.6235735641782837`*^9}, {3.6235745787909927`*^9, 
   3.6235746405925074`*^9}, {3.6235786632553077`*^9, 3.623578670462717*^9}, {
   3.623584618000001*^9, 3.6235846265184846`*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"FifthHarmonic", "[", 
    RowBox[{
     RowBox[{"z_", "?", "NumericQ"}], ",", 
     RowBox[{"a_", "?", "NumericQ"}], ",", 
     RowBox[{"l_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     RowBox[{"-", 
      FractionBox["3840", "\[Pi]"]}], "0.0005", "*", "  ", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"F", "[", 
         RowBox[{
          RowBox[{"z", "+", 
           RowBox[{"a", 
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}]}]}], ",", "l"}], "]"}], 
        FractionBox[
         RowBox[{
          RowBox[{"5", " ", "u"}], "-", 
          RowBox[{"20", " ", 
           SuperscriptBox["u", "3"]}], "+", 
          RowBox[{"16", " ", 
           SuperscriptBox["u", "5"]}]}], 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox["u", "2"]}], "]"}]]}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "+", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        RowBox[{"-", 
         FractionBox["3840", "\[Pi]"]}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "5"}]], 
            RowBox[{"Gamma", "[", "5", "]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "4"]}], "+", 
          RowBox[{"0.98", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "4"}]], 
            RowBox[{"Gamma", "[", "4", "]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "3"]}], "+", " ", 
          RowBox[{"0.56", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "3"}]], 
            RowBox[{"Gamma", "[", "3", "]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "2"]}], "+", 
          RowBox[{"0.049", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "2"}]], 
            RowBox[{"Gamma", "[", "2", "]"}]], "*", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}]}], "+", 
          RowBox[{"0.0375", 
           SuperscriptBox["a", 
            RowBox[{"-", "1"}]]}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"t", "+", 
             RowBox[{"a", 
              RowBox[{"(", 
               RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
          FractionBox[
           RowBox[{
            RowBox[{"5", " ", "x"}], "-", 
            RowBox[{"20", " ", 
             SuperscriptBox["x", "3"]}], "+", 
            RowBox[{"16", " ", 
             SuperscriptBox["x", "5"]}]}], 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}], "]"}]]}], ")"}]}], "+", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], " ", 
          SuperscriptBox["a", 
           RowBox[{"1", "/", "2"}]]}], 
         RowBox[{"\[Pi]", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"F", "[", 
            RowBox[{
             RowBox[{"t", "+", 
              RowBox[{"a", 
               RowBox[{"(", 
                RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
           FractionBox[
            RowBox[{
             RowBox[{"5", " ", "x"}], "-", 
             RowBox[{"20", " ", 
              SuperscriptBox["x", "3"]}], "+", 
             RowBox[{"16", " ", 
              SuperscriptBox["x", "5"]}]}], 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}], "]"}]]}], ",", "t"}], "]"}]}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "z", ",", "Infinity"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "10"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", "20"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<OscillatorySelection\>\"", ",", 
         RowBox[{"Method", "\[Rule]", "\"\<DoubleExponential\>\""}], ",", 
         RowBox[{"\"\<FourierFiniteRangeMethod\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<LocalAdaptive\>\"", ",", 
            RowBox[{"\"\<Partitioning\>\"", "\[Rule]", "Automatic"}]}], 
           "}"}]}]}], "}"}]}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.623556297187783*^9, 3.6235562984577847`*^9}, {
   3.6235563293478165`*^9, 3.6235563469178333`*^9}, {3.6235563812878685`*^9, 
   3.6235565029979897`*^9}, {3.6235618064565306`*^9, 3.623561813966958*^9}, {
   3.623562065016238*^9, 3.623562068142415*^9}, 3.6235738125004077`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"FifthHarmonicPlot", " ", "=", " ", 
   RowBox[{"DiscretePlot", "[", 
    RowBox[{
     RowBox[{"FifthHarmonic", "[", 
      RowBox[{"x", ",", "1", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1.5", ",", "0.2"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", " ", "None"}], ",", "  ", 
     RowBox[{"PlotMarkers", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledDiamond]\>\"", ",", "10"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "  ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.623561870330164*^9, 3.6235618709852004`*^9}, {
   3.623561919729974*^9, 3.623561920920041*^9}, 3.6235735754789267`*^9, {
   3.6235744539028883`*^9, 3.623574488142836*^9}, 3.6235750151198096`*^9, 
   3.623578475846648*^9, {3.6235786872886744`*^9, 3.623578696646207*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the argument function \
(\[NoBreak]\\!\\(\\(\\(-\\(\\(\\(\\@2\\\\ \[ExponentialE]\\^\\(\\(\\(-1\\)\\) \
- t - x\\)\\\\ \\(\\((\\(\\(5\\\\ x\\)\\) - \\(\\(20\\\\ x\\^3\\)\\) + \
\\(\\(16\\\\ x\\^5\\)\\))\\)\\)\\)\\/\\(\[Pi]\\\\ \\@\\(\\(\\(0.` \
\[VeryThinSpace]\\)\\) + t\\)\\\\ \\@\\(1 - x\\^2\\)\\)\\)\\)\\)\\) - \\(3840\
\\\\ \[ExponentialE]\\^\\(\\(\\(-1\\)\\) - t - x\\)\\\\ \\(\\((\\(\\(0.0375` \
\[VeryThinSpace]\\)\\) + \\(\\(0.049`\\\\ \\(\\((\\(\\(0.` \
\[VeryThinSpace]\\)\\) + t)\\)\\)\\)\\) + \\(\\(0.28`\\\\ \\((\\(\\(0.` \
\[VeryThinSpace]\\)\\) + t)\\)\\^2\\)\\) + \\(\\(0.16333333333333333`\\\\ \
\\((\\(\\(0.` \[VeryThinSpace]\\)\\) + t)\\)\\^3\\)\\) + \\(\\(1\\/24\\\\ \
\\((\\(\\(0.` \[VeryThinSpace]\\)\\) + t)\\)\\^4\\)\\))\\)\\)\\\\ \
\\(\\((\\(\\(5\\\\ x\\)\\) - \\(\\(20\\\\ x\\^3\\)\\) + \\(\\(16\\\\ x\\^5\\)\
\\))\\)\\)\\)\\/\\(\[Pi]\\\\ \\@\\(1 - x\\^2\\)\\)\\)\[NoBreak]) is less than \
WorkingPrecision (\[NoBreak]\\!\\(20.`\\)\[NoBreak]). \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precw\\\", ButtonNote -> \
\\\"NIntegrate::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235619361699095`*^9, 3.6235620733377113`*^9, 3.6235735785881033`*^9, 
   3.6235738193818007`*^9, {3.623574445577416*^9, 3.6235744892469006`*^9}, 
   3.6235750206591263`*^9, {3.6235784570275784`*^9, 3.6235784779267673`*^9}, {
   3.623578689457799*^9, 3.623578697293244*^9}, 3.623584632037799*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \[NoBreak]\\!\\({\\(\\({0, \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`70.\\)\\), 1.`20.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.\
009730427008790660952366675169284317187191400746006635417835457844806`70.\\)\
\[NoBreak] and \
\[NoBreak]\\!\\(195.\
828204369420219022454690876755787970295040514074894922581596660837`70.\\)\
\[NoBreak] for the integral and error estimates. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", ButtonNote -> \
\\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235619361699095`*^9, 3.6235620733377113`*^9, 3.6235735785881033`*^9, 
   3.6235738193818007`*^9, {3.623574445577416*^9, 3.6235744892469006`*^9}, 
   3.6235750206591263`*^9, {3.6235784570275784`*^9, 3.6235784779267673`*^9}, {
   3.623578689457799*^9, 3.623578697293244*^9}, 3.623584632436822*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the argument function \
(\[NoBreak]\\!\\(\\(\\(-\\(\\(\\(3840\\\\ \[ExponentialE]\\^\\(\\(\\(-1\\)\\) \
- t - x\\)\\\\ \\(\\((\\(\\(0.0375` \[VeryThinSpace]\\)\\) + \\(\\(0.049`\\\\ \
\\(\\((\\(\\(-0.2`\\)\\) + t)\\)\\)\\)\\) + \\(\\(0.28`\\\\ \
\\((\\(\\(-0.2`\\)\\) + t)\\)\\^2\\)\\) + \\(\\(0.16333333333333333`\\\\ \\((\
\\(\\(-0.2`\\)\\) + t)\\)\\^3\\)\\) + \\(\\(1\\/24\\\\ \\((\\(\\(-0.2`\\)\\) \
+ t)\\)\\^4\\)\\))\\)\\)\\\\ \\(\\((\\(\\(5\\\\ x\\)\\) - \\(\\(20\\\\ \
x\\^3\\)\\) + \\(\\(16\\\\ x\\^5\\)\\))\\)\\)\\)\\/\\(\[Pi]\\\\ \\@\\(1 - \
x\\^2\\)\\)\\)\\)\\)\\) - \\(\\@2\\\\ \[ExponentialE]\\^\\(\\(\\(-1\\)\\) - t \
- x\\)\\\\ \\(\\((\\(\\(5\\\\ x\\)\\) - \\(\\(20\\\\ x\\^3\\)\\) + \\(\\(16\\\
\\ x\\^5\\)\\))\\)\\)\\)\\/\\(\[Pi]\\\\ \\@\\(\\(\\(-0.2`\\)\\) + t\\)\\\\ \
\\@\\(1 - x\\^2\\)\\)\\)\[NoBreak]) is less than WorkingPrecision (\[NoBreak]\
\\!\\(20.`\\)\[NoBreak]). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precw\\\", ButtonNote -> \
\\\"NIntegrate::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235619361699095`*^9, 3.6235620733377113`*^9, 3.6235735785881033`*^9, 
   3.6235738193818007`*^9, {3.623574445577416*^9, 3.6235744892469006`*^9}, 
   3.6235750206591263`*^9, {3.6235784570275784`*^9, 3.6235784779267673`*^9}, {
   3.623578689457799*^9, 3.623578697293244*^9}, 3.6235846325188265`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
200000000000000011102230246251565404236316680908203125`20., \
\[Infinity]}\\)\\), \\(\\({\\(\\(-1.`70.\\)\\), 1.`20.}\\)\\)}\\)\[NoBreak]. \
NIntegrate obtained \
\[NoBreak]\\!\\(0.\
8266973529106575868656360254975428509956722613097316143966343712109042`70.\\)\
\[NoBreak] and \
\[NoBreak]\\!\\(160.\
330573237284009340535716757733719207939124924741883542611354984213`70.\\)\
\[NoBreak] for the integral and error estimates. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", ButtonNote -> \
\\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235619361699095`*^9, 3.6235620733377113`*^9, 3.6235735785881033`*^9, 
   3.6235738193818007`*^9, {3.623574445577416*^9, 3.6235744892469006`*^9}, 
   3.6235750206591263`*^9, {3.6235784570275784`*^9, 3.6235784779267673`*^9}, {
   3.623578689457799*^9, 3.623578697293244*^9}, 3.6235846328168435`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "precw"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"The precision of the argument function \
(\[NoBreak]\\!\\(\\(\\(-\\(\\(\\(3840\\\\ \[ExponentialE]\\^\\(\\(\\(-1\\)\\) \
- t - x\\)\\\\ \\(\\((\\(\\(0.0375` \[VeryThinSpace]\\)\\) + \\(\\(0.049`\\\\ \
\\(\\((\\(\\(-0.4`\\)\\) + t)\\)\\)\\)\\) + \\(\\(0.28`\\\\ \
\\((\\(\\(-0.4`\\)\\) + t)\\)\\^2\\)\\) + \\(\\(0.16333333333333333`\\\\ \\((\
\\(\\(-0.4`\\)\\) + t)\\)\\^3\\)\\) + \\(\\(1\\/24\\\\ \\((\\(\\(-0.4`\\)\\) \
+ t)\\)\\^4\\)\\))\\)\\)\\\\ \\(\\((\\(\\(5\\\\ x\\)\\) - \\(\\(20\\\\ \
x\\^3\\)\\) + \\(\\(16\\\\ x\\^5\\)\\))\\)\\)\\)\\/\\(\[Pi]\\\\ \\@\\(1 - \
x\\^2\\)\\)\\)\\)\\)\\) - \\(\\@2\\\\ \[ExponentialE]\\^\\(\\(\\(-1\\)\\) - t \
- x\\)\\\\ \\(\\((\\(\\(5\\\\ x\\)\\) - \\(\\(20\\\\ x\\^3\\)\\) + \\(\\(16\\\
\\ x\\^5\\)\\))\\)\\)\\)\\/\\(\[Pi]\\\\ \\@\\(\\(\\(-0.4`\\)\\) + t\\)\\\\ \
\\@\\(1 - x\\^2\\)\\)\\)\[NoBreak]) is less than WorkingPrecision (\[NoBreak]\
\\!\\(20.`\\)\[NoBreak]). \\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", \
ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/General/precw\\\", ButtonNote -> \
\\\"NIntegrate::precw\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235619361699095`*^9, 3.6235620733377113`*^9, 3.6235735785881033`*^9, 
   3.6235738193818007`*^9, {3.623574445577416*^9, 3.6235744892469006`*^9}, 
   3.6235750206591263`*^9, {3.6235784570275784`*^9, 3.6235784779267673`*^9}, {
   3.623578689457799*^9, 3.623578697293244*^9}, 3.6235846329108486`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: precw\\), \
\\\"MessageName\\\"]\\)\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235619361699095`*^9, 3.6235620733377113`*^9, 3.6235735785881033`*^9, 
   3.6235738193818007`*^9, {3.623574445577416*^9, 3.6235744892469006`*^9}, 
   3.6235750206591263`*^9, {3.6235784570275784`*^9, 3.6235784779267673`*^9}, {
   3.623578689457799*^9, 3.623578697293244*^9}, 3.6235846329608526`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
40000000000000002220446049250313080847263336181640625`20., \
\[Infinity]}\\)\\), \\(\\({\\(\\(-1.`70.\\)\\), 1.`20.}\\)\\)}\\)\[NoBreak]. \
NIntegrate obtained \
\[NoBreak]\\!\\(0.\
6768425463161168164426920016688305385425389560297215024636112320442854`70.\\)\
\[NoBreak] and \
\[NoBreak]\\!\\(131.\
2675709679860592875326701275397206648295665877125021114220038381105`70.\\)\
\[NoBreak] for the integral and error estimates. \\!\\(\\*ButtonBox[\\\"\
\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", ButtonFrame->None, \
ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", ButtonNote -> \
\\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235619361699095`*^9, 3.6235620733377113`*^9, 3.6235735785881033`*^9, 
   3.6235738193818007`*^9, {3.623574445577416*^9, 3.6235744892469006`*^9}, 
   3.6235750206591263`*^9, {3.6235784570275784`*^9, 3.6235784779267673`*^9}, {
   3.623578689457799*^9, 3.623578697293244*^9}, 3.6235846332498684`*^9}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvi\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235619361699095`*^9, 3.6235620733377113`*^9, 3.6235735785881033`*^9, 
   3.6235738193818007`*^9, {3.623574445577416*^9, 3.6235744892469006`*^9}, 
   3.6235750206591263`*^9, {3.6235784570275784`*^9, 3.6235784779267673`*^9}, {
   3.623578689457799*^9, 3.623578697293244*^9}, 3.62358463330387*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"FifthHarmonicPlot", " ", ",", "Forceplot"}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.623561943008298*^9, 3.6235619436933374`*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.24720000000000014`, 0.24, 0.6]}, 
    {RGBColor[0.24720000000000014`, 0.24, 0.6], {}, 
     GeometricTransformationBox[InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FrontFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        BackFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        GraphicsColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FontSize->10,
        FontColor->RGBColor[0.24720000000000014`, 0.24, 0.6]], {0, 0}], {{{0.,
       1.00992216917989}}, {{0.2, 0.8268543381227987}}, {{0.4, 
      0.6769710749370753}}, {{0.6000000000000001, 0.5542570379952424}}, {{0.8,
       0.45378728211661645`}}, {{1., 0.37152960322454803`}}, {{
      1.2000000000000002`, 0.3041827118387979}}, {{1.4000000000000001`, 
      0.2490437407370818}}}], {}}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.007], LineBox[CompressedData["
1:eJwV0f8303sAx3GkfKshxZnuiEskxSlXV6pX3dxI1DWUTmJXqHT7otxbnLpx
r3UlZaecUr5U1hUpypeusspnJBLGVpPr63wJG7PuZqx433t/eJ7HH/C0iTjG
jNLR0tLy/6//9Y0abq0eidroDvNRQuTQ3WJ5vIfuhaemtmPTGjnW3MrMLqMH
QWFMe6ZUybG9SVyaQ4/Epla9xzKpHLsj1c+v0ONg6TvfZEgsR5fLH1su0ZPR
eKLyl9kSOW4v3nk+lZ6BVYuzDV+x5EjSL3O4QL8LmUPOmbzacYTsuVMyoShH
4pqhhNgzYzAiSaHeVi9xjC1K2LtLBvuA8eGai7XITX16yGmzFKeaPZCpbIC+
56/HY5eOwqLctFtbuwUen5K76hgjeCLZ8rZlfRvOyR0f8kyGwY/JWbJHJoJf
V6XgstlHqJZtMH54RAxX5lX/etch6EwXmSyx74A0L5RR7jUId8J6EljcCYHo
Z45z7ADeJrs11zn1wL9xXF1f2A9rjnS6cLwXkfTzTXodEkjVPd3vXCUw2HlV
T2otwd3Rqje0y/14kLpHsDWsDzTGPfnAwAD82KXzDAt6kXaoIvq23RC0tfrm
tun2YnJT0cDBcx9RJ8s3Lq3oRtzq2nLzmmEsd2PXWbO70FNce7HVZhSS6CVH
D/h04nOMKGt5ghQvNEyDMKu/sWKz3mx0lQxtKcucos064J1nc+CxxTi+15fH
XJhpxylGuG1fqBxrr2bdvKzbDmdZsJHYfwJKbt2iXroYZsYT+rWaCYRbZK6M
tn8P3ZdZJV9nK9AtULj96PsOh92qPhhs/4SEFUzHtGgRirZF3H4x+Qk9nuMu
dhwhVFJLk6Fr/4DWz1LQBW2oCPSek+GlRG+w1ipH/f8++LBvlQ8pceQKLV4n
uBU2Xb7tXLYKN9T5OnYPBFi3NjmDvnoSTcvSqwOnWhBq1TKtLZzECHNTh9Hz
ZqjeXJIcT1KDt8hZpY5rQqZuWBzTbgqiwFulmh1vYdZdkadTO4WiK6cH+zwa
MfdsUpBH7DSCWSaOPvQ30CoMK5Es1MDrr6BdleYNOHGz5NJCvgaD07axLQb1
eL4iRd/06GdIGf6D1PzXMPU94fwb7QvMWbnuFk516FwpEMbzvoBb3fjebuMr
PMqF3UDYDDjzxDefxdRiX4m7KWN2BmnVVQEnuTVIZN9J6rw/i20Xw5VCIR8P
hxlZND+C9RcUHBGdj5QcNqt7B8Fr/yhOvjkfkcwx++IAAh/Ve6t4Mz6+4vEe
+e8msDy9c9h6AR+p6Xvr0iII/EzETnFafBx0v6EwjCcwXLwvZO1HCrbJi3z0
8gniamj3HCoozH57ZoG4gGCWMRJsVErhw1h/W34RwdIF+Rx5MQXO7rJ9Wx8T
NEREFT4toECcmCfZPILGCd+ooGwKna3puXOEBPd6vBXc3ylUnlfvF74j+MFF
wOQkUsjwDF/ObSdwHyvbePYshe1/rir/rpvAIdG5IuQUhWenmxqSRghyUtZZ
mh+mcG3lN+kBMoINpZON8w5SiJVkB9nICYQBfnpTkRQc/X7qqVYSXPfeb9kZ
RkFXW3SXoybgMZWK5r0Ueis8Y1gaglcbXjD5IRR4MVwX1xmC+rGC9U+CKVy3
NlIRQmDhl11yn0nhX2lqdHw=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"MessagesHead" -> DiscretePlot},
  PlotRange->{{0, 1.6}, {0, 1}},
  PlotRangePadding->{{Automatic, Automatic}, {
    Automatic, Automatic}}]], "Output",
 CellChangeTimes->{
  3.6235619495806713`*^9, 3.6235620821632133`*^9, 3.6235735847974567`*^9, {
   3.6235744494206343`*^9, 3.6235744942771854`*^9}, 3.6235750245293455`*^9, {
   3.6235784616768427`*^9, 3.623578481243955*^9}, {3.623578693294016*^9, 
   3.623578700515428*^9}, 3.623584655534135*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{
   RowBox[{"SixthHarmonic", "[", 
    RowBox[{
     RowBox[{"z_", "?", "NumericQ"}], ",", 
     RowBox[{"a_", "?", "NumericQ"}], ",", 
     RowBox[{"l_", "?", "NumericQ"}]}], "]"}], ":=", 
   RowBox[{
    RowBox[{
     FractionBox["46080", "\[Pi]"], "0.000045", "*", "  ", 
     RowBox[{"NIntegrate", "[", 
      RowBox[{
       RowBox[{
        RowBox[{"F", "[", 
         RowBox[{
          RowBox[{"z", "+", 
           RowBox[{"a", 
            RowBox[{"(", 
             RowBox[{"1", "+", "u"}], ")"}]}]}], ",", "l"}], "]"}], 
        FractionBox[
         RowBox[{
          RowBox[{"-", "1"}], "+", 
          RowBox[{"18", " ", 
           SuperscriptBox["u", "2"]}], "-", 
          RowBox[{"48", " ", 
           SuperscriptBox["u", "4"]}], "+", 
          RowBox[{"32", " ", 
           SuperscriptBox["u", "6"]}]}], 
         RowBox[{"Sqrt", "[", 
          RowBox[{"1", "-", 
           SuperscriptBox["u", "2"]}], "]"}]]}], ",", 
       RowBox[{"{", 
        RowBox[{"u", ",", 
         RowBox[{"-", "1"}], ",", "1"}], "}"}]}], "]"}]}], "+", " ", 
    RowBox[{"NIntegrate", "[", 
     RowBox[{
      RowBox[{
       RowBox[{
        FractionBox["46080", "\[Pi]"], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "6"}]], 
            RowBox[{"Gamma", "[", "6", "]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "5"]}], "+", 
          RowBox[{"0.96", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "5"}]], 
            RowBox[{"Gamma", "[", "5", "]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "4"]}], "+", 
          RowBox[{"0.469", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "4"}]], 
            RowBox[{"Gamma", "[", "4", "]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "3"]}], "+", 
          RowBox[{"0.185", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "3"}]], 
            RowBox[{"Gamma", "[", "3", "]"}]], 
           SuperscriptBox[
            RowBox[{"(", 
             RowBox[{"t", "-", "z"}], ")"}], "2"]}], "+", 
          RowBox[{"0.0022", 
           FractionBox[
            SuperscriptBox["a", 
             RowBox[{"-", "2"}]], 
            RowBox[{"Gamma", "[", "2", "]"}]], "*", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}]}], "+", 
          RowBox[{"0.0058", 
           SuperscriptBox["a", 
            RowBox[{"-", "1"}]]}]}], ")"}], 
        RowBox[{"(", 
         RowBox[{
          RowBox[{"F", "[", 
           RowBox[{
            RowBox[{"t", "+", 
             RowBox[{"a", 
              RowBox[{"(", 
               RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
          FractionBox[
           RowBox[{
            RowBox[{"-", "1"}], "+", 
            RowBox[{"18", " ", 
             SuperscriptBox["x", "2"]}], "-", 
            RowBox[{"48", " ", 
             SuperscriptBox["x", "4"]}], "+", 
            RowBox[{"32", " ", 
             SuperscriptBox["x", "6"]}]}], 
           RowBox[{"Sqrt", "[", 
            RowBox[{"1", "-", 
             SuperscriptBox["x", "2"]}], "]"}]]}], ")"}]}], "-", 
       RowBox[{
        FractionBox[
         RowBox[{
          RowBox[{"Sqrt", "[", "2", "]"}], " ", 
          SuperscriptBox["a", 
           RowBox[{"1", "/", "2"}]]}], 
         RowBox[{"\[Pi]", "*", 
          RowBox[{"Sqrt", "[", 
           RowBox[{"(", 
            RowBox[{"t", "-", "z"}], ")"}], "]"}]}]], 
        RowBox[{"D", "[", 
         RowBox[{
          RowBox[{
           RowBox[{"F", "[", 
            RowBox[{
             RowBox[{"t", "+", 
              RowBox[{"a", 
               RowBox[{"(", 
                RowBox[{"1", "+", "x"}], ")"}]}]}], ",", "l"}], "]"}], 
           FractionBox[
            RowBox[{
             RowBox[{"-", "1"}], "+", 
             RowBox[{"18", " ", 
              SuperscriptBox["x", "2"]}], "-", 
             RowBox[{"48", " ", 
              SuperscriptBox["x", "4"]}], "+", 
             RowBox[{"32", " ", 
              SuperscriptBox["x", "6"]}]}], 
            RowBox[{"Sqrt", "[", 
             RowBox[{"1", "-", 
              SuperscriptBox["x", "2"]}], "]"}]]}], ",", "t"}], "]"}]}]}], 
      ",", 
      RowBox[{"{", 
       RowBox[{"t", ",", "z", ",", "Infinity"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{"x", ",", 
        RowBox[{"-", "1"}], ",", "1"}], "}"}], ",", 
      RowBox[{"AccuracyGoal", "\[Rule]", "4"}], ",", 
      RowBox[{"WorkingPrecision", "\[Rule]", " ", "8"}], ",", 
      RowBox[{"Method", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\"\<OscillatorySelection\>\"", ",", 
         RowBox[{"Method", "\[Rule]", "\"\<DoubleExponential\>\""}], ",", 
         RowBox[{"\"\<FourierFiniteRangeMethod\>\"", "\[Rule]", 
          RowBox[{"{", 
           RowBox[{"\"\<LocalAdaptive\>\"", ",", 
            RowBox[{"\"\<Partitioning\>\"", "\[Rule]", "3"}]}], "}"}]}]}], 
        "}"}]}]}], "]"}]}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6235565366880245`*^9, 3.623556539418027*^9}, {
   3.623556608588097*^9, 3.62355678020827*^9}, {3.6235621263607264`*^9, 
   3.6235621315360203`*^9}, 3.6235622811145287`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"SixthHarmonicPlot", " ", "=", " ", 
   RowBox[{"DiscretePlot", "[", 
    RowBox[{
     RowBox[{"SixthHarmonic", "[", 
      RowBox[{"x", ",", "2", ",", "1"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"x", ",", "0", ",", "1.5", ",", "0.2"}], "}"}], ",", 
     RowBox[{"Filling", "\[Rule]", " ", "None"}], ",", "  ", 
     RowBox[{"PlotMarkers", "\[Rule]", " ", 
      RowBox[{"{", 
       RowBox[{"\"\<\[FilledDiamond]\>\"", ",", "10"}], "}"}]}], ",", 
     RowBox[{"PlotRange", "\[Rule]", "  ", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"0", ",", "1.6"}], "}"}], ",", 
        RowBox[{"{", 
         RowBox[{"0", ",", "1"}], "}"}]}], "}"}]}]}], "]"}]}], ";"}]], "Input",
 CellChangeTimes->{{3.6148346776940575`*^9, 3.6148346782830915`*^9}, {
   3.614838802807501*^9, 3.614838805072631*^9}, 3.623557904536598*^9, {
   3.623562149187024*^9, 3.6235621690631547`*^9}, 3.6235622273624706`*^9, {
   3.6235735911908197`*^9, 3.623573596487121*^9}, {3.623573837463827*^9, 
   3.623573862087228*^9}, {3.623574557486781*^9, 3.623574568758421*^9}, {
   3.623575038295128*^9, 3.623575053782009*^9}, {3.6235784002943516`*^9, 
   3.623578409389868*^9}, {3.6236482375605235`*^9, 3.623648247681099*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \[NoBreak]\\!\\({\\(\\({0, \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(1.003030161306731761073510766840423733134151544947937497777`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(40.55542070950483930965654409889856099968062093862296756892`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235621834129725`*^9, 3.623562231800724*^9, 3.623562286866856*^9, 
   3.6235735983772297`*^9, 3.6235738421320934`*^9, {3.623574550792401*^9, 
   3.623574570093498*^9}, {3.6235750396302047`*^9, 3.6235750547820663`*^9}, {
   3.623578402083454*^9, 3.623578410624939*^9}, 3.6235846654136977`*^9, {
   3.623648240926716*^9, 3.623648248932171*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
200000000000000011102230246251565404236316680908203125`8., \
\[Infinity]}\\)\\), \\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. \
NIntegrate obtained \
\[NoBreak]\\!\\(0.8212116393247714419869931537614012414256756835902364275849`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(33.20397013881260516244438760444573525022916784124657922237`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235621834129725`*^9, 3.623562231800724*^9, 3.623562286866856*^9, 
   3.6235735983772297`*^9, 3.6235738421320934`*^9, {3.623574550792401*^9, 
   3.623574570093498*^9}, {3.6235750396302047`*^9, 3.6235750547820663`*^9}, {
   3.623578402083454*^9, 3.623578410624939*^9}, 3.6235846654136977`*^9, {
   3.623648240926716*^9, 3.6236482492351885`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"NIntegrate", "::", "ncvi"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"NIntegrate failed to converge to prescribed accuracy after \
\[NoBreak]\\!\\(9\\)\[NoBreak] iterated refinements in \[NoBreak]\\!\\(x\\)\
\[NoBreak] in the region \
\[NoBreak]\\!\\({\\(\\({0.\
40000000000000002220446049250313080847263336181640625`8., \[Infinity]}\\)\\), \
\\(\\({\\(\\(-1.`58.\\)\\), 1.`8.}\\)\\)}\\)\[NoBreak]. NIntegrate obtained \
\[NoBreak]\\!\\(0.6723512239002010627976389169909139517477196723137774700676`\
58.\\)\[NoBreak] and \
\[NoBreak]\\!\\(27.18511147690578012558426105035563228724898689065341957682`\
58.\\)\[NoBreak] for the integral and error estimates. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/NIntegrate/ncvi\\\", \
ButtonNote -> \\\"NIntegrate::ncvi\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235621834129725`*^9, 3.623562231800724*^9, 3.623562286866856*^9, 
   3.6235735983772297`*^9, 3.6235738421320934`*^9, {3.623574550792401*^9, 
   3.623574570093498*^9}, {3.6235750396302047`*^9, 3.6235750547820663`*^9}, {
   3.623578402083454*^9, 3.623578410624939*^9}, 3.6235846654136977`*^9, {
   3.623648240926716*^9, 3.6236482495552073`*^9}}],

Cell[BoxData[
 RowBox[{
  StyleBox[
   RowBox[{"General", "::", "stop"}], "MessageName"], 
  RowBox[{
  ":", " "}], "\<\"Further output of \
\[NoBreak]\\!\\(\\*StyleBox[\\(NIntegrate :: ncvi\\), \\\"MessageName\\\"]\\)\
\[NoBreak] will be suppressed during this calculation. \
\\!\\(\\*ButtonBox[\\\"\[RightSkeleton]\\\", ButtonStyle->\\\"Link\\\", \
ButtonFrame->None, ButtonData:>\\\"paclet:ref/message/General/stop\\\", \
ButtonNote -> \\\"General::stop\\\"]\\)\"\>"}]], "Message", "MSG",
 CellChangeTimes->{
  3.6235621834129725`*^9, 3.623562231800724*^9, 3.623562286866856*^9, 
   3.6235735983772297`*^9, 3.6235738421320934`*^9, {3.623574550792401*^9, 
   3.623574570093498*^9}, {3.6235750396302047`*^9, 3.6235750547820663`*^9}, {
   3.623578402083454*^9, 3.623578410624939*^9}, 3.6235846654136977`*^9, {
   3.623648240926716*^9, 3.6236482496102085`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.623573859248067*^9, 3.62357385931007*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Show", "[", 
  RowBox[{"{", 
   RowBox[{"SixthHarmonicPlot", " ", ",", "Forceplot"}], "}"}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.614834672685769*^9, 3.614834720638529*^9}, 
   3.6148349180068903`*^9, {3.6148349802944756`*^9, 3.61483499619039*^9}, {
   3.6148384963438597`*^9, 3.6148385141908875`*^9}, {3.6148386757271857`*^9, 
   3.6148386855407515`*^9}, {3.6148389350871153`*^9, 
   3.6148389397343826`*^9}, {3.6148390297925663`*^9, 3.614839049368693*^9}, {
   3.6148391874406404`*^9, 3.614839196877184*^9}, 3.6235579072097507`*^9, {
   3.623573608013777*^9, 3.6235736118379946`*^9}}],

Cell[BoxData[
 GraphicsBox[{{
    {RGBColor[0.24720000000000014`, 0.24, 0.6]}, 
    {RGBColor[0.24720000000000014`, 0.24, 0.6], {}, 
     GeometricTransformationBox[InsetBox[
       StyleBox["\<\"\[FilledDiamond]\"\>",
        StripOnInput->False,
        LineColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FrontFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        BackFaceColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        GraphicsColor->RGBColor[0.24720000000000014`, 0.24, 0.6],
        FontSize->10,
        FontColor->RGBColor[0.24720000000000014`, 0.24, 0.6]], {0, 0}], {{{0.,
       1.0034792199472689`}}, {{0.2, 0.8215792974437145}}, {{0.4, 
      0.6726522369087986}}, {{0.6000000000000001, 0.5507210724839438}}, {{0.8,
       0.4508922784107009}}, {{1., 0.369159374661533}}, {{1.2000000000000002`,
       0.30224213282241374`}}, {{1.4000000000000001`, 
      0.24745492901760424`}}}], {}}}, {{}, {}, 
    {RGBColor[1, 0, 0], Thickness[0.007], LineBox[CompressedData["
1:eJwV0f8303sAx3GkfKshxZnuiEskxSlXV6pX3dxI1DWUTmJXqHT7otxbnLpx
r3UlZaecUr5U1hUpypeusspnJBLGVpPr63wJG7PuZqx433t/eJ7HH/C0iTjG
jNLR0tLy/6//9Y0abq0eidroDvNRQuTQ3WJ5vIfuhaemtmPTGjnW3MrMLqMH
QWFMe6ZUybG9SVyaQ4/Epla9xzKpHLsj1c+v0ONg6TvfZEgsR5fLH1su0ZPR
eKLyl9kSOW4v3nk+lZ6BVYuzDV+x5EjSL3O4QL8LmUPOmbzacYTsuVMyoShH
4pqhhNgzYzAiSaHeVi9xjC1K2LtLBvuA8eGai7XITX16yGmzFKeaPZCpbIC+
56/HY5eOwqLctFtbuwUen5K76hgjeCLZ8rZlfRvOyR0f8kyGwY/JWbJHJoJf
V6XgstlHqJZtMH54RAxX5lX/etch6EwXmSyx74A0L5RR7jUId8J6EljcCYHo
Z45z7ADeJrs11zn1wL9xXF1f2A9rjnS6cLwXkfTzTXodEkjVPd3vXCUw2HlV
T2otwd3Rqje0y/14kLpHsDWsDzTGPfnAwAD82KXzDAt6kXaoIvq23RC0tfrm
tun2YnJT0cDBcx9RJ8s3Lq3oRtzq2nLzmmEsd2PXWbO70FNce7HVZhSS6CVH
D/h04nOMKGt5ghQvNEyDMKu/sWKz3mx0lQxtKcucos064J1nc+CxxTi+15fH
XJhpxylGuG1fqBxrr2bdvKzbDmdZsJHYfwJKbt2iXroYZsYT+rWaCYRbZK6M
tn8P3ZdZJV9nK9AtULj96PsOh92qPhhs/4SEFUzHtGgRirZF3H4x+Qk9nuMu
dhwhVFJLk6Fr/4DWz1LQBW2oCPSek+GlRG+w1ipH/f8++LBvlQ8pceQKLV4n
uBU2Xb7tXLYKN9T5OnYPBFi3NjmDvnoSTcvSqwOnWhBq1TKtLZzECHNTh9Hz
ZqjeXJIcT1KDt8hZpY5rQqZuWBzTbgqiwFulmh1vYdZdkadTO4WiK6cH+zwa
MfdsUpBH7DSCWSaOPvQ30CoMK5Es1MDrr6BdleYNOHGz5NJCvgaD07axLQb1
eL4iRd/06GdIGf6D1PzXMPU94fwb7QvMWbnuFk516FwpEMbzvoBb3fjebuMr
PMqF3UDYDDjzxDefxdRiX4m7KWN2BmnVVQEnuTVIZN9J6rw/i20Xw5VCIR8P
hxlZND+C9RcUHBGdj5QcNqt7B8Fr/yhOvjkfkcwx++IAAh/Ve6t4Mz6+4vEe
+e8msDy9c9h6AR+p6Xvr0iII/EzETnFafBx0v6EwjCcwXLwvZO1HCrbJi3z0
8gniamj3HCoozH57ZoG4gGCWMRJsVErhw1h/W34RwdIF+Rx5MQXO7rJ9Wx8T
NEREFT4toECcmCfZPILGCd+ooGwKna3puXOEBPd6vBXc3ylUnlfvF74j+MFF
wOQkUsjwDF/ObSdwHyvbePYshe1/rir/rpvAIdG5IuQUhWenmxqSRghyUtZZ
mh+mcG3lN+kBMoINpZON8w5SiJVkB9nICYQBfnpTkRQc/X7qqVYSXPfeb9kZ
RkFXW3SXoybgMZWK5r0Ueis8Y1gaglcbXjD5IRR4MVwX1xmC+rGC9U+CKVy3
NlIRQmDhl11yn0nhX2lqdHw=
      "]]}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->True,
  AxesOrigin->{0, 0},
  Method->{"MessagesHead" -> DiscretePlot},
  PlotRange->{{0, 1.6}, {0, 1}},
  PlotRangePadding->{{Automatic, Automatic}, {
    Automatic, Automatic}}]], "Output",
 CellChangeTimes->{
  3.6235738637443223`*^9, {3.623574562196048*^9, 3.623574572174617*^9}, {
   3.6235750425673714`*^9, 3.623575057023193*^9}, {3.6235784057736626`*^9, 
   3.6235784135571065`*^9}, {3.623584670037961*^9, 3.623584672217084*^9}, {
   3.6236482436138673`*^9, 3.6236482512132998`*^9}}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.6235738606601467`*^9, 3.623573860755152*^9}}]
},
WindowSize->{1826, 859},
WindowMargins->{{Automatic, -31}, {-164, Automatic}},
FrontEndVersion->"9.0 for Microsoft Windows (64-bit) (January 25, 2013)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[557, 20, 10793, 301, 525, "Input"],
Cell[11353, 323, 3294, 89, 115, "Input"],
Cell[14650, 414, 708, 16, 31, "Input"],
Cell[CellGroupData[{
Cell[15383, 434, 1849, 42, 66, "Input"],
Cell[17235, 478, 2641, 48, 249, "Output"]
}, Open  ]],
Cell[19891, 529, 3631, 65, 192, "Input"],
Cell[23525, 596, 3708, 91, 108, "Input"],
Cell[27236, 689, 1821, 34, 31, "Input"],
Cell[CellGroupData[{
Cell[29082, 727, 273, 6, 31, "Input"],
Cell[29358, 735, 3979, 69, 249, "Output"]
}, Open  ]],
Cell[33352, 807, 3796, 108, 108, "Input"],
Cell[CellGroupData[{
Cell[37173, 919, 1328, 27, 31, "Input"],
Cell[38504, 948, 933, 18, 21, "Message"],
Cell[39440, 968, 966, 17, 39, "Message"],
Cell[40409, 987, 925, 18, 21, "Message"],
Cell[41337, 1007, 1026, 20, 39, "Message"],
Cell[42366, 1029, 934, 18, 21, "Message"],
Cell[43303, 1049, 586, 12, 21, "Message"],
Cell[43892, 1063, 1026, 19, 39, "Message"],
Cell[44921, 1084, 586, 12, 21, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[45544, 1101, 197, 4, 31, "Input"],
Cell[45744, 1107, 3466, 61, 249, "Output"]
}, Open  ]],
Cell[49225, 1171, 6638, 156, 108, "Input"],
Cell[CellGroupData[{
Cell[55888, 1331, 1070, 24, 31, "Input"],
Cell[56961, 1357, 1275, 22, 39, "Message"],
Cell[58239, 1381, 1339, 25, 39, "Message"],
Cell[59581, 1408, 1336, 24, 39, "Message"],
Cell[60920, 1434, 893, 17, 21, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[61850, 1456, 170, 4, 31, "Input"],
Cell[62023, 1462, 3247, 59, 249, "Output"]
}, Open  ]],
Cell[65285, 1524, 94, 1, 31, "Input"],
Cell[65382, 1527, 4912, 134, 175, "Input"],
Cell[CellGroupData[{
Cell[70319, 1665, 1103, 25, 31, "Input"],
Cell[71425, 1692, 1235, 21, 39, "Message"],
Cell[72663, 1715, 1298, 24, 39, "Message"],
Cell[73964, 1741, 1296, 23, 39, "Message"],
Cell[75263, 1766, 857, 16, 21, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[76157, 1787, 179, 5, 31, "Input"],
Cell[76339, 1794, 3358, 61, 249, "Output"]
}, Open  ]],
Cell[79712, 1858, 5082, 143, 133, "Input"],
Cell[CellGroupData[{
Cell[84819, 2005, 1036, 23, 31, "Input"],
Cell[85858, 2030, 1655, 26, 60, "Message"],
Cell[87516, 2058, 1219, 22, 39, "Message"],
Cell[88738, 2082, 1580, 25, 60, "Message"],
Cell[90321, 2109, 1287, 25, 39, "Message"],
Cell[91611, 2136, 1580, 25, 60, "Message"],
Cell[93194, 2163, 815, 15, 21, "Message"],
Cell[94012, 2180, 1287, 25, 39, "Message"],
Cell[95302, 2207, 811, 15, 21, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[96150, 2227, 204, 5, 31, "Input"],
Cell[96357, 2234, 3248, 59, 249, "Output"]
}, Open  ]],
Cell[99620, 2296, 5425, 154, 180, "Input"],
Cell[CellGroupData[{
Cell[105070, 2454, 1260, 26, 31, "Input"],
Cell[106333, 2482, 1237, 21, 39, "Message"],
Cell[107573, 2505, 1304, 24, 39, "Message"],
Cell[108880, 2531, 1301, 23, 39, "Message"],
Cell[110184, 2556, 860, 16, 21, "Message"]
}, Open  ]],
Cell[111059, 2575, 91, 1, 31, "Input"],
Cell[CellGroupData[{
Cell[111175, 2580, 615, 11, 31, "Input"],
Cell[111793, 2593, 3252, 59, 249, "Output"]
}, Open  ]],
Cell[115060, 2655, 94, 1, 31, "Input"]
}
]
*)

(* End of internal cache information *)
