function y = H_PID(omega, P, I, D)
% H_PID Transfer function of a generic PID controller
%
%   Y = H_PID(omega, P, I, D) is the transfer function for a generic
%     PID controller with proportional gain P, integral gain I and
%     differential gain D.
%
%   The response is calculated from P+I/(i*omega)+D*i*omega .
%
%   See also H_PID2
%
%   Copyright 2016 
%   Jannis Luebbe, Matthias Temmen, Philipp Rahe, Michael Reichling
%
%   This work is licensed under the Creative Commons 
%   Attribution-NonCommercial 4.0 International License, which permits 
%   non-commercial unrestricted use, distribution and reproduction 
%   provided the original work is properly cited. To view a copy of 
%   this license, visit http://creativecommons.org/licenses/by-nc/4.0/.
%
%   The software is provided "as is", without warranty of any kind, 
%   express or implied, including but not limited to the warranties of 
%   merchantability, fitness for a particular purpose and noninfringement. 
%   In no event shall the authors or copyright holders be liable for any 
%   claim, damages or other liability, whether in an action of contract, 
%   tort or otherwise, arising from, out of or in connection with the 
%   software or the use or other dealings in the software.
%

  y = P + I./(1i.*omega) + D.*1i.*omega;
  
end


