function y = H_Csimple(omega_m, p)
% H_Csimple Simplified complex cantilever frequency response
%
%   Y = H_Csimple(omega_m, p) is the simplified version of the cantilever 
%     frequency response function, calculated from the modulation 
%     frequency omega_m with omega = omega_0 + omega_m and the cantilever
%     eigenfrequency omega_0. p is the parameter struct, 
%     see parameters_default. 
%     The transfer function follows Eq.2 in [1].
%
%   Following entries are accessed in parameter struct p:
%   p.CL.f0 : cantilever eigenfrequency (in Hz)
%   p.CL.Q  : cantilever quality factor
%   
%   [1] Polesel-Maris et al., Phys. Rev. B 79, 235401 (2009)
%
%   See also H_Cfull, parameters_default
%
%   Copyright 2016 
%   Jannis Luebbe, Matthias Temmen, Philipp Rahe, Michael Reichling
%
%   This work is licensed under the Creative Commons 
%   Attribution-NonCommercial 4.0 International License, which permits 
%   non-commercial unrestricted use, distribution and reproduction 
%   provided the original work is properly cited. To view a copy of 
%   this license, visit http://creativecommons.org/licenses/by-nc/4.0/.
%
%   The software is provided "as is", without warranty of any kind, 
%   express or implied, including but not limited to the warranties of 
%   merchantability, fitness for a particular purpose and noninfringement. 
%   In no event shall the authors or copyright holders be liable for any 
%   claim, damages or other liability, whether in an action of contract, 
%   tort or otherwise, arising from, out of or in connection with the 
%   software or the use or other dealings in the software.
%

  omega_0 = 2.*pi.*p.CL.f0;
  Q       = p.CL.Q;
  
  y = 1./( 1./Q + 2i.*omega_m./omega_0 );
  
end
