function y = H_ac(omega_m, p)
% H_AC Transfer function of the amplitude PID controller
%
%   Y = H_AC(omega_m, p) is the transfer function for the PID controller 
%     within the amplitude feedback loop, calculated from the modulation 
%     frequency omega_m with omega = omega_0 + omega_m and the cantilever
%     eigenfrequency omega_0. p is the parameter struct, 
%     see parameters_default. 
%
%   Following entries are accessed in parameter struct p:
%   p.AFB.Pgain   : proportional gain for the PID loop
%   p.AFB.Igain   : integral gain for the PID loop
%   p.AFB.Dgain   : differential gain for the PID loop
%   p.SYS.S_z_A   : sensitivity of detection system in m/V
%   p.SYS.S_z_exc : sensitivity of the drive piezo in m/V
%
%   See also H_PID2, parameters_default
%
%   Copyright 2016 
%   Jannis Luebbe, Matthias Temmen, Philipp Rahe, Michael Reichling
%
%   This work is licensed under the Creative Commons 
%   Attribution-NonCommercial 4.0 International License, which permits 
%   non-commercial unrestricted use, distribution and reproduction 
%   provided the original work is properly cited. To view a copy of 
%   this license, visit http://creativecommons.org/licenses/by-nc/4.0/.
%
%   The software is provided "as is", without warranty of any kind, 
%   express or implied, including but not limited to the warranties of 
%   merchantability, fitness for a particular purpose and noninfringement. 
%   In no event shall the authors or copyright holders be liable for any 
%   claim, damages or other liability, whether in an action of contract, 
%   tort or otherwise, arising from, out of or in connection with the 
%   software or the use or other dealings in the software.
%

  y = -p.SYS.S_z_exc./p.SYS.S_z_A ...
        .*H_PID2(omega_m, p.AFB.Pgain, p.AFB.Igain, p.AFB.Dgain);
  
end

