function y = but4(omega,omega_c)
% BUT4 Butterworth filter of 4th order
%
%   Y = BUT4(omega, omega_c) is the transfer function of a Butterworth
%   filter of 4th order [1] defined in frequency space. omega_c is the 
%   cutoff frequency of the filter.
%
%   [1] S. Butterworth, Experimental Wireless & the Wireless Engineer, 
%       7, 536 (1930).
%
%   See also BUT1, BUT2, BUT3, BUT5
%
%   Copyright 2016 
%   Jannis Luebbe, Matthias Temmen, Philipp Rahe, Michael Reichling
%
%   This work is licensed under the Creative Commons 
%   Attribution-NonCommercial 4.0 International License, which permits 
%   non-commercial unrestricted use, distribution and reproduction 
%   provided the original work is properly cited. To view a copy of 
%   this license, visit http://creativecommons.org/licenses/by-nc/4.0/.
%
%   The software is provided "as is", without warranty of any kind, 
%   express or implied, including but not limited to the warranties of 
%   merchantability, fitness for a particular purpose and noninfringement. 
%   In no event shall the authors or copyright holders be liable for any 
%   claim, damages or other liability, whether in an action of contract, 
%   tort or otherwise, arising from, out of or in connection with the 
%   software or the use or other dealings in the software.
%

 y = 1./((1+0.7654.*1i.*omega./(omega_c)+(1i.*omega./omega_c).^2) ...
         .*(1+1.8478.*1i.*omega./(omega_c)+(1i.*omega./omega_c).^2));
end
