%%  Generates figures from manuscript as examples for using the code
%
%   Copyright 2016 
%   Jannis Luebbe, Matthias Temmen, Philipp Rahe, Michael Reichling
%
%   This work is licensed under the Creative Commons 
%   Attribution-NonCommercial 4.0 International License, which permits 
%   non-commercial unrestricted use, distribution and reproduction 
%   provided the original work is properly cited. To view a copy of 
%   this license, visit http://creativecommons.org/licenses/by-nc/4.0/.
%
%   The software is provided "as is", without warranty of any kind, 
%   express or implied, including but not limited to the warranties of 
%   merchantability, fitness for a particular purpose and noninfringement. 
%   In no event shall the authors or copyright holders be liable for any 
%   claim, damages or other liability, whether in an action of contract, 
%   tort or otherwise, arising from, out of or in connection with the 
%   software or the use or other dealings in the software.
%

clear all;

% Initial parameter set:
parameters_initial = parameters_default();

% Numerical evaluation and graphics output: X axis range
min_fm  = 1e1;
max_fm  = 1.2e3;
cnt_fm  = 10000;

% frequency axis for all figures
omegam = linspace(2*pi.*min_fm, 2*pi.*max_fm, cnt_fm);
f = omegam/(2*pi);



%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%% Create figures %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%% Figure 5:
figure

% frequency shift noise spectral density d^df for diffrent P_PLL gains
subplot(2,2,1)
  p = parameters_initial;
  p.PLL.Pgain = -4.2*(-368.7);
  ddf = sqrt(D_df_free(omegam, p));
  loglog(f, ddf); hold on;

  p.PLL.Pgain = -2.1*(-368.7);
  ddf = sqrt(D_df_free(omegam, p));
  loglog(f, ddf); 

  p.PLL.Pgain = -0.5*(-368.7);
  ddf = sqrt(D_df_free(omegam, p));
  loglog(f, ddf); hold off; 

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{{\Delta}f} (Hz/Hz^{1/2})');
  legend('P_{PLL}=-4.2Hz/deg', ...
         'P_{PLL}=-2.1Hz/deg', ...
         'P_{PLL}=-0.5Hz/deg', ...
         'location', 'best');
  title('Figure 5');

% amplitude noise spectral density d^A for diffrent P_PLL gains
subplot(2,2,2)
  p = parameters_initial;
  p.AFB.Pgain = 0.08;
  p.PLL.Pgain = -4.2*(-368.7);
  dA = sqrt(D_A(omegam, p));
  loglog(f, dA.*1e15); hold on;

  p.PLL.Pgain = -2.1*(-368.7);
  dA = sqrt(D_A(omegam, p));
  loglog(f, dA.*1e15); 

  p.PLL.Pgain = -0.5*(-368.7);
  dA = sqrt(D_A(omegam, p));
  loglog(f, dA.*1e15); hold off; 

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{A} (fm/Hz^{1/2})');
  legend('P_{PLL}=-4.2Hz/deg', ...
         'P_{PLL}=-2.1Hz/deg', ...
         'P_{PLL}=-0.5Hz/deg', ...
         'location', 'best');

% frequency shift noise spectral density d^df for different P_A gains
subplot(2,2,3)
  omegam = linspace(2*pi.*min_fm, 2*pi.*max_fm, cnt_fm);
  f = omegam/(2*pi);

  p = parameters_initial;
  p.AFB.Pgain = 0.16;
  ddf = sqrt(D_df_free(omegam, p));
  loglog(f, ddf); hold on;

  p.AFB.Pgain = 0.08;
  ddf = sqrt(D_df_free(omegam, p));
  loglog(f, ddf); 

  p.AFB.Pgain = 0.01;
  ddf = sqrt(D_df_free(omegam, p));
  loglog(f, ddf); 

  p.AFB.Pgain = 0.0;
  ddf = sqrt(D_df_free(omegam, p));
  loglog(f, ddf); hold off; 

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{{\Delta}f} (Hz/Hz^{1/2})');
  legend('P_{A}=0.16', ...
         'P_{A}=0.08', ...
         'P_{A}=0.01', ...
         'P_{A}=0.00', ...
         'location', 'best');

% amplitude noise spectral density d^A for different P_A gains
subplot(2,2,4)

  p = parameters_initial;
  p.AFB.Pgain = 0.16;
  dA = sqrt(D_A(omegam, p));
  loglog(f, dA.*1e15); hold on;

  p.AFB.Pgain = 0.08;
  dA = sqrt(D_A(omegam, p));
  loglog(f, dA.*1e15); 

  p.AFB.Pgain = 0.01;
  dA = sqrt(D_A(omegam, p));
  loglog(f, dA.*1e15); 

  p.AFB.Pgain = 0.0;
  dA = sqrt(D_A(omegam, p));
  loglog(f, dA.*1e15); hold off; 

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{A} (fm/Hz^{1/2})');
  legend('P_{A}=0.16', ...
         'P_{A}=0.08', ...
         'P_{A}=0.01', ...
         'P_{A}=0.00', ...
         'location', 'best');


%% Figure 6:
figure  
  p = parameters_initial;

  subplot(2,1,1);
    p.AFB.Pgain = 0.08;
    p.ZFB.Pgain = 0.0;
    p.ZFB.Igain = 0.0;

    loglog(f, sqrt(D_df_free(omegam, p)), '--'); hold on
    loglog(f, sqrt(D_df(omegam, p)));
    p.AFB.Pgain = 0.0;
    loglog(f, sqrt(D_df(omegam, p)));

    axis tight; xlabel('f_m (Hz)'); ylabel('d^{{\Delta}f}, d^{{\Delta}f}_{ts} (Hz)');
    legend('no tip-sample interaction', ...
           'with tip-sample interaction, P_A = 0.08', ...
           'with tip-sample interaction, P_A = 0.0', ...
           'location', 'best');
    title('Figure 6');

  subplot(2,1,2);
    p.AFB.Pgain = 0.08;
    p.TS.beta  = 12.3e9;
    p.TS.alpha = -p.TS.beta;
    loglog(f, sqrt(D_df_free(omegam, p)), '--'); hold on
    loglog(f, sqrt(D_df(omegam, p)));
    p.TS.beta  = 6.36e9;
    p.TS.alpha = -p.TS.beta;
    loglog(f, sqrt(D_df(omegam, p)));

    axis tight; xlabel('f_m (Hz)'); ylabel('d^{{\Delta}f}, d^{{\Delta}f}_{ts} (Hz)');
    legend('no tip-sample interaction', ...
           'with tip-sample interaction, <df> = -45Hz', ...
           'with tip-sample interaction, <df> = -30Hz', ...
           'location', 'best');

%% Figure 7:
figure

subplot(2,2,1)
  p = parameters_initial;
  p.ZFB.Pgain = 0.18;
  p.ZFB.Igain = 200;
  p.AFB.Pgain = 0.08;
  loglog(f, sqrt(D_df_free(omegam, p)), '--'); hold on;
  loglog(f, sqrt(D_df(omegam, p))); 
  p.AFB.Pgain = 0.0;
  loglog(f, sqrt(D_df(omegam, p))); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{{\Delta}f}, d^{{\Delta}f}_{ts} (Hz)');
  legend('no tip-sample interaction', ...
         'with tip-sample interaction, P_A = 0.08', ...
         'with tip-sample interaction, P_A = 0.0', ...
         'location', 'best');
  title('Figure 7'); 

subplot(2,2,2)
  p = parameters_initial;
  p.ZFB.Pgain = 0.18;
  p.ZFB.Igain = 200;
  p.AFB.Pgain = 0.08;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12); hold on;
  p.AFB.Pgain = 0.0;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{z_p} (pm/Hz^{1/2})');
  legend('P_A = 0.08', ...
         'P_A = 0.0', ...
         'location', 'best');

subplot(2,2,3)
  p = parameters_initial;
  p.ZFB.Pgain = 0.18;
  p.ZFB.Igain = 200;
  p.AFB.Pgain = 0.08;
  loglog(f, sqrt(D_df_free(omegam, p)), '--'); hold on;
  p.TS.beta = 21.2e9; p.TS.alpha = -p.TS.beta;
  loglog(f, sqrt(D_df(omegam, p))); 
  p.TS.beta = 12.3e9; p.TS.alpha = -p.TS.beta;
  loglog(f, sqrt(D_df(omegam, p)));
  p.TS.beta = 6.36e9; p.TS.alpha = -p.TS.beta;
  loglog(f, sqrt(D_df(omegam, p))); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{{\Delta}f}, d^{{\Delta}f}_{ts} (Hz)');
  legend('no tip-sample interaction', ...
         'with tip-sample interaction, <df> = -60Hz', ...
         'with tip-sample interaction, <df> = -45Hz', ...
         'with tip-sample interaction, <df> = -30Hz', ...
         'location', 'best');

subplot(2,2,4)
  p = parameters_initial;
  p.ZFB.Pgain = 0.18;
  p.ZFB.Igain = 200;
  p.AFB.Pgain = 0.08;
  p.TS.beta = 21.2e9; p.TS.alpha = -p.TS.beta;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12); hold on;
  p.TS.beta = 12.3e9; p.TS.alpha = -p.TS.beta;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12);
  p.TS.beta = 6.36e9; p.TS.alpha = -p.TS.beta;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12); hold off;     

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{z_p} (pm/Hz^{1/2})');
  legend('<df> = -60Hz', ...
         '<df> = -45Hz', ...
         '<df> = -30Hz', ...
         'location', 'best');   


%% Figure 8:
figure

subplot(2,2,1)
  p = parameters_initial;
  p.AFB.Pgain = 0.08;
  p.TS.beta = 12.3e9; p.TS.alpha = -p.TS.beta;
  p.ZFB.Pgain = 0.36;
  p.ZFB.Igain = 200;
  loglog(f, sqrt(D_df_free(omegam, p)), '--'); hold on;
  loglog(f, sqrt(D_df(omegam, p))); 
  p.ZFB.Pgain = 0.18;
  loglog(f, sqrt(D_df(omegam, p)));
  p.ZFB.Pgain = 0.03;
  loglog(f, sqrt(D_df(omegam, p))); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{{\Delta}f}, d^{{\Delta}f}_{ts} (Hz)');
  legend('no tip-sample interaction', ...
         'with tip-sample interaction, P_z = 0.36', ...
         'with tip-sample interaction, P_z = 0.18', ...
         'with tip-sample interaction, P_z = 0.03', ...
         'location', 'best');
  title('Figure 8'); 

subplot(2,2,2)
  p = parameters_initial;
  p.AFB.Pgain = 0.08;
  p.TS.beta = 12.3e9; p.TS.alpha = -p.TS.beta;
  p.ZFB.Pgain = 0.36;
  p.ZFB.Igain = 200;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12); hold on;
  p.ZFB.Pgain = 0.18;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12);
  p.ZFB.Pgain = 0.03;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{z_p} (pm/Hz^{1/2})');
  legend('P_z = 0.36', ...
         'P_z = 0.18', ...
         ' P_z = 0.03', ...
         'location', 'best');

subplot(2,2,3)
  p = parameters_initial;
  p.AFB.Pgain = 0.08;
  p.TS.beta = 12.3e9; p.TS.alpha = -p.TS.beta;
  p.ZFB.Pgain = 0.18;
  p.ZFB.Igain = 400;
  loglog(f, sqrt(D_df_free(omegam, p)), '--'); hold on;
  loglog(f, sqrt(D_df(omegam, p))); 
  p.ZFB.Igain = 200;
  loglog(f, sqrt(D_df(omegam, p)));
  p.ZFB.Igain = 40;
  loglog(f, sqrt(D_df(omegam, p))); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{{\Delta}f}, d^{{\Delta}f}_{ts} (Hz)');
  legend('no tip-sample interaction', ...
         'with tip-sample interaction, I_z = 400Hz', ...
         'with tip-sample interaction, I_z = 200Hz', ...
         'with tip-sample interaction, I_z = 40Hz', ...
         'location', 'best');

subplot(2,2,4)
  p = parameters_initial;
  p.AFB.Pgain = 0.08;
  p.TS.beta = 12.3e9; p.TS.alpha = -p.TS.beta;
  p.ZFB.Pgain = 0.18;
  p.ZFB.Igain = 400;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12); hold on;
  p.ZFB.Igain = 200;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12);
  p.ZFB.Igain = 40;
  loglog(f, sqrt(D_zp(omegam, p)).*1e12); hold off;    

  axis tight; xlabel('f_m (Hz)'); ylabel('d^{z_p} (pm/Hz^{1/2})');
  legend('I_z = 400Hz', ...
         'I_z = 200Hz', ...
         'I_z = 40Hz', ...
         'location', 'best');   



%% Figure 10(a):
figure

  p = parameters_initial;
  p.AFB.Pgain = 0.16;
  semilogx(f, 20.*log10(abs(H_A(omegam, p)))); hold on;
  p.AFB.Pgain = 0.08;
  semilogx(f, 20.*log10(abs(H_A(omegam, p)))); 
  p.AFB.Pgain = 0.01;
  semilogx(f, 20.*log10(abs(H_A(omegam, p)))); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('gain |H_A| (dB)');
  legend('P_A = 0.16', ...
         'P_A = 0.08', ...
         'P_A = 0.01', ...
         'location', 'best');  
  title('Figure 10(a)');


%% Figure 11(a):
figure

  p = parameters_initial;
  p.PLL.Pgain = -4.2*(-368.7);
  semilogx(f, 20.*log10(abs(H_filter(omegam, p)))); hold on;
  p.PLL.Pgain = -2.1*(-368.7);
  semilogx(f, 20.*log10(abs(H_filter(omegam, p)))); 
  p.PLL.Pgain = -0.5*(-368.7);
  semilogx(f, 20.*log10(abs(H_filter(omegam, p)))); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('gain |H_{filter}| (dB)');
  legend('P_{PLL} = -4.2 Hz/deg', ...
         'P_{PLL} = -2.1 Hz/deg', ...
         'P_{PLL} = -0.5 Hz/deg', ...
         'location', 'best');  
  title('Figure 11(a)');


%% Figure 12(a,b):
figure

subplot(2,1,1);
  p = parameters_initial;
  p.ZFB.Igain = 200;
  p.ZFB.Pgain = 0.36;
  semilogx(f, 20.*log10(abs(H_z(omegam, p)))); hold on;
  p.ZFB.Pgain = 0.18;
  semilogx(f, 20.*log10(abs(H_z(omegam, p)))); 
  p.ZFB.Pgain = 0.03;
  semilogx(f, 20.*log10(abs(H_z(omegam, p)))); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('gain |H_{z}| (dB)');
  legend('P_{z} = 0.36', ...
         'P_{z} = 0.18', ...
         'P_{z} = 0.03', ...
         'location', 'best');  
  title('Figure 12(a,b)');

subplot(2,1,2);
  p = parameters_initial;
  p.ZFB.Pgain = 0.18;
  p.ZFB.Igain = 400;
  semilogx(f, 20.*log10(abs(H_z(omegam, p)))); hold on;
  p.ZFB.Igain = 200;
  semilogx(f, 20.*log10(abs(H_z(omegam, p)))); 
  p.ZFB.Igain = 40;
  semilogx(f, 20.*log10(abs(H_z(omegam, p)))); hold off;

  axis tight; xlabel('f_m (Hz)'); ylabel('gain |H_{z}| (dB)');
  legend('I_{z} = 400Hz', ...
         'I_{z} = 200Hz', ...
         'I_{z} = 40Hz', ...
         'location', 'best');  

