%%  Plots the step response for different control loops
%
%   Uses the inverse Laplace transformation [1] to calculate the step 
%   response of the amplitude, distance, and frequency control loop. 
%
%   [1] J. Valsa and L. Brancik: Approximate Formulae for 
%   Numerical Inversion of Laplace Transforms, Int. Journal of 
%   Numerical Modelling: Electronic Networks, Devices and Fields, 
%   Vol. 11, (1998), pp. 153-166
%
%   Copyright 2016 
%   Jannis Luebbe, Matthias Temmen, Philipp Rahe, Michael Reichling
%
%   This work is licensed under the Creative Commons 
%   Attribution-NonCommercial 4.0 International License, which permits 
%   non-commercial unrestricted use, distribution and reproduction 
%   provided the original work is properly cited. To view a copy of 
%   this license, visit http://creativecommons.org/licenses/by-nc/4.0/.
%
%   The software is provided "as is", without warranty of any kind, 
%   express or implied, including but not limited to the warranties of 
%   merchantability, fitness for a particular purpose and noninfringement. 
%   In no event shall the authors or copyright holders be liable for any 
%   claim, damages or other liability, whether in an action of contract, 
%   tort or otherwise, arising from, out of or in connection with the 
%   software or the use or other dealings in the software.
%


%% Figure 10(b)
figure

  p = parameters_default();
  p.AFB.Pgain = 0.16;
  p.AFB.Igain = 1*pi;
  [t3,ft3] = INVLAP('H_A(-i*s,p)/s', p, 0.0001, 0.022, 3000);
  plot((0.005+t3).*1e3+30+35+26,-ft3,'b-','Linewidth',2); hold on;
  
  p.AFB.Pgain = 0.08;
  [t2,ft2] = INVLAP('H_A(-i*s,p)/s', p, 0.0001, 0.022, 3000);
  plot((0.005+t2).*1e3+30+34,-ft2,'-','color',[0 0.5 0],'Linewidth',2);
  
  p.AFB.Pgain = 0.01;
  [t1,ft1] = INVLAP('H_A(-i*s,p)/s', p, 0.0001, 0.060, 3000);
  plot((0.005+t1).*1e3,-ft1,'-','Color', [1 0 0] ,'Linewidth',2); hold off;
  
  xlabel('time t (ms)'); ylabel('A(t)'); title('Figure 10(b)');
  legend('P_A = 0.16', 'P_A = 0.08', 'P_A = 0.01', 'location', 'best');

  
%% Figure 11(b)
figure

  p = parameters_default();
  p.PLL.Pgain = -4.2*(-368.7);
  [t3,ft3] = INVLAP('H_filter(-i*s,p)/s', p, 0.0001, 0.028, 3000);
  plot((0.005+t3+0.075).*1e3,ft3,'b-','Linewidth',2); hold on;
  
  p.PLL.Pgain = -2.1*(-368.7);
  [t2,ft2] = INVLAP('H_filter(-i*s,p)/s', p, 0.0001, 0.028, 3000);
  plot((0.005+t2+0.04).*1e3,ft2,'-','color',[0 0.5 0],'Linewidth',2);
  
  p.PLL.Pgain = -0.5*(-368.7);
  [t1,ft1] = INVLAP('H_filter(-i*s,p)/s', p, 0.0001, 0.028, 3000);
  plot((0.005+t1+0.005).*1e3,ft1,'-','Color', [1 0 0] ,'Linewidth',2); hold off;
  
  xlabel('time t (ms)'); ylabel('{\Delta}f(t)'); title('Figure 11(b)');
  legend('P_{PLL} = -4.2 Hz/deg', ...
         'P_{PLL} = -2.1 Hz/deg', ...
         'P_{PLL} = -0.5 Hz/deg', 'location', 'best');

%% Figure 12(c,d)
figure
subplot(2,1,1);
  p = parameters_default();
  p.ZFB.Igain = 200;
  p.ZFB.Pgain = 0.36;
  [t3,ft3] = INVLAP('H_z(-i*s,p)/s', p, 0.0001, 0.050, 3000);
  plot((0.005+t3+0.010).*1e3+80,-ft3,'-','Color', [0 0 1] ,'Linewidth',2); hold on;
  
  p.ZFB.Pgain = 0.18;
  [t2,ft2] = INVLAP('H_z(-i*s,p)/s', p, 0.0001, 0.040, 3000);
  plot((0.005+t2+0.005).*1e3+40,-ft2,'-','Color', [0 0.5 0] ,'Linewidth',2);
  
  p.ZFB.Pgain = 0.03;
  [t1,ft1] = INVLAP('H_z(-i*s,p)/s', p, 0.0001, 0.040, 3000);
  plot((0.005+t1).*1e3,-ft1,'-','Color', [1 0 0] ,'Linewidth',2); hold off;
  
  xlabel('time t (ms)'); ylabel('z_p(t)'); title('Figure 12(c,d)');
  legend('P_{z} = 0.36', ...
         'P_{z} = 0.18', ...
         'P_{z} = 0.03', 'location', 'best');

subplot(2,1,2);
  p = parameters_default();
  p.ZFB.Pgain = 0.18;
  p.ZFB.Igain = 400;
  [t3,ft3] = INVLAP('H_z(-i*s,p)/s', p, 0.0001, 0.14, 3000);
  plot((0.005+t3).*1e3,-ft3,'-','Color', [0 0 1] ,'Linewidth',2); hold on;
  
  p.ZFB.Igain = 200;
  [t2,ft2] = INVLAP('H_z(-i*s,p)/s', p, 0.0001, 0.14, 3000);
  plot((0.005+t2).*1e3,-ft2,'-','Color', [0 0.5 0] ,'Linewidth',2);
  
  p.ZFB.Igain = 40;
  [t1,ft1] = INVLAP('H_z(-i*s,p)/s', p, 0.0001, 0.14, 3000);
  plot((0.005+t1).*1e3,-ft1,'-','Color', [1 0 0] ,'Linewidth',2); hold off;
  
  xlabel('time t (ms)'); ylabel('z_p(t)'); 
  legend('I_{z} = 400 Hz', ...
         'I_{z} = 200 Hz', ...
         'I_{z} = 40 Hz', 'location', 'best');

