function y = D_exc_th(p)
% D_EXC_TH Power noise spectral density of the driven cantilever excitation
%
%   Y = D_EXC_TH(p) calculates the power spectral density of a thermally 
%     excited cantilever expressed as the cantilever excitation.
%     p is the parameter struct, see parameters_default. 
%     The formula follows [1].
%
%   Following entries are accessed in parameter struct p:
%   p.CL.f0 : cantilever eigenfrequency (in Hz)
%   p.CL.Q  : cantilever quality factor
%   p.CL.k  : cantilever stiffness (in N/m)
%   p.CL.T  : cantilever temperature (in K)
%
%   [1] Luebbe et al., Beil. J. Nanotech. 4, 32 (2013)
%
%   See also parameters_default
%
%   Copyright 2016 
%   Jannis Luebbe, Matthias Temmen, Philipp Rahe, Michael Reichling
%
%   This work is licensed under the Creative Commons 
%   Attribution-NonCommercial 4.0 International License, which permits 
%   non-commercial unrestricted use, distribution and reproduction 
%   provided the original work is properly cited. To view a copy of 
%   this license, visit http://creativecommons.org/licenses/by-nc/4.0/.
%
%   The software is provided "as is", without warranty of any kind, 
%   express or implied, including but not limited to the warranties of 
%   merchantability, fitness for a particular purpose and noninfringement. 
%   In no event shall the authors or copyright holders be liable for any 
%   claim, damages or other liability, whether in an action of contract, 
%   tort or otherwise, arising from, out of or in connection with the 
%   software or the use or other dealings in the software.
%

  kb = 1.3806503E-23;
  
  y  = 4 .* kb .* p.CL.T ./ ( p.CL.k .* 2.*pi.*p.CL.f0 .* p.CL.Q );
  
end
