%data = dlmread('df_graph_data_export.txt')
%data = importdata('df_graph_data_export.txt')
clear all
close all
filename = 'Force_vs_z.txt';
delimiterIn = ' ';
headerlinesIn = 3;
A = importdata(filename,delimiterIn,headerlinesIn);

filename = 'df_vs_z.txt';
delimiterIn = ' ';
headerlinesIn = 3;
B = importdata(filename,delimiterIn,headerlinesIn);

%ON=importdata([ONp ONf]);
%ON=ON.data; 

%A.data(:,1) z column
%A.data(:,2) df column 1
%A.data(:,4) df column 2
%A.data(:,6) df column 2
figure(3)
plot(A.data(:,1)*10^9,A.data(:,2),'ro-'); hold on
plot(A.data(:,1)*10^9,A.data(:,4),'bx-');
plot(A.data(:,1)*10^9,A.data(:,6),'g^-');
axis([0.6 1.2 -0.04 0.04]);
%title('Force', 'fontsize',20,'fontweight', 'bold'); 
xlabel('z [nm]', 'fontsize',20,'fontweight', 'bold'); 
ylabel('Force [nN]', 'fontsize',20,'fontweight', 'bold');
legend('atom centre','atom edge','off atom','Location','SouthEast');
a=findobj(gcf); % get the handles associated with the current figure

allaxes=findall(a,'Type','axes');
alllines=findall(a,'Type','line');
alltext=findall(a,'Type','text');

set(allaxes,'FontName','Arial','FontWeight','Bold','LineWidth',2, 'FontSize',20);
set(alllines,'Linewidth',2);
set(alltext,'FontName','Arial','FontWeight','Bold','FontSize',20);

%%%%%%
figure(6) %10^6 rather than 10^9 as I think the units got messed up in gwyddion when rescaling
plot(B.data(:,1)*10^9,B.data(:,2),'ro-'); hold on
plot(B.data(:,1)*10^9,B.data(:,4),'bx-');
plot(B.data(:,1)*10^9,B.data(:,6),'g^-');
axis([1.0 1.6 -1 1]);
%title('Force', 'fontsize',20,'fontweight', 'bold'); 
xlabel('z [nm]', 'fontsize',20,'fontweight', 'bold'); 
ylabel('\Deltaf [Hz]', 'fontsize',20,'fontweight', 'bold');
legend('atom centre','atom edge','off atom','Location','SouthEast');
a=findobj(gcf); % get the handles associated with the current figure

allaxes=findall(a,'Type','axes');
alllines=findall(a,'Type','line');
alltext=findall(a,'Type','text');

set(allaxes,'FontName','Arial','FontWeight','Bold','LineWidth',2, 'FontSize',20);
set(alllines,'Linewidth',2);
set(alltext,'FontName','Arial','FontWeight','Bold','FontSize',20);

