/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.util.BitSet;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import org.jmol.g3d.Font3D;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Chain;
import org.jmol.viewer.Compiler;
import org.jmol.viewer.Context;
import org.jmol.viewer.Frame;
import org.jmol.viewer.Group;
import org.jmol.viewer.JmolConstants;
import org.jmol.viewer.PatternMatcher;
import org.jmol.viewer.ScriptException;
import org.jmol.viewer.Token;
import org.jmol.viewer.Viewer;

class Eval
implements Runnable {
    Compiler compiler;
    static final int scriptLevelMax = 10;
    int scriptLevel;
    Context[] stack = new Context[10];
    String filename;
    String script;
    short[] linenumbers;
    short[] lineIndices;
    Token[][] aatoken;
    int pc;
    long timeBeginExecution;
    long timeEndExecution;
    boolean error;
    String errorMessage;
    Token[] statement;
    int statementLength;
    Viewer viewer;
    Thread myThread;
    boolean terminationNotification;
    boolean interruptExecution;
    boolean tQuiet;
    static final boolean logMessages = false;
    final StringBuffer strbufLog = new StringBuffer(80);
    int pcLastExpressionInstruction;
    Hashtable variables = new Hashtable();
    boolean echoShapeActive = false;
    int[] monitorArgs = new int[5];
    private static final int[] shapeToks = new int[]{4102, 2052, 10509, 10532, 0x10010F, 339, 10514, 8458, 303360, 8489, 2307, 10535, 340, 8474, 342, 307, 2049, 6149, 2068, 2080, 1050891, 0x100151, 346, 1371, 343, 349, 341};
    static final String[] pdbRecords;
    AxisAngle4f aaMoveTo;
    AxisAngle4f aaStep;
    AxisAngle4f aaTotal;
    Matrix3f matrixStart;
    Matrix3f matrixInverse;
    Matrix3f matrixStep;
    Matrix3f matrixEnd;

    Eval(Viewer viewer) {
        this.compiler = new Compiler();
        this.viewer = viewer;
        this.clearDefinitionsAndLoadPredefined();
    }

    synchronized void start() {
        if (this.myThread == null) {
            this.myThread = new Thread(this);
            this.interruptExecution = false;
            this.myThread.start();
        }
    }

    synchronized void haltExecution() {
        if (this.myThread != null) {
            this.interruptExecution = true;
            this.myThread.interrupt();
        }
    }

    boolean isScriptExecuting() {
        return this.myThread != null;
    }

    synchronized void clearMyThread() {
        this.myThread = null;
    }

    boolean isActive() {
        return this.myThread != null;
    }

    boolean hasTerminationNotification() {
        return this.terminationNotification;
    }

    void resetTerminationNotification() {
        this.terminationNotification = false;
    }

    boolean hadRuntimeError() {
        return this.error;
    }

    String getErrorMessage() {
        return this.errorMessage;
    }

    int getExecutionWalltime() {
        return (int)(this.timeEndExecution - this.timeBeginExecution);
    }

    boolean loadScript(String filename, String script) {
        this.filename = filename;
        this.script = script;
        if (!this.compiler.compile(filename, script)) {
            this.error = true;
            this.errorMessage = this.compiler.getErrorMessage();
            this.viewer.scriptStatus(this.errorMessage);
            return false;
        }
        this.pc = 0;
        this.aatoken = this.compiler.getAatokenCompiled();
        this.linenumbers = this.compiler.getLineNumbers();
        this.lineIndices = this.compiler.getLineIndices();
        return true;
    }

    void clearState(boolean tQuiet) {
        int i = 10;
        while (--i >= 0) {
            this.stack[i] = null;
        }
        this.scriptLevel = 0;
        this.error = false;
        this.errorMessage = null;
        this.terminationNotification = false;
        this.interruptExecution = false;
        this.tQuiet = tQuiet;
    }

    boolean loadScriptString(String script, boolean tQuiet) {
        this.clearState(tQuiet);
        return this.loadScript(null, script);
    }

    boolean loadScriptFile(String filename, boolean tQuiet) {
        this.clearState(tQuiet);
        return this.loadScriptFileInternal(filename);
    }

    boolean loadScriptFileInternal(String filename) {
        Object t = this.viewer.getInputStreamOrErrorMessageFromName(filename);
        if (!(t instanceof InputStream)) {
            return this.loadError((String)t);
        }
        BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)t));
        StringBuffer script = new StringBuffer();
        try {
            String command;
            while ((command = reader.readLine()) != null) {
                script.append(command);
                script.append("\n");
            }
        }
        catch (IOException e) {
            try {
                reader.close();
            }
            catch (IOException ioe) {
                // empty catch block
            }
            return this.ioError(filename);
        }
        try {
            reader.close();
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return this.loadScript(filename, script.toString());
    }

    boolean loadError(String msg) {
        this.error = true;
        this.errorMessage = msg;
        return false;
    }

    boolean fileNotFound(String filename) {
        return this.loadError("file not found:" + filename);
    }

    boolean ioError(String filename) {
        return this.loadError("io error reading:" + filename);
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        str.append("Eval\n pc:");
        str.append(this.pc);
        str.append("\n");
        str.append(this.aatoken.length);
        str.append(" statements\n");
        for (int i = 0; i < this.aatoken.length; ++i) {
            str.append(" |");
            Token[] atoken = this.aatoken[i];
            for (int j = 0; j < atoken.length; ++j) {
                str.append(' ');
                str.append(atoken[j]);
            }
            str.append("\n");
        }
        str.append("END\n");
        return str.toString();
    }

    void clearDefinitionsAndLoadPredefined() {
        String definition;
        this.variables.clear();
        int cPredef = JmolConstants.predefinedSets.length;
        for (int iPredef = 0; iPredef < cPredef; ++iPredef) {
            this.predefine(JmolConstants.predefinedSets[iPredef]);
        }
        int i = JmolConstants.elementNames.length;
        while (--i > 1) {
            definition = "@" + JmolConstants.elementNames[i] + " _e=" + i;
            this.predefine(definition);
        }
        int j = JmolConstants.alternateElementNumbers.length;
        while (--j >= 0) {
            definition = "@" + JmolConstants.alternateElementNames[j] + " _e=" + JmolConstants.alternateElementNumbers[j];
            this.predefine(definition);
        }
    }

    void predefineElements() {
        int i = JmolConstants.elementNames.length;
        while (--i > 1) {
            String definition = "@" + JmolConstants.elementNames[i] + " _e=" + i;
            if (!this.compiler.compile("#element", definition)) {
                System.out.println("element definition error:" + definition);
                continue;
            }
            Token[][] aatoken = this.compiler.getAatokenCompiled();
            Token[] statement = aatoken[0];
            String variable = (String)statement[1].value;
            this.variables.put(variable, statement);
        }
    }

    void predefine(String script) {
        if (this.compiler.compile("#predefine", script)) {
            Token[][] aatoken = this.compiler.getAatokenCompiled();
            if (aatoken.length != 1) {
                this.viewer.scriptStatus("predefinition does not have exactly 1 command:" + script);
                return;
            }
            Token[] statement = aatoken[0];
            if (statement.length > 2) {
                int tok = statement[1].tok;
                if (tok == 1 || (tok & 0x48000) == 294912) {
                    String variable = (String)statement[1].value;
                    this.variables.put(variable, statement);
                } else {
                    this.viewer.scriptStatus("invalid variable name:" + script);
                }
            } else {
                this.viewer.scriptStatus("bad predefinition length:" + script);
            }
        } else {
            this.viewer.scriptStatus("predefined set compile error:" + script + "\ncompile error:" + this.compiler.getErrorMessage());
        }
    }

    public void run() {
        this.refresh();
        this.timeBeginExecution = System.currentTimeMillis();
        this.viewer.pushHoldRepaint();
        try {
            this.instructionDispatchLoop();
        }
        catch (ScriptException e) {
            this.error = true;
            this.errorMessage = "" + e;
            this.viewer.scriptStatus(this.errorMessage);
        }
        this.timeEndExecution = System.currentTimeMillis();
        if (this.errorMessage == null && this.interruptExecution) {
            this.errorMessage = "execution interrupted";
        }
        if (this.errorMessage != null) {
            this.viewer.scriptStatus(this.errorMessage);
        } else if (!this.tQuiet) {
            this.viewer.scriptStatus("Script completed");
        }
        this.clearMyThread();
        this.terminationNotification = true;
        this.viewer.popHoldRepaint();
    }

    void instructionDispatchLoop() throws ScriptException {
        long timeBegin = 0L;
        block58: while (!this.interruptExecution && this.pc < this.aatoken.length) {
            this.statement = this.aatoken[this.pc++];
            this.statementLength = this.statement.length;
            if (this.viewer.getDebugScript()) {
                this.logDebugScript();
            }
            Token token = this.statement[0];
            switch (token.tok) {
                case 303360: {
                    this.proteinShape(8);
                    continue block58;
                }
                case 4718849: {
                    this.background();
                    continue block58;
                }
                case 4868: {
                    this.center();
                    continue block58;
                }
                case 526598: {
                    this.color();
                    continue block58;
                }
                case 777: {
                    this.define();
                    continue block58;
                }
                case 1050891: {
                    this.echo();
                    continue block58;
                }
                case 268: 
                case 277: {
                    return;
                }
                case 0x10010F: {
                    this.label();
                    continue block58;
                }
                case 0x100151: {
                    this.hover();
                    continue block58;
                }
                case 0x100110: {
                    this.load();
                    continue block58;
                }
                case 10514: {
                    this.monitor();
                    continue block58;
                }
                case 278: {
                    this.refresh();
                    continue block58;
                }
                case 280: {
                    this.reset();
                    continue block58;
                }
                case 2105627: {
                    this.rotate();
                    continue block58;
                }
                case 0x10011D: {
                    this.script();
                    continue block58;
                }
                case 798: {
                    this.select();
                    continue block58;
                }
                case 2097450: {
                    this.translate();
                    continue block58;
                }
                case 302: {
                    this.zap();
                    continue block58;
                }
                case 12591: {
                    this.zoom();
                    continue block58;
                }
                case 316: {
                    this.delay();
                    continue block58;
                }
                case 317: {
                    this.delay();
                    this.pc = 0;
                    continue block58;
                }
                case 2097470: {
                    this.move();
                    continue block58;
                }
                case 793: {
                    this.restrict();
                    continue block58;
                }
                case 2105631: {
                    this.set();
                    continue block58;
                }
                case 8481: {
                    this.slab();
                    continue block58;
                }
                case 306: {
                    this.depth();
                    continue block58;
                }
                case 307: {
                    this.star();
                    continue block58;
                }
                case 2107683: {
                    this.cpk();
                    continue block58;
                }
                case 8492: {
                    this.wireframe();
                    continue block58;
                }
                case 339: {
                    this.vector();
                    continue block58;
                }
                case 323: {
                    this.animation();
                    continue block58;
                }
                case 338: {
                    this.vibration();
                    continue block58;
                }
                case 8458: {
                    this.dots();
                    continue block58;
                }
                case 10535: {
                    this.proteinShape(11);
                    continue block58;
                }
                case 340: {
                    this.proteinShape(12);
                    continue block58;
                }
                case 8474: {
                    this.proteinShape(13);
                    continue block58;
                }
                case 341: {
                    this.proteinShape(26);
                    continue block58;
                }
                case 8489: {
                    this.proteinShape(9);
                    continue block58;
                }
                case 2307: {
                    this.proteinShape(10);
                    continue block58;
                }
                case 342: {
                    this.proteinShape(14);
                    continue block58;
                }
                case 14656: {
                    this.spin();
                    continue block58;
                }
                case 10532: {
                    this.ssbond();
                    continue block58;
                }
                case 10509: {
                    this.hbond();
                    continue block58;
                }
                case 288: {
                    this.show();
                    continue block58;
                }
                case 324: 
                case 102661: {
                    this.frame();
                    continue block58;
                }
                case 336: {
                    this.font();
                    continue block58;
                }
                case 2097496: {
                    this.moveto();
                    continue block58;
                }
                case 345: {
                    this.console();
                    continue block58;
                }
                case 346: {
                    this.pmesh();
                    continue block58;
                }
                case 1371: {
                    this.polyhedra();
                    continue block58;
                }
                case 343: {
                    this.sasurface();
                    continue block58;
                }
                case 348: {
                    this.centerAt();
                    continue block58;
                }
                case 349: {
                    this.isosurface();
                    continue block58;
                }
                case 6299942: {
                    this.stereo();
                    continue block58;
                }
                case 1287: {
                    this.connect();
                    continue block58;
                }
                case 261: 
                case 270: 
                case 273: 
                case 275: 
                case 276: 
                case 284: 
                case 296: 
                case 299: 
                case 319: 
                case 322: 
                case 2349: 
                case 4417: 
                case 10498: 
                case 2097431: {
                    this.viewer.scriptStatus("Script command not implemented:" + token.value);
                    continue block58;
                }
            }
            this.unrecognizedCommand(token);
            return;
        }
    }

    int getLinenumber() {
        return this.linenumbers[this.pc];
    }

    String getLine() {
        short ichBegin = this.lineIndices[this.pc];
        int ichEnd = this.script.indexOf(13, (int)ichBegin);
        if (ichEnd == -1 && (ichEnd = this.script.indexOf(10, (int)ichBegin)) == -1) {
            ichEnd = this.script.length();
        }
        return this.script.substring(ichBegin, ichEnd);
    }

    /*
     * Enabled aggressive block sorting
     */
    void logDebugScript() {
        this.strbufLog.setLength(0);
        this.strbufLog.append(this.statement[0].value.toString());
        int i = 1;
        while (true) {
            block17: {
                if (i >= this.statementLength) {
                    this.viewer.scriptStatus(this.strbufLog.toString());
                    return;
                }
                this.strbufLog.append(' ');
                Token token = this.statement[i];
                switch (token.tok) {
                    case 2: {
                        this.strbufLog.append(token.intValue);
                        break block17;
                    }
                    case 16407: {
                        this.strbufLog.append(Group.getSeqcodeString(token.intValue));
                        break block17;
                    }
                    case 16409: {
                        this.strbufLog.append(':');
                        this.strbufLog.append((char)token.intValue);
                        break block17;
                    }
                    case 16410: {
                        this.strbufLog.append("%");
                        this.strbufLog.append("" + token.value);
                        break;
                    }
                    case 16411: {
                        this.strbufLog.append("/");
                        this.strbufLog.append("" + token.value);
                        break;
                    }
                    case 16405: {
                        this.strbufLog.append('[');
                        this.strbufLog.append(Group.getGroup3((short)token.intValue));
                        this.strbufLog.append(']');
                        break block17;
                    }
                    case 16406: {
                        this.strbufLog.append('[');
                        this.strbufLog.append(token.value);
                        this.strbufLog.append(']');
                        break block17;
                    }
                    case 16412: {
                        this.strbufLog.append('.');
                        break;
                    }
                    case 16408: {
                        this.strbufLog.append(Group.getSeqcodeString(token.intValue));
                        this.strbufLog.append('-');
                        this.strbufLog.append(Group.getSeqcodeString((Integer)token.value));
                        break;
                    }
                    case 32774: {
                        this.strbufLog.append("within ");
                        break;
                    }
                    case 32785: {
                        this.strbufLog.append("connected ");
                        break;
                    }
                    case 32784: {
                        this.strbufLog.append("substructure ");
                        break;
                    }
                    case 163840: 
                    case 163841: 
                    case 163842: 
                    case 163843: 
                    case 163844: 
                    case 163845: {
                        this.strbufLog.append(Token.atomPropertyNames[token.intValue & 0xF]);
                        this.strbufLog.append(Token.comparatorNames[token.tok & 0xF]);
                    }
                }
                this.strbufLog.append("" + token.value);
            }
            ++i;
        }
    }

    void evalError(String message) throws ScriptException {
        throw new ScriptException(message, this.getLine(), this.filename, this.getLinenumber());
    }

    void unrecognizedCommand(Token token) throws ScriptException {
        this.evalError("unrecognized command:" + token.value);
    }

    void unrecognizedAtomProperty(int propnum) throws ScriptException {
        this.evalError("unrecognized atom property:" + propnum);
    }

    void filenameExpected() throws ScriptException {
        this.evalError("filename expected");
    }

    void booleanExpected() throws ScriptException {
        this.evalError("boolean expected");
    }

    void booleanOrPercentExpected() throws ScriptException {
        this.evalError("boolean or percent expected");
    }

    void booleanOrNumberExpected() throws ScriptException {
        this.evalError("boolean or number expected");
    }

    void integerExpected() throws ScriptException {
        this.evalError("integer expected");
    }

    void numberExpected() throws ScriptException {
        this.evalError("number expected");
    }

    void propertyNameExpected() throws ScriptException {
        this.evalError("property name expected");
    }

    void axisExpected() throws ScriptException {
        this.evalError("x y z axis expected");
    }

    void colorExpected() throws ScriptException {
        this.evalError("color expected");
    }

    void keywordExpected() throws ScriptException {
        this.evalError("keyword expected");
    }

    void unrecognizedColorObject() throws ScriptException {
        this.evalError("unrecognized color object");
    }

    void unrecognizedExpression() throws ScriptException {
        this.evalError("runtime unrecognized expression");
    }

    void undefinedVariable() throws ScriptException {
        this.evalError("variable undefined");
    }

    void badArgumentCount() throws ScriptException {
        this.evalError("bad argument count");
    }

    void invalidArgument() throws ScriptException {
        this.evalError("invalid argument");
    }

    void incompatibleArguments() throws ScriptException {
        this.evalError("incompatible arguments");
    }

    void insufficientArguments() throws ScriptException {
        this.evalError("insufficient arguments");
    }

    void unrecognizedSetParameter() throws ScriptException {
        this.evalError("unrecognized SET parameter");
    }

    void unrecognizedSubcommand() throws ScriptException {
        this.evalError("unrecognized subcommand");
    }

    void invalidParameterOrder() throws ScriptException {
        this.evalError("invalid parameter order");
    }

    void subcommandExpected() throws ScriptException {
        this.evalError("subcommand expected");
    }

    void setspecialShouldNotBeHere() throws ScriptException {
        this.evalError("interpreter error - setspecial should not be here");
    }

    void numberOutOfRange() throws ScriptException {
        this.evalError("number out of range");
    }

    void numberOutOfRange(int min, int max) throws ScriptException {
        this.evalError("integer out of range (" + min + " - " + max + ")");
    }

    void numberOutOfRange(float min, float max) throws ScriptException {
        this.evalError("decimal number out of range (" + min + " - " + max + ")");
    }

    void numberMustBe(int a, int b) throws ScriptException {
        this.evalError("number must be (" + a + " or " + b + ")");
    }

    void badAtomNumber() throws ScriptException {
        this.evalError("bad atom number");
    }

    void errorLoadingScript(String msg) throws ScriptException {
        this.evalError("error loading script -> " + msg);
    }

    void fileNotFoundException(String filename) throws ScriptException {
        this.evalError("file not found : " + filename);
    }

    void notImplemented(int itoken) {
        this.notImplemented(this.statement[itoken]);
    }

    void notImplemented(Token token) {
        this.viewer.scriptStatus("" + token.value + " not implemented in command:" + this.statement[0].value);
    }

    void checkStatementLength(int length) throws ScriptException {
        if (this.statementLength != length) {
            this.badArgumentCount();
        }
    }

    void checkLength34() throws ScriptException {
        if (this.statementLength < 3 || this.statementLength > 4) {
            this.badArgumentCount();
        }
    }

    void checkLength2() throws ScriptException {
        this.checkStatementLength(2);
    }

    void checkLength3() throws ScriptException {
        this.checkStatementLength(3);
    }

    void checkLength4() throws ScriptException {
        this.checkStatementLength(4);
    }

    int intParameter(int index) throws ScriptException {
        if (this.statement[index].tok != 2) {
            this.integerExpected();
        }
        return this.statement[index].intValue;
    }

    float floatParameter(int index) throws ScriptException {
        if (index >= this.statementLength) {
            this.badArgumentCount();
        }
        float floatValue = 0.0f;
        switch (this.statement[index].tok) {
            case 2: {
                floatValue = this.statement[index].intValue;
                break;
            }
            case 3: {
                floatValue = ((Float)this.statement[index].value).floatValue();
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        return floatValue;
    }

    float getSetAngstroms() throws ScriptException {
        this.checkLength3();
        Token token = this.statement[2];
        switch (token.tok) {
            case 2: {
                return (float)token.intValue / 250.0f;
            }
            case 3: {
                return ((Float)token.value).floatValue();
            }
        }
        this.numberExpected();
        return -1.0f;
    }

    boolean getSetBoolean() throws ScriptException {
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 8193: {
                return true;
            }
            case 8192: {
                return false;
            }
        }
        this.booleanExpected();
        return false;
    }

    short getSetAxesTypeMad() throws ScriptException {
        this.checkLength3();
        int tok = this.statement[2].tok;
        short mad = 0;
        switch (tok) {
            case 8193: {
                mad = 1;
            }
            case 8192: {
                break;
            }
            case 2: {
                int diameterPixels = this.statement[2].intValue;
                if (diameterPixels < 0 || diameterPixels >= 20) {
                    this.numberOutOfRange(0, 19);
                }
                mad = (short)diameterPixels;
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(2);
                if (angstroms < 0.0f || angstroms >= 2.0f) {
                    this.numberOutOfRange(0.0f, 1.99999f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 16414: {
                mad = -1;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        return mad;
    }

    int getSetInteger() throws ScriptException {
        this.checkLength3();
        return this.intParameter(2);
    }

    BitSet copyBitSet(BitSet bitSet) {
        BitSet copy = new BitSet();
        copy.or(bitSet);
        return copy;
    }

    BitSet expression(Token[] code, int pcStart) throws ScriptException {
        int numberOfAtoms = this.viewer.getAtomCount();
        BitSet[] stack = new BitSet[10];
        int sp = 0;
        int pc = pcStart;
        block31: while (true) {
            Token instruction = code[pc];
            switch (instruction.tok) {
                case 32868: {
                    break;
                }
                case 32869: {
                    this.pcLastExpressionInstruction = pc;
                    break block31;
                }
                case 36875: {
                    int n = sp++;
                    BitSet bitSet = new BitSet(numberOfAtoms);
                    stack[n] = bitSet;
                    BitSet bs = bitSet;
                    int i = numberOfAtoms;
                    while (--i >= 0) {
                        bs.set(i);
                    }
                    break;
                }
                case 49157: {
                    stack[sp++] = new BitSet();
                    break;
                }
                case 32772: {
                    BitSet bs = stack[--sp];
                    stack[sp - 1].or(bs);
                    break;
                }
                case 32771: {
                    BitSet bs = stack[--sp];
                    stack[sp - 1].and(bs);
                    break;
                }
                case 32773: {
                    BitSet bs = stack[sp - 1];
                    this.notSet(bs);
                    break;
                }
                case 32774: {
                    BitSet bs = stack[sp - 1];
                    stack[sp - 1] = new BitSet();
                    this.withinInstruction(instruction, bs, stack[sp - 1]);
                    break;
                }
                case 32785: {
                    BitSet bs = stack[sp - 1];
                    stack[sp - 1] = this.connected(instruction, bs);
                    break;
                }
                case 32784: {
                    stack[sp++] = this.getSubstructureSet((String)instruction.value);
                    break;
                }
                case 299011: {
                    stack[sp++] = this.copyBitSet(this.viewer.getSelectionSet());
                    break;
                }
                case 296961: {
                    stack[sp++] = this.getHeteroSet();
                    break;
                }
                case 296962: {
                    stack[sp++] = this.getHydrogenSet();
                    break;
                }
                case 16406: {
                    stack[sp++] = this.getSpecName((String)instruction.value);
                    break;
                }
                case 16405: {
                    stack[sp++] = this.getSpecResid(instruction.intValue);
                    break;
                }
                case 16407: {
                    stack[sp++] = this.getSpecSeqcode(instruction.intValue);
                    break;
                }
                case 16408: {
                    int seqcodeA = instruction.intValue;
                    int seqcodeB = (Integer)instruction.value;
                    stack[sp++] = this.getSpecSeqcodeRange(seqcodeA, seqcodeB);
                    break;
                }
                case 16409: {
                    stack[sp++] = this.getSpecChain((char)instruction.intValue);
                    break;
                }
                case 16412: {
                    stack[sp++] = this.getSpecAtom((String)instruction.value);
                    break;
                }
                case 16410: {
                    stack[sp++] = this.getSpecAlternate((String)instruction.value);
                    break;
                }
                case 16411: {
                    stack[sp++] = this.getSpecModel((String)instruction.value);
                    break;
                }
                case 294918: {
                    stack[sp++] = this.getProteinSet();
                    break;
                }
                case 294919: {
                    stack[sp++] = this.getNucleicSet();
                    break;
                }
                case 294920: {
                    stack[sp++] = this.getDnaSet();
                    break;
                }
                case 294921: {
                    stack[sp++] = this.getRnaSet();
                    break;
                }
                case 294922: {
                    stack[sp++] = this.getPurineSet();
                    break;
                }
                case 294923: {
                    stack[sp++] = this.getPyrimidineSet();
                    break;
                }
                case 1: 
                case 294912: 
                case 294917: 
                case 294924: 
                case 296964: 
                case 303360: 
                case 311299: {
                    stack[sp++] = this.lookupIdentifierValue((String)instruction.value);
                    break;
                }
                case 163840: 
                case 163841: 
                case 163842: 
                case 163843: 
                case 163844: 
                case 163845: {
                    int n = sp++;
                    BitSet bitSet = new BitSet();
                    stack[n] = bitSet;
                    BitSet bs = bitSet;
                    this.comparatorInstruction(instruction, bs);
                    break;
                }
                default: {
                    this.unrecognizedExpression();
                }
            }
            ++pc;
        }
        if (sp != 1) {
            this.evalError("atom expression compiler error - stack over/underflow");
        }
        return stack[0];
    }

    BitSet lookupIdentifierValue(String identifier) throws ScriptException {
        int seqcodeEnd;
        String potentialGroupName;
        BitSet bsName;
        int alphaLen;
        BitSet bsDefinedSet = this.lookupValue(identifier, false);
        if (bsDefinedSet != null) {
            return this.copyBitSet(bsDefinedSet);
        }
        int len = identifier.length();
        for (alphaLen = 0; alphaLen < len && Compiler.isAlphabetic(identifier.charAt(alphaLen)); ++alphaLen) {
        }
        if (alphaLen > 3) {
            this.undefinedVariable();
        }
        if ((bsName = this.lookupPotentialGroupName(potentialGroupName = identifier.substring(0, alphaLen))) == null) {
            this.undefinedVariable();
        }
        if (alphaLen == len) {
            return bsName;
        }
        for (seqcodeEnd = alphaLen; seqcodeEnd < len && Compiler.isDigit(identifier.charAt(seqcodeEnd)); ++seqcodeEnd) {
        }
        int seqNumber = 0;
        try {
            seqNumber = Integer.parseInt(identifier.substring(alphaLen, seqcodeEnd));
        }
        catch (NumberFormatException nfe) {
            this.evalError("identifier parser error #373");
        }
        char insertionCode = ' ';
        if (seqcodeEnd < len && identifier.charAt(seqcodeEnd) == '^') {
            if (++seqcodeEnd == len) {
                this.evalError("invalid insertion code");
            }
            insertionCode = identifier.charAt(seqcodeEnd++);
        }
        int seqcode = Group.getSeqcode(seqNumber, insertionCode);
        BitSet bsSequence = this.getSpecSeqcode(seqcode);
        BitSet bsNameSequence = bsName;
        bsNameSequence.and(bsSequence);
        if (seqcodeEnd == len) {
            return bsNameSequence;
        }
        char chainID = identifier.charAt(seqcodeEnd);
        if (++seqcodeEnd != len) {
            this.undefinedVariable();
        }
        BitSet bsChain = this.getSpecChain(chainID);
        BitSet bsNameSequenceChain = bsNameSequence;
        bsNameSequenceChain.and(bsChain);
        return bsNameSequenceChain;
    }

    BitSet lookupPotentialGroupName(String potentialGroupName) {
        BitSet bsResult = null;
        Frame frame = this.viewer.getFrame();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom = frame.getAtomAt(i);
            if (!atom.isGroup3(potentialGroupName)) continue;
            if (bsResult == null) {
                bsResult = new BitSet(i + 1);
            }
            bsResult.set(i);
        }
        return bsResult;
    }

    void notSet(BitSet bs) {
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (bs.get(i)) {
                bs.clear(i);
                continue;
            }
            bs.set(i);
        }
    }

    BitSet getHeteroSet() {
        Frame frame = this.viewer.getFrame();
        BitSet bsHetero = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!frame.getAtomAt(i).isHetero()) continue;
            bsHetero.set(i);
        }
        return bsHetero;
    }

    BitSet getHydrogenSet() {
        Frame frame = this.viewer.getFrame();
        BitSet bsHydrogen = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom = frame.getAtomAt(i);
            if (atom.getElementNumber() != 1) continue;
            bsHydrogen.set(i);
        }
        return bsHydrogen;
    }

    BitSet getProteinSet() {
        Frame frame = this.viewer.getFrame();
        BitSet bsProtein = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!frame.getAtomAt(i).isProtein()) continue;
            bsProtein.set(i);
        }
        return bsProtein;
    }

    BitSet getNucleicSet() {
        Frame frame = this.viewer.getFrame();
        BitSet bsNucleic = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!frame.getAtomAt(i).isNucleic()) continue;
            bsNucleic.set(i);
        }
        return bsNucleic;
    }

    BitSet getDnaSet() {
        Frame frame = this.viewer.getFrame();
        BitSet bsDna = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!frame.getAtomAt(i).isDna()) continue;
            bsDna.set(i);
        }
        return bsDna;
    }

    BitSet getRnaSet() {
        Frame frame = this.viewer.getFrame();
        BitSet bsRna = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!frame.getAtomAt(i).isRna()) continue;
            bsRna.set(i);
        }
        return bsRna;
    }

    BitSet getPurineSet() {
        Frame frame = this.viewer.getFrame();
        BitSet bsPurine = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!frame.getAtomAt(i).isPurine()) continue;
            bsPurine.set(i);
        }
        return bsPurine;
    }

    BitSet getPyrimidineSet() {
        Frame frame = this.viewer.getFrame();
        BitSet bsPyrimidine = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (!frame.getAtomAt(i).isPyrimidine()) continue;
            bsPyrimidine.set(i);
        }
        return bsPyrimidine;
    }

    BitSet getSpecName(String resNameSpec) {
        BitSet bsRes = new BitSet();
        Frame frame = this.viewer.getFrame();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom = frame.getAtomAt(i);
            if (!atom.isGroup3Match(resNameSpec)) continue;
            bsRes.set(i);
        }
        return bsRes;
    }

    BitSet getSpecResid(int resid) {
        BitSet bsRes = new BitSet();
        Frame frame = this.viewer.getFrame();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom = frame.getAtomAt(i);
            if (atom.getGroupID() != resid) continue;
            bsRes.set(i);
        }
        return bsRes;
    }

    BitSet getSpecSeqcode(int seqcode) {
        Frame frame = this.viewer.getFrame();
        BitSet bsResno = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom = frame.getAtomAt(i);
            if (seqcode != atom.getSeqcode()) continue;
            bsResno.set(i);
        }
        return bsResno;
    }

    BitSet getSpecSeqcodeRange(int seqcodeA, int seqcodeB) {
        Frame frame = this.viewer.getFrame();
        BitSet bsResidue = new BitSet();
        frame.selectSeqcodeRange(seqcodeA, seqcodeB, bsResidue);
        return bsResidue;
    }

    BitSet getSpecChain(char chain) {
        boolean caseSensitive = this.viewer.getChainCaseSensitive();
        if (!caseSensitive) {
            chain = Character.toUpperCase(chain);
        }
        Frame frame = this.viewer.getFrame();
        BitSet bsChain = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            char ch = frame.getAtomAt(i).getChainID();
            if (!caseSensitive) {
                ch = Character.toUpperCase(ch);
            }
            if (chain != ch) continue;
            bsChain.set(i);
        }
        return bsChain;
    }

    BitSet getSpecAtom(String atomSpec) {
        Frame frame = this.viewer.getFrame();
        BitSet bsAtom = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom = frame.getAtomAt(i);
            if (!atom.isAtomNameMatch(atomSpec)) continue;
            bsAtom.set(i);
        }
        return bsAtom;
    }

    BitSet getResidueWildcard(String strWildcard) {
        Frame frame = this.viewer.getFrame();
        BitSet bsResidue = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom = frame.getAtomAt(i);
            if (!atom.isGroup3Match(strWildcard)) continue;
            bsResidue.set(i);
        }
        return bsResidue;
    }

    BitSet lookupValue(String variable, boolean plurals) throws ScriptException {
        Object value = this.variables.get(variable);
        if (value != null) {
            if (value instanceof Token[]) {
                value = this.expression((Token[])value, 2);
                this.variables.put(variable, value);
            }
            return (BitSet)value;
        }
        if (plurals) {
            return null;
        }
        int len = variable.length();
        if (len < 5) {
            return null;
        }
        if (variable.charAt(len - 1) != 's') {
            return null;
        }
        variable = variable.endsWith("ies") ? variable.substring(0, len - 3) + 'y' : variable.substring(0, len - 1);
        return this.lookupValue(variable, true);
    }

    void selectModelIndexAtoms(int modelIndex, BitSet bsResult) {
        Frame frame = this.viewer.getFrame();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            if (frame.getAtomAt(i).getModelIndex() != modelIndex) continue;
            bsResult.set(i);
        }
    }

    BitSet getSpecAlternate(String alternateSpec) {
        System.out.println("getSpecAlternate(" + alternateSpec + ")");
        Frame frame = this.viewer.getFrame();
        BitSet bs = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom = frame.getAtomAt(i);
            if (!atom.isAlternateLocationMatch(alternateSpec)) continue;
            bs.set(i);
        }
        return bs;
    }

    BitSet getSpecModel(String modelTag) {
        int modelNumber = -1;
        try {
            modelNumber = Integer.parseInt(modelTag);
        }
        catch (NumberFormatException nfe) {
            // empty catch block
        }
        BitSet bsModel = new BitSet(this.viewer.getAtomCount());
        this.selectModelIndexAtoms(this.viewer.getModelNumberIndex(modelNumber), bsModel);
        return bsModel;
    }

    void comparatorInstruction(Token instruction, BitSet bs) throws ScriptException {
        int comparator = instruction.tok;
        int property = instruction.intValue;
        float propertyValue = 0.0f;
        int comparisonValue = (Integer)instruction.value;
        int numberOfAtoms = this.viewer.getAtomCount();
        Frame frame = this.viewer.getFrame();
        block23: for (int i = 0; i < numberOfAtoms; ++i) {
            Atom atom = frame.getAtomAt(i);
            switch (property) {
                case 98304: {
                    propertyValue = atom.getAtomNumber();
                    break;
                }
                case 98305: {
                    propertyValue = atom.getElementNumber();
                    break;
                }
                case 98308: {
                    propertyValue = atom.getBfactor100();
                    if (propertyValue < 0.0f) continue block23;
                    propertyValue /= 100.0f;
                    break;
                }
                case 98314: {
                    propertyValue = atom.getOccupancy();
                    break;
                }
                case 98315: {
                    propertyValue = atom.getPolymerLength();
                    break;
                }
                case 98306: {
                    propertyValue = atom.getResno();
                    if (propertyValue != -1.0f) break;
                    continue block23;
                }
                case 98311: {
                    propertyValue = atom.getGroupID();
                    if (!(propertyValue < 0.0f)) break;
                    continue block23;
                }
                case 98312: {
                    propertyValue = atom.getSpecialAtomID();
                    if (!(propertyValue < 0.0f)) break;
                    continue block23;
                }
                case 98313: {
                    propertyValue = this.getProteinStructureType(atom);
                    if (propertyValue != -1.0f) break;
                    continue block23;
                }
                case 100355: {
                    propertyValue = atom.getRasMolRadius();
                    break;
                }
                case 98310: {
                    propertyValue = atom.getCovalentBondCount();
                    break;
                }
                case 98316: {
                    propertyValue = atom.getHbondCount();
                    break;
                }
                case 102661: {
                    propertyValue = atom.getModelTagNumber();
                    break;
                }
                default: {
                    this.unrecognizedAtomProperty(property);
                }
            }
            boolean match = false;
            switch (comparator) {
                case 163843: {
                    match = propertyValue < (float)comparisonValue;
                    break;
                }
                case 163842: {
                    match = propertyValue <= (float)comparisonValue;
                    break;
                }
                case 163841: {
                    match = propertyValue >= (float)comparisonValue;
                    break;
                }
                case 163840: {
                    match = propertyValue > (float)comparisonValue;
                    break;
                }
                case 163844: {
                    match = propertyValue == (float)comparisonValue;
                    break;
                }
                case 163845: {
                    boolean bl = match = propertyValue != (float)comparisonValue;
                }
            }
            if (!match) continue;
            bs.set(i);
        }
    }

    void withinInstruction(Token instruction, BitSet bs, BitSet bsResult) throws ScriptException {
        Object withinSpec = instruction.value;
        if (withinSpec instanceof Float) {
            this.withinDistance(((Float)withinSpec).floatValue(), bs, bsResult);
            return;
        }
        if (withinSpec instanceof String) {
            String withinStr = (String)withinSpec;
            if (withinStr.equals("group")) {
                this.withinGroup(bs, bsResult);
                return;
            }
            if (withinStr.equals("chain")) {
                this.withinChain(bs, bsResult);
                return;
            }
            if (withinStr.equals("model")) {
                this.withinModel(bs, bsResult);
                return;
            }
        }
        this.evalError("Unrecognized within parameter:" + withinSpec);
    }

    void withinDistance(float distance, BitSet bs, BitSet bsResult) {
        Frame frame = this.viewer.getFrame();
        int i = frame.getAtomCount();
        while (--i >= 0) {
            if (!bs.get(i)) continue;
            Atom atom = frame.getAtomAt(i);
            AtomIterator iterWithin = frame.getWithinAnyModelIterator(atom, distance);
            while (iterWithin.hasNext()) {
                bsResult.set(iterWithin.next().getAtomIndex());
            }
        }
    }

    void withinGroup(BitSet bs, BitSet bsResult) {
        Frame frame = this.viewer.getFrame();
        Group groupLast = null;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom;
            Group group;
            if (!bs.get(i) || (group = (atom = frame.getAtomAt(i)).getGroup()) == groupLast) continue;
            group.selectAtoms(bsResult);
            groupLast = group;
        }
    }

    void withinChain(BitSet bs, BitSet bsResult) {
        Frame frame = this.viewer.getFrame();
        Chain chainLast = null;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            Atom atom;
            Chain chain;
            if (!bs.get(i) || (chain = (atom = frame.getAtomAt(i)).getChain()) == chainLast) continue;
            chain.selectAtoms(bsResult);
            chainLast = chain;
        }
    }

    void withinModel(BitSet bs, BitSet bsResult) {
        Frame frame = this.viewer.getFrame();
        int modelIndexLast = -1;
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            int modelIndex;
            if (!bs.get(i) || (modelIndex = frame.getAtomAt(i).getModelIndex()) == modelIndexLast) continue;
            this.selectModelIndexAtoms(modelIndex, bsResult);
            modelIndexLast = modelIndex;
        }
    }

    BitSet connected(Token instruction, BitSet bs) {
        int min = instruction.intValue;
        int max = (Integer)instruction.value;
        System.out.println("connected(" + min + "," + max + "," + bs + ")");
        Frame frame = this.viewer.getFrame();
        BitSet bsResult = new BitSet();
        int i = this.viewer.getAtomCount();
        while (--i >= 0) {
            int connectedCount = frame.getAtomAt(i).getConnectedCount(bs);
            if (connectedCount < min || connectedCount > max) continue;
            bsResult.set(i);
        }
        return bsResult;
    }

    BitSet getSubstructureSet(String smiles) throws ScriptException {
        PatternMatcher matcher = new PatternMatcher(this.viewer);
        try {
            return matcher.getSubstructureSet(smiles);
        }
        catch (InvalidSmilesException e) {
            this.evalError(e.getMessage());
            return null;
        }
    }

    int getProteinStructureType(Atom atom) {
        return atom.getProteinStructureType();
    }

    int getArgbParam(int itoken) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.colorExpected();
        }
        if (this.statement[itoken].tok != 540692) {
            this.colorExpected();
        }
        return this.statement[itoken].intValue;
    }

    int getArgbOrNoneParam(int itoken) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.colorExpected();
        }
        if (this.statement[itoken].tok == 540692) {
            return this.statement[itoken].intValue;
        }
        if (this.statement[itoken].tok != 49157) {
            this.colorExpected();
        }
        return 0;
    }

    void background() throws ScriptException {
        int tok;
        if (this.statementLength < 2 || this.statementLength > 3) {
            this.badArgumentCount();
        }
        if ((tok = this.statement[1].tok) == 540692 || tok == 49157) {
            this.viewer.setBackgroundArgb(this.getArgbOrNoneParam(1));
        } else {
            this.viewer.setShapePropertyArgb(this.getShapeType(tok), "bgcolor", this.getArgbOrNoneParam(2));
        }
    }

    void center() throws ScriptException {
        this.viewer.setCenterBitSet(this.statementLength == 1 ? null : this.expression(this.statement, 1));
    }

    void color() throws ScriptException {
        if (this.statementLength > 5 || this.statementLength < 2) {
            this.badArgumentCount();
        }
        int tok = this.statement[1].tok;
        block0 : switch (tok) {
            case 296: 
            case 2081: 
            case 2082: 
            case 16385: 
            case 16402: 
            case 16420: 
            case 16422: 
            case 16424: 
            case 16425: 
            case 36868: 
            case 36869: 
            case 49157: 
            case 98308: 
            case 294912: 
            case 540692: 
            case 2107683: {
                this.colorObject(4102, 1);
                break;
            }
            case 16421: {
                this.viewer.setRubberbandArgb(this.getArgbParam(2));
                break;
            }
            case 4718849: {
                this.viewer.setBackgroundArgb(this.getArgbOrNoneParam(2));
                break;
            }
            case 1: 
            case 296962: {
                String str = (String)this.statement[1].value;
                int argb = this.getArgbOrNoneParam(2);
                if (str.equalsIgnoreCase("dotsConvex")) {
                    this.viewer.setShapePropertyArgb(7, "colorConvex", argb);
                    return;
                }
                if (str.equalsIgnoreCase("dotsConcave")) {
                    this.viewer.setShapePropertyArgb(7, "colorConcave", argb);
                    return;
                }
                if (str.equalsIgnoreCase("dotsSaddle")) {
                    this.viewer.setShapePropertyArgb(7, "colorSaddle", argb);
                    return;
                }
                if (str.equalsIgnoreCase("selectionHalo")) {
                    this.viewer.setSelectionArgb(argb);
                    return;
                }
                int i = JmolConstants.elementNames.length;
                while (--i >= 0) {
                    if (!str.equalsIgnoreCase(JmolConstants.elementNames[i])) continue;
                    this.viewer.setElementArgb(i, this.getArgbParam(2));
                    return;
                }
                i = JmolConstants.alternateElementNames.length;
                while (--i >= 0) {
                    if (!str.equalsIgnoreCase(JmolConstants.alternateElementNames[i])) continue;
                    this.viewer.setElementArgb(JmolConstants.alternateElementNumbers[i], this.getArgbParam(2));
                    return;
                }
                this.invalidArgument();
            }
            default: {
                int i;
                if (tok == 10498) {
                    tok = 2052;
                }
                for (i = 0; i < shapeToks.length; ++i) {
                    if (tok != shapeToks[i]) continue;
                    this.colorObject(tok, 2);
                    break block0;
                }
                this.invalidArgument();
            }
        }
    }

    void colorObject(int tokObject, int itoken) throws ScriptException {
        if (itoken >= this.statementLength) {
            this.badArgumentCount();
        }
        String translucentOrOpaque = null;
        Object colorvalue = null;
        int shapeType = this.getShapeType(tokObject);
        String colorOrBgcolor = "color";
        int tok = this.statement[itoken].tok;
        if (tok == 4718849) {
            colorOrBgcolor = "bgcolor";
            tok = this.statement[++itoken].tok;
        }
        if (tok == 16425 || tok == 16424) {
            translucentOrOpaque = (String)this.statement[itoken].value;
            ++itoken;
        }
        if (itoken < this.statementLength) {
            colorvalue = this.statement[itoken].value;
            tok = this.statement[itoken].tok;
            switch (tok) {
                case 296: 
                case 2081: 
                case 2082: 
                case 16402: 
                case 16419: 
                case 16420: 
                case 36869: 
                case 49157: 
                case 98308: 
                case 294912: 
                case 2107683: {
                    break;
                }
                case 36868: {
                    this.viewer.calcSelectedGroupsCount();
                    break;
                }
                case 16422: {
                    this.viewer.calcSelectedMonomersCount();
                    break;
                }
                case 16385: {
                    this.notImplemented(itoken);
                    return;
                }
                case 540692: {
                    int argb = this.getArgbParam(itoken);
                    colorvalue = argb == 0 ? null : new Integer(argb);
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.loadShape(shapeType);
            this.viewer.setShapeProperty(shapeType, colorOrBgcolor, colorvalue);
        }
        if (translucentOrOpaque != null) {
            this.viewer.setShapeProperty(shapeType, "translucency", translucentOrOpaque);
        }
    }

    void define() throws ScriptException {
        String variable = (String)this.statement[1].value;
        this.variables.put(variable, this.expression(this.statement, 2));
    }

    void predefine(Token[] statement) {
        String variable = (String)statement[1].value;
        this.variables.put(variable, statement);
    }

    void echo() {
        String text = "";
        if (this.statementLength == 2 && this.statement[1].tok == 4) {
            text = (String)this.statement[1].value;
        }
        if (this.echoShapeActive) {
            this.viewer.setShapeProperty(20, "echo", text);
        }
        this.viewer.scriptEcho(text);
    }

    void label() {
        String strLabel = (String)this.statement[1].value;
        if (strLabel.equalsIgnoreCase("on")) {
            strLabel = this.viewer.getModelCount() > 1 ? "[%n]%r:%c.%a/%M" : (this.viewer.getChainCount() > 1 ? "[%n]%r:%c.%a" : (this.viewer.getGroupCount() <= 1 ? "%e%i" : "[%n]%r.%a"));
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.viewer.loadShape(4);
        this.viewer.setLabel(strLabel);
    }

    void hover() {
        String strLabel = (String)this.statement[1].value;
        if (strLabel.equalsIgnoreCase("on")) {
            strLabel = "%U";
        } else if (strLabel.equalsIgnoreCase("off")) {
            strLabel = null;
        }
        this.viewer.loadShape(21);
        this.viewer.setShapeProperty(21, "label", strLabel);
    }

    void load() throws ScriptException {
        int i = 1;
        if (this.statement[i].tok == 1) {
            ++i;
        }
        if (this.statement[i].tok != 4) {
            this.filenameExpected();
        }
        if (this.statementLength == i + 1) {
            String filename = (String)this.statement[i].value;
            this.viewer.openFile(filename);
        } else {
            String modelName = (String)this.statement[i].value;
            String[] filenames = new String[this.statementLength - ++i];
            while (i < this.statementLength) {
                filenames[filenames.length - this.statementLength + i] = (String)this.statement[i].value;
                ++i;
            }
            this.viewer.openFiles(modelName, filenames);
        }
        String errMsg = this.viewer.getOpenFileError();
        if (errMsg != null) {
            this.evalError(errMsg);
        }
    }

    void monitor() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.setShowMeasurements(true);
            return;
        }
        if (this.statementLength == 2) {
            if (this.statement[1].tok == 8193) {
                this.viewer.setShowMeasurements(true);
            } else if (this.statement[1].tok == 8192) {
                this.viewer.clearMeasurements();
            } else {
                this.booleanExpected();
            }
            return;
        }
        if (this.statementLength < 3 || this.statementLength > 5) {
            this.badArgumentCount();
        }
        for (int i = 1; i < this.statementLength; ++i) {
            if (this.statement[i].tok == 2) continue;
            this.integerExpected();
        }
        int argCount = this.monitorArgs[0] = this.statementLength - 1;
        for (int i = 0; i < argCount; ++i) {
            int atomNumber;
            int atomIndex;
            Token token = this.statement[i + 1];
            if (token.tok != 2) {
                this.integerExpected();
            }
            if ((atomIndex = this.viewer.getAtomIndexFromAtomNumber(atomNumber = token.intValue)) == -1) {
                this.badAtomNumber();
            }
            this.monitorArgs[i + 1] = atomIndex;
        }
        this.viewer.toggleMeasurement(this.monitorArgs);
    }

    void refresh() {
        this.viewer.requestRepaintAndWait();
    }

    void reset() {
        this.viewer.homePosition();
    }

    void restrict() throws ScriptException {
        this.select();
        this.viewer.invertSelection();
        boolean bondmode = this.viewer.getBondSelectionModeOr();
        this.viewer.setBondSelectionModeOr(true);
        this.viewer.setShapeSize(1, 0);
        int shapeType = 16;
        while (--shapeType >= 0) {
            this.viewer.setShapeSize(shapeType, 0);
        }
        this.viewer.setLabel(null);
        this.viewer.setBondSelectionModeOr(bondmode);
        this.viewer.invertSelection();
    }

    void rotate() throws ScriptException {
        if (this.statement.length > 3 && this.statement[1].tok == 4109) {
            this.checkStatementLength(6);
            this.viewer.rotateAxisAngle(this.floatParameter(2), this.floatParameter(3), this.floatParameter(4), this.floatParameter(5));
            return;
        }
        this.checkLength3();
        float degrees = this.floatParameter(2);
        switch (this.statement[1].tok) {
            case 49154: {
                this.viewer.rotateXDegrees(degrees);
                break;
            }
            case 311299: {
                this.viewer.rotateYDegrees(degrees);
                break;
            }
            case 49156: {
                this.viewer.rotateZDegreesScript(degrees);
                break;
            }
            default: {
                this.axisExpected();
            }
        }
    }

    void pushContext() throws ScriptException {
        if (this.scriptLevel == 10) {
            this.evalError("too many script levels");
        }
        Context context = new Context();
        context.filename = this.filename;
        context.script = this.script;
        context.linenumbers = this.linenumbers;
        context.lineIndices = this.lineIndices;
        context.aatoken = this.aatoken;
        context.pc = this.pc;
        this.stack[this.scriptLevel++] = context;
    }

    void popContext() throws ScriptException {
        if (this.scriptLevel == 0) {
            this.evalError("RasMol virtual machine error - stack underflow");
        }
        Context context = this.stack[--this.scriptLevel];
        this.stack[this.scriptLevel] = null;
        this.filename = context.filename;
        this.script = context.script;
        this.linenumbers = context.linenumbers;
        this.lineIndices = context.lineIndices;
        this.aatoken = context.aatoken;
        this.pc = context.pc;
    }

    void script() throws ScriptException {
        this.pushContext();
        String filename = (String)this.statement[1].value;
        if (!this.loadScriptFileInternal(filename)) {
            this.errorLoadingScript(this.errorMessage);
        }
        this.instructionDispatchLoop();
        this.popContext();
    }

    void select() throws ScriptException {
        if (this.statementLength == 1) {
            this.viewer.selectAll();
            if (!this.viewer.getRasmolHydrogenSetting()) {
                this.viewer.excludeSelectionSet(this.getHydrogenSet());
            }
            if (!this.viewer.getRasmolHeteroSetting()) {
                this.viewer.excludeSelectionSet(this.getHeteroSet());
            }
        } else {
            this.viewer.setSelectionSet(this.expression(this.statement, 1));
        }
        this.viewer.scriptStatus("" + this.viewer.getSelectionCount() + " atoms selected");
    }

    void translate() throws ScriptException {
        int percent;
        if (this.statementLength < 3) {
            this.badArgumentCount();
        }
        if (this.statement[2].tok != 2) {
            this.integerExpected();
        }
        if ((percent = this.statement[2].intValue) > 100 || percent < -100) {
            this.numberOutOfRange(-100, 100);
        }
        switch (this.statement[1].tok) {
            case 49154: {
                this.viewer.translateToXPercent(percent);
                break;
            }
            case 311299: {
                this.viewer.translateToYPercent(percent);
                break;
            }
            case 49156: {
                this.viewer.translateToZPercent(percent);
                break;
            }
            default: {
                this.axisExpected();
            }
        }
    }

    void zap() {
        this.viewer.clear();
    }

    void zoom() throws ScriptException {
        if (this.statement[1].tok == 2) {
            int percent = this.statement[1].intValue;
            if (percent < 5 || percent > 20000) {
                this.numberOutOfRange(5, 20000);
            }
            this.viewer.zoomToPercent(percent);
            return;
        }
        switch (this.statement[1].tok) {
            case 8193: {
                this.viewer.setZoomEnabled(true);
                break;
            }
            case 8192: {
                this.viewer.setZoomEnabled(false);
                break;
            }
            default: {
                this.booleanOrPercentExpected();
            }
        }
    }

    void delay() throws ScriptException {
        long timeBegin = System.currentTimeMillis();
        long millis = 0L;
        Token token = this.statement[1];
        switch (token.tok) {
            case 2: 
            case 8193: {
                millis = token.intValue * 1000;
                break;
            }
            case 3: {
                millis = (long)(((Float)token.value).floatValue() * 1000.0f);
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        this.viewer.requestRepaintAndWait();
        if ((millis -= System.currentTimeMillis() - timeBegin) > 0L) {
            this.viewer.popHoldRepaint();
            try {
                Thread.sleep(millis);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
            this.viewer.pushHoldRepaint();
        }
    }

    void move() throws ScriptException {
        if (this.statementLength < 10 || this.statementLength > 12) {
            this.badArgumentCount();
        }
        float dRotX = this.floatParameter(1);
        float dRotY = this.floatParameter(2);
        float dRotZ = this.floatParameter(3);
        int dZoom = this.intParameter(4);
        int dTransX = this.intParameter(5);
        int dTransY = this.intParameter(6);
        int dTransZ = this.intParameter(7);
        int dSlab = this.intParameter(8);
        float floatSecondsTotal = this.floatParameter(9);
        int fps = 30;
        if (this.statementLength > 10) {
            fps = this.statement[10].intValue;
            if (this.statementLength > 11) {
                // empty if block
            }
        }
        int zoom = this.viewer.getZoomPercent();
        int slab = this.viewer.getSlabPercentSetting();
        float transX = this.viewer.getTranslationXPercent();
        float transY = this.viewer.getTranslationYPercent();
        float transZ = this.viewer.getTranslationZPercent();
        long timeBegin = System.currentTimeMillis();
        int timePerStep = 1000 / fps;
        int totalSteps = (int)((float)fps * floatSecondsTotal);
        float radiansPerDegreePerStep = (float)Math.PI / 180 / (float)totalSteps;
        float radiansXStep = radiansPerDegreePerStep * dRotX;
        float radiansYStep = radiansPerDegreePerStep * dRotY;
        float radiansZStep = radiansPerDegreePerStep * dRotZ;
        this.viewer.setInMotion(true);
        if (totalSteps == 0) {
            totalSteps = 1;
        }
        for (int i = 1; i <= totalSteps && !this.interruptExecution; ++i) {
            int timeAllowed;
            int timeSpent;
            if (dRotX != 0.0f) {
                this.viewer.rotateXRadians(radiansXStep);
            }
            if (dRotY != 0.0f) {
                this.viewer.rotateYRadians(radiansYStep);
            }
            if (dRotZ != 0.0f) {
                this.viewer.rotateZRadians(radiansZStep);
            }
            if (dZoom != 0) {
                this.viewer.zoomToPercent(zoom + dZoom * i / totalSteps);
            }
            if (dTransX != 0) {
                this.viewer.translateToXPercent(transX + (float)(dTransX * i / totalSteps));
            }
            if (dTransY != 0) {
                this.viewer.translateToYPercent(transY + (float)(dTransY * i / totalSteps));
            }
            if (dTransZ != 0) {
                this.viewer.translateToZPercent(transZ + (float)(dTransZ * i / totalSteps));
            }
            if (dSlab != 0) {
                this.viewer.slabToPercent(slab + dSlab * i / totalSteps);
            }
            if ((timeSpent = (int)(System.currentTimeMillis() - timeBegin)) >= (timeAllowed = i * timePerStep)) continue;
            this.viewer.requestRepaintAndWait();
            timeSpent = (int)(System.currentTimeMillis() - timeBegin);
            int timeToSleep = timeAllowed - timeSpent;
            if (timeToSleep <= 0) continue;
            try {
                Thread.sleep(timeToSleep);
                continue;
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.viewer.setInMotion(false);
    }

    void slab() throws ScriptException {
        if (this.statement[1].tok == 2) {
            int percent = this.statement[1].intValue;
            if (percent < 0 || percent > 100) {
                this.numberOutOfRange(0, 100);
            }
            this.viewer.slabToPercent(percent);
            return;
        }
        switch (this.statement[1].tok) {
            case 8193: {
                this.viewer.setSlabEnabled(true);
                break;
            }
            case 8192: {
                this.viewer.setSlabEnabled(false);
                break;
            }
            default: {
                this.booleanOrPercentExpected();
            }
        }
    }

    void depth() throws ScriptException {
        this.viewer.depthToPercent(this.intParameter(1));
    }

    void star() throws ScriptException {
        int mad = 0;
        int tok = 8193;
        if (this.statementLength > 1) {
            tok = this.statement[1].tok;
            if (this.statementLength != 2 && (this.statementLength != 3 || tok != 2 || this.statement[2].tok != 49181)) {
                this.badArgumentCount();
            }
        }
        switch (tok) {
            case 8193: 
            case 16438: {
                mad = -100;
                break;
            }
            case 8192: {
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (this.statementLength == 2) {
                    if (radiusRasMol >= 750 || radiusRasMol < -100) {
                        this.numberOutOfRange(-100, 749);
                    }
                    mad = (short)radiusRasMol;
                    if (radiusRasMol <= 0) break;
                    mad = (short)(mad * 8);
                    break;
                }
                if (radiusRasMol < 0 || radiusRasMol > 100) {
                    this.numberOutOfRange(0, 100);
                }
                mad = (short)(-radiusRasMol);
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(1);
                if (angstroms < 0.0f || angstroms > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 98308: {
                mad = -1000;
                break;
            }
            case 16439: {
                mad = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(15, mad);
    }

    void cpk() throws ScriptException {
        int mad = 0;
        int tok = 8193;
        if (this.statementLength > 1) {
            tok = this.statement[1].tok;
            if (this.statementLength != 2 && (this.statementLength != 3 || tok != 2 || this.statement[2].tok != 49181)) {
                this.badArgumentCount();
            }
        }
        switch (tok) {
            case 8193: 
            case 16438: {
                mad = -100;
                break;
            }
            case 8192: {
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (this.statementLength == 2) {
                    if (radiusRasMol >= 750 || radiusRasMol < -200) {
                        this.numberOutOfRange(-200, 749);
                    }
                    mad = (short)radiusRasMol;
                    if (radiusRasMol <= 0) break;
                    mad = (short)(mad * 8);
                    break;
                }
                if (radiusRasMol < 0 || radiusRasMol > 200) {
                    this.numberOutOfRange(0, 200);
                }
                mad = (short)(-radiusRasMol);
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(1);
                if (angstroms < 0.0f || angstroms > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            case 98308: {
                mad = -1000;
                break;
            }
            case 16439: {
                mad = -1001;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(0, mad);
    }

    short getMadParameter() throws ScriptException {
        int tok = this.statement[1].tok;
        short mad = 1;
        switch (tok) {
            case 8193: {
                break;
            }
            case 8192: {
                mad = 0;
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (radiusRasMol < 0 || radiusRasMol > 750) {
                    this.numberOutOfRange(0, 750);
                }
                mad = (short)(radiusRasMol * 4 * 2);
                break;
            }
            case 3: {
                float angstroms = this.floatParameter(1);
                if (angstroms < 0.0f || angstroms > 3.0f) {
                    this.numberOutOfRange(0.0f, 3.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        return mad;
    }

    void wireframe() throws ScriptException {
        this.viewer.setShapeSize(1, this.getMadParameter());
    }

    void ssbond() throws ScriptException {
        this.viewer.loadShape(3);
        this.viewer.setShapeSize(3, this.getMadParameter());
    }

    void hbond() throws ScriptException {
        this.viewer.loadShape(2);
        if (this.statementLength == 2 && this.statement[1].tok == 1 && ((String)this.statement[1].value).equalsIgnoreCase("calculate")) {
            BitSet bs = this.viewer.getSelectionSet();
            this.viewer.getFrame().autoHbond(bs, bs);
            return;
        }
        this.viewer.setShapeSize(2, this.getMadParameter());
    }

    void vector() throws ScriptException {
        int mad = 1;
        if (this.statementLength > 1) {
            switch (this.statement[1].tok) {
                case 8193: {
                    break;
                }
                case 8192: {
                    mad = 0;
                    break;
                }
                case 2: {
                    int diameterPixels = this.statement[1].intValue;
                    if (diameterPixels < 0 || diameterPixels >= 20) {
                        this.numberOutOfRange(0, 19);
                    }
                    mad = (short)diameterPixels;
                    break;
                }
                case 3: {
                    float angstroms = this.floatParameter(1);
                    if (angstroms < 0.0f || angstroms > 3.0f) {
                        this.numberOutOfRange(0.0f, 3.0f);
                    }
                    mad = (short)(angstroms * 1000.0f * 2.0f);
                    break;
                }
                case 1: {
                    String cmd = (String)this.statement[1].value;
                    if (!cmd.equalsIgnoreCase("scale")) {
                        this.unrecognizedSubcommand();
                    }
                    this.vectorScale();
                    return;
                }
                default: {
                    this.booleanOrNumberExpected();
                }
            }
            this.checkLength2();
        }
        this.viewer.setShapeSize(5, mad);
    }

    void vectorScale() throws ScriptException {
        this.checkLength3();
        float scale = this.floatParameter(2);
        if (scale < -10.0f || scale > 10.0f) {
            this.numberOutOfRange(-10.0f, 10.0f);
        }
        this.viewer.setVectorScale(scale);
    }

    void animation() throws ScriptException {
        if (this.statementLength < 2) {
            this.subcommandExpected();
        }
        int tok = this.statement[1].tok;
        boolean animate = false;
        switch (tok) {
            case 8193: {
                animate = true;
            }
            case 8192: {
                this.viewer.setAnimationOn(animate);
                break;
            }
            case 4096: {
                this.showAnimation();
                break;
            }
            case 324: {
                this.frame(2);
                break;
            }
            case 16415: {
                this.animationMode();
                break;
            }
            case 16416: {
                this.animationDirection();
                break;
            }
            case 16417: {
                this.viewer.setAnimationFps(this.getSetInteger());
                break;
            }
            default: {
                this.unrecognizedSubcommand();
            }
        }
    }

    void animationMode() throws ScriptException {
        float startDelay = 1.0f;
        float endDelay = 1.0f;
        if (this.statementLength < 3 || this.statementLength > 5) {
            this.badArgumentCount();
        }
        int animationMode = 0;
        switch (this.statement[2].tok) {
            case 317: {
                ++animationMode;
                break;
            }
            case 1: {
                String cmd = (String)this.statement[2].value;
                if (cmd.equalsIgnoreCase("once")) {
                    endDelay = 0.0f;
                    startDelay = 0.0f;
                    break;
                }
                if (cmd.equalsIgnoreCase("palindrome")) {
                    animationMode = 2;
                    break;
                }
                this.unrecognizedSubcommand();
            }
        }
        if (this.statementLength >= 4) {
            startDelay = endDelay = this.floatParameter(3);
            if (this.statementLength == 5) {
                endDelay = this.floatParameter(4);
            }
        }
        this.viewer.setAnimationReplayMode(animationMode, startDelay, endDelay);
    }

    void vibration() throws ScriptException {
        if (this.statementLength < 2) {
            this.subcommandExpected();
        }
        Token token = this.statement[1];
        float period = 0.0f;
        switch (token.tok) {
            case 2: 
            case 8192: 
            case 8193: {
                period = token.intValue;
                break;
            }
            case 3: {
                period = this.floatParameter(1);
                break;
            }
            case 1: {
                String cmd = (String)this.statement[1].value;
                if (cmd.equalsIgnoreCase("scale")) {
                    this.vibrationScale();
                    return;
                }
            }
            default: {
                this.unrecognizedSubcommand();
            }
        }
        this.viewer.setVibrationPeriod(period);
    }

    void vibrationScale() throws ScriptException {
        this.checkLength3();
        float scale = this.floatParameter(2);
        if (scale < -10.0f || scale > 10.0f) {
            this.numberOutOfRange(-10.0f, 10.0f);
        }
        this.viewer.setVibrationScale(scale);
    }

    void animationDirection() throws ScriptException {
        int direction;
        this.checkStatementLength(4);
        boolean negative = false;
        if (this.statement[2].tok == 32770) {
            negative = true;
        } else if (this.statement[2].tok != 32775) {
            this.invalidArgument();
        }
        if (this.statement[3].tok != 2) {
            this.invalidArgument();
        }
        if ((direction = this.statement[3].intValue) != 1) {
            this.numberMustBe(1, -1);
        }
        if (negative) {
            direction = -direction;
        }
        this.viewer.setAnimationDirection(direction);
    }

    void dots() throws ScriptException {
        int mad = 0;
        switch (this.statement[1].tok) {
            case 8193: 
            case 16438: {
                mad = 1;
                break;
            }
            case 16439: {
                mad = -1;
                break;
            }
            case 8192: {
                break;
            }
            case 2: {
                int dotsParam = this.statement[1].intValue;
                if (dotsParam < 0 || dotsParam > 1000) {
                    this.numberOutOfRange(0, 1000);
                }
                mad = (short)dotsParam;
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(7, mad);
    }

    void proteinShape(int shapeType) throws ScriptException {
        int mad = 0;
        int tok = this.statement[1].tok;
        switch (tok) {
            case 8193: {
                mad = -1;
                break;
            }
            case 8192: {
                break;
            }
            case 296: {
                mad = -2;
                break;
            }
            case 16418: 
            case 98308: {
                mad = -4;
                break;
            }
            case 2: {
                int radiusRasMol = this.statement[1].intValue;
                if (radiusRasMol < 0 || radiusRasMol >= 500) {
                    this.numberOutOfRange(0, 499);
                }
                mad = (short)(radiusRasMol * 4 * 2);
                break;
            }
            case 3: {
                float angstroms = ((Float)this.statement[1].value).floatValue();
                if (angstroms < 0.0f || angstroms > 4.0f) {
                    this.numberOutOfRange(0.0f, 4.0f);
                }
                mad = (short)(angstroms * 1000.0f * 2.0f);
                break;
            }
            default: {
                this.booleanOrNumberExpected();
            }
        }
        this.viewer.setShapeSize(shapeType, mad);
    }

    void spin() throws ScriptException {
        boolean spinOn = false;
        switch (this.statement[1].tok) {
            case 8193: {
                spinOn = true;
            }
            case 8192: {
                break;
            }
            default: {
                this.booleanExpected();
            }
        }
        this.viewer.setSpinOn(spinOn);
    }

    void frame() throws ScriptException {
        this.frame(1);
    }

    void frame(int offset) throws ScriptException {
        if (this.statementLength <= offset) {
            this.badArgumentCount();
        }
        if (this.statement[offset].tok == 32770) {
            this.checkStatementLength(++offset + 1);
            if (this.statement[offset].tok != 2 || this.statement[offset].intValue != 1) {
                this.invalidArgument();
            }
            this.viewer.setAnimationPrevious();
            return;
        }
        if (this.statementLength != offset + 1) {
            this.badArgumentCount();
        }
        int modelNumber = -1;
        switch (this.statement[offset].tok) {
            case 32777: 
            case 36875: {
                break;
            }
            case 49157: {
                break;
            }
            case 2: {
                modelNumber = this.statement[offset].intValue;
                break;
            }
            case 1: {
                String ident = (String)this.statement[offset].value;
                if (ident.equalsIgnoreCase("next")) {
                    this.viewer.setAnimationNext();
                    return;
                }
                if (ident.equalsIgnoreCase("prev")) {
                    this.viewer.setAnimationPrevious();
                    return;
                }
                if (!ident.equalsIgnoreCase("play")) break;
                this.viewer.setAnimationOn(true, this.viewer.getDisplayModelIndex());
                return;
            }
            default: {
                this.invalidArgument();
            }
        }
        int modelIndex = this.viewer.getModelNumberIndex(modelNumber);
        this.viewer.setDisplayModelIndex(modelIndex);
    }

    int getShapeType(int tok) throws ScriptException {
        int i = shapeToks.length;
        while (--i >= 0) {
            if (tok != shapeToks[i]) continue;
            return i;
        }
        this.unrecognizedColorObject();
        return -1;
    }

    void font() throws ScriptException {
        int shapeType = 0;
        int fontsize = 0;
        String fontface = "SansSerif";
        String fontstyle = "Plain";
        switch (this.statementLength) {
            case 5: {
                if (this.statement[4].tok != 1) {
                    this.keywordExpected();
                }
                fontstyle = (String)this.statement[4].value;
            }
            case 4: {
                if (this.statement[3].tok != 1) {
                    this.keywordExpected();
                }
                fontface = (String)this.statement[3].value;
            }
            case 3: {
                if (this.statement[2].tok != 2) {
                    this.integerExpected();
                }
                fontsize = this.statement[2].intValue;
                shapeType = this.getShapeType(this.statement[1].tok);
                break;
            }
            default: {
                this.badArgumentCount();
            }
        }
        Font3D font3d = this.viewer.getFont3D(fontface, fontstyle, fontsize);
        this.viewer.setShapeProperty(shapeType, "font", font3d);
    }

    void set() throws ScriptException {
        switch (this.statement[1].tok) {
            case 2049: {
                this.setAxes();
                break;
            }
            case 2051: {
                this.setBondmode();
                break;
            }
            case 2052: {
                this.setBonds();
                break;
            }
            case 6149: {
                this.setBoundbox();
                break;
            }
            case 526598: {
                System.out.println("WARNING! use 'set defaultColors' not 'set color'");
            }
            case 18471: {
                this.setDefaultColors();
                break;
            }
            case 2075: {
                this.setDebugScript();
                break;
            }
            case 2055: {
                this.setDisplay();
                break;
            }
            case 1050891: {
                this.setEcho();
                break;
            }
            case 2056: {
                this.setFontsize();
                break;
            }
            case 2080: {
                this.setFrank();
                break;
            }
            case 296961: {
                this.setHetero();
                break;
            }
            case 296962: {
                this.setHydrogen();
                break;
            }
            case 2079: {
                this.setLabelOffset();
                break;
            }
            case 10514: {
                this.setMonitor();
                break;
            }
            case 2077: {
                this.setProperty();
                break;
            }
            case 296964: {
                this.setSolvent();
                break;
            }
            case 100355: {
                this.setRadius();
                break;
            }
            case 10535: {
                this.setStrands();
                break;
            }
            case 2065: {
                this.setSpecular();
                break;
            }
            case 2066: {
                this.setSpecPower();
                break;
            }
            case 2048: {
                this.setAmbient();
                break;
            }
            case 2078: {
                this.setDiffuse();
                break;
            }
            case 14656: {
                this.setSpin();
                break;
            }
            case 10532: {
                this.setSsbond();
                break;
            }
            case 10509: {
                this.setHbond();
                break;
            }
            case 2076: {
                this.setScale3d();
                break;
            }
            case 2068: {
                this.setUnitcell();
                break;
            }
            case 2062: {
                this.setPicking();
                break;
            }
            case 2050: 
            case 2058: 
            case 2059: 
            case 2060: 
            case 2061: 
            case 2063: 
            case 2064: 
            case 2067: 
            case 2069: 
            case 2081: 
            case 2307: 
            case 2349: {
                this.notImplemented(1);
                break;
            }
            case 1: {
                this.viewer.setBooleanProperty((String)this.statement[1].value, this.getSetBoolean());
                break;
            }
            case 4718849: 
            case 6299942: {
                this.setspecialShouldNotBeHere();
            }
            default: {
                this.unrecognizedSetParameter();
            }
        }
    }

    void setAxes() throws ScriptException {
        this.viewer.setShapeSize(16, this.getSetAxesTypeMad());
    }

    void setBoundbox() throws ScriptException {
        this.viewer.setShapeSize(17, this.getSetAxesTypeMad());
    }

    void setUnitcell() throws ScriptException {
        this.viewer.setShapeSize(18, this.getSetAxesTypeMad());
    }

    void setFrank() throws ScriptException {
        this.viewer.setShapeSize(19, this.getSetAxesTypeMad());
    }

    void setDefaultColors() throws ScriptException {
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 16392: 
            case 16430: {
                this.viewer.setDefaultColors((String)this.statement[2].value);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    void setBondmode() throws ScriptException {
        this.checkLength3();
        boolean bondmodeOr = false;
        switch (this.statement[2].tok) {
            case 32771: {
                break;
            }
            case 32772: {
                bondmodeOr = true;
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.viewer.setBondSelectionModeOr(bondmodeOr);
    }

    void setBonds() throws ScriptException {
        this.viewer.setShowMultipleBonds(this.getSetBoolean());
    }

    void setDisplay() throws ScriptException {
        boolean showHalo = false;
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 299011: {
                showHalo = true;
            }
            case 16391: {
                this.viewer.setSelectionHaloEnabled(showHalo);
                break;
            }
            default: {
                this.keywordExpected();
            }
        }
    }

    void setEcho() throws ScriptException {
        String propertyName = "target";
        String propertyValue = null;
        this.checkLength34();
        this.echoShapeActive = true;
        switch (this.statement[2].tok) {
            case 8192: {
                this.echoShapeActive = false;
                propertyName = "off";
                break;
            }
            case 49157: {
                this.echoShapeActive = false;
            }
            case 1: {
                propertyValue = (String)this.statement[2].value;
                break;
            }
            default: {
                this.keywordExpected();
            }
        }
        this.viewer.loadShape(20);
        this.viewer.setShapeProperty(20, propertyName, propertyValue);
        if (this.statementLength == 4) {
            int tok = this.statement[3].tok;
            if (tok != 1 && tok != 4868) {
                this.keywordExpected();
            }
            this.viewer.setShapeProperty(20, "align", (String)this.statement[3].value);
        }
    }

    void setFontsize() throws ScriptException {
        int rasmolSize = 8;
        if (this.statementLength == 3) {
            rasmolSize = this.getSetInteger();
            if ((rasmolSize += 5) < 6 || rasmolSize > 63) {
                this.numberOutOfRange(6, 6);
            }
        }
        this.viewer.loadShape(4);
        this.viewer.setShapeProperty(4, "fontsize", new Integer(rasmolSize));
    }

    void setLabelOffset() throws ScriptException {
        this.checkLength4();
        int xOffset = this.intParameter(2);
        int yOffset = this.intParameter(3);
        int offset = (xOffset & 0xFF) << 8 | yOffset & 0xFF;
        this.viewer.loadShape(4);
        this.viewer.setShapeProperty(4, "offset", new Integer(offset));
    }

    void setHetero() throws ScriptException {
        this.viewer.setRasmolHeteroSetting(this.getSetBoolean());
    }

    void setHydrogen() throws ScriptException {
        this.viewer.setRasmolHydrogenSetting(this.getSetBoolean());
    }

    void setMonitor() throws ScriptException {
        boolean showMeasurementNumbers = false;
        this.checkLength3();
        switch (this.statement[2].tok) {
            case 8193: {
                showMeasurementNumbers = true;
            }
            case 8192: {
                this.viewer.setShapeProperty(6, "showMeasurementNumbers", showMeasurementNumbers ? Boolean.TRUE : Boolean.FALSE);
                return;
            }
            case 1: {
                if (!this.viewer.setMeasureDistanceUnits((String)this.statement[2].value)) {
                    this.unrecognizedSetParameter();
                }
                return;
            }
        }
        this.viewer.setShapeSize(6, this.getSetAxesTypeMad());
    }

    void setDebugScript() throws ScriptException {
        this.viewer.setDebugScript(this.getSetBoolean());
    }

    void setProperty() throws ScriptException {
        this.checkLength4();
        if (this.statement[2].tok != 1) {
            this.propertyNameExpected();
        }
        String propertyName = (String)this.statement[2].value;
        switch (this.statement[3].tok) {
            case 8193: {
                this.viewer.setBooleanProperty(propertyName, true);
                break;
            }
            case 8192: {
                this.viewer.setBooleanProperty(propertyName, false);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.notImplemented(3);
            }
            default: {
                this.unrecognizedSetParameter();
            }
        }
    }

    void setSolvent() throws ScriptException {
        this.viewer.setSolventOn(this.getSetBoolean());
    }

    void setRadius() throws ScriptException {
        this.viewer.setSolventProbeRadius(this.getSetAngstroms());
    }

    void setStrands() throws ScriptException {
        int strandCount = 5;
        if (this.statementLength == 3) {
            if (this.statement[2].tok != 2) {
                this.integerExpected();
            }
            if ((strandCount = this.statement[2].intValue) < 0 || strandCount > 20) {
                this.numberOutOfRange(0, 20);
            }
        }
        this.viewer.setShapeProperty(11, "strandCount", new Integer(strandCount));
    }

    void setSpecular() throws ScriptException {
        this.checkLength3();
        if (this.statement[2].tok == 2) {
            this.viewer.setSpecularPercent(this.getSetInteger());
        } else {
            this.viewer.setSpecular(this.getSetBoolean());
        }
    }

    void setSpecPower() throws ScriptException {
        this.viewer.setSpecularPower(this.getSetInteger());
    }

    void setAmbient() throws ScriptException {
        this.viewer.setAmbientPercent(this.getSetInteger());
    }

    void setDiffuse() throws ScriptException {
        this.viewer.setDiffusePercent(this.getSetInteger());
    }

    void setSpin() throws ScriptException {
        this.checkLength4();
        int value = this.intParameter(3);
        switch (this.statement[2].tok) {
            case 49154: {
                this.viewer.setSpinX(value);
                break;
            }
            case 311299: {
                this.viewer.setSpinY(value);
                break;
            }
            case 49156: {
                this.viewer.setSpinZ(value);
                break;
            }
            case 16417: {
                this.viewer.setSpinFps(value);
                break;
            }
            default: {
                this.unrecognizedSetParameter();
            }
        }
    }

    void setSsbond() throws ScriptException {
        this.checkLength3();
        boolean ssbondsBackbone = false;
        this.viewer.loadShape(3);
        switch (this.statement[2].tok) {
            case 303360: {
                ssbondsBackbone = true;
                break;
            }
            case 294917: {
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
        this.viewer.setSsbondsBackbone(ssbondsBackbone);
    }

    void setHbond() throws ScriptException {
        this.checkLength3();
        boolean bool = false;
        switch (this.statement[2].tok) {
            case 303360: {
                bool = true;
            }
            case 294917: {
                this.viewer.setHbondsBackbone(bool);
                break;
            }
            case 16429: {
                bool = true;
            }
            case 16414: {
                this.viewer.setHbondsSolid(bool);
                break;
            }
            default: {
                this.invalidArgument();
            }
        }
    }

    void setScale3d() throws ScriptException {
        this.checkLength3();
        float angstromsPerInch = 0.0f;
        switch (this.statement[2].tok) {
            case 3: {
                angstromsPerInch = ((Float)this.statement[2].value).floatValue();
                break;
            }
            case 2: {
                angstromsPerInch = this.statement[2].intValue;
                break;
            }
            default: {
                this.numberExpected();
            }
        }
        this.viewer.setScaleAngstromsPerInch(angstromsPerInch);
    }

    void setPicking() throws ScriptException {
        int pickingMode = 1;
        if (this.statementLength >= 3) {
            block0 : switch (this.statement[2].tok) {
                case 8192: 
                case 49157: {
                    pickingMode = 0;
                }
                case 8193: {
                    break;
                }
                case 16395: {
                    pickingMode = 1;
                    break;
                }
                case 16396: {
                    pickingMode = 2;
                    break;
                }
                case 10514: {
                    pickingMode = 3;
                    break;
                }
                case 16397: {
                    pickingMode = 4;
                    break;
                }
                case 16398: {
                    pickingMode = 5;
                    break;
                }
                case 0x10010F: {
                    pickingMode = 6;
                    break;
                }
                case 4868: {
                    pickingMode = 7;
                    break;
                }
                case 16399: {
                    pickingMode = 8;
                    break;
                }
                case 10498: {
                    pickingMode = 9;
                    break;
                }
                case 4102: {
                    pickingMode = 10;
                    break;
                }
                case 36868: {
                    pickingMode = 11;
                    break;
                }
                case 36869: {
                    pickingMode = 12;
                    break;
                }
                case 798: {
                    pickingMode = 10;
                    if (this.statementLength != 4) break;
                    switch (this.statement[3].tok) {
                        case 36869: {
                            pickingMode = 12;
                        }
                        case 4102: {
                            break block0;
                        }
                        case 36868: {
                            pickingMode = 11;
                            break block0;
                        }
                    }
                    this.invalidArgument();
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
        }
        this.viewer.setPickingMode(pickingMode);
    }

    void show() throws ScriptException {
        switch (this.statement[1].tok) {
            case 36876: {
                this.showPdbHeader();
                break;
            }
            case 102661: {
                this.showModel();
                break;
            }
            case 323: {
                this.showAnimation();
                break;
            }
            case 4111: {
                this.showOrientation();
                break;
            }
            case 4110: {
                this.showTransform();
                break;
            }
            case 4868: {
                this.showCenter();
                break;
            }
            case 4112: {
                this.showFile();
                break;
            }
            case 6149: {
                this.showBoundbox();
                break;
            }
            case 12591: {
                this.showZoom();
                break;
            }
            case 4096: 
            case 4097: 
            case 4098: 
            case 4099: 
            case 4102: 
            case 4103: 
            case 4104: 
            case 4105: 
            case 4106: 
            case 4417: 
            case 6169: 
            case 14656: 
            case 36868: 
            case 36869: 
            case 36875: 
            case 299011: {
                this.notImplemented(1);
                break;
            }
            default: {
                this.evalError("unrecognized SHOW parameter");
            }
        }
    }

    void showString(String str) {
        System.out.println("show:" + str);
        this.viewer.scriptStatus(str);
    }

    void showPdbHeader() {
        if ("pdb" != this.viewer.getModelSetTypeName()) {
            this.showString("!Not a pdb file!");
            return;
        }
        String modelFile = this.viewer.getCurrentFileAsString();
        int ichMin = modelFile.length();
        int i = pdbRecords.length;
        while (--i >= 0) {
            int ichFound = -1;
            String strRecord = pdbRecords[i];
            if (modelFile.startsWith(strRecord)) {
                ichFound = 0;
            } else {
                String strSearch = "\n" + strRecord;
                ichFound = modelFile.indexOf(strSearch);
                if (ichFound >= 0) {
                    ++ichFound;
                }
            }
            if (ichFound < 0 || ichFound >= ichMin) continue;
            ichMin = ichFound;
        }
        this.showString(modelFile.substring(0, ichMin));
    }

    void showModel() {
        int modelCount = this.viewer.getModelCount();
        this.showString("model count = " + modelCount + "\nmodelSetHasVibrationVectors:" + this.viewer.modelSetHasVibrationVectors());
        Properties props = this.viewer.getModelSetProperties();
        this.printProperties(props);
        for (int i = 0; i < modelCount; ++i) {
            this.showString("" + i + ":" + this.viewer.getModelNumber(i) + ":" + this.viewer.getModelName(i) + "\nmodelHasVibrationVectors:" + this.viewer.modelHasVibrationVectors(i));
            this.printProperties(this.viewer.getModelProperties(i));
        }
    }

    void showFile() throws ScriptException {
        System.out.println("showFile && statementLength=" + this.statementLength);
        if (this.statementLength == 2) {
            this.showString(this.viewer.getCurrentFileAsString());
            return;
        }
        if (this.statementLength == 3 && this.statement[2].tok == 4) {
            String fileName = (String)this.statement[2].value;
            System.out.println("fileName=" + fileName);
            this.showString(this.viewer.getFileAsString(fileName));
            return;
        }
        this.invalidArgument();
    }

    void printProperties(Properties props) {
        if (props == null) {
            this.showString("Properties: null");
        } else {
            Enumeration<?> e = props.propertyNames();
            this.showString("Properties:");
            while (e.hasMoreElements()) {
                String propertyName = (String)e.nextElement();
                this.showString(" " + propertyName + "=" + props.getProperty(propertyName));
            }
        }
        System.out.println("");
    }

    void showAnimation() {
        this.showString("show animation information goes here");
    }

    void showOrientation() {
        this.showString(this.viewer.getOrientationText());
    }

    void showTransform() {
        this.showString("transform:\n" + this.viewer.getTransformText());
    }

    void showCenter() {
        this.showString("center: " + this.viewer.getCenter());
    }

    void showZoom() {
        this.showString("zoom " + (this.viewer.getZoomEnabled() ? "" + this.viewer.getZoomPercentSetting() : "off"));
    }

    void showBoundbox() {
        this.showString("boundbox: " + this.viewer.getBoundBoxCenter() + " " + this.viewer.getBoundBoxCornerVector());
    }

    void moveto() throws ScriptException {
        int yTrans;
        if (this.statementLength < 6 || this.statementLength > 9) {
            this.badArgumentCount();
        }
        float floatSecondsTotal = this.floatParameter(1);
        float axisX = this.floatParameter(2);
        float axisY = this.floatParameter(3);
        float axisZ = this.floatParameter(4);
        float degrees = this.floatParameter(5);
        int zoom = this.statementLength >= 7 ? this.intParameter(6) : 100;
        int xTrans = this.statementLength >= 8 ? this.intParameter(7) : 0;
        int n = yTrans = this.statementLength >= 9 ? this.intParameter(8) : 0;
        if (this.aaMoveTo == null) {
            this.aaMoveTo = new AxisAngle4f();
            this.aaStep = new AxisAngle4f();
            this.aaTotal = new AxisAngle4f();
            this.matrixStart = new Matrix3f();
            this.matrixEnd = new Matrix3f();
            this.matrixStep = new Matrix3f();
            this.matrixInverse = new Matrix3f();
        }
        if (degrees < 0.01f && degrees > -0.01f) {
            this.matrixEnd.setIdentity();
        } else {
            if (axisX == 0.0f && axisY == 0.0f && axisZ == 0.0f) {
                int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
                if (sleepTime > 0) {
                    try {
                        Thread.sleep(sleepTime);
                    }
                    catch (InterruptedException ie) {
                        // empty catch block
                    }
                }
                return;
            }
            this.aaMoveTo.set(axisX, axisY, axisZ, degrees * (float)Math.PI / 180.0f);
            this.matrixEnd.set(this.aaMoveTo);
        }
        this.viewer.getRotation(this.matrixStart);
        this.matrixInverse.invert(this.matrixStart);
        this.matrixStep.mul(this.matrixEnd, this.matrixInverse);
        this.aaTotal.set(this.matrixStep);
        int fps = 30;
        int totalSteps = (int)(floatSecondsTotal * (float)fps);
        if (totalSteps > 1) {
            this.aaStep.angle /= (float)totalSteps;
            int frameTimeMillis = 1000 / fps;
            long targetTime = System.currentTimeMillis();
            int zoomStart = this.viewer.getZoomPercent();
            int zoomDelta = zoom - zoomStart;
            float xTransStart = this.viewer.getTranslationXPercent();
            float xTransDelta = (float)xTrans - xTransStart;
            float yTransStart = this.viewer.getTranslationYPercent();
            float yTransDelta = (float)yTrans - yTransStart;
            for (int i = 1; i < totalSteps; ++i) {
                this.viewer.getRotation(this.matrixStart);
                this.matrixInverse.invert(this.matrixStart);
                this.matrixStep.mul(this.matrixEnd, this.matrixInverse);
                this.aaTotal.set(this.matrixStep);
                this.aaStep.set(this.aaTotal);
                this.aaStep.angle /= (float)(totalSteps - i + 1);
                if (this.aaStep.angle == 0.0f) {
                    this.matrixStep.setIdentity();
                } else {
                    this.matrixStep.set(this.aaStep);
                }
                this.matrixStep.mul(this.matrixStart);
                this.viewer.zoomToPercent(zoomStart + zoomDelta * i / totalSteps);
                this.viewer.translateToXPercent(xTransStart + xTransDelta * (float)i / (float)totalSteps);
                this.viewer.translateToYPercent(yTransStart + yTransDelta * (float)i / (float)totalSteps);
                this.viewer.setRotation(this.matrixStep);
                if (System.currentTimeMillis() >= (targetTime += (long)frameTimeMillis)) continue;
                this.viewer.requestRepaintAndWait();
                int sleepTime = (int)(targetTime - System.currentTimeMillis());
                if (sleepTime <= 0) continue;
                try {
                    Thread.sleep(sleepTime);
                    continue;
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        } else {
            int sleepTime = (int)(floatSecondsTotal * 1000.0f) - 30;
            if (sleepTime > 0) {
                try {
                    Thread.sleep(sleepTime);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
        }
        this.viewer.zoomToPercent(zoom);
        this.viewer.translateToXPercent(xTrans);
        this.viewer.translateToYPercent(yTrans);
        this.viewer.setRotation(this.matrixEnd);
    }

    void console() {
        this.viewer.showConsole(this.statement[1].tok == 8193);
    }

    void pmesh() throws ScriptException {
        this.viewer.loadShape(22);
        this.viewer.setShapeProperty(22, "meshID", null);
        for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            switch (this.statement[i].tok) {
                case 1: {
                    propertyName = "meshID";
                    propertyValue = this.statement[i].value;
                    break;
                }
                case 4: {
                    String filename = (String)this.statement[i].value;
                    Object t = this.viewer.getUnzippedBufferedReaderOrErrorMessageFromName(filename);
                    if (t instanceof String) {
                        this.fileNotFoundException(filename + ":" + t);
                    }
                    propertyName = "bufferedreader";
                    propertyValue = t;
                    break;
                }
                case 8458: {
                    propertyValue = Boolean.TRUE;
                }
                case 16433: {
                    propertyName = "dots";
                    break;
                }
                case 16434: {
                    propertyValue = Boolean.TRUE;
                }
                case 16435: {
                    propertyName = "mesh";
                    break;
                }
                case 16436: {
                    propertyValue = Boolean.TRUE;
                }
                case 16437: {
                    propertyName = "fill";
                    break;
                }
                case 8192: 
                case 8193: {
                    propertyName = (String)this.statement[i].value;
                    break;
                }
                case 16426: {
                    propertyName = "delete";
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.setShapeProperty(22, propertyName, propertyValue);
        }
    }

    void polyhedra() throws ScriptException {
        boolean needsGenerating = false;
        boolean onOffDelete = false;
        boolean typeSeen = false;
        boolean edgeParameterSeen = false;
        boolean isDesignParameter = false;
        int nAtomSets = 0;
        this.viewer.loadShape(23);
        this.viewer.setShapeProperty(23, "init", null);
        String setPropertyName = "potentialCenterSet";
        String decimalPropertyName = "radius_";
        block11: for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Serializable propertyValue = null;
            Token token = this.statement[i];
            switch (token.tok) {
                case 32772: 
                case 163844: {
                    continue block11;
                }
                case 2052: {
                    if (nAtomSets > 0) {
                        this.invalidParameterOrder();
                    }
                    needsGenerating = true;
                    propertyName = "bonds";
                    break;
                }
                case 100355: {
                    decimalPropertyName = "radius";
                    continue block11;
                }
                case 1: {
                    String str = (String)token.value;
                    if ("collapsed".equalsIgnoreCase(str)) {
                        propertyName = "collapsed";
                        propertyValue = Boolean.TRUE;
                        if (typeSeen) {
                            this.incompatibleArguments();
                        }
                        typeSeen = true;
                        break;
                    }
                    if ("flat".equalsIgnoreCase(str)) {
                        propertyName = "collapsed";
                        propertyValue = Boolean.FALSE;
                        if (typeSeen) {
                            this.incompatibleArguments();
                        }
                        typeSeen = true;
                        break;
                    }
                    if (!needsGenerating) {
                        this.insufficientArguments();
                    }
                    if ("to".equalsIgnoreCase(str)) {
                        if (nAtomSets > 1) {
                            this.invalidParameterOrder();
                        }
                        setPropertyName = "potentialVertexSet";
                        continue block11;
                    }
                    if ("centerAngleMax".equalsIgnoreCase(str)) {
                        decimalPropertyName = "centerAngleMax";
                        isDesignParameter = true;
                        continue block11;
                    }
                    if ("faceNormalMax".equalsIgnoreCase(str)) {
                        decimalPropertyName = "faceNormalMax";
                        isDesignParameter = true;
                        continue block11;
                    }
                    if ("faceCenterOffset".equalsIgnoreCase(str)) {
                        decimalPropertyName = "faceCenterOffset";
                        isDesignParameter = true;
                        continue block11;
                    }
                    this.unrecognizedSubcommand();
                }
                case 2: {
                    if (nAtomSets > 0 && !isDesignParameter) {
                        this.invalidParameterOrder();
                    }
                    if (decimalPropertyName == "radius_") {
                        propertyName = "vertexCount";
                        propertyValue = new Integer(token.intValue);
                        needsGenerating = true;
                        break;
                    }
                }
                case 3: {
                    if (nAtomSets > 0 && !isDesignParameter) {
                        this.invalidParameterOrder();
                    }
                    propertyName = decimalPropertyName == "radius_" ? "radius" : decimalPropertyName;
                    propertyValue = new Float(this.floatParameter(i));
                    decimalPropertyName = "radius_";
                    isDesignParameter = false;
                    needsGenerating = true;
                    break;
                }
                case 8192: 
                case 8193: 
                case 16426: {
                    if (++i != this.statementLength || needsGenerating || nAtomSets > 1 || nAtomSets == 0 && setPropertyName == "potentialVertexSet") {
                        this.incompatibleArguments();
                    }
                    propertyName = (String)token.value;
                    onOffDelete = true;
                    break;
                }
                case 16427: 
                case 16428: 
                case 16429: {
                    if (edgeParameterSeen) {
                        this.incompatibleArguments();
                    }
                    propertyName = (String)token.value;
                    edgeParameterSeen = true;
                    break;
                }
                case 32868: {
                    if (typeSeen) {
                        this.invalidParameterOrder();
                    }
                    if (++nAtomSets > 2) {
                        this.badArgumentCount();
                    }
                    if (setPropertyName == "potentialVertexSet") {
                        needsGenerating = true;
                    }
                    propertyName = setPropertyName;
                    setPropertyName = "potentialVertexSet";
                    propertyValue = this.expression(this.statement, ++i);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.setShapeProperty(23, propertyName, propertyValue);
            if (!onOffDelete) continue;
            return;
        }
        if (!(needsGenerating || typeSeen || edgeParameterSeen)) {
            this.insufficientArguments();
        }
        if (needsGenerating) {
            this.viewer.setShapeProperty(23, "generate", null);
        }
    }

    void sasurface() throws ScriptException {
        this.viewer.loadShape(24);
        this.viewer.setShapeProperty(24, "surfaceID", null);
        for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            switch (this.statement[i].tok) {
                case 1: {
                    propertyValue = this.statement[i].value;
                }
                case 36875: {
                    propertyName = "surfaceID";
                    break;
                }
                case 8192: 
                case 8193: {
                    propertyName = (String)this.statement[i].value;
                    break;
                }
                case 16426: {
                    propertyName = "delete";
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.setShapeProperty(24, propertyName, propertyValue);
        }
    }

    void centerAt() throws ScriptException {
        float x;
        float y;
        float z;
        if (this.statementLength != 2 && this.statementLength != 5) {
            this.badArgumentCount();
        }
        String relativeTo = null;
        switch (this.statement[1].tok) {
            case 16431: {
                relativeTo = "absolute";
                break;
            }
            case 16432: {
                relativeTo = "average";
                break;
            }
            case 6149: {
                relativeTo = "boundbox";
                break;
            }
            default: {
                this.unrecognizedSubcommand();
            }
        }
        if (this.statementLength == 2) {
            z = 0.0f;
            y = 0.0f;
            x = 0.0f;
        } else {
            x = this.floatParameter(2);
            y = this.floatParameter(3);
            z = this.floatParameter(4);
        }
        this.viewer.setCenter(relativeTo, x, y, z);
    }

    void isosurface() throws ScriptException {
        this.viewer.loadShape(25);
        this.viewer.setShapeProperty(25, "meshID", null);
        boolean colorSeen = false;
        int colorRangeStage = 0;
        for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            switch (this.statement[i].tok) {
                case 1: {
                    propertyValue = this.statement[i].value;
                }
                case 36875: {
                    propertyName = "meshID";
                    break;
                }
                case 4: {
                    String filename = (String)this.statement[i].value;
                    Object t = this.viewer.getUnzippedBufferedReaderOrErrorMessageFromName(filename);
                    if (t instanceof String) {
                        this.fileNotFoundException(filename + ":" + t);
                    }
                    propertyName = colorSeen ? "colorreader" : "bufferedreader";
                    propertyValue = t;
                    if (!colorSeen || colorRangeStage == 0 || colorRangeStage == 3) break;
                    this.invalidArgument();
                    break;
                }
                case 3: {
                    if (colorRangeStage == 0) {
                        propertyName = "cutoff";
                        propertyValue = this.statement[i].value;
                        break;
                    }
                }
                case 2: {
                    if (colorRangeStage == 0 || colorRangeStage >= 3) {
                        this.invalidArgument();
                    }
                    propertyName = colorRangeStage == 1 ? "rangeMin" : "rangeMax";
                    propertyValue = new Float(this.floatParameter(i));
                    ++colorRangeStage;
                    break;
                }
                case 8458: {
                    propertyValue = Boolean.TRUE;
                }
                case 16433: {
                    propertyName = "dots";
                    break;
                }
                case 16434: {
                    propertyValue = Boolean.TRUE;
                }
                case 16435: {
                    propertyName = "mesh";
                    break;
                }
                case 16436: {
                    propertyValue = Boolean.TRUE;
                }
                case 16437: {
                    propertyName = "fill";
                    break;
                }
                case 8192: 
                case 8193: {
                    propertyName = (String)this.statement[i].value;
                    break;
                }
                case 16426: {
                    propertyName = "delete";
                    break;
                }
                case 526598: {
                    colorSeen = true;
                    propertyName = "removeRange";
                    break;
                }
                case 16431: {
                    colorRangeStage = 1;
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            if (propertyName == null) continue;
            this.viewer.setShapeProperty(25, propertyName, propertyValue);
        }
    }

    void stereo() throws ScriptException {
        int stereoMode = 1;
        float degrees = -5.0f;
        boolean degreesSeen = false;
        block6: for (int i = 1; i < this.statementLength; ++i) {
            switch (this.statement[i].tok) {
                case 8193: {
                    stereoMode = 1;
                    continue block6;
                }
                case 8192: {
                    stereoMode = 0;
                    continue block6;
                }
                case 2: 
                case 3: {
                    degrees = this.floatParameter(i);
                    degreesSeen = true;
                    continue block6;
                }
                case 1: {
                    String id = (String)this.statement[i].value;
                    if (!degreesSeen) {
                        degrees = 3.0f;
                    }
                    if (id.equalsIgnoreCase("redblue")) {
                        stereoMode = 3;
                        continue block6;
                    }
                    if (id.equalsIgnoreCase("redcyan")) {
                        stereoMode = 2;
                        continue block6;
                    }
                    if (id.equalsIgnoreCase("redgreen")) {
                        stereoMode = 4;
                        continue block6;
                    }
                }
                default: {
                    this.booleanOrNumberExpected();
                }
            }
        }
        this.viewer.setStereoDegrees(degrees);
        this.viewer.setStereoMode(stereoMode);
    }

    void connect() throws ScriptException {
        boolean haveType = false;
        int nAtomSets = 0;
        int nDistances = 0;
        this.viewer.setShapeProperty(1, "resetConnectParameters", null);
        if (this.statementLength == 1) {
            this.viewer.setShapeProperty(1, "rasmolCompatibleConnect", null);
            return;
        }
        for (int i = 1; i < this.statementLength; ++i) {
            String propertyName = null;
            Object propertyValue = null;
            block0 : switch (this.statement[i].tok) {
                case 8192: 
                case 8193: {
                    if (this.statementLength != 2) {
                        this.badArgumentCount();
                    }
                    this.viewer.setShapeProperty(1, "rasmolCompatibleConnect", null);
                    return;
                }
                case 2: 
                case 3: {
                    if (++nDistances > 2) {
                        this.badArgumentCount();
                    }
                    if (nAtomSets > 0 || haveType) {
                        this.invalidParameterOrder();
                    }
                    propertyName = "connectDistance";
                    propertyValue = new Float(this.floatParameter(i));
                    break;
                }
                case 32868: {
                    if (++nAtomSets > 2) {
                        this.badArgumentCount();
                    }
                    if (haveType) {
                        this.invalidParameterOrder();
                    }
                    propertyName = "connectSet";
                    propertyValue = this.expression(this.statement, i);
                    i = this.pcLastExpressionInstruction;
                    break;
                }
                case 1: 
                case 10509: {
                    String cmd = (String)this.statement[i].value;
                    int j = JmolConstants.bondOrderNames.length;
                    while (--j >= 0) {
                        if (!cmd.equalsIgnoreCase(JmolConstants.bondOrderNames[j])) continue;
                        if (haveType) {
                            this.incompatibleArguments();
                        }
                        cmd = JmolConstants.bondOrderNames[j];
                        propertyName = "connectBondOrder";
                        propertyValue = cmd;
                        haveType = true;
                        break block0;
                    }
                    if (++i != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    if ("modify".equalsIgnoreCase(cmd)) {
                        propertyValue = "modify";
                    } else if ("create".equalsIgnoreCase(cmd)) {
                        propertyValue = "create";
                    } else if ("modifyOrCreate".equalsIgnoreCase(cmd)) {
                        propertyValue = "modifyOrCreate";
                    } else if ("auto".equalsIgnoreCase(cmd)) {
                        propertyValue = "auto";
                    } else {
                        this.unrecognizedSubcommand();
                    }
                    propertyName = "connectOperation";
                    break;
                }
                case 16426: 
                case 49157: {
                    if (++i != this.statementLength) {
                        this.invalidParameterOrder();
                    }
                    propertyName = "connectOperation";
                    propertyValue = "delete";
                    break;
                }
                default: {
                    this.invalidArgument();
                }
            }
            this.viewer.setShapeProperty(1, propertyName, propertyValue);
        }
        this.viewer.setShapeProperty(1, "applyConnectParameters", null);
    }

    static {
        if (shapeToks.length != 27) {
            System.out.println("shapeToks mismatch");
            throw new NullPointerException();
        }
        pdbRecords = new String[]{"ATOM  ", "HELIX ", "SHEET ", "TURN  ", "MODEL ", "SCALE", "HETATM", "SEQRES", "DBREF "};
    }
}

