/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Polyhedra;
import org.jmol.viewer.ShapeRenderer;

class PolyhedraRenderer
extends ShapeRenderer {
    PolyhedraRenderer() {
    }

    void render() {
        Polyhedra polyhedra = (Polyhedra)this.shape;
        Polyhedra.Polyhedron[] polyhedrons = polyhedra.polyhedrons;
        int i = polyhedra.polyhedronCount;
        while (--i >= 0) {
            this.render1(polyhedrons[i]);
        }
    }

    void render1(Polyhedra.Polyhedron p) {
        int displayModelIndex = this.displayModelIndex;
        if (displayModelIndex >= 0 && p.centralAtom.modelIndex != displayModelIndex) {
            return;
        }
        if (!p.visible) {
            return;
        }
        short colix = Graphics3D.inheritColix(p.polyhedronColix, p.centralAtom.colixAtom);
        if (p.collapsed) {
            this.renderCollapsed(p, colix);
        } else {
            this.renderFlat(p, colix);
        }
    }

    void renderFlat(Polyhedra.Polyhedron p, short colix) {
        Atom[] vertexAtoms = p.vertexAtoms;
        byte[] planes = p.planes;
        short[] normixes = p.normixes;
        int drawEdges = p.edges;
        int i = 0;
        int j = 0;
        while (j < planes.length) {
            this.drawFace(colix, drawEdges, normixes[i++], vertexAtoms[planes[j++]], vertexAtoms[planes[j++]], vertexAtoms[planes[j++]]);
        }
        i = 0;
        j = 0;
        while (j < planes.length) {
            this.fillFace(colix, normixes[i++], vertexAtoms[planes[j++]], vertexAtoms[planes[j++]], vertexAtoms[planes[j++]]);
        }
    }

    void drawFace(short colix, int drawEdges, short normix, Atom atomA, Atom atomB, Atom atomC) {
        if (drawEdges == 1 || drawEdges == 2 && this.g3d.isDirectedTowardsCamera(normix)) {
            this.g3d.drawCylinderTriangle(Graphics3D.getOpaqueColix(colix), atomA.screenX, atomA.screenY, atomA.screenZ, atomB.screenX, atomB.screenY, atomB.screenZ, atomC.screenX, atomC.screenY, atomC.screenZ, 3);
        }
    }

    void fillFace(short colix, short normix, Atom atomA, Atom atomB, Atom atomC) {
        this.g3d.fillTriangle(colix, normix, atomA.screenX, atomA.screenY, atomA.screenZ, atomB.screenX, atomB.screenY, atomB.screenZ, atomC.screenX, atomC.screenY, atomC.screenZ);
    }

    void renderCollapsed(Polyhedra.Polyhedron p, short colix) {
        Point3i[] screens = this.viewer.allocTempScreens(p.faceCount);
        this.viewer.transformPoints(p.collapsedCenters, screens);
        Atom[] vertexAtoms = p.vertexAtoms;
        byte[] planes = p.planes;
        short[] normixes = p.collapsedNormixes;
        int drawEdges = p.edges;
        int i = p.faceCount;
        while (--i >= 0) {
            this.renderCollapsedFace(colix, drawEdges, screens[i], vertexAtoms[planes[3 * i + 0]], vertexAtoms[planes[3 * i + 1]], vertexAtoms[planes[3 * i + 2]], normixes[3 * i + 0], normixes[3 * i + 1], normixes[3 * i + 2]);
        }
        this.viewer.freeTempScreens(screens);
    }

    void renderCollapsedFace(short colix, int drawEdges, Point3i center, Atom atomA, Atom atomB, Atom atomC, short normixA, short normixB, short normixC) {
        this.drawCollapsed(colix, drawEdges, normixA, center, atomB, atomC);
        this.drawCollapsed(colix, drawEdges, normixB, center, atomA, atomC);
        this.drawCollapsed(colix, drawEdges, normixC, center, atomA, atomB);
        this.fillCollapsed(colix, normixA, center, atomB, atomC);
        this.fillCollapsed(colix, normixB, center, atomA, atomC);
        this.fillCollapsed(colix, normixC, center, atomA, atomB);
    }

    void drawCollapsed(short colix, int drawEdges, short normix, Point3i collapsed, Atom atomB, Atom atomC) {
        if (drawEdges == 1 || drawEdges == 2 && this.g3d.isDirectedTowardsCamera(normix)) {
            this.g3d.drawCylinderTriangle(Graphics3D.getOpaqueColix(colix), collapsed.x, collapsed.y, collapsed.z, atomB.screenX, atomB.screenY, atomB.screenZ, atomC.screenX, atomC.screenY, atomC.screenZ, 3);
        }
    }

    void fillCollapsed(short colix, short normix, Point3i collapsed, Atom atomB, Atom atomC) {
        this.g3d.fillTriangle(colix, normix, collapsed.x, collapsed.y, collapsed.z, atomB.screenX, atomB.screenY, atomB.screenZ, atomC.screenX, atomC.screenY, atomC.screenZ);
    }
}

