/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.AxisAngle4f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.Bmp;
import org.jmol.viewer.Frame;
import org.jmol.viewer.SasFlattenedPointList;
import org.jmol.viewer.Sasurface;
import org.jmol.viewer.Util;
import org.jmol.viewer.Viewer;

class SasGem {
    final Graphics3D g3d;
    final Viewer viewer;
    final Frame frame;
    final int geodesicLevel;
    final SasFlattenedPointList fplIdeal;
    final SasFlattenedPointList fplActual;
    final SasFlattenedPointList fplVisibleIdeal;
    final SasFlattenedPointList fplTorusSegment;
    final SasFlattenedPointList fplForStitching;
    final Vector3f[] geodesicVertexVectors;
    final int geodesicVertexCount;
    final int geodesicFaceCount;
    final short[] geodesicFaceVertexes;
    final short[] geodesicNeighborVertexes;
    final Vector3f centerVectorT = new Vector3f();
    final Point3f vertexPointT = new Point3f();
    final Vector3f vertexVectorT = new Vector3f();
    final Point3f projectedPointT = new Point3f();
    final Vector3f projectedVectorT = new Vector3f();
    final int[] bmpNotClippedT;
    final int[] bmpClippedT;
    final int[] idealEdgeMapT;
    final int[] actualEdgeMapT;
    final int[] visibleIdealEdgeMapT;
    final int[] faceMapT;
    final int[] vertexMapT;
    short firstStitchedGeodesicVertex;
    short lastStitchedGeodesicVertex;
    private static final float PI = (float)Math.PI;
    private static final int MAX_FULL_TORUS_STEP_COUNT = Sasurface.MAX_FULL_TORUS_STEP_COUNT;
    final AxisAngle4f aaT = new AxisAngle4f();
    final Matrix3f matrixT = new Matrix3f();
    final Vector3f vectorT = new Vector3f();
    int stitchesCount;
    short[] stitches = new short[64];
    float[] segmentVertexAngles = new float[MAX_FULL_TORUS_STEP_COUNT];
    short[] segmentVertexes = new short[MAX_FULL_TORUS_STEP_COUNT];
    final Vector3f vector0T = new Vector3f();
    final Vector3f vector90T = new Vector3f();
    final Point3f planeCenterT = new Point3f();
    final Vector3f vectorBA = new Vector3f();
    final Vector3f vectorBC = new Vector3f();
    int seamCount;
    short[] seam = new short[64];

    SasGem(Viewer viewer, Graphics3D g3d, Frame frame, int geodesicLevel) {
        this.g3d = g3d;
        this.viewer = viewer;
        this.frame = frame;
        this.geodesicLevel = geodesicLevel;
        this.geodesicVertexVectors = g3d.getGeodesicVertexVectors();
        this.geodesicVertexCount = g3d.getGeodesicVertexCount(geodesicLevel);
        this.geodesicFaceCount = g3d.getGeodesicFaceCount(geodesicLevel);
        this.geodesicFaceVertexes = g3d.getGeodesicFaceVertexes(geodesicLevel);
        this.geodesicNeighborVertexes = g3d.getGeodesicNeighborVertexes(geodesicLevel);
        this.bmpNotClippedT = Bmp.allocateBitmap(this.geodesicVertexCount);
        this.bmpClippedT = Bmp.allocateBitmap(this.geodesicVertexCount);
        this.idealEdgeMapT = Bmp.allocateBitmap(this.geodesicVertexCount);
        this.actualEdgeMapT = Bmp.allocateBitmap(this.geodesicVertexCount);
        this.visibleIdealEdgeMapT = Bmp.allocateBitmap(this.geodesicVertexCount);
        this.faceMapT = Bmp.allocateBitmap(this.geodesicFaceCount);
        this.vertexMapT = Bmp.allocateBitmap(this.geodesicFaceCount);
        this.fplIdeal = new SasFlattenedPointList(g3d, geodesicLevel);
        this.fplActual = new SasFlattenedPointList(g3d, geodesicLevel);
        this.fplVisibleIdeal = new SasFlattenedPointList(g3d, geodesicLevel);
        this.fplTorusSegment = new SasFlattenedPointList(g3d, geodesicLevel);
        this.fplForStitching = new SasFlattenedPointList(g3d, geodesicLevel);
    }

    void reset() {
        this.stitchesCount = 0;
    }

    boolean findIdealEdge(boolean isEdgeA, Point3f geodesicCenter, float geodesicRadius, Point3f planeCenter, Vector3f planeUnitNormal, int[] idealEdgeMap) {
        Bmp.clearBitmap(this.bmpNotClippedT);
        Bmp.clearBitmap(idealEdgeMap);
        int unclippedCount = 0;
        int i = this.geodesicVertexCount;
        while (--i >= 0) {
            this.vertexPointT.scaleAdd(geodesicRadius, this.geodesicVertexVectors[i], geodesicCenter);
            this.vertexVectorT.sub(this.vertexPointT, planeCenter);
            float dot = this.vertexVectorT.dot(planeUnitNormal);
            if (isEdgeA) {
                dot = -dot;
            }
            if (!(dot >= 0.0f)) continue;
            ++unclippedCount;
            Bmp.setBit(this.bmpNotClippedT, i);
        }
        if (unclippedCount == 0) {
            return false;
        }
        if (unclippedCount == this.geodesicVertexCount) {
            this.findClippedFaceVertexes(isEdgeA, geodesicCenter, geodesicRadius, planeCenter, planeUnitNormal, idealEdgeMap);
            return false;
        }
        int v = -1;
        block1: while ((v = Bmp.nextSetBit(this.bmpNotClippedT, v + 1)) >= 0) {
            int j;
            int neighborsOffset = v * 6;
            int n = j = v < 12 ? 5 : 6;
            while (--j >= 0) {
                short neighbor = this.geodesicNeighborVertexes[neighborsOffset + j];
                if (Bmp.getBit(this.bmpNotClippedT, neighbor)) continue;
                Bmp.setBit(idealEdgeMap, v);
                continue block1;
            }
        }
        return true;
    }

    boolean findIdealInsideEdge(boolean isEdgeA, Point3f geodesicCenter, float geodesicRadius, Point3f planeCenter, Vector3f planeUnitNormal, int[] idealInsideEdgeMap) {
        Bmp.clearBitmap(this.bmpClippedT);
        Bmp.clearBitmap(idealInsideEdgeMap);
        int clippedCount = 0;
        int i = this.geodesicVertexCount;
        while (--i >= 0) {
            this.vertexPointT.scaleAdd(geodesicRadius, this.geodesicVertexVectors[i], geodesicCenter);
            this.vertexVectorT.sub(this.vertexPointT, planeCenter);
            float dot = this.vertexVectorT.dot(planeUnitNormal);
            if (isEdgeA) {
                dot = -dot;
            }
            if (!(dot <= 0.0f)) continue;
            ++clippedCount;
            Bmp.setBit(this.bmpClippedT, i);
        }
        if (clippedCount == 0) {
            return false;
        }
        if (clippedCount == this.geodesicVertexCount) {
            return false;
        }
        int v = -1;
        block1: while ((v = Bmp.nextSetBit(this.bmpClippedT, v + 1)) >= 0) {
            int j;
            int neighborsOffset = v * 6;
            int n = j = v < 12 ? 5 : 6;
            while (--j >= 0) {
                short neighbor = this.geodesicNeighborVertexes[neighborsOffset + j];
                if (Bmp.getBit(this.bmpClippedT, neighbor)) continue;
                Bmp.setBit(idealInsideEdgeMap, v);
                continue block1;
            }
        }
        return true;
    }

    boolean findActualEdge(int[] visibleVertexMap, int[] actualEdgeMap) {
        int edgeVertexCount = 0;
        Bmp.clearBitmap(actualEdgeMap);
        int v = -1;
        block0: while ((v = Bmp.nextSetBit(visibleVertexMap, v + 1)) >= 0) {
            int j;
            int neighborsOffset = v * 6;
            int n = j = v < 12 ? 5 : 6;
            while (--j >= 0) {
                short neighbor = this.geodesicNeighborVertexes[neighborsOffset + j];
                if (Bmp.getBit(visibleVertexMap, neighbor)) continue;
                Bmp.setBit(actualEdgeMap, v);
                ++edgeVertexCount;
                continue block0;
            }
        }
        return edgeVertexCount > 0;
    }

    short findClosestVertex(short normix, int[] edgeVertexMap) {
        int champion = -1;
        float championAngle = (float)Math.PI;
        Vector3f vector = this.geodesicVertexVectors[normix];
        int v = -1;
        while ((v = Bmp.nextSetBit(edgeVertexMap, v + 1)) >= 0) {
            float angle = vector.angle(this.geodesicVertexVectors[v]);
            if (!(angle < championAngle)) continue;
            championAngle = angle;
            champion = v;
        }
        return (short)champion;
    }

    void findClippedFaceVertexes(boolean isEdgeA, Point3f geodesicCenter, float radius, Point3f planeCenter, Vector3f planeUnitNormal, int[] edgeVertexMap) {
    }

    void calcVectors0and90(Point3f planeCenter, Vector3f axisVector, Point3f planeZeroPoint, Vector3f vector0, Vector3f vector90) {
        vector0.sub(planeZeroPoint, planeCenter);
        this.aaT.set(axisVector, 1.5707964f);
        this.matrixT.set(this.aaT);
        this.matrixT.transform(vector0, vector90);
    }

    boolean projectAndSortGeodesicPoints(boolean isEdgeA, Point3f geodesicCenter, float geodesicRadius, Point3f planeCenter, Vector3f axisUnitVector, Point3f planeZeroPoint, boolean fullTorus, int[] convexVertexMap, boolean dump) {
        if (!this.findActualEdge(convexVertexMap, this.actualEdgeMapT)) {
            return false;
        }
        if (!this.findIdealEdge(isEdgeA, geodesicCenter, geodesicRadius, planeCenter, axisUnitVector, this.idealEdgeMapT)) {
            return false;
        }
        Bmp.and(this.visibleIdealEdgeMapT, this.idealEdgeMapT, this.actualEdgeMapT);
        this.calcVectors0and90(planeCenter, axisUnitVector, planeZeroPoint, this.vector0T, this.vector90T);
        this.fplActual.setGeodesicEdge(geodesicCenter, geodesicRadius, planeCenter, axisUnitVector, planeZeroPoint, fullTorus, this.vector0T, this.vector90T, this.geodesicVertexVectors, this.actualEdgeMapT);
        this.fplIdeal.setGeodesicEdge(geodesicCenter, geodesicRadius, planeCenter, axisUnitVector, planeZeroPoint, fullTorus, this.vector0T, this.vector90T, this.geodesicVertexVectors, this.idealEdgeMapT);
        this.fplVisibleIdeal.setGeodesicEdge(geodesicCenter, geodesicRadius, planeCenter, axisUnitVector, planeZeroPoint, fullTorus, this.vector0T, this.vector90T, this.geodesicVertexVectors, this.visibleIdealEdgeMapT);
        if (dump) {
            System.out.println("++++++++++++++++ projectAndSort isEdgeA:" + isEdgeA);
            System.out.println("fplActual=");
            this.fplActual.dump();
            System.out.println("fplIdeal=");
            this.fplIdeal.dump();
            System.out.println("fplVisibleIdeal=");
            this.fplVisibleIdeal.dump();
            System.out.println("---------------- projectAndSort");
        }
        return true;
    }

    void calcClippingPlaneCenter(Point3f axisPoint, Vector3f axisUnitVector, Point3f planePoint, Point3f planeCenterPoint) {
        this.vectorT.sub(axisPoint, planePoint);
        float distance = axisUnitVector.dot(this.vectorT);
        planeCenterPoint.scaleAdd(-distance, axisUnitVector, axisPoint);
    }

    static float calcAngleInThePlane(Vector3f radialVector0, Vector3f radialVector90, Vector3f vectorInQuestion) {
        float angle = radialVector0.angle(vectorInQuestion);
        float angle90 = radialVector90.angle(vectorInQuestion);
        if (angle90 > 1.5707964f) {
            angle = (float)Math.PI * 2 - angle;
        }
        return angle;
    }

    float angleABC(float xA, float yA, float xB, float yB, float xC, float yC) {
        double vxAB = xA - xB;
        double vyAB = yA - yB;
        double vxBC = xC - xB;
        double vyBC = yC - yB;
        double dot = vxAB * vxBC + vyAB * vyBC;
        double lenAB = Math.sqrt(vxAB * vxAB + vyAB * vyAB);
        double lenBC = Math.sqrt(vxBC * vxBC + vyBC * vyBC);
        float angle = (float)Math.acos(dot / (lenAB * lenBC));
        return angle;
    }

    float angleABCRight(float xA, float xB, float xC, float yC) {
        double vxAB = xA - xB;
        double vxBC = xC - xB;
        double vyBC = yC;
        double dot = vxAB * vxBC;
        double lenAB = Math.abs(vxAB);
        double lenBC = Math.sqrt(vxBC * vxBC + vyBC * vyBC);
        return (float)Math.acos(dot / (lenAB * lenBC));
    }

    float angleABCLeft(float xA, float xB, float yB, float xC, float yC) {
        double vxAB = xA - xB;
        double vyAB = 0.0f - yB;
        double vxBC = xC - xB;
        double vyBC = yC - yB;
        double dot = vxAB * vxBC + vyAB * vyBC;
        double lenAB = Math.sqrt(vxAB * vxAB + vyAB * vyAB);
        double lenBC = Math.sqrt(vxBC * vxBC + vyBC * vyBC);
        return (float)Math.acos(dot / (lenAB * lenBC));
    }

    void clipGeodesic(boolean isEdgeA, Point3f geodesicCenter, float radius, Point3f planePoint, Vector3f axisUnitVector, int[] geodesicVertexMap) {
        this.centerVectorT.sub(geodesicCenter, planePoint);
        float dotCenter = this.centerVectorT.dot(axisUnitVector);
        if (isEdgeA) {
            dotCenter = -dotCenter;
        }
        if (dotCenter >= radius) {
            return;
        }
        if (dotCenter < -radius) {
            Bmp.clearBitmap(geodesicVertexMap);
            return;
        }
        int i = -1;
        while ((i = Bmp.nextSetBit(geodesicVertexMap, i + 1)) >= 0) {
            this.vertexPointT.scaleAdd(radius, this.geodesicVertexVectors[i], geodesicCenter);
            this.vertexVectorT.sub(this.vertexPointT, planePoint);
            float dot = this.vertexVectorT.dot(axisUnitVector);
            if (isEdgeA) {
                dot = -dot;
            }
            if (!(dot < 0.0f)) continue;
            Bmp.clearBit(geodesicVertexMap, i);
        }
    }

    int[] calcFaceBitmap(int[] vertexMap) {
        Bmp.clearBitmap(this.faceMapT);
        int i = this.geodesicFaceCount;
        int j = 3 * (i - 1);
        while (--i >= 0) {
            if (Bmp.getBit(vertexMap, this.geodesicFaceVertexes[j]) || Bmp.getBit(vertexMap, this.geodesicFaceVertexes[j + 1]) || Bmp.getBit(vertexMap, this.geodesicFaceVertexes[j + 2])) {
                Bmp.setBit(this.faceMapT, i);
            }
            j -= 3;
        }
        return Bmp.allocMinimalCopy(this.faceMapT);
    }

    int[] calcFaceVertexBitmap(int[] faceMap) {
        Bmp.clearBitmap(this.vertexMapT);
        int i = -1;
        while ((i = Bmp.nextSetBit(faceMap, i + 1)) >= 0) {
            int j = i * 3;
            Bmp.setBit(this.vertexMapT, this.geodesicFaceVertexes[j]);
            Bmp.setBit(this.vertexMapT, this.geodesicFaceVertexes[j + 1]);
            Bmp.setBit(this.vertexMapT, this.geodesicFaceVertexes[j + 2]);
        }
        return Bmp.allocMinimalCopy(this.vertexMapT);
    }

    void stitchWithTorusSegment(short startingVertex, short vertexIncrement, float startingAngle, float angleIncrement, int stepCount, boolean dump) {
        float endingAngle = startingAngle + angleIncrement * (float)(stepCount - 1);
        this.fplForStitching.buildForStitching(startingAngle, endingAngle, this.fplIdeal, this.fplActual, this.fplVisibleIdeal, dump);
        this.fplTorusSegment.generateTorusSegment(startingVertex, vertexIncrement, startingAngle, angleIncrement, stepCount);
        this.stitchEm(this.fplTorusSegment, this.fplForStitching, dump);
        if (dump) {
            this.dumpStitches();
        }
    }

    void stitchEm(SasFlattenedPointList torusFpl, SasFlattenedPointList geodesicFpl, boolean dump) {
        if (geodesicFpl.count == 0) {
            this.lastStitchedGeodesicVertex = (short)-1;
            this.firstStitchedGeodesicVertex = (short)-1;
            return;
        }
        int tLast = torusFpl.count - 1;
        int gLast = geodesicFpl.count - 1;
        this.firstStitchedGeodesicVertex = geodesicFpl.vertexes[0];
        this.oneStitch(torusFpl.vertexes[0], this.firstStitchedGeodesicVertex);
        int t = 0;
        int g = 0;
        while (t < tLast && g < gLast) {
            float d1 = geodesicFpl.angles[g + 1] - torusFpl.angles[t];
            float d2 = torusFpl.angles[t + 1] - geodesicFpl.angles[g];
            if (d1 < d2) {
                ++g;
            } else {
                ++t;
            }
            this.oneStitch(torusFpl.vertexes[t], geodesicFpl.vertexes[g]);
        }
        while (t < tLast || g < gLast) {
            if (t < tLast) {
                ++t;
            } else {
                ++g;
            }
            this.oneStitch(torusFpl.vertexes[t], geodesicFpl.vertexes[g]);
        }
        this.lastStitchedGeodesicVertex = geodesicFpl.vertexes[gLast];
    }

    void oneStitch(short torusVertex, short geodesicVertex) {
        if (this.stitchesCount + 1 >= this.stitches.length) {
            this.stitches = Util.doubleLength(this.stitches);
        }
        this.stitches[this.stitchesCount] = torusVertex;
        this.stitches[this.stitchesCount + 1] = geodesicVertex;
        this.stitchesCount += 2;
    }

    void dumpStitches() {
        System.out.println("    >> stitches stitchesCount=" + this.stitchesCount);
        for (int i = 0; i < this.stitchesCount; i += 2) {
            System.out.println("    " + this.stitches[i] + "->(" + this.stitches[i + 1] + ")");
        }
    }

    short[] createSeam() {
        return this.createSeam(this.stitchesCount, this.stitches);
    }

    short[] createSeam(int stitchCount, short[] stitches) {
        this.seamCount = 0;
        short lastTorusVertex = -1;
        short lastGeodesicVertex = -1;
        for (int i = 0; i < stitchCount; i += 2) {
            short torusVertex = stitches[i];
            short geodesicVertex = stitches[i + 1];
            if (torusVertex != lastTorusVertex) {
                if (geodesicVertex != lastGeodesicVertex) {
                    if (this.seamCount > 0) {
                        this.addToSeam((short)Short.MIN_VALUE);
                    }
                    this.addToSeam(torusVertex);
                    this.addToSeam(~geodesicVertex);
                } else {
                    this.addToSeam(torusVertex);
                }
            } else {
                this.addToSeam(~geodesicVertex);
            }
            lastTorusVertex = torusVertex;
            lastGeodesicVertex = geodesicVertex;
        }
        short[] newSeam = new short[this.seamCount];
        int i = newSeam.length;
        while (--i >= 0) {
            newSeam[i] = this.seam[i];
        }
        return newSeam;
    }

    void addToSeam(short vertex) {
        if (this.seamCount == this.seam.length) {
            this.seam = Util.doubleLength(this.seam);
        }
        this.seam[this.seamCount++] = vertex;
    }

    void dumpSeam(int stitchCount, short[] stitches, short[] seam) {
        int i;
        System.out.println("dumpSeam:");
        for (i = 0; i < stitchCount; i += 2) {
            System.out.println("  " + stitches[i] + "->" + stitches[i + 1]);
        }
        System.out.println(" --");
        for (i = 0; i < seam.length; ++i) {
            short v = seam[i];
            System.out.print("  " + v + " ");
            if (v == Short.MIN_VALUE) {
                System.out.println(" -- break");
                continue;
            }
            if (v < 0) {
                System.out.println("(" + ~v + ")");
                continue;
            }
            System.out.println("");
        }
    }

    void decodeSeam(short[] seam) {
        System.out.println("-----\ndecodeSeam\n-----");
        boolean breakSeam = true;
        int lastTorusVertex = -1;
        int lastGeodesicVertex = -1;
        for (int i = 0; i < seam.length; ++i) {
            if (breakSeam) {
                lastTorusVertex = seam[i++];
                lastGeodesicVertex = ~seam[i];
                System.out.println("--break--");
                breakSeam = false;
                continue;
            }
            int v = seam[i];
            if (v > 0) {
                System.out.println(" " + lastTorusVertex + " -> " + v + " -> " + "(" + lastGeodesicVertex + ")");
                lastTorusVertex = v;
                continue;
            }
            System.out.println(" " + lastTorusVertex + " -> " + "(" + (v ^= 0xFFFFFFFF) + ") -> " + "(" + lastGeodesicVertex + ")");
            lastGeodesicVertex = v;
        }
    }
}

