/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.HashMap;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.CmlReader;
import org.xml.sax.Attributes;

class MolproReader
extends CmlReader {
    MolproReader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        return this.readAtomSetCollectionSax(reader, new MolproHandler(), "molpro");
    }

    class MolproHandler
    extends CmlReader.CmlHandler {
        private String normalCoordinateTag = "normalCoordinate";
        private String vibrationsTag = "vibrations";
        int frequencyCount;

        MolproHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            HashMap<String, String> hashAtts = new HashMap<String, String>(atts.getLength());
            int i = atts.getLength();
            while (--i >= 0) {
                hashAtts.put(atts.getLocalName(i), atts.getValue(i));
            }
            MolproReader.this.processStartElement(namespaceURI, localName, qName, hashAtts);
            this.molproStartElement(namespaceURI, localName, qName, atts);
        }

        public void molproStartElement(String namespaceURI, String localName, String qName, Attributes atts) {
            if (this.normalCoordinateTag.equals(localName)) {
                String wavenumber = "";
                MolproReader.this.atomSetCollection.cloneLastAtomSet();
                ++this.frequencyCount;
                int i = atts.getLength();
                while (--i >= 0) {
                    String attLocalName = atts.getLocalName(i);
                    String attValue = atts.getValue(i);
                    if ("wavenumber".equals(attLocalName)) {
                        wavenumber = attValue;
                        continue;
                    }
                    if (!"units".equals(attLocalName)) continue;
                }
                MolproReader.this.atomSetCollection.setAtomSetProperty("Frequency", wavenumber + " cm**-1");
                MolproReader.this.keepChars = true;
                return;
            }
            if (this.vibrationsTag.equals(localName)) {
                this.frequencyCount = 0;
                return;
            }
        }

        public void endElement(String uri, String localName, String qName) {
            MolproReader.this.processEndElement(uri, localName, qName);
            this.molproProcessEndElement(uri, localName, qName);
            MolproReader.this.keepChars = false;
            MolproReader.this.title = null;
            MolproReader.this.dictRef = null;
            MolproReader.this.chars = null;
        }

        public void molproProcessEndElement(String uri, String localName, String qName) {
            if (this.normalCoordinateTag.equals(localName)) {
                int atomCount = MolproReader.this.atomSetCollection.getLastAtomSetAtomCount();
                MolproReader.this.tokens = MolproReader.this.getTokens(MolproReader.this.chars);
                int offset = MolproReader.this.tokens.length - atomCount * 3;
                for (int i = 0; i < atomCount; ++i) {
                    Atom atom = MolproReader.this.atomSetCollection.atoms[i + MolproReader.this.atomSetCollection.currentAtomSetIndex * atomCount];
                    atom.vectorX = MolproReader.this.parseFloat(MolproReader.this.tokens[offset++]);
                    atom.vectorY = MolproReader.this.parseFloat(MolproReader.this.tokens[offset++]);
                    atom.vectorZ = MolproReader.this.parseFloat(MolproReader.this.tokens[offset++]);
                }
            }
        }
    }
}

