/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;

class V3000Reader
extends AtomSetCollectionReader {
    int headerAtomCount;
    int headerBondCount;

    V3000Reader() {
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.atomSetCollection = new AtomSetCollection("v3000");
        boolean startNewAtomSet = false;
        this.processCtab(reader, startNewAtomSet);
        return this.atomSetCollection;
    }

    String processCtab(BufferedReader reader, boolean startNewAtomSet) throws Exception {
        String line = reader.readLine();
        while (line != null && !line.equals("$$$$") && !line.startsWith("M  END")) {
            if (line.startsWith("M  V30 BEGIN ATOM")) {
                line = this.processAtomBlock(reader);
                continue;
            }
            if (line.startsWith("M  V30 BEGIN BOND")) {
                line = this.processBondBlock(reader);
                continue;
            }
            if (line.startsWith("M  V30 BEGIN CTAB")) {
                if (startNewAtomSet) {
                    this.atomSetCollection.newAtomSet();
                }
            } else if (line.startsWith("M  V30 COUNTS")) {
                this.processCounts(line);
            }
            line = reader.readLine();
        }
        return line;
    }

    void processCounts(String line) {
        this.headerAtomCount = this.parseInt(line, 13);
        this.headerBondCount = this.parseInt(line, this.ichNextParse);
    }

    String processAtomBlock(BufferedReader reader) throws Exception {
        int i = this.headerAtomCount;
        while (--i >= 0) {
            String option;
            String line = this.readLineWithContinuation(reader);
            if (line == null || !line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized atom");
            }
            Atom atom = new Atom();
            atom.atomSerial = this.parseInt(line, 7);
            atom.elementSymbol = this.parseToken(line, this.ichNextParse);
            atom.x = this.parseFloat(line, this.ichNextParse);
            atom.y = this.parseFloat(line, this.ichNextParse);
            atom.z = this.parseFloat(line, this.ichNextParse);
            this.parseInt(line, this.ichNextParse);
            while ((option = this.parseToken(line, this.ichNextParse)) != null) {
                if (!option.startsWith("CHG=")) continue;
                atom.formalCharge = this.parseInt(option, 4);
            }
            this.atomSetCollection.addAtomWithMappedSerialNumber(atom);
        }
        String line = reader.readLine();
        if (line == null || !line.startsWith("M  V30 END ATOM")) {
            throw new Exception("M  V30 END ATOM not found");
        }
        return line;
    }

    String processBondBlock(BufferedReader reader) throws Exception {
        int i = this.headerBondCount;
        while (--i >= 0) {
            String line = this.readLineWithContinuation(reader);
            if (line == null || !line.startsWith("M  V30 ")) {
                throw new Exception("unrecognized bond");
            }
            this.parseInt(line, 7);
            int order = this.parseInt(line, this.ichNextParse);
            int atomSerial1 = this.parseInt(line, this.ichNextParse);
            int atomSerial2 = this.parseInt(line, this.ichNextParse);
            this.atomSetCollection.addNewBondWithMappedSerialNumbers(atomSerial1, atomSerial2, order);
        }
        String line = reader.readLine();
        if (line == null || !line.startsWith("M  V30 END BOND")) {
            throw new Exception("M  V30 END BOND not found");
        }
        return line;
    }

    String readLineWithContinuation(BufferedReader reader) throws Exception {
        String line = reader.readLine();
        if (line != null && line.length() > 7) {
            while (line.charAt(line.length() - 1) == '-') {
                String line2 = reader.readLine();
                if (line2 == null || !line.startsWith("M  V30 ")) {
                    throw new Exception("Invalid line continuation");
                }
                line = line + line2.substring(7);
            }
        }
        return line;
    }
}

