/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.viewer.AlphaMonomer;
import org.jmol.viewer.AlphaPolymer;
import org.jmol.viewer.AminoMonomer;
import org.jmol.viewer.AminoPolymer;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Closest;
import org.jmol.viewer.Group;
import org.jmol.viewer.Model;
import org.jmol.viewer.Monomer;
import org.jmol.viewer.NucleicMonomer;
import org.jmol.viewer.NucleicPolymer;
import org.jmol.viewer.PhosphorusMonomer;
import org.jmol.viewer.PhosphorusPolymer;

abstract class Polymer {
    Model model;
    Monomer[] monomers;
    int monomerCount;
    private int[] atomIndices;
    Point3f[] leadMidpoints;
    Vector3f[] wingVectors;
    private final Vector3f unitVectorX = new Vector3f(1.0f, 0.0f, 0.0f);
    int selectedMonomerCount;
    private static final BitSet bsNull = new BitSet();
    BitSet bsSelectedMonomers;

    Polymer(Monomer[] monomers) {
        this.monomers = monomers;
        int i = this.monomerCount = monomers.length;
        while (--i >= 0) {
            monomers[i].setPolymer(this);
        }
        this.model = monomers[0].chain.model;
        this.model.addPolymer(this);
    }

    static Polymer allocatePolymer(Group[] groups, int firstGroupIndex) {
        Monomer[] monomers = Polymer.getAminoMonomers(groups, firstGroupIndex);
        if (monomers != null) {
            return new AminoPolymer(monomers);
        }
        monomers = Polymer.getAlphaMonomers(groups, firstGroupIndex);
        if (monomers != null) {
            return new AlphaPolymer(monomers);
        }
        monomers = Polymer.getNucleicMonomers(groups, firstGroupIndex);
        if (monomers != null) {
            return new NucleicPolymer(monomers);
        }
        monomers = Polymer.getPhosphorusMonomers(groups, firstGroupIndex);
        if (monomers != null) {
            return new PhosphorusPolymer(monomers);
        }
        System.out.println("Polymer.allocatePolymer() ... why am I here?");
        throw new NullPointerException();
    }

    static Monomer[] getAlphaMonomers(Group[] groups, int firstGroupIndex) {
        Group group;
        AlphaMonomer previous = null;
        int count = 0;
        int i = firstGroupIndex;
        while (i < groups.length && (group = groups[i]) instanceof AlphaMonomer) {
            AlphaMonomer current = (AlphaMonomer)group;
            if (current.polymer != null || !current.isConnectedAfter(previous)) break;
            previous = current;
            ++i;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        Monomer[] monomers = new Monomer[count];
        for (int j = 0; j < count; ++j) {
            monomers[j] = (AlphaMonomer)groups[firstGroupIndex + j];
        }
        return monomers;
    }

    static Monomer[] getAminoMonomers(Group[] groups, int firstGroupIndex) {
        Group group;
        AminoMonomer previous = null;
        int count = 0;
        int i = firstGroupIndex;
        while (i < groups.length && (group = groups[i]) instanceof AminoMonomer) {
            AminoMonomer current = (AminoMonomer)group;
            if (current.polymer != null || !current.isConnectedAfter(previous)) break;
            previous = current;
            ++i;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        Monomer[] monomers = new Monomer[count];
        for (int j = 0; j < count; ++j) {
            monomers[j] = (AminoMonomer)groups[firstGroupIndex + j];
        }
        return monomers;
    }

    static Monomer[] getPhosphorusMonomers(Group[] groups, int firstGroupIndex) {
        Group group;
        PhosphorusMonomer previous = null;
        int count = 0;
        int i = firstGroupIndex;
        while (i < groups.length && (group = groups[i]) instanceof PhosphorusMonomer) {
            PhosphorusMonomer current = (PhosphorusMonomer)group;
            if (current.polymer != null || !current.isConnectedAfter(previous)) break;
            previous = current;
            ++i;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        Monomer[] monomers = new Monomer[count];
        for (int j = 0; j < count; ++j) {
            monomers[j] = (PhosphorusMonomer)groups[firstGroupIndex + j];
        }
        return monomers;
    }

    static Monomer[] getNucleicMonomers(Group[] groups, int firstGroupIndex) {
        Group group;
        NucleicMonomer previous = null;
        int count = 0;
        int i = firstGroupIndex;
        while (i < groups.length && (group = groups[i]) instanceof NucleicMonomer) {
            NucleicMonomer current = (NucleicMonomer)group;
            if (current.polymer != null || !current.isConnectedAfter(previous)) break;
            previous = current;
            ++i;
            ++count;
        }
        if (count == 0) {
            return null;
        }
        Monomer[] monomers = new Monomer[count];
        for (int j = 0; j < count; ++j) {
            monomers[j] = (NucleicMonomer)groups[firstGroupIndex + j];
        }
        return monomers;
    }

    int[] getLeadAtomIndices() {
        if (this.atomIndices == null) {
            this.atomIndices = new int[this.monomerCount];
            int i = this.monomerCount;
            while (--i >= 0) {
                this.atomIndices[i] = this.monomers[i].getLeadAtomIndex();
            }
        }
        return this.atomIndices;
    }

    int getIndex(Monomer monomer) {
        int i = this.monomerCount;
        while (--i >= 0 && this.monomers[i] != monomer) {
        }
        return i;
    }

    int getIndex(char chainID, int seqcode) {
        int i = this.monomerCount;
        while (--i >= 0 && (this.monomers[i].seqcode != seqcode || this.monomers[i].chain.chainID != chainID)) {
        }
        return i;
    }

    final Point3f getLeadPoint(int monomerIndex) {
        return this.monomers[monomerIndex].getLeadAtomPoint();
    }

    final Point3f getInitiatorPoint() {
        return this.monomers[0].getInitiatorAtom().point3f;
    }

    final Point3f getTerminatorPoint() {
        return this.monomers[this.monomerCount - 1].getTerminatorAtom().point3f;
    }

    final Atom getLeadAtom(int monomerIndex) {
        return this.monomers[monomerIndex].getLeadAtom();
    }

    void getLeadMidPoint(int groupIndex, Point3f midPoint) {
        if (groupIndex == this.monomerCount) {
            --groupIndex;
        } else if (groupIndex > 0) {
            midPoint.set(this.getLeadPoint(groupIndex));
            midPoint.add(this.getLeadPoint(groupIndex - 1));
            midPoint.scale(0.5f);
            return;
        }
        midPoint.set(this.getLeadPoint(groupIndex));
    }

    boolean hasWingPoints() {
        return false;
    }

    final Point3f getWingPoint(int polymerIndex) {
        return this.monomers[polymerIndex].getWingAtomPoint();
    }

    void addSecondaryStructure(byte type, char startChainID, int startSeqcode, char endChainID, int endSeqcode) {
    }

    void calculateStructures() {
    }

    boolean isNucleic() {
        return this.monomers[0].isNucleic();
    }

    void calcHydrogenBonds(BitSet bsA, BitSet bsB) {
    }

    Point3f[] getLeadMidpoints() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.leadMidpoints;
    }

    final Vector3f[] getWingVectors() {
        if (this.leadMidpoints == null) {
            this.calcLeadMidpointsAndWingVectors();
        }
        return this.wingVectors;
    }

    final void calcLeadMidpointsAndWingVectors() {
        int count = this.monomerCount;
        this.leadMidpoints = new Point3f[count + 1];
        this.wingVectors = new Vector3f[count + 1];
        boolean hasWingPoints = this.hasWingPoints();
        Vector3f vectorA = new Vector3f();
        Vector3f vectorB = new Vector3f();
        Vector3f vectorC = new Vector3f();
        Vector3f vectorD = new Vector3f();
        this.leadMidpoints[0] = this.getInitiatorPoint();
        Point3f leadPoint = this.getLeadPoint(0);
        Vector3f previousVectorD = null;
        for (int i = 1; i < count; ++i) {
            Point3f leadPointPrev = leadPoint;
            leadPoint = this.getLeadPoint(i);
            Point3f midpoint = new Point3f(leadPoint);
            midpoint.add(leadPointPrev);
            midpoint.scale(0.5f);
            this.leadMidpoints[i] = midpoint;
            if (!hasWingPoints) continue;
            vectorA.sub(leadPoint, leadPointPrev);
            vectorB.sub(leadPointPrev, this.getWingPoint(i - 1));
            vectorC.cross(vectorA, vectorB);
            vectorD.cross(vectorA, vectorC);
            vectorD.normalize();
            if (previousVectorD != null && (double)previousVectorD.angle(vectorD) > 1.5707963267948966) {
                vectorD.scale(-1.0f);
            }
            previousVectorD = this.wingVectors[i] = new Vector3f(vectorD);
        }
        this.leadMidpoints[count] = this.getTerminatorPoint();
        if (!hasWingPoints) {
            if (count < 3) {
                this.wingVectors[1] = this.unitVectorX;
            } else {
                Point3f prev = this.leadMidpoints[0];
                Point3f current = this.leadMidpoints[1];
                Vector3f previousVectorC = null;
                for (int i = 1; i < count; ++i) {
                    Point3f next = this.leadMidpoints[i + 1];
                    vectorA.sub(prev, current);
                    vectorB.sub(next, current);
                    vectorC.cross(vectorA, vectorB);
                    vectorC.normalize();
                    if (previousVectorC != null && (double)previousVectorC.angle(vectorC) > 1.5707963267948966) {
                        vectorC.scale(-1.0f);
                    }
                    previousVectorC = this.wingVectors[i] = new Vector3f(vectorC);
                    prev = current;
                    current = next;
                }
            }
        }
        this.wingVectors[0] = this.wingVectors[1];
        this.wingVectors[count] = this.wingVectors[count - 1];
    }

    void findNearestAtomIndex(int xMouse, int yMouse, Closest closest, short[] mads) {
        int i = this.monomerCount;
        while (--i >= 0) {
            if (mads[i] <= 0 && mads[i + 1] <= 0) continue;
            this.monomers[i].findNearestAtomIndex(xMouse, yMouse, closest, mads[i], mads[i + 1]);
        }
    }

    void calcSelectedMonomersCount(BitSet bsSelected) {
        this.selectedMonomerCount = 0;
        if (this.bsSelectedMonomers == null) {
            this.bsSelectedMonomers = new BitSet();
        } else {
            this.bsSelectedMonomers.and(bsNull);
        }
        int i = this.monomerCount;
        while (--i >= 0) {
            if (!this.monomers[i].isSelected(bsSelected)) continue;
            ++this.selectedMonomerCount;
            this.bsSelectedMonomers.set(i);
        }
    }

    int getSelectedMonomerIndex(Monomer monomer) {
        int selectedMonomerIndex = 0;
        for (int i = 0; i < this.monomerCount; ++i) {
            if (!this.bsSelectedMonomers.get(i)) continue;
            if (this.monomers[i] == monomer) {
                return selectedMonomerIndex;
            }
            ++selectedMonomerIndex;
        }
        return -1;
    }
}

