/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import javax.vecmath.Vector3f;
import org.jmol.util.Bmp;
import org.jmol.viewer.Atom;
import org.jmol.viewer.Sasurface;
import org.jmol.viewer.Sasurface1;
import org.jmol.viewer.Viewer;

class SasCache {
    final Viewer viewer;
    int atomCacheSize;
    int atomScreensLength;
    Point3i[][] atomCacheScreens;
    int[] atomCacheAtomIndexes;
    int atomCacheLruClock;
    int[] atomCacheLrus;
    Vector3f[] atomCacheTransformedGeodesicVectors;
    int torusCacheSize;
    int torusScreensLength;
    Point3i[][] torusCacheScreens;
    Sasurface1.Torus[] torusCacheToruses;
    int torusCacheLruClock;
    int[] torusCacheLrus;
    Vector3f[] torusCacheTransformedGeodesicVectors;
    static final int MAX_TORUS_POINTS = Sasurface.MAX_TORUS_POINTS;
    Point3f[] torusPointsT;

    SasCache(Viewer viewer, int atomCacheSize, int geodesicVertexCount) {
        this.viewer = viewer;
        this.allocAtomCache(atomCacheSize, geodesicVertexCount);
        this.allocTorusCache(2, MAX_TORUS_POINTS);
    }

    void clear() {
        this.clearAtomCache();
        this.clearTorusCache();
    }

    void allocAtomCache(int atomCacheSize, int geodesicVertexCount) {
        this.atomCacheSize = atomCacheSize;
        this.atomCacheScreens = new Point3i[atomCacheSize][];
        this.atomCacheAtomIndexes = new int[atomCacheSize];
        this.atomCacheLrus = new int[atomCacheSize];
        this.atomScreensLength = geodesicVertexCount;
        int i = atomCacheSize;
        while (--i >= 0) {
            this.atomCacheScreens[i] = this.allocScreens(this.atomScreensLength);
            this.atomCacheAtomIndexes[i] = -1;
            this.atomCacheLrus[i] = -1;
        }
        this.atomCacheLruClock = 0;
        this.atomCacheTransformedGeodesicVectors = this.viewer.g3d.getTransformedVertexVectors();
    }

    void clearAtomCache() {
        int i = this.atomCacheSize;
        while (--i >= 0) {
            this.atomCacheLrus[i] = -1;
            this.atomCacheAtomIndexes[i] = -1;
        }
    }

    void free() {
        int i = this.atomCacheSize;
        while (--i >= 0) {
            this.atomCacheScreens[i] = null;
            this.atomCacheAtomIndexes[i] = -1;
            this.atomCacheLrus[i] = -1;
        }
    }

    Point3i[] lookupAtomScreens(Atom atom, int[] vertexMap) {
        int atomIndex = atom.atomIndex;
        int i = this.atomCacheSize;
        while (--i >= 0) {
            if (this.atomCacheAtomIndexes[i] != atomIndex) continue;
            ++this.atomCacheLruClock;
            return this.atomCacheScreens[i];
        }
        int iOldest = 0;
        int lruOldest = this.atomCacheLrus[0];
        int i2 = this.atomCacheSize;
        while (--i2 > 0) {
            if (this.atomCacheLrus[i2] >= lruOldest) continue;
            lruOldest = this.atomCacheLrus[i2];
            iOldest = i2;
        }
        Point3i[] screens = this.atomCacheScreens[iOldest];
        this.calcAtomScreens(atom, vertexMap, screens);
        this.atomCacheAtomIndexes[iOldest] = atomIndex;
        ++this.atomCacheLruClock;
        return screens;
    }

    void touchAtomScreens(Point3i[] screens) {
        int i = this.atomCacheSize;
        while (--i >= 0) {
            if (screens != this.atomCacheScreens[i]) continue;
            ++this.atomCacheLruClock;
            return;
        }
        throw new NullPointerException();
    }

    void flushAtomScreens(Atom atom) {
        int atomIndex = atom.atomIndex;
        int i = this.atomCacheSize;
        while (--i >= 0) {
            if (this.atomCacheAtomIndexes[i] != atomIndex) continue;
            this.atomCacheAtomIndexes[i] = -1;
            this.atomCacheLrus[i] = -1;
            break;
        }
    }

    void calcAtomScreens(Atom atom, int[] vertexMap, Point3i[] screens) {
        float radius = atom.getVanderwaalsRadiusFloat();
        int atomX = atom.getScreenX();
        int atomY = atom.getScreenY();
        int atomZ = atom.getScreenZ();
        float scaledRadius = this.viewer.scaleToScreen(atomZ, radius);
        int v = -1;
        while ((v = Bmp.nextSetBit(vertexMap, v + 1)) >= 0) {
            Vector3f tv = this.atomCacheTransformedGeodesicVectors[v];
            Point3i screen = screens[v];
            screen.x = atomX + (int)(scaledRadius * tv.x);
            screen.y = atomY - (int)(scaledRadius * tv.y);
            screen.z = atomZ - (int)(scaledRadius * tv.z);
        }
    }

    void allocTorusCache(int torusCacheSize, int torusScreensLength) {
        this.torusCacheSize = torusCacheSize;
        this.torusScreensLength = torusScreensLength;
        this.torusCacheScreens = new Point3i[torusCacheSize][];
        this.torusCacheToruses = new Sasurface1.Torus[torusCacheSize];
        this.torusCacheLrus = new int[torusCacheSize];
        int i = torusCacheSize;
        while (--i >= 0) {
            this.torusCacheScreens[i] = this.allocScreens(torusScreensLength);
            this.torusCacheToruses[i] = null;
            this.torusCacheLrus[i] = -1;
        }
        this.torusCacheLruClock = 0;
        this.torusPointsT = this.allocPoints(MAX_TORUS_POINTS);
    }

    void clearTorusCache() {
        int i = this.torusCacheSize;
        while (--i >= 0) {
            this.torusCacheToruses[i] = null;
            this.torusCacheLrus[i] = -1;
        }
    }

    Point3i[] lookupTorusScreens(Sasurface1.Torus torus) {
        int i = this.torusCacheSize;
        while (--i >= 0) {
            if (this.torusCacheToruses[i] != torus) continue;
            ++this.torusCacheLruClock;
            return this.torusCacheScreens[i];
        }
        int iOldest = 0;
        int lruOldest = this.torusCacheLrus[0];
        int i2 = this.torusCacheSize;
        while (--i2 > 0) {
            if (this.torusCacheLrus[i2] >= lruOldest) continue;
            lruOldest = this.torusCacheLrus[i2];
            iOldest = i2;
        }
        Point3i[] screens = this.torusCacheScreens[iOldest];
        torus.calcPoints(this.torusPointsT);
        torus.calcScreens(this.torusPointsT, screens);
        this.torusCacheToruses[iOldest] = torus;
        ++this.torusCacheLruClock;
        return screens;
    }

    Point3f[] allocPoints(int count) {
        Point3f[] points = new Point3f[count];
        int i = count;
        while (--i >= 0) {
            points[i] = new Point3f();
        }
        return points;
    }

    Point3i[] allocScreens(int count) {
        Point3i[] screens = new Point3i[count];
        int i = count;
        while (--i >= 0) {
            screens[i] = new Point3i();
        }
        return screens;
    }
}

