/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.text.NumberFormat;
import javax.vecmath.Point3i;
import org.jmol.viewer.BbcageRenderer;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Uccage;

class UccageRenderer
extends ShapeRenderer {
    NumberFormat nf;
    byte fid;
    final Point3i[] screens = new Point3i[8];

    UccageRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.screens[i] = new Point3i();
        }
    }

    void initRenderer() {
        this.nf = NumberFormat.getInstance();
        this.fid = this.g3d.getFontFid("Monospaced", 12);
    }

    void render() {
        Uccage uccage = (Uccage)this.shape;
        short mad = uccage.mad;
        if (mad == 0 || !uccage.hasUnitcell) {
            return;
        }
        short colix = uccage.colix;
        if (colix == 0) {
            colix = 17;
        }
        BbcageRenderer.render(this.viewer, this.g3d, mad, colix, this.frame.unitcellVertices, this.screens);
        this.g3d.setFont(this.fid);
        this.nf.setMaximumFractionDigits(3);
        this.nf.setMinimumFractionDigits(3);
        this.g3d.drawString("a=" + this.nf.format(uccage.a) + "\u00c5", colix, 5, 15, 0);
        this.g3d.drawString("b=" + this.nf.format(uccage.b) + "\u00c5", colix, 5, 30, 0);
        this.g3d.drawString("c=" + this.nf.format(uccage.c) + "\u00c5", colix, 5, 45, 0);
        this.nf.setMaximumFractionDigits(1);
        this.g3d.drawString("\u03b1=" + this.nf.format(uccage.alpha) + "\u00b0", colix, 5, 60, 0);
        this.g3d.drawString("\u03b2=" + this.nf.format(uccage.beta) + "\u00b0", colix, 5, 75, 0);
        this.g3d.drawString("\u03b3=" + this.nf.format(uccage.gamma) + "\u00b0", colix, 5, 90, 0);
    }
}

