/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DataBufferInt;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import org.jmol.g3d.Platform3D;

final class Swing3D
extends Platform3D {
    static final ColorModel rgbColorModel = ColorModel.getRGBdefault();
    static final int[] sampleModelBitMasks = new int[]{0xFF0000, 65280, 255, -16777216};

    Swing3D() {
    }

    Image allocateImage() {
        SinglePixelPackedSampleModel sppsm = new SinglePixelPackedSampleModel(3, this.windowWidth, this.windowHeight, sampleModelBitMasks);
        DataBufferInt dbi = new DataBufferInt(this.pBuffer, this.windowSize);
        WritableRaster wr = Raster.createWritableRaster(sppsm, dbi, null);
        BufferedImage bi = new BufferedImage(rgbColorModel, wr, false, null);
        return bi;
    }

    Image allocateOffscreenImage(int width, int height) {
        return new BufferedImage(width, height, 1);
    }

    Graphics getGraphics(Image image) {
        BufferedImage bi = (BufferedImage)image;
        Graphics2D g2d = bi.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2d.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return g2d;
    }
}

