/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Bbcage;
import org.jmol.viewer.ShapeRenderer;
import org.jmol.viewer.Viewer;

class BbcageRenderer
extends ShapeRenderer {
    final Point3i[] screens = new Point3i[8];

    BbcageRenderer() {
        int i = 8;
        while (--i >= 0) {
            this.screens[i] = new Point3i();
        }
    }

    void render() {
        Bbcage bbcage = (Bbcage)this.shape;
        short mad = bbcage.mad;
        if (mad == 0) {
            return;
        }
        short colix = bbcage.colix;
        if (colix == 0) {
            colix = 17;
        }
        BbcageRenderer.render(this.viewer, this.g3d, mad, colix, this.frame.bboxVertices, this.screens);
    }

    static void render(Viewer viewer, Graphics3D g3d, short mad, short colix, Point3f[] vertices, Point3i[] screens) {
        int zSum = 0;
        int i = 8;
        while (--i >= 0) {
            viewer.transformPoint(vertices[i], screens[i]);
            zSum += screens[i].z;
        }
        short widthPixels = mad;
        if (mad >= 20) {
            widthPixels = viewer.scaleToScreen(zSum / 8, mad);
        }
        for (int i2 = 0; i2 < 24; i2 += 2) {
            if (mad < 0) {
                g3d.drawDottedLine(colix, screens[Bbcage.edges[i2]], screens[Bbcage.edges[i2 + 1]]);
                continue;
            }
            g3d.fillCylinder(colix, (byte)3, widthPixels, screens[Bbcage.edges[i2]], screens[Bbcage.edges[i2 + 1]]);
        }
    }
}

