/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.BitSet;
import javax.vecmath.Matrix3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Geodesic3D;
import org.jmol.g3d.Graphics3D;
import org.jmol.g3d.Shade3D;
import org.jmol.util.Bmp;

class Normix3D {
    static final int NORMIX_GEODESIC_LEVEL = 3;
    final Graphics3D g3d;
    final Vector3f[] transformedVectors;
    final byte[] intensities;
    final byte[] intensities2Sided;
    final int normixCount;
    static final int[] vertexCounts = new int[]{12, 42, 162, 642, 2562};
    static final short[][] faceNormixesArrays = new short[4][];
    private static final boolean TIMINGS = false;
    private static final boolean DEBUG_WITH_SEQUENTIAL_SEARCH = true;
    private final Matrix3f rotationMatrix = new Matrix3f();
    final BitSet bsNull = new BitSet();
    final BitSet bsConsidered = new BitSet();
    short[] inverseNormixes;
    private static final boolean DEBUG_FACE_VECTORS = false;

    Normix3D(Graphics3D g3d) {
        this.g3d = g3d;
        this.normixCount = Geodesic3D.getVertexCount(3);
        this.intensities = new byte[this.normixCount];
        this.intensities2Sided = new byte[this.normixCount];
        this.transformedVectors = new Vector3f[this.normixCount];
        int i = this.normixCount;
        while (--i >= 0) {
            this.transformedVectors[i] = new Vector3f();
        }
    }

    short getNormix(Vector3f v) {
        return this.getNormix(v.x, v.y, v.z, 3);
    }

    Vector3f getVector(short normix) {
        return Geodesic3D.vertexVectors[normix];
    }

    short getNormix(double x, double y, double z, int geodesicLevel) {
        double t;
        short champion;
        if (z >= 0.0) {
            champion = 0;
            t = z - 1.0;
        } else {
            champion = 11;
            t = z - -1.0;
        }
        this.bsConsidered.and(this.bsNull);
        this.bsConsidered.set(champion);
        double championDist2 = x * x + y * y + t * t;
        for (int lvl = 0; lvl <= geodesicLevel; ++lvl) {
            short[] neighborVertexes = Geodesic3D.neighborVertexesArrays[lvl];
            int offsetNeighbors = 6 * champion;
            int i = offsetNeighbors + (champion < 12 ? 5 : 6);
            while (--i >= offsetNeighbors) {
                short challenger = neighborVertexes[i];
                if (this.bsConsidered.get(challenger)) continue;
                this.bsConsidered.set(challenger);
                Vector3f v = Geodesic3D.vertexVectors[challenger];
                double d = (double)v.x - x;
                double d2 = d * d;
                if (d2 >= championDist2 || (d2 += (d = (double)v.y - y) * d) >= championDist2 || (d2 += (d = (double)v.z - z) * d) >= championDist2) continue;
                champion = challenger;
                championDist2 = d2;
            }
        }
        int champSeq = 0;
        double champSeqD2 = Normix3D.dist2(Geodesic3D.vertexVectors[champSeq], x, y, z);
        int k = vertexCounts[geodesicLevel];
        while (--k > 0) {
            double challengerD2 = Normix3D.dist2(Geodesic3D.vertexVectors[k], x, y, z);
            if (!(challengerD2 < champSeqD2)) continue;
            champSeq = k;
            champSeqD2 = challengerD2;
        }
        if (champion != champSeq && champSeqD2 + 0.01 < championDist2) {
            System.out.println("?que? getNormix is messed up?");
            boolean considered = this.bsConsidered.get(champSeq);
            System.out.println("Was the sequential winner considered? " + considered);
            System.out.println("champion " + champion + " @ " + championDist2 + " sequential champ " + champSeq + " @ " + champSeqD2 + "\n");
            return (short)champSeq;
        }
        return champion;
    }

    void calculateInverseNormixes() {
        this.inverseNormixes = new short[this.normixCount];
        int n = this.normixCount;
        while (--n >= 0) {
            Vector3f v = Geodesic3D.vertexVectors[n];
            this.inverseNormixes[n] = this.getNormix(-v.x, -v.y, -v.z, 3);
        }
        n = this.normixCount;
        while (--n >= 0) {
            if (this.inverseNormixes[this.inverseNormixes[n]] == n) continue;
            throw new NullPointerException();
        }
    }

    byte getIntensity(short normix) {
        if (normix < 0) {
            return this.intensities2Sided[~normix];
        }
        return this.intensities[normix];
    }

    void setRotationMatrix(Matrix3f rotationMatrix) {
        this.rotationMatrix.set(rotationMatrix);
        int i = this.normixCount;
        while (--i >= 0) {
            byte intensity;
            Vector3f tv = this.transformedVectors[i];
            rotationMatrix.transform(Geodesic3D.vertexVectors[i], tv);
            float x = tv.x;
            float y = -tv.y;
            float z = tv.z;
            this.intensities[i] = intensity = Shade3D.calcIntensityNormalized(x, y, z);
            if (z >= 0.0f) {
                this.intensities2Sided[i] = intensity;
                continue;
            }
            this.intensities2Sided[i] = Shade3D.calcIntensityNormalized(-x, -y, -z);
        }
    }

    Vector3f[] getTransformedVectors() {
        return this.transformedVectors;
    }

    short[] getFaceNormixes(int level) {
        short[] faceNormixes = faceNormixesArrays[level];
        if (faceNormixes != null) {
            return faceNormixes;
        }
        return this.calcFaceNormixes(level);
    }

    static double dist2(Vector3f v1, Vector3f v2) {
        double dx = v1.x - v2.x;
        double dy = v1.y - v2.y;
        double dz = v1.z - v2.z;
        return dx * dx + dy * dy + dz * dz;
    }

    static double dist2(Vector3f v1, double x, double y, double z) {
        double dx = (double)v1.x - x;
        double dy = (double)v1.y - y;
        double dz = (double)v1.z - z;
        return dx * dx + dy * dy + dz * dz;
    }

    private synchronized short[] calcFaceNormixes(int level) {
        short[] faceNormixes = faceNormixesArrays[level];
        if (faceNormixes != null) {
            return faceNormixes;
        }
        Vector3f t = new Vector3f();
        short[] faceVertexes = Geodesic3D.faceVertexesArrays[level];
        int j = faceVertexes.length;
        int faceCount = j / 3;
        faceNormixes = new short[faceCount];
        int i = faceCount;
        while (--i >= 0) {
            short normix;
            Vector3f vA = Geodesic3D.vertexVectors[faceVertexes[--j]];
            Vector3f vB = Geodesic3D.vertexVectors[faceVertexes[--j]];
            Vector3f vC = Geodesic3D.vertexVectors[faceVertexes[--j]];
            t.add(vA, vB);
            t.add(vC);
            faceNormixes[i] = normix = this.getNormix(t);
        }
        Normix3D.faceNormixesArrays[level] = faceNormixes;
        return faceNormixes;
    }

    boolean isDirectedTowardsCamera(short normix) {
        return normix < 0 || this.transformedVectors[normix].z > 0.0f;
    }

    short getVisibleNormix(double x, double y, double z, int[] visibilityBitmap, int level) {
        int maxVisible;
        int minMapped = Bmp.getMinMappedBit(visibilityBitmap);
        if (minMapped < 0) {
            return -1;
        }
        int maxMapped = Bmp.getMaxMappedBit(visibilityBitmap);
        int max = maxMapped < (maxVisible = Geodesic3D.vertexCounts[level]) ? maxMapped : maxVisible;
        int champion = minMapped;
        Vector3f v = Geodesic3D.vertexVectors[champion];
        double d = x - (double)v.x;
        double championDist2 = d * d;
        d = y - (double)v.y;
        championDist2 += d * d;
        d = z - (double)v.z;
        championDist2 += d * d;
        for (int challenger = minMapped + 1; challenger < max; ++challenger) {
            double challengerDist2;
            if (!Bmp.getBit(visibilityBitmap, challenger) || !((challengerDist2 = Normix3D.dist2(Geodesic3D.vertexVectors[challenger], x, y, z)) < championDist2)) continue;
            champion = challenger;
            championDist2 = challengerDist2;
        }
        if (!Bmp.getBit(visibilityBitmap, champion)) {
            throw new IndexOutOfBoundsException();
        }
        return (short)champion;
    }
}

