/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.util.BitSet;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;
import org.jmol.g3d.Graphics3D;
import org.jmol.viewer.Atom;
import org.jmol.viewer.AtomIterator;
import org.jmol.viewer.Bond;
import org.jmol.viewer.SelectionIndependentShape;
import org.jmol.viewer.Util;

class Polyhedra
extends SelectionIndependentShape {
    static final float DEFAULT_CENTRAL_ANGLE_MAX = 2.5307274f;
    static final float DEFAULT_FACE_NORMAL_MAX = 0.5235988f;
    static final float DEFAULT_FACE_CENTER_OFFSET = 0.25f;
    static final int EDGES_NONE = 0;
    static final int EDGES_ALL = 1;
    static final int EDGES_FRONT = 2;
    static final int MINIMUM_ACCEPTABLE_VERTEX_COUNT = 3;
    static final int MAXIMUM_ACCEPTABLE_VERTEX_COUNT = 20;
    static final int FACE_COUNT_MAX = 85;
    static final boolean debugging = false;
    int polyhedronCount;
    Polyhedron[] polyhedrons = new Polyhedron[32];
    float radius;
    int acceptableVertexCountCount = 0;
    int[] acceptableVertexCounts = new int[8];
    float faceCenterOffset;
    float centralAngleMax;
    float faceNormalMax;
    int drawEdges;
    boolean isCollapsed;
    BitSet bsCenters;
    BitSet bsVertices;
    int potentialVertexCount;
    Atom[] potentialVertexAtoms = new Atom[20];
    private final Vector3f normalT = new Vector3f();
    final short[] normixesT = new short[85];
    final byte[] planesT = new byte[255];
    final short[] collapsedNormixesT = new short[255];
    final Point3f[] collapsedCentersT = new Point3f[85];
    final Vector3f[] centerVectors = new Vector3f[255];
    private final Vector3f centerSum = new Vector3f();
    private final Point3f ptT;
    private final Point3f ptT2;

    Polyhedra() {
        int i = this.collapsedCentersT.length;
        while (--i >= 0) {
            this.collapsedCentersT[i] = new Point3f();
        }
        this.ptT = new Point3f();
        this.ptT2 = new Point3f();
    }

    void initShape() {
    }

    void setProperty(String propertyName, Object value, BitSet bs) {
        if ("init" == propertyName) {
            this.faceCenterOffset = 0.25f;
            this.centralAngleMax = 2.5307274f;
            this.faceNormalMax = 0.5235988f;
            this.radius = 0.0f;
            this.acceptableVertexCountCount = 0;
            this.bsVertices = null;
            this.bsCenters = null;
            this.isCollapsed = false;
            this.drawEdges = 0;
            return;
        }
        if ("radius" == propertyName) {
            if (value instanceof Float) {
                this.radius = ((Float)value).floatValue();
            } else {
                this.invalidPropertyType(propertyName, value, "Float");
            }
            return;
        }
        if ("bonds" == propertyName) {
            this.radius = 0.0f;
            return;
        }
        if ("vertexCount" == propertyName) {
            if (value instanceof Integer) {
                int vertexCount;
                if (this.acceptableVertexCountCount < this.acceptableVertexCounts.length && (vertexCount = ((Integer)value).intValue()) >= 3 && vertexCount <= 20) {
                    this.acceptableVertexCounts[this.acceptableVertexCountCount++] = vertexCount;
                }
            } else {
                this.invalidPropertyType(propertyName, value, "Integer");
            }
            return;
        }
        if ("potentialCenterSet" == propertyName) {
            if (value instanceof BitSet) {
                this.bsCenters = (BitSet)value;
            } else {
                this.invalidPropertyType(propertyName, value, "BitSet");
            }
            return;
        }
        if ("potentialVertexSet" == propertyName) {
            if (value instanceof BitSet) {
                this.bsVertices = (BitSet)value;
            } else {
                this.invalidPropertyType(propertyName, value, "BitSet");
            }
            return;
        }
        if ("faceCenterOffset" == propertyName) {
            if (value instanceof Float) {
                this.faceCenterOffset = ((Float)value).floatValue();
            } else {
                this.invalidPropertyType(propertyName, value, "Float");
            }
            return;
        }
        if ("centerAngleMax" == propertyName) {
            if (value instanceof Float) {
                this.centralAngleMax = ((Float)value).floatValue() / 180.0f * 3.1415925f;
            } else {
                this.invalidPropertyType(propertyName, value, "Float");
            }
            return;
        }
        if ("faceNormalMax" == propertyName) {
            if (value instanceof Float) {
                this.faceNormalMax = ((Float)value).floatValue() / 180.0f * 3.1415925f;
            } else {
                this.invalidPropertyType(propertyName, value, "Float");
            }
            return;
        }
        if ("generate" == propertyName) {
            if (this.bsCenters == null) {
                this.bsCenters = bs;
            }
            this.buildPolyhedra();
            return;
        }
        if ("collapsed" == propertyName) {
            if (this.bsCenters == null) {
                this.bsCenters = bs;
            }
            this.isCollapsed = value == Boolean.TRUE;
            this.setCollapsed(this.isCollapsed, this.bsCenters);
            return;
        }
        if ("delete" == propertyName) {
            if (this.bsCenters == null) {
                this.bsCenters = bs;
            }
            this.deletePolyhedra(this.bsCenters);
            return;
        }
        if ("on" == propertyName) {
            if (this.bsCenters == null) {
                this.bsCenters = bs;
            }
            this.setVisible(true, this.bsCenters);
            return;
        }
        if ("off" == propertyName) {
            if (this.bsCenters == null) {
                this.bsCenters = bs;
            }
            this.setVisible(false, this.bsCenters);
            return;
        }
        if ("noedges" == propertyName) {
            this.drawEdges = 0;
            if (this.bsCenters == null) {
                this.bsCenters = bs;
            }
            this.setEdges(this.drawEdges, this.bsCenters);
            return;
        }
        if ("edges" == propertyName) {
            this.drawEdges = 1;
            if (this.bsCenters == null) {
                this.bsCenters = bs;
            }
            this.setEdges(this.drawEdges, this.bsCenters);
            return;
        }
        if ("frontedges" == propertyName) {
            this.drawEdges = 2;
            if (this.bsCenters == null) {
                this.bsCenters = bs;
            }
            this.setEdges(this.drawEdges, this.bsCenters);
            return;
        }
        if ("color" == propertyName) {
            this.colix = Graphics3D.getColix(value);
            this.setColix(this.colix, this.colix != 3 ? null : (String)value, bs);
            return;
        }
        if ("translucency" == propertyName) {
            this.setTranslucent("translucent" == value, bs);
            return;
        }
        super.setProperty(propertyName, value, bs);
    }

    void deletePolyhedra(BitSet bs) {
        int i;
        int newCount = 0;
        for (i = 0; i < this.polyhedronCount; ++i) {
            Polyhedron p = this.polyhedrons[i];
            if (bs.get(p.centralAtom.atomIndex)) continue;
            this.polyhedrons[newCount++] = p;
        }
        for (i = newCount; i < this.polyhedronCount; ++i) {
            this.polyhedrons[i] = null;
        }
        this.polyhedronCount = newCount;
    }

    void setVisible(boolean visible, BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !bs.get(p.centralAtom.atomIndex)) continue;
            p.visible = visible;
        }
    }

    void setEdges(int edges, BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !bs.get(p.centralAtom.atomIndex)) continue;
            p.edges = edges;
        }
    }

    void setCollapsed(boolean isCollapsed, BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !bs.get(p.centralAtom.atomIndex)) continue;
            p.collapsed = isCollapsed;
        }
    }

    void setColix(short colix, String palette, BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            int atomIndex;
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !bs.get(atomIndex = p.centralAtom.atomIndex)) continue;
            p.polyhedronColix = colix != 3 ? colix : this.viewer.getColixAtomPalette(this.frame.getAtomAt(atomIndex), palette);
        }
    }

    void setTranslucent(boolean isTranslucent, BitSet bs) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            Polyhedron p = this.polyhedrons[i];
            if (p == null || !bs.get(p.centralAtom.atomIndex)) continue;
            p.polyhedronColix = Graphics3D.setTranslucent(p.polyhedronColix, isTranslucent);
        }
    }

    void savePolyhedron(Polyhedron p) {
        int i = this.polyhedronCount;
        while (--i >= 0) {
            if (!p.isSimilarEnoughToDelete(this.polyhedrons[i])) continue;
            this.polyhedrons[i] = p;
            return;
        }
        if (this.polyhedronCount == this.polyhedrons.length) {
            this.polyhedrons = (Polyhedron[])Util.doubleLength(this.polyhedrons);
        }
        this.polyhedrons[this.polyhedronCount++] = p;
    }

    void buildPolyhedra() {
        int i = this.frame.atomCount;
        while (--i >= 0) {
            Polyhedron p;
            if (!this.bsCenters.get(i) || (p = this.constructPolyhedron(i)) == null) continue;
            this.savePolyhedron(p);
        }
    }

    Polyhedron constructPolyhedron(int atomIndex) {
        Atom atom = this.frame.getAtomAt(atomIndex);
        if (this.radius > 0.0f) {
            this.identifyPotentialRadiusVertices(atom);
        } else {
            this.identifyPotentialBondsVertices(atom);
        }
        if (this.acceptableVertexCountCount == 0) {
            return this.validatePolyhedronNew(atom, this.potentialVertexCount, this.potentialVertexAtoms);
        }
        if (this.potentialVertexCount >= 3) {
            int i = this.acceptableVertexCountCount;
            while (--i >= 0) {
                if (this.potentialVertexCount != this.acceptableVertexCounts[i]) continue;
                return this.validatePolyhedronNew(atom, this.potentialVertexCount, this.potentialVertexAtoms);
            }
        }
        return null;
    }

    void identifyPotentialBondsVertices(Atom atom) {
        this.potentialVertexCount = 0;
        Bond[] bonds = atom.bonds;
        if (bonds == null) {
            return;
        }
        int i = bonds.length;
        while (--i >= 0) {
            Atom otherAtom;
            Bond bond = bonds[i];
            Atom atom2 = otherAtom = bond.atom1 == atom ? bond.atom2 : bond.atom1;
            if (this.bsVertices != null && !this.bsVertices.get(otherAtom.atomIndex)) continue;
            if (this.potentialVertexCount == this.potentialVertexAtoms.length) break;
            this.potentialVertexAtoms[this.potentialVertexCount++] = otherAtom;
        }
    }

    void identifyPotentialRadiusVertices(Atom atom) {
        this.potentialVertexCount = 0;
        AtomIterator withinIterator = this.frame.getWithinModelIterator(atom, this.radius);
        while (withinIterator.hasNext()) {
            Atom otherAtom = withinIterator.next();
            if (otherAtom == atom || this.bsVertices != null && !this.bsVertices.get(otherAtom.atomIndex)) continue;
            if (this.potentialVertexCount == this.potentialVertexAtoms.length) break;
            this.potentialVertexAtoms[this.potentialVertexCount++] = otherAtom;
        }
    }

    Polyhedron validatePolyhedronNew(Atom centralAtom, int vertexCount, Atom[] otherAtoms) {
        int faceCount = 0;
        Point3f centralAtomPoint = centralAtom.point3f;
        int i = vertexCount;
        while (--i >= 0) {
            this.centerVectors[i] = new Vector3f(otherAtoms[i].point3f);
            this.centerVectors[i].sub(centralAtomPoint);
        }
        block1: for (i = 0; i < vertexCount - 2; ++i) {
            for (int j = i + 1; j < vertexCount - 1; ++j) {
                if (this.centerVectors[i].angle(this.centerVectors[j]) > this.centralAngleMax) continue;
                for (int k = j + 1; k < vertexCount; ++k) {
                    if (this.centerVectors[i].angle(this.centerVectors[k]) > this.centralAngleMax || this.centerVectors[j].angle(this.centerVectors[k]) > this.centralAngleMax) continue;
                    Point3f pointI = otherAtoms[i].point3f;
                    Point3f pointJ = otherAtoms[j].point3f;
                    Point3f pointK = otherAtoms[k].point3f;
                    this.getNormalFromCenter(centralAtomPoint, pointI, pointJ, pointK, false, this.normalT);
                    this.centerSum.add(this.centerVectors[i], this.centerVectors[j]);
                    this.centerSum.add(this.centerVectors[k]);
                    if (this.centerSum.angle(this.normalT) > this.faceNormalMax) continue;
                    this.planesT[3 * faceCount + 0] = (byte)i;
                    this.planesT[3 * faceCount + 1] = (byte)j;
                    this.planesT[3 * faceCount + 2] = (byte)k;
                    this.normixesT[faceCount] = this.g3d.getNormix(this.normalT);
                    Point3f collapsedCenter = this.collapsedCentersT[faceCount];
                    collapsedCenter.scaleAdd(this.faceCenterOffset, this.normalT, centralAtomPoint);
                    this.getNormalFromCenter(pointI, collapsedCenter, pointJ, pointK, true, this.normalT);
                    this.collapsedNormixesT[3 * faceCount + 0] = this.g3d.getNormix(this.normalT);
                    this.getNormalFromCenter(pointJ, pointI, collapsedCenter, pointK, true, this.normalT);
                    this.collapsedNormixesT[3 * faceCount + 1] = this.g3d.getNormix(this.normalT);
                    this.getNormalFromCenter(pointK, pointI, pointJ, collapsedCenter, true, this.normalT);
                    this.collapsedNormixesT[3 * faceCount + 2] = this.g3d.getNormix(this.normalT);
                    if (++faceCount == 85) break block1;
                }
            }
        }
        if (faceCount < 1) {
            return null;
        }
        return new Polyhedron(centralAtom, vertexCount, otherAtoms, faceCount, this.normixesT, this.planesT, this.collapsedCentersT, this.collapsedNormixesT);
    }

    void getNormalFromCenter(Point3f ptCenter, Point3f ptA, Point3f ptB, Point3f ptC, boolean isCollapsed, Vector3f normal) {
        this.g3d.calcNormalizedNormal(ptA, ptB, ptC, normal);
        this.ptT.add(ptA, ptB);
        this.ptT.add(ptC);
        this.ptT.scale(0.33333334f);
        this.ptT2.set(normal);
        this.ptT2.scale(0.1f);
        this.ptT2.add(this.ptT);
        if (!isCollapsed && ptCenter.distance(this.ptT2) < ptCenter.distance(this.ptT) || isCollapsed && ptCenter.distance(this.ptT) < ptCenter.distance(this.ptT2)) {
            normal.scale(-1.0f);
        }
    }

    class Polyhedron {
        final Atom centralAtom;
        final int vertexCount;
        final Atom[] vertexAtoms;
        final int faceCount;
        final short[] normixes;
        final byte[] planes;
        final Point3f[] collapsedCenters;
        final short[] collapsedNormixes;
        boolean visible;
        short polyhedronColix;
        boolean collapsed;
        int edges;

        Polyhedron(Atom centralAtom, int vertexCount, Atom[] vertexAtoms, int faceCount, short[] normixes, byte[] planes, Point3f[] collapsedCenters, short[] collapsedNormixes) {
            System.out.println("new Polyhedron vertexCount = " + vertexCount + ";" + " faceCount = " + faceCount);
            this.centralAtom = centralAtom;
            this.vertexCount = vertexCount;
            this.vertexAtoms = new Atom[vertexCount];
            int i = vertexCount;
            while (--i >= 0) {
                this.vertexAtoms[i] = vertexAtoms[i];
            }
            this.faceCount = faceCount;
            this.normixes = new short[faceCount];
            this.collapsedCenters = new Point3f[faceCount];
            i = faceCount;
            while (--i >= 0) {
                this.normixes[i] = normixes[i];
                this.collapsedCenters[i] = new Point3f(collapsedCenters[i]);
            }
            this.planes = new byte[faceCount * 3];
            this.collapsedNormixes = new short[faceCount * 3];
            i = faceCount * 3;
            while (--i >= 0) {
                this.planes[i] = planes[i];
                this.collapsedNormixes[i] = collapsedNormixes[i];
            }
            this.visible = true;
            this.polyhedronColix = 0;
            this.collapsed = Polyhedra.this.isCollapsed;
            this.edges = Polyhedra.this.drawEdges;
        }

        boolean isSimilarEnoughToDelete(Polyhedron p) {
            return this.centralAtom == p.centralAtom && this.faceCount == p.faceCount;
        }
    }
}

