/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;

class AtomSetCollection {
    String fileTypeName;
    String collectionName;
    Properties atomSetCollectionProperties = new Properties();
    Hashtable atomSetCollectionAuxiliaryInfo = new Hashtable();
    static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    static final String[] dictRefUnitcellTags = new String[]{"cif:_cell_length_a", "cif:_cell_length_b", "cif:cell_length_c", "cif:_cell_length_alpha", "cif:_cell_length_beta", "cif:_cell_length_gamma"};
    int atomCount;
    Atom[] atoms = new Atom[256];
    int bondCount;
    Bond[] bonds = new Bond[256];
    int structureCount;
    Structure[] structures = new Structure[16];
    int atomSetCount;
    int currentAtomSetIndex = -1;
    int[] atomSetNumbers = new int[16];
    String[] atomSetNames = new String[16];
    int[] atomSetAtomCounts = new int[16];
    Properties[] atomSetProperties = new Properties[16];
    Hashtable[] atomSetAuxiliaryInfo = new Hashtable[16];
    String errorMessage;
    String spaceGroup;
    float wavelength = Float.NaN;
    boolean coordinatesAreFractional;
    float[] notionalUnitcell;
    float[] pdbScaleMatrix;
    float[] pdbScaleTranslate;
    String[] pdbStructureRecords;
    Hashtable atomSymbolicMap = new Hashtable();

    AtomSetCollection(String fileTypeName) {
        this.fileTypeName = fileTypeName;
        ((Hashtable)this.atomSetCollectionProperties).put("PATH_KEY", ".PATH");
        ((Hashtable)this.atomSetCollectionProperties).put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
    }

    AtomSetCollection(AtomSetCollection[] array) {
        this("Array");
        for (int i = 0; i < array.length; ++i) {
            this.appendAtomSetCollection(array[i]);
        }
    }

    protected void appendAtomSetCollection(AtomSetCollection collection) {
        int existingAtomsCount = this.atomCount;
        int clonedAtoms = 0;
        for (int atomSetNum = 0; atomSetNum < collection.atomSetCount; ++atomSetNum) {
            this.newAtomSet();
            this.setAtomSetName(collection.getAtomSetName(atomSetNum));
            Properties properties = collection.getAtomSetProperties(atomSetNum);
            if (properties != null) {
                Enumeration props = ((Hashtable)properties).keys();
                while (props != null && props.hasMoreElements()) {
                    String key = (String)props.nextElement();
                    this.setAtomSetProperty(key, properties.getProperty(key));
                }
            }
            for (int atomNum = 0; atomNum < collection.atomSetAtomCounts[atomSetNum]; ++atomNum) {
                this.newCloneAtom(collection.atoms[clonedAtoms]);
                ++clonedAtoms;
            }
        }
        for (int bondNum = 0; bondNum < collection.bondCount; ++bondNum) {
            Bond bond = collection.bonds[bondNum];
            this.addNewBond(bond.atomIndex1 + existingAtomsCount, bond.atomIndex2 + existingAtomsCount, bond.order);
        }
    }

    protected void finalize() {
        try {
            super.finalize();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    void finish() {
        this.atoms = null;
        this.bonds = null;
        this.pdbScaleTranslate = null;
        this.pdbScaleMatrix = null;
        this.notionalUnitcell = null;
        this.pdbStructureRecords = null;
    }

    void freeze() {
        System.out.println("AtomSetCollection.freeze; atomCount = " + this.atomCount);
        if (this.hasAlternateLocations()) {
            this.hackAlternateLocationDamage();
        }
    }

    void discardPreviousAtoms() {
        int i = this.atomCount;
        while (--i >= 0) {
            this.atoms[i] = null;
        }
        this.atomCount = 0;
        this.atomSymbolicMap.clear();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        i = this.atomSetNumbers.length;
        while (--i >= 0) {
            this.atomSetAtomCounts[i] = 0;
            this.atomSetNumbers[i] = 0;
            this.atomSetNames[i] = null;
        }
    }

    Atom newCloneAtom(Atom atom) {
        Atom clone = atom.cloneAtom();
        this.addAtom(clone);
        return clone;
    }

    void cloneFirstAtomSet() {
        this.newAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int i = 0; i < firstCount; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    void cloneFirstAtomSetWithBonds(int nBonds) {
        this.cloneFirstAtomSet();
        int firstCount = this.atomSetAtomCounts[0];
        for (int bondNum = 0; bondNum < nBonds; ++bondNum) {
            Bond bond = this.bonds[this.bondCount - nBonds];
            this.addNewBond(bond.atomIndex1 + firstCount, bond.atomIndex2 + firstCount, bond.order);
        }
    }

    void cloneLastAtomSet() {
        int count = this.getLastAtomSetAtomCount();
        int atomIndex = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        while (--count >= 0) {
            this.newCloneAtom(this.atoms[atomIndex]);
            ++atomIndex;
        }
    }

    int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = (Atom[])AtomSetCollectionReader.doubleLength(this.atoms);
        }
        this.atoms[this.atomCount++] = atom;
        if (this.atomSetCount == 0) {
            this.atomSetCount = 1;
            this.currentAtomSetIndex = 0;
            this.atomSetNumbers[0] = 1;
        }
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        this.atomSetAtomCounts[n] = this.atomSetAtomCounts[n] + 1;
    }

    void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    Bond addNewBond(int atomIndex1, int atomIndex2) {
        return this.addNewBond(atomIndex1, atomIndex2, 1);
    }

    Bond addNewBond(String atomName1, String atomName2) {
        return this.addNewBond(atomName1, atomName2, 1);
    }

    Bond addNewBond(int atomIndex1, int atomIndex2, int order) {
        if (atomIndex1 < 0 || atomIndex1 >= this.atomCount || atomIndex2 < 0 || atomIndex2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(atomIndex1, atomIndex2, order);
        this.addBond(bond);
        return bond;
    }

    Bond addNewBond(String atomName1, String atomName2, int order) {
        return this.addNewBond(this.getAtomNameIndex(atomName1), this.getAtomNameIndex(atomName2), order);
    }

    Bond addNewBondWithMappedSerialNumbers(int atomSerial1, int atomSerial2, int order) {
        return this.addNewBond(this.getAtomSerialNumberIndex(atomSerial1), this.getAtomSerialNumberIndex(atomSerial2), order);
    }

    void addBond(Bond bond) {
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order <= 0) {
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])AtomSetCollectionReader.setLength(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
    }

    void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])AtomSetCollectionReader.setLength(this.structures, this.structureCount + 32);
        }
        this.structures[this.structureCount++] = structure;
    }

    void setCollectionName(String collectionName) {
        if (collectionName != null && (collectionName = collectionName.trim()).length() > 0) {
            this.collectionName = collectionName;
        }
    }

    void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            String atomName = this.atoms[index].atomName;
            if (atomName != null) {
                this.atomSymbolicMap.put(atomName, new Integer(index));
            }
        }
    }

    void mapMostRecentAtomSerialNumber() {
        if (this.atomCount > 0) {
            int index = this.atomCount - 1;
            int atomSerial = this.atoms[index].atomSerial;
            if (atomSerial != Integer.MIN_VALUE) {
                this.atomSymbolicMap.put(new Integer(atomSerial), new Integer(index));
            }
        }
    }

    void mapAtomName(String atomName, int atomIndex) {
        this.atomSymbolicMap.put(atomName, new Integer(atomIndex));
    }

    int getAtomNameIndex(String atomName) {
        int index = -1;
        Object value = this.atomSymbolicMap.get(atomName);
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    int getAtomSerialNumberIndex(int serialNumber) {
        int index = -1;
        Object value = this.atomSymbolicMap.get(new Integer(serialNumber));
        if (value != null) {
            index = (Integer)value;
        }
        return index;
    }

    void setAtomSetCollectionProperty(String key, String value) {
        ((Hashtable)this.atomSetCollectionProperties).put(key, value);
    }

    String getAtomSetCollectionProperty(String key) {
        return (String)((Hashtable)this.atomSetCollectionProperties).get(key);
    }

    void setAtomSetCollectionAuxiliaryInfo(String key, Object value) {
        this.atomSetCollectionAuxiliaryInfo.put(key, value);
    }

    Object getAtomSetCollectionAuxiliaryInfo(String key) {
        return this.atomSetCollectionAuxiliaryInfo.get(key);
    }

    void newAtomSet() {
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = AtomSetCollectionReader.doubleLength(this.atomSetNumbers);
            this.atomSetNames = AtomSetCollectionReader.doubleLength(this.atomSetNames);
            this.atomSetAtomCounts = AtomSetCollectionReader.doubleLength(this.atomSetAtomCounts);
            this.atomSetProperties = (Properties[])AtomSetCollectionReader.doubleLength(this.atomSetProperties);
            this.atomSetAuxiliaryInfo = (Hashtable[])AtomSetCollectionReader.doubleLength(this.atomSetAuxiliaryInfo);
        }
        this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        this.atomSymbolicMap.clear();
    }

    void setAtomSetName(String atomSetName) {
        this.atomSetNames[this.currentAtomSetIndex] = atomSetName;
    }

    void setAtomSetName(String atomSetName, int atomSetIndex) {
        this.atomSetNames[atomSetIndex] = atomSetName;
    }

    void setAtomSetNames(String atomSetName, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetName(atomSetName, idx);
            --idx;
        }
    }

    void setAtomSetNumber(int atomSetNumber) {
        this.atomSetNumbers[this.currentAtomSetIndex] = atomSetNumber;
    }

    void setAtomSetProperty(String key, String value) {
        this.setAtomSetProperty(key, value, this.currentAtomSetIndex);
    }

    void setAtomSetAuxiliaryInfo(String key, Object value) {
        this.setAtomSetAuxiliaryInfo(key, value, this.currentAtomSetIndex);
    }

    void setAtomSetProperty(String key, String value, int atomSetIndex) {
        if (this.atomSetProperties[atomSetIndex] == null) {
            this.atomSetProperties[atomSetIndex] = new Properties();
        }
        ((Hashtable)this.atomSetProperties[atomSetIndex]).put(key, value);
    }

    void setAtomSetAuxiliaryInfo(String key, Object value, int atomSetIndex) {
        if (this.atomSetAuxiliaryInfo[atomSetIndex] == null) {
            this.atomSetAuxiliaryInfo[atomSetIndex] = new Hashtable();
        }
        this.atomSetAuxiliaryInfo[atomSetIndex].put(key, value);
    }

    void setAtomSetProperties(String key, String value, int n) {
        int idx = this.currentAtomSetIndex;
        while (--n >= 0) {
            this.setAtomSetProperty(key, value, idx);
            --idx;
        }
    }

    void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int index) {
        this.atomSetProperties[this.currentAtomSetIndex] = (Properties)((Hashtable)this.atomSetProperties[index]).clone();
    }

    int getAtomSetNumber(int atomSetIndex) {
        return this.atomSetNumbers[atomSetIndex];
    }

    String getAtomSetName(int atomSetIndex) {
        return this.atomSetNames[atomSetIndex];
    }

    Properties getAtomSetProperties(int atomSetIndex) {
        return this.atomSetProperties[atomSetIndex];
    }

    Hashtable getAtomSetAuxiliaryInfo(int atomSetIndex) {
        return this.atomSetAuxiliaryInfo[atomSetIndex];
    }

    boolean hasAlternateLocations() {
        int i = this.atomCount;
        while (--i >= 0) {
            if (this.atoms[i].alternateLocationID == '\u0000') continue;
            return true;
        }
        return false;
    }

    void hackAlternateLocationDamage() {
        System.out.println("hacking alternate location damage");
    }
}

