/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.io.BufferedReader;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Strand;
import org.jmol.adapter.smarter.Structure;

class CifReader
extends AtomSetCollectionReader {
    float[] notionalUnitcell;
    BufferedReader reader;
    String line;
    RidiculousFileFormatTokenizer tokenizer = new RidiculousFileFormatTokenizer();
    Map strandsMap;
    static final String[] cellParamNames = new String[]{"_cell_length_a", "_cell_length_b", "_cell_length_c", "_cell_angle_alpha", "_cell_angle_beta", "_cell_angle_gamma"};
    static final byte NONE = 0;
    static final byte TYPE_SYMBOL = 1;
    static final byte LABEL = 2;
    static final byte FRACT_X = 3;
    static final byte FRACT_Y = 4;
    static final byte FRACT_Z = 5;
    static final byte CARTN_X = 6;
    static final byte CARTN_Y = 7;
    static final byte CARTN_Z = 8;
    static final byte OCCUPANCY = 9;
    static final byte B_ISO = 10;
    static final byte COMP_ID = 11;
    static final byte ASYM_ID = 12;
    static final byte SEQ_ID = 13;
    static final byte INS_CODE = 14;
    static final byte ALT_ID = 15;
    static final byte GROUP_PDB = 16;
    static final byte SITE_ID = 17;
    static final byte MODEL_NO = 18;
    static final byte ATOM_PROPERTY_MAX = 19;
    static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_label_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site.Cartn_x", "_atom_site.Cartn_y", "_atom_site.Cartn_z", "_atom_site_occupancy", "_atom_site.b_iso_or_equiv", "_atom_site.label_comp_id", "_atom_site.label_asym_id", "_atom_site.label_seq_id", "_atom_site.pdbx_PDB_ins_code", "_atom_site.label_alt_id", "_atom_site.group_PDB", "_atom_site.id", "_atom_site.pdbx_PDB_model_num"};
    static final byte[] atomFieldMap = new byte[]{1, 2, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 1;
    static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 2;
    static final byte GEOM_BOND_SITE_SYMMETRY_2 = 3;
    static final byte GEOM_BOND_PROPERTY_MAX = 4;
    static final String[] geomBondFields;
    static final byte[] geomBondFieldMap;
    static final byte CONF_TYPE_ID = 1;
    static final byte BEG_ASYM_ID = 2;
    static final byte BEG_SEQ_ID = 3;
    static final byte BEG_INS_CODE = 4;
    static final byte END_ASYM_ID = 5;
    static final byte END_SEQ_ID = 6;
    static final byte END_INS_CODE = 7;
    static final byte STRUCT_CONF_PROPERTY_MAX = 8;
    static final String[] structConfFields;
    static final byte[] structConfFieldMap;
    static final byte STRUCT_SHEET_RANGE_PROPERTY_MAX = 8;
    static final String[] structSheetRangeFields;
    static final byte[] structSheetRangeFieldMap;
    static final byte STRUCT_ASYM_ID = 1;
    static final byte STRUCT_BLANK_CHAIN_ID = 2;
    static final byte STRUCT_PROPERTY_MAX = 3;
    static final String[] structAsymNames;
    static final byte[] structAsymMap;
    static final byte POLYSEQ_ASYM_ID = 1;
    static final byte POLYSEQ_PDB_STRAND_ID = 2;
    static final byte POLYSEQ_PROPERTY_MAX = 3;
    static final String[] polySeqFields;
    static final byte[] polySeqMap;
    static final byte NONPOLY_ASYM_ID = 1;
    static final byte NONPOLY_PDB_STRAND_ID = 2;
    static final byte NONPOLY_PROPERTY_MAX = 3;
    static final String[] nonPolyFields;
    static final byte[] nonPolyMap;

    CifReader() {
    }

    void initialize() {
        this.notionalUnitcell = new float[6];
        int i = 6;
        while (--i >= 0) {
            this.notionalUnitcell[i] = Float.NaN;
        }
    }

    AtomSetCollection readAtomSetCollection(BufferedReader reader) throws Exception {
        this.reader = reader;
        this.atomSetCollection = new AtomSetCollection("cif");
        this.strandsMap = new Hashtable();
        this.line = reader.readLine();
        while (this.line != null) {
            if (this.line.startsWith("loop_")) {
                this.processLoopBlock();
                continue;
            }
            if (this.line.startsWith("data_")) {
                this.processDataParameter();
            } else if (this.line.startsWith("_cell_") || this.line.startsWith("_cell.")) {
                this.processCellParameter();
            } else if (this.line.startsWith("_symmetry_space_group_name_H-M")) {
                this.processSymmetrySpaceGroupNameHM();
            } else if (this.line.startsWith("_struct_asym")) {
                this.processStructAsymBlock();
            }
            this.line = reader.readLine();
        }
        this.checkUnitcell();
        this.logger.log("Done reading... Found these strands:");
        Iterator strands = this.strandsMap.values().iterator();
        while (strands.hasNext()) {
            Strand strand = (Strand)strands.next();
            this.logger.log(strand.toString());
        }
        return this.atomSetCollection;
    }

    static final boolean isMatch(String str1, String str2) {
        int cch = str1.length();
        if (str2.length() != cch) {
            return false;
        }
        int i = cch;
        while (--i >= 0) {
            char ch2;
            char ch1 = str1.charAt(i);
            if (ch1 == (ch2 = str2.charAt(i)) || (ch1 == '_' || ch1 == '.') && (ch2 == '_' || ch2 == '.')) continue;
            if (ch1 <= 'Z' && ch1 >= 'A') {
                ch1 = (char)(ch1 + 32);
            } else if (ch2 <= 'Z' && ch2 >= 'A') {
                ch2 = (char)(ch2 + 32);
            }
            if (ch1 == ch2) continue;
            return false;
        }
        return true;
    }

    void processDataParameter() {
        String collectionName = this.line.substring(5).trim();
        if (collectionName.length() > 0) {
            this.atomSetCollection.collectionName = collectionName;
        }
    }

    void processSymmetrySpaceGroupNameHM() {
        this.atomSetCollection.spaceGroup = this.line.substring(29).trim();
    }

    void processCellParameter() {
        String cellParameter = this.parseToken(this.line);
        int i = cellParamNames.length;
        while (--i >= 0) {
            if (!CifReader.isMatch(cellParameter, cellParamNames[i])) continue;
            this.notionalUnitcell[i] = this.parseFloat(this.line, this.ichNextParse);
            return;
        }
    }

    void checkUnitcell() {
        int i = 6;
        while (--i >= 0) {
            if (!Float.isNaN(this.notionalUnitcell[i])) continue;
            return;
        }
        this.atomSetCollection.notionalUnitcell = this.notionalUnitcell;
    }

    private void processLoopBlock() throws Exception {
        this.line = this.reader.readLine().trim();
        if (this.line.startsWith("_atom_site")) {
            this.processAtomSiteLoopBlock();
            return;
        }
        if (this.line.startsWith("_struct_asym")) {
            this.processStructAsymBlock();
            return;
        }
        if (this.line.startsWith("_geom_bond")) {
            this.processGeomBondLoopBlock();
            return;
        }
        if (this.line.startsWith("_struct_conf") && !this.line.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (this.line.startsWith("_pdbx_poly_seq_scheme")) {
            this.processPolySeqSchemeLoopBlock();
            return;
        }
        if (this.line.startsWith("_pdbx_nonpoly_scheme")) {
            this.processNonPolySchemeLoopBlock();
            return;
        }
        if (this.line.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        this.skipLoopHeaders();
        this.skipLoopData();
    }

    private void skipLoopHeaders() throws Exception {
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) == '_') {
            this.line = this.reader.readLine();
        }
    }

    private void skipLoopData() throws Exception {
        char ch;
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && (ch = this.line.charAt(0)) != '_' && ch != '#' && !this.line.startsWith("loop_") && !this.line.startsWith("data_")) {
            this.line = this.reader.readLine();
        }
    }

    void processAtomSiteLoopBlock() throws Exception {
        char chFirst;
        int lineLength;
        int i;
        int currentModelNO = -1;
        int missingSequenceNumber = 0;
        int atomSerial = 0;
        int[] fieldTypes = new int[100];
        boolean[] atomPropertyReferenced = new boolean[19];
        int fieldCount = this.parseLoopParameters(atomFields, atomFieldMap, fieldTypes, atomPropertyReferenced);
        if (atomPropertyReferenced[6]) {
            for (i = 3; i < 5; ++i) {
                this.disableField(fieldCount, fieldTypes, i);
            }
        } else if (atomPropertyReferenced[3]) {
            this.atomSetCollection.coordinatesAreFractional = true;
            for (i = 6; i < 8; ++i) {
                this.disableField(fieldCount, fieldTypes, i);
            }
        } else {
            this.skipLoopData();
            return;
        }
        while (this.line != null && (lineLength = this.line.length()) != 0 && (chFirst = this.line.charAt(0)) != '#' && chFirst != '_' && !this.line.startsWith("loop_") && !this.line.startsWith("data_")) {
            if (chFirst == ' ') {
                int i2 = lineLength;
                while (--i2 >= 0 && this.line.charAt(i2) == ' ') {
                }
                if (i2 < 0) break;
            }
            if (this.line.length() == 1) {
                this.logger.log("char value is " + (chFirst + '\u0000'));
            }
            this.tokenizer.setString(this.line);
            Atom atom = new Atom();
            block22: for (int i3 = 0; i3 < fieldCount; ++i3) {
                String field;
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setString(this.reader.readLine());
                }
                if ((field = this.tokenizer.nextToken()) == null) {
                    this.logger.log("field == null!");
                }
                switch (fieldTypes[i3]) {
                    case 0: {
                        continue block22;
                    }
                    case 1: {
                        char ch1;
                        char ch0;
                        String elementSymbol = field.length() < 2 ? field : (Atom.isValidElementSymbol(ch0 = field.charAt(0), ch1 = Character.toLowerCase(field.charAt(1))) ? "" + ch0 + ch1 : "" + ch0);
                        atom.elementSymbol = elementSymbol;
                        continue block22;
                    }
                    case 2: {
                        atom.atomName = field;
                        continue block22;
                    }
                    case 3: 
                    case 6: {
                        atom.x = this.parseFloat(field);
                        continue block22;
                    }
                    case 4: 
                    case 7: {
                        atom.y = this.parseFloat(field);
                        continue block22;
                    }
                    case 5: 
                    case 8: {
                        atom.z = this.parseFloat(field);
                        continue block22;
                    }
                    case 9: {
                        float floatOccupancy = this.parseFloat(field);
                        if (Float.isNaN(floatOccupancy)) continue block22;
                        atom.occupancy = (int)(floatOccupancy * 100.0f);
                        continue block22;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloat(field);
                        continue block22;
                    }
                    case 11: {
                        atom.group3 = field;
                        continue block22;
                    }
                    case 12: {
                        char firstChar;
                        if (field.length() > 1) {
                            this.logger.log("Don't know how to deal with chains more than 1 char", field);
                        }
                        if ((firstChar = field.charAt(0)) == '?' || firstChar == '.') continue block22;
                        String chainID = "" + firstChar;
                        if (this.strandsMap.containsKey(chainID)) {
                            Strand strand = (Strand)this.strandsMap.get(chainID);
                            if (strand.isBlank.booleanValue()) {
                                atom.chainID = (char)48;
                                continue block22;
                            }
                            if (strand.authorID != null) {
                                atom.chainID = strand.authorID.charAt(0);
                                continue block22;
                            }
                            atom.chainID = (char)48;
                            continue block22;
                        }
                        atom.chainID = firstChar;
                        continue block22;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseInt(field);
                        if (atom.sequenceNumber != Integer.MIN_VALUE) continue block22;
                        this.logger.log("Warning! mmCIF ERROR: Missing SEQ_ID in mmCIF file for #" + atomSerial + " group3=" + atom.group3);
                        atom.sequenceNumber = --missingSequenceNumber;
                        continue block22;
                    }
                    case 14: {
                        char insCode = field.charAt(0);
                        if (insCode == '?' || insCode == '.') continue block22;
                        atom.chainID = insCode;
                        continue block22;
                    }
                    case 15: {
                        char alternateLocationID = field.charAt(0);
                        if (alternateLocationID == '?' || alternateLocationID == '.') continue block22;
                        atom.alternateLocationID = alternateLocationID;
                        continue block22;
                    }
                    case 16: {
                        if (!"HETATM".equals(field)) continue block22;
                        atom.isHetero = true;
                        continue block22;
                    }
                    case 17: {
                        atomSerial = this.parseInt(field);
                        continue block22;
                    }
                    case 18: {
                        int modelNO = this.parseInt(field);
                        if (modelNO == currentModelNO) continue block22;
                        this.atomSetCollection.newAtomSet();
                        currentModelNO = modelNO;
                    }
                }
            }
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                this.logger.log("atom " + atom.atomName + " has invalid/unknown coordinates");
            } else {
                this.atomSetCollection.addAtomWithMappedName(atom);
            }
            this.line = this.reader.readLine();
        }
    }

    void disableField(int fieldCount, int[] fieldTypes, int fieldIndex) {
        int i = fieldCount;
        while (--i >= 0) {
            if (fieldTypes[i] != fieldIndex) continue;
            fieldTypes[i] = 0;
        }
    }

    int parseLoopParameters(String[] fields, byte[] fieldMap, int[] fieldTypes, boolean[] propertyReferenced) throws Exception {
        int fieldCount = 0;
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) == '_') {
            int i = fields.length;
            while (--i >= 0) {
                if (!CifReader.isMatch(this.line, fields[i])) continue;
                int iproperty = fieldMap[i];
                propertyReferenced[iproperty] = true;
                fieldTypes[fieldCount] = iproperty;
                break;
            }
            ++fieldCount;
            this.line = this.reader.readLine();
        }
        return fieldCount;
    }

    Object[] parseAndProcessStructParameters(String[] fields, byte[] fieldMap, int[] fieldTypes, boolean[] propertyReferenced) throws Exception {
        int fieldCount = 0;
        Strand struct = new Strand();
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) == '_') {
            this.logger.log("Processing line: ", this.line);
            int i = fields.length;
            while (--i >= 0) {
                this.tokenizer.setString(this.line);
                String key = this.tokenizer.nextToken();
                String value = null;
                if (!CifReader.isMatch(key, fields[i])) continue;
                if (this.tokenizer.hasMoreTokens()) {
                    value = this.tokenizer.nextToken();
                    if (fields[i].equals(structAsymNames[0])) {
                        struct.chainID = value;
                    }
                    if (fields[i].equals(structAsymNames[1])) {
                        struct.isBlank = "Y".equals(value) ? Boolean.TRUE : Boolean.FALSE;
                    }
                    this.logger.log("struct", struct);
                } else {
                    struct = null;
                }
                int iproperty = fieldMap[i];
                propertyReferenced[iproperty] = true;
                fieldTypes[fieldCount] = iproperty;
                i = -1;
            }
            ++fieldCount;
            this.line = this.reader.readLine();
        }
        this.logger.log("parseLoopParameters sees fieldCount=" + fieldCount);
        this.logger.log("parsed struct -> " + struct);
        Object[] results = new Object[]{new Integer(fieldCount), struct};
        return results;
    }

    void processGeomBondLoopBlock() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[4];
        int fieldCount = this.parseLoopParameters(geomBondFields, geomBondFieldMap, fieldTypes, propertyReferenced);
        int i = 4;
        while (--i > 0) {
            if (propertyReferenced[i]) continue;
            this.logger.log("?que? missing _geom_bond property:" + i);
            this.skipLoopData();
            return;
        }
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '#' && this.line.charAt(0) != '_' && !this.line.startsWith("loop_") && !this.line.startsWith("data_")) {
            this.tokenizer.setString(this.line);
            int atomIndex1 = -1;
            int atomIndex2 = -1;
            String symmetry = null;
            block8: for (int i2 = 0; i2 < fieldCount; ++i2) {
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setString(this.reader.readLine());
                }
                String field = this.tokenizer.nextToken();
                switch (fieldTypes[i2]) {
                    case 0: {
                        continue block8;
                    }
                    case 1: {
                        atomIndex1 = this.atomSetCollection.getAtomNameIndex(field);
                        continue block8;
                    }
                    case 2: {
                        atomIndex2 = this.atomSetCollection.getAtomNameIndex(field);
                        continue block8;
                    }
                    case 3: {
                        if (field.charAt(0) == '.') continue block8;
                        symmetry = field;
                    }
                }
            }
            if (atomIndex1 >= 0 && atomIndex2 >= 0 && symmetry == null) {
                Bond bond = new Bond();
                bond.atomIndex1 = atomIndex1;
                bond.atomIndex2 = atomIndex2;
                this.atomSetCollection.addBond(bond);
            }
            this.line = this.reader.readLine();
        }
    }

    void processStructConfLoopBlock() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[8];
        int fieldCount = this.parseLoopParameters(structConfFields, structConfFieldMap, fieldTypes, propertyReferenced);
        int i = 8;
        while (--i > 0) {
            if (propertyReferenced[i]) continue;
            this.logger.log("?que? missing _struct_conf property:" + i);
            this.skipLoopData();
            return;
        }
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '#') {
            this.tokenizer.setString(this.line);
            Structure structure = new Structure();
            block12: for (int i2 = 0; i2 < fieldCount; ++i2) {
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setString(this.reader.readLine());
                }
                String field = this.tokenizer.nextToken();
                char firstChar = field.charAt(0);
                switch (fieldTypes[i2]) {
                    case 0: {
                        continue block12;
                    }
                    case 1: {
                        if (field.startsWith("HELX")) {
                            structure.structureType = "helix";
                            continue block12;
                        }
                        if (field.startsWith("TURN")) {
                            structure.structureType = "turn";
                            continue block12;
                        }
                        structure.structureType = "none";
                        continue block12;
                    }
                    case 2: {
                        structure.startChainID = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block12;
                    }
                    case 3: {
                        structure.startSequenceNumber = this.parseInt(field);
                        continue block12;
                    }
                    case 4: {
                        structure.startInsertionCode = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block12;
                    }
                    case 5: {
                        structure.endChainID = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block12;
                    }
                    case 6: {
                        structure.endSequenceNumber = this.parseInt(field);
                        continue block12;
                    }
                    case 7: {
                        structure.endInsertionCode = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
            this.line = this.reader.readLine();
        }
    }

    void processStructSheetRangeLoopBlock() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[8];
        int fieldCount = this.parseLoopParameters(structSheetRangeFields, structSheetRangeFieldMap, fieldTypes, propertyReferenced);
        int i = 8;
        while (--i > 1) {
            if (propertyReferenced[i]) continue;
            this.logger.log("?que? missing _struct_conf property:" + i);
            this.skipLoopData();
            return;
        }
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '#') {
            this.tokenizer.setString(this.line);
            Structure structure = new Structure();
            structure.structureType = "sheet";
            block10: for (int i2 = 0; i2 < fieldCount; ++i2) {
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setString(this.reader.readLine());
                }
                String field = this.tokenizer.nextToken();
                char firstChar = field.charAt(0);
                switch (fieldTypes[i2]) {
                    case 2: {
                        structure.startChainID = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block10;
                    }
                    case 3: {
                        structure.startSequenceNumber = this.parseInt(field);
                        continue block10;
                    }
                    case 4: {
                        structure.startInsertionCode = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block10;
                    }
                    case 5: {
                        structure.endChainID = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                        continue block10;
                    }
                    case 6: {
                        structure.endSequenceNumber = this.parseInt(field);
                        continue block10;
                    }
                    case 7: {
                        structure.endInsertionCode = (char)(firstChar == '.' || firstChar == '?' ? 32 : (int)firstChar);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
            this.line = this.reader.readLine();
        }
    }

    private void addOrUpdateStrandInfo(Strand strand) {
        this.logger.log("Found only one chain", strand.chainID);
        if (this.strandsMap.containsKey(strand.chainID)) {
            Strand prevStrand = (Strand)this.strandsMap.get(strand.chainID);
            if (strand.authorID != null) {
                prevStrand.authorID = strand.authorID;
            }
            if (prevStrand.isBlank != null) {
                prevStrand.isBlank = strand.isBlank;
            }
        } else {
            this.strandsMap.put(strand.chainID, strand);
        }
    }

    private void processStructAsymBlock() throws Exception {
        int[] fieldTypes = new int[10];
        boolean[] structPropertyReferenced = new boolean[3];
        Object[] results = this.parseAndProcessStructParameters(structAsymNames, structAsymMap, fieldTypes, structPropertyReferenced);
        int fieldCount = (Integer)results[0];
        Strand struct = (Strand)results[1];
        if (struct != null) {
            this.addOrUpdateStrandInfo(struct);
        } else {
            char chFirst;
            int lineLength;
            this.logger.log("Found multiple chains... parsing them now");
            while (this.line != null && (lineLength = this.line.length()) != 0 && (chFirst = this.line.charAt(0)) != '#' && chFirst != '_' && !this.line.startsWith("loop_") && !this.line.startsWith("data_")) {
                int i;
                if (chFirst == ' ') {
                    i = lineLength;
                    while (--i >= 0 && this.line.charAt(i) == ' ') {
                    }
                    if (i < 0) break;
                }
                if (this.line.length() == 1) {
                    this.logger.log("char value is " + (chFirst + '\u0000'));
                }
                this.tokenizer.setString(this.line);
                struct = new Strand();
                block6: for (i = 0; i < fieldCount; ++i) {
                    String field;
                    if (!this.tokenizer.hasMoreTokens()) {
                        this.tokenizer.setString(this.reader.readLine());
                    }
                    if ((field = this.tokenizer.nextToken()) == null) {
                        this.logger.log("field == null!");
                    }
                    switch (fieldTypes[i]) {
                        case 1: {
                            struct.chainID = field;
                            continue block6;
                        }
                        case 2: {
                            struct.isBlank = "Y".equals(field) ? Boolean.TRUE : Boolean.FALSE;
                        }
                    }
                }
                this.addOrUpdateStrandInfo(struct);
                this.line = this.reader.readLine();
            }
        }
    }

    private void processPolySeqSchemeLoopBlock() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[3];
        int fieldCount = this.parseLoopParameters(polySeqFields, polySeqMap, fieldTypes, propertyReferenced);
        int i = 3;
        while (--i > 1) {
            if (propertyReferenced[i]) continue;
            this.logger.log("?que? missing _pdbx_poly_seq_scheme property:" + i);
            this.skipLoopData();
            return;
        }
        String lastChainID = "XXXXX";
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '#') {
            this.tokenizer.setString(this.line);
            Strand strand = new Strand();
            block6: for (int i2 = 0; i2 < fieldCount; ++i2) {
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setString(this.reader.readLine());
                }
                String field = this.tokenizer.nextToken();
                switch (fieldTypes[i2]) {
                    case 1: {
                        strand.chainID = field;
                        continue block6;
                    }
                    case 2: {
                        strand.authorID = field.charAt(0) == '?' ? null : field;
                    }
                }
            }
            if (!lastChainID.equals(strand.chainID)) {
                this.addOrUpdateStrandInfo(strand);
                lastChainID = strand.chainID;
            }
            this.line = this.reader.readLine();
        }
        this.logger.log("Done reading _loop Poly Seq Scheme");
        Iterator strands = this.strandsMap.values().iterator();
        while (strands.hasNext()) {
            Strand strand = (Strand)strands.next();
            this.logger.log(strand.toString());
        }
    }

    private void processNonPolySchemeLoopBlock() throws Exception {
        int[] fieldTypes = new int[100];
        boolean[] propertyReferenced = new boolean[3];
        int fieldCount = this.parseLoopParameters(nonPolyFields, polySeqMap, fieldTypes, propertyReferenced);
        int i = 3;
        while (--i > 1) {
            if (propertyReferenced[i]) continue;
            this.logger.log("?que? missing _pdbx_nonpoly_scheme property:" + i);
            this.skipLoopData();
            return;
        }
        String lastChainID = "XXXXX";
        while (this.line != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '#') {
            this.tokenizer.setString(this.line);
            Strand strand = new Strand();
            block6: for (int i2 = 0; i2 < fieldCount; ++i2) {
                if (!this.tokenizer.hasMoreTokens()) {
                    this.tokenizer.setString(this.reader.readLine());
                }
                String field = this.tokenizer.nextToken();
                switch (fieldTypes[i2]) {
                    case 1: {
                        strand.chainID = field;
                        continue block6;
                    }
                    case 2: {
                        strand.authorID = field.charAt(0) == '?' ? null : field;
                    }
                }
            }
            if (!lastChainID.equals(strand.chainID)) {
                this.addOrUpdateStrandInfo(strand);
                lastChainID = strand.chainID;
            }
            this.line = this.reader.readLine();
        }
        this.logger.log("Done reading _loop NonPoly Scheme");
        Iterator strands = this.strandsMap.values().iterator();
        while (strands.hasNext()) {
            Strand strand = (Strand)strands.next();
            this.logger.log(strand.toString());
        }
    }

    static {
        if (atomFieldMap.length != atomFields.length) {
            CifReader.atomFields[100] = "explode";
        }
        geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_site_symmetry_2"};
        geomBondFieldMap = new byte[]{1, 2, 3};
        structConfFields = new String[]{"_struct_conf.conf_type_id", "_struct_conf.beg_auth_asym_id", "_struct_conf.beg_auth_seq_id", "_struct_conf.pdbx_beg_PDB_ins_code", "_struct_conf.end_auth_asym_id", "_struct_conf.end_auth_seq_id", "_struct_conf.pdbx_end_PDB_ins_code"};
        structConfFieldMap = new byte[]{1, 2, 3, 4, 5, 6, 7};
        structSheetRangeFields = new String[]{"_struct_sheet_range.beg_label_asym_id", "_struct_sheet_range.beg_label_seq_id", "_struct_sheet_range.pdbx_beg_PDB_ins_code", "_struct_sheet_range.end_label_asym_id", "_struct_sheet_range.end_label_seq_id", "_struct_sheet_range.pdbx_end_PDB_ins_code"};
        structSheetRangeFieldMap = new byte[]{2, 3, 4, 5, 6, 7};
        structAsymNames = new String[]{"_struct_asym.id", "_struct_asym.pdbx_blank_PDB_chainid_flag"};
        structAsymMap = new byte[]{1, 2};
        if (structAsymMap.length != structAsymNames.length) {
            CifReader.structAsymNames[100] = "explode";
        }
        polySeqFields = new String[]{"_pdbx_poly_seq_scheme.asym_id", "_pdbx_poly_seq_scheme.pdb_strand_id"};
        polySeqMap = new byte[]{1, 2};
        if (polySeqMap.length != polySeqFields.length) {
            CifReader.polySeqFields[100] = "explode";
        }
        nonPolyFields = new String[]{"_pdbx_nonpoly_scheme.asym_id", "_pdbx_nonpoly_scheme.pdb_strand_id"};
        nonPolyMap = new byte[]{1, 2};
        if (nonPolyMap.length != nonPolyFields.length) {
            CifReader.nonPolyFields[100] = "explode";
        }
    }

    static class RidiculousFileFormatTokenizer {
        String str;
        int ich;
        int cch;

        RidiculousFileFormatTokenizer() {
        }

        void setString(String str) {
            if (str == null) {
                str = "";
            }
            this.str = str;
            this.cch = str.length();
            this.ich = 0;
        }

        boolean hasMoreTokens() {
            char ch;
            while (this.ich < this.cch && ((ch = this.str.charAt(this.ich)) == ' ' || ch == '\t')) {
                ++this.ich;
            }
            return this.ich < this.cch;
        }

        String nextToken() {
            if (this.ich == this.cch) {
                return null;
            }
            int ichStart = this.ich;
            char ch = this.str.charAt(ichStart);
            if (ch != '\'' && ch != '\"') {
                while (this.ich < this.cch && (ch = this.str.charAt(this.ich)) != ' ' && ch != '\t') {
                    ++this.ich;
                }
                return this.str.substring(ichStart, this.ich);
            }
            char chOpeningQuote = ch;
            boolean previousCharacterWasQuote = false;
            while (++this.ich < this.cch) {
                ch = this.str.charAt(this.ich);
                if (previousCharacterWasQuote && (ch == ' ' || ch == '\t')) break;
                previousCharacterWasQuote = ch == chOpeningQuote;
            }
            if (this.ich == this.cch) {
                if (previousCharacterWasQuote) {
                    return this.str.substring(ichStart + 1, this.ich - 1);
                }
                return this.str.substring(ichStart, this.ich);
            }
            ++this.ich;
            return this.str.substring(ichStart + 1, this.ich - 2);
        }
    }
}

