/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.zip.GZIPInputStream;
import org.jmol.api.JmolAdapter;
import org.jmol.viewer.MonitorInputStream;
import org.jmol.viewer.Viewer;

class FileManager {
    Viewer viewer;
    JmolAdapter modelAdapter;
    private String openErrorMessage;
    URL appletDocumentBase = null;
    URL appletCodeBase = null;
    String appletProxy = null;
    private String nameAsGiven;
    private String fullPathName;
    String fileName;
    private File file;
    private FileOpenThread fileOpenThread;
    private FilesOpenThread filesOpenThread;
    private DOMOpenThread aDOMOpenThread;
    final String[] urlPrefixes = new String[]{"http:", "https:", "ftp:", "file:"};
    final byte[] abMagic = new byte[4];

    FileManager(Viewer viewer, JmolAdapter modelAdapter) {
        this.viewer = viewer;
        this.modelAdapter = modelAdapter;
    }

    void openFile(String name) {
        System.out.println("FileManager.openFile(" + name + ")");
        this.nameAsGiven = name;
        this.fileName = null;
        this.fullPathName = null;
        this.openErrorMessage = null;
        this.classifyName(name);
        if (this.openErrorMessage != null) {
            System.out.println("openErrorMessage=" + this.openErrorMessage);
            return;
        }
        this.fileOpenThread = new FileOpenThread(this.fullPathName, name);
        this.fileOpenThread.run();
    }

    void openFiles(String modelName, String[] names) {
        String[] fullPathNames = new String[names.length];
        for (int i = 0; i < names.length; ++i) {
            this.nameAsGiven = names[i];
            this.fileName = null;
            this.fullPathName = null;
            this.openErrorMessage = null;
            this.classifyName(names[i]);
            if (this.openErrorMessage != null) {
                System.out.println("openErrorMessage=" + this.openErrorMessage);
                return;
            }
            fullPathNames[i] = this.fullPathName;
        }
        this.fileName = this.nameAsGiven = modelName;
        this.fullPathName = this.nameAsGiven;
        this.filesOpenThread = new FilesOpenThread(fullPathNames, names);
        this.filesOpenThread.run();
    }

    void openStringInline(String strModel) {
        this.openErrorMessage = null;
        this.fileName = "string";
        this.fullPathName = "string";
        this.fileOpenThread = new FileOpenThread(this.fullPathName, new StringReader(strModel));
        this.fileOpenThread.run();
    }

    void openDOM(Object DOMNode) {
        this.openErrorMessage = null;
        this.fileName = "JSNode";
        this.fullPathName = "JSNode";
        this.aDOMOpenThread = new DOMOpenThread(DOMNode);
        this.aDOMOpenThread.run();
    }

    void openReader(String fullPathName, String name, Reader reader) {
        this.openErrorMessage = null;
        this.fullPathName = fullPathName;
        this.fileName = name;
        this.fileOpenThread = new FileOpenThread(fullPathName, reader);
        this.fileOpenThread.run();
    }

    String getFileAsString(String name) {
        System.out.println("FileManager.getFileAsString(" + name + ")");
        Object t = this.getInputStreamOrErrorMessageFromName(name);
        byte[] abMagic = new byte[4];
        if (t instanceof String) {
            return "Error:" + t;
        }
        try {
            String line;
            BufferedInputStream bis;
            FilterInputStream is = bis = new BufferedInputStream((InputStream)t, 8192);
            bis.mark(5);
            int countRead = 0;
            countRead = bis.read(abMagic, 0, 4);
            bis.reset();
            if (countRead == 4 && abMagic[0] == 31 && abMagic[1] == -117) {
                is = new GZIPInputStream(bis);
            }
            BufferedReader br = new BufferedReader(new InputStreamReader(is));
            StringBuffer sb = new StringBuffer(8192);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append('\n');
            }
            return "" + sb;
        }
        catch (IOException ioe) {
            return ioe.getMessage();
        }
    }

    Object waitForClientFileOrErrorMessage() {
        Object clientFile = null;
        if (this.fileOpenThread != null) {
            clientFile = this.fileOpenThread.clientFile;
            if (this.fileOpenThread.errorMessage != null) {
                this.openErrorMessage = this.fileOpenThread.errorMessage;
            } else if (clientFile == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.fileOpenThread = null;
        } else if (this.filesOpenThread != null) {
            clientFile = this.filesOpenThread.clientFile;
            if (this.filesOpenThread.errorMessage != null) {
                this.openErrorMessage = this.filesOpenThread.errorMessage;
            } else if (clientFile == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
        } else if (this.aDOMOpenThread != null) {
            clientFile = this.aDOMOpenThread.clientFile;
            if (this.aDOMOpenThread.errorMessage != null) {
                this.openErrorMessage = this.aDOMOpenThread.errorMessage;
            } else if (clientFile == null) {
                this.openErrorMessage = "Client file is null loading:" + this.nameAsGiven;
            }
            this.aDOMOpenThread = null;
        }
        if (this.openErrorMessage != null) {
            return this.openErrorMessage;
        }
        return clientFile;
    }

    String getFullPathName() {
        return this.fullPathName != null ? this.fullPathName : this.nameAsGiven;
    }

    String getFileName() {
        return this.fileName != null ? this.fileName : this.nameAsGiven;
    }

    void setAppletContext(URL documentBase, URL codeBase, String jmolAppletProxy) {
        this.appletDocumentBase = documentBase;
        System.out.println("appletDocumentBase=" + documentBase);
        this.appletCodeBase = codeBase;
        this.appletProxy = jmolAppletProxy;
    }

    void dumpDocumentBase(String documentBase) {
        System.out.println("dumpDocumentBase:" + documentBase);
        Object inputStreamOrError = this.getInputStreamOrErrorMessageFromName(documentBase);
        if (inputStreamOrError == null) {
            System.out.println("?Que? ?null?");
        } else if (inputStreamOrError instanceof String) {
            System.out.println("Error:" + inputStreamOrError);
        } else {
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)inputStreamOrError));
            try {
                String line;
                while ((line = br.readLine()) != null) {
                    System.out.println(line);
                }
                br.close();
            }
            catch (Exception ex) {
                System.out.println("exception caught:" + ex);
            }
        }
    }

    private void classifyName(String name) {
        if (name == null) {
            return;
        }
        if (this.appletDocumentBase != null) {
            try {
                URL url = new URL(this.appletDocumentBase, name);
                this.fullPathName = url.toString();
                this.fileName = this.fullPathName.substring(this.fullPathName.lastIndexOf(47) + 1, this.fullPathName.length());
            }
            catch (MalformedURLException e) {
                this.openErrorMessage = e.getMessage();
            }
            return;
        }
        for (int i = 0; i < this.urlPrefixes.length; ++i) {
            if (!name.startsWith(this.urlPrefixes[i])) continue;
            try {
                URL url = new URL(name);
                this.fullPathName = url.toString();
                this.fileName = this.fullPathName.substring(this.fullPathName.lastIndexOf(47) + 1, this.fullPathName.length());
            }
            catch (MalformedURLException e) {
                this.openErrorMessage = e.getMessage();
            }
            return;
        }
        this.file = new File(name);
        this.fullPathName = this.file.getAbsolutePath();
        this.fileName = this.file.getName();
    }

    Object getInputStreamOrErrorMessageFromName(String name) {
        String errorMessage = null;
        int iurlPrefix = this.urlPrefixes.length;
        while (--iurlPrefix >= 0 && !name.startsWith(this.urlPrefixes[iurlPrefix])) {
        }
        try {
            InputStream in;
            int length;
            if (this.appletDocumentBase == null) {
                if (iurlPrefix >= 0) {
                    URL url = new URL(name);
                    URLConnection conn = url.openConnection();
                    length = conn.getContentLength();
                    in = conn.getInputStream();
                } else {
                    File file = new File(name);
                    length = (int)file.length();
                    in = new FileInputStream(file);
                }
            } else {
                if (iurlPrefix >= 0 && this.appletProxy != null) {
                    name = this.appletProxy + "?url=" + URLEncoder.encode(name, "utf-8");
                }
                URL url = new URL(this.appletDocumentBase, name);
                URLConnection conn = url.openConnection();
                length = conn.getContentLength();
                in = conn.getInputStream();
            }
            return new MonitorInputStream(in, length);
        }
        catch (Exception e) {
            errorMessage = "" + e;
            return errorMessage;
        }
    }

    Object getUnzippedBufferedReaderOrErrorMessageFromName(String name) {
        Object t = this.getInputStreamOrErrorMessageFromName(name);
        if (t instanceof String) {
            return t;
        }
        try {
            BufferedInputStream bis;
            FilterInputStream is = bis = new BufferedInputStream((InputStream)t, 8192);
            bis.mark(5);
            int countRead = 0;
            countRead = bis.read(this.abMagic, 0, 4);
            bis.reset();
            if (countRead == 4 && this.abMagic[0] == 31 && this.abMagic[1] == -117) {
                is = new GZIPInputStream(bis);
            }
            return new BufferedReader(new InputStreamReader(is));
        }
        catch (IOException ioe) {
            return ioe.getMessage();
        }
    }

    class FilesOpenThread
    implements Runnable {
        boolean terminated;
        String errorMessage;
        String[] fullPathNameInThread;
        String[] nameAsGivenInThread;
        Object clientFile;
        Reader[] reader;
        byte[] abMagicF = new byte[4];

        FilesOpenThread(String[] fullPathName, String[] nameAsGiven) {
            this.fullPathNameInThread = fullPathName;
            this.nameAsGivenInThread = nameAsGiven;
        }

        FilesOpenThread(String[] name, Reader[] reader) {
            this.fullPathNameInThread = name;
            this.nameAsGivenInThread = name;
            this.reader = reader;
        }

        public void run() {
            if (this.reader != null) {
                this.openReader(this.reader);
            } else {
                InputStream[] istream = new InputStream[this.nameAsGivenInThread.length];
                for (int i = 0; i < this.nameAsGivenInThread.length; ++i) {
                    Object t = FileManager.this.getInputStreamOrErrorMessageFromName(this.nameAsGivenInThread[i]);
                    if (!(t instanceof InputStream)) {
                        this.errorMessage = t == null ? "error opening:" + this.nameAsGivenInThread : (String)t;
                        this.terminated = true;
                        return;
                    }
                    istream[i] = (InputStream)t;
                }
                this.openInputStream(this.fullPathNameInThread, istream);
            }
            if (this.errorMessage != null) {
                System.out.println("error opening " + this.fullPathNameInThread + "\n" + this.errorMessage);
            }
            this.terminated = true;
        }

        private void openInputStream(String[] fullPathName, InputStream[] istream) {
            Reader[] zistream = new InputStreamReader[istream.length];
            for (int i = 0; i < istream.length; ++i) {
                BufferedInputStream bistream;
                FilterInputStream istreamToRead = bistream = new BufferedInputStream(istream[i], 8192);
                bistream.mark(5);
                int countRead = 0;
                try {
                    countRead = bistream.read(this.abMagicF, 0, 4);
                    bistream.reset();
                    if (countRead == 4 && this.abMagicF[0] == 31 && this.abMagicF[1] == -117) {
                        istreamToRead = new GZIPInputStream(bistream);
                    }
                    zistream[i] = new InputStreamReader(istreamToRead);
                    continue;
                }
                catch (IOException ioe) {
                    this.errorMessage = ioe.getMessage();
                    return;
                }
            }
            this.openReader(zistream);
        }

        private void openReader(Reader[] reader) {
            BufferedReader[] buffered = new BufferedReader[reader.length];
            for (int i = 0; i < reader.length; ++i) {
                buffered[i] = new BufferedReader(reader[i]);
            }
            Object clientFile = FileManager.this.modelAdapter.openBufferedReaders(this.fullPathNameInThread, buffered);
            if (clientFile instanceof String) {
                this.errorMessage = (String)clientFile;
            } else {
                this.clientFile = clientFile;
            }
        }
    }

    class FileOpenThread
    implements Runnable {
        boolean terminated;
        String errorMessage;
        String fullPathNameInThread;
        String nameAsGivenInThread;
        Object clientFile;
        Reader reader;
        byte[] abMagicF = new byte[4];

        FileOpenThread(String fullPathName, String nameAsGiven) {
            this.fullPathNameInThread = fullPathName;
            this.nameAsGivenInThread = nameAsGiven;
        }

        FileOpenThread(String name, Reader reader) {
            this.nameAsGivenInThread = this.fullPathNameInThread = name;
            this.reader = reader;
        }

        public void run() {
            if (this.reader != null) {
                this.openReader(this.reader);
            } else {
                Object t = FileManager.this.getInputStreamOrErrorMessageFromName(this.nameAsGivenInThread);
                if (!(t instanceof InputStream)) {
                    this.errorMessage = t == null ? "error opening:" + this.nameAsGivenInThread : (String)t;
                } else {
                    this.openInputStream(this.fullPathNameInThread, FileManager.this.fileName, (InputStream)t);
                }
            }
            if (this.errorMessage != null) {
                System.out.println("error opening " + this.fullPathNameInThread + "\n" + this.errorMessage);
            }
            this.terminated = true;
        }

        private void openInputStream(String fullPathName, String fileName, InputStream istream) {
            BufferedInputStream bistream;
            FilterInputStream istreamToRead = bistream = new BufferedInputStream(istream, 8192);
            bistream.mark(5);
            int countRead = 0;
            try {
                countRead = bistream.read(this.abMagicF, 0, 4);
                bistream.reset();
                if (countRead == 4 && this.abMagicF[0] == 31 && this.abMagicF[1] == -117) {
                    istreamToRead = new GZIPInputStream(bistream);
                }
                this.openReader(new InputStreamReader(istreamToRead));
            }
            catch (IOException ioe) {
                this.errorMessage = ioe.getMessage();
            }
        }

        private void openReader(Reader reader) {
            Object clientFile = FileManager.this.modelAdapter.openBufferedReader(this.fullPathNameInThread, new BufferedReader(reader));
            if (clientFile instanceof String) {
                this.errorMessage = (String)clientFile;
            } else {
                this.clientFile = clientFile;
            }
        }
    }

    class DOMOpenThread
    implements Runnable {
        boolean terminated;
        String errorMessage;
        Object aDOMNode;
        Object clientFile;

        DOMOpenThread(Object DOMNode) {
            this.aDOMNode = DOMNode;
        }

        public void run() {
            this.clientFile = FileManager.this.modelAdapter.openDOMReader(this.aDOMNode);
            this.errorMessage = null;
            this.terminated = true;
        }
    }
}

