/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.viewer;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;
import org.jmol.viewer.Mesh;
import org.jmol.viewer.ShapeRenderer;

abstract class MeshRenderer
extends ShapeRenderer {
    MeshRenderer() {
    }

    void render1(Mesh mesh) {
        if (!mesh.visible) {
            return;
        }
        int vertexCount = mesh.vertexCount;
        if (vertexCount == 0) {
            return;
        }
        Point3f[] vertices = mesh.vertices;
        Point3i[] screens = this.viewer.allocTempScreens(vertexCount);
        int i = vertexCount;
        while (--i >= 0) {
            this.viewer.transformPoint(vertices[i], screens[i]);
        }
        if (mesh.showPoints) {
            this.renderPoints(mesh, screens, vertexCount);
        }
        if (mesh.drawTriangles) {
            this.renderTriangles(mesh, screens, false);
        }
        if (mesh.fillTriangles) {
            this.renderTriangles(mesh, screens, true);
        }
        this.viewer.freeTempScreens(screens);
    }

    void renderPoints(Mesh mesh, Point3i[] screens, int vertexCount) {
        short colix = mesh.colix;
        short[] vertexColixes = mesh.vertexColixes;
        int i = vertexCount;
        while (--i >= 0) {
            this.g3d.fillSphereCentered(vertexColixes != null ? vertexColixes[i] : colix, 4, screens[i]);
        }
    }

    void renderTriangles(Mesh mesh, Point3i[] screens, boolean fill) {
        int[][] polygonIndexes = mesh.polygonIndexes;
        short[] normixes = mesh.normixes;
        short colix = mesh.colix;
        short[] vertexColixes = mesh.vertexColixes;
        int i = mesh.polygonCount;
        while (--i >= 0) {
            short colixC;
            short colixB;
            short colixA;
            int[] vertexIndexes = polygonIndexes[i];
            int iA = vertexIndexes[0];
            int iB = vertexIndexes[1];
            int iC = vertexIndexes[2];
            if (vertexColixes != null) {
                colixA = vertexColixes[iA];
                colixB = vertexColixes[iB];
                colixC = vertexColixes[iC];
            } else {
                colixB = colixC = colix;
                colixA = colixC;
            }
            if (vertexIndexes.length == 3) {
                if (fill) {
                    this.g3d.fillTriangle(screens[iA], colixA, normixes[iA], screens[iB], colixB, normixes[iB], screens[iC], colixC, normixes[iC]);
                    continue;
                }
                this.g3d.drawTriangle(colixA, screens[iA], screens[iB], screens[iC]);
                continue;
            }
            if (vertexIndexes.length == 4) {
                short colixD;
                int iD = vertexIndexes[3];
                short s = colixD = vertexColixes != null ? vertexColixes[iD] : colix;
                if (fill) {
                    this.g3d.fillQuadrilateral(screens[iA], colixA, normixes[iA], screens[iB], colixB, normixes[iB], screens[iC], colixC, normixes[iC], screens[iD], colixD, normixes[iD]);
                    continue;
                }
                this.g3d.drawQuadrilateral(colixA, screens[iA], screens[iB], screens[iC], screens[iD]);
                continue;
            }
            System.out.println("PmeshRenderer: polygon with > 4 sides");
        }
    }
}

